/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.ClassificationModel$;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.json4s.JsonAST;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public final class SVMModel$
implements Loader<SVMModel>,
scala.Serializable {
    public static SVMModel$ MODULE$;

    static {
        new SVMModel$();
    }

    @Override
    public SVMModel load(SparkContext sc, String path) {
        Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String loadedClassName = (String)tuple3._1();
        String version = (String)tuple3._2();
        JsonAST.JValue metadata = (JsonAST.JValue)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)loadedClassName, (Object)version, (Object)metadata);
        String loadedClassName2 = (String)tuple32._1();
        String version2 = (String)tuple32._2();
        JsonAST.JValue metadata2 = (JsonAST.JValue)tuple32._3();
        String classNameV1_0 = "org.apache.spark.mllib.classification.SVMModel";
        Tuple2 tuple2 = new Tuple2((Object)loadedClassName2, (Object)version2);
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("1.0".equals(string)) {
                String string2 = className;
                String string3 = classNameV1_0;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    Tuple2<Object, Object> tuple22 = ClassificationModel$.MODULE$.getNumFeaturesClasses(metadata2);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    int numFeatures = tuple22._1$mcI$sp();
                    int numClasses = tuple22._2$mcI$sp();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numFeatures, numClasses);
                    int numFeatures2 = sp2._1$mcI$sp();
                    int numClasses2 = sp2._2$mcI$sp();
                    GLMClassificationModel.SaveLoadV1_0.Data data = GLMClassificationModel$SaveLoadV1_0$.MODULE$.loadData(sc, path, classNameV1_0);
                    SVMModel model = new SVMModel(data.weights(), data.intercept());
                    Predef$.MODULE$.assert(model.weights().size() == numFeatures2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("SVMModel.load with numFeatures=").append(numFeatures2).append(" was given non-matching weights vector of size ").append(model.weights().size()).toString());
                    Predef$.MODULE$.assert(numClasses2 == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("SVMModel.load was given numClasses=").append(numClasses2).append(" but only supports 2 classes").toString());
                    Option<Object> option = data.threshold();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        double t = BoxesRunTime.unboxToDouble((Object)some.value());
                        model.setThreshold(t);
                    } else if (None$.MODULE$.equals(option)) {
                        model.clearThreshold();
                    } else {
                        throw new MatchError(option);
                    }
                    return model;
                }
            }
        }
        throw new Exception(new StringBuilder(98).append("SVMModel.load did not recognize model with (className, format version):").append("(").append(loadedClassName2).append(", ").append(version2).append(").  Supported:\n").append("  (").append(classNameV1_0).append(", 1.0)").toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SVMModel$() {
        MODULE$ = this;
    }
}

