/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.norm$;
import breeze.linalg.normalize$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.numerics.package;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaPairRDD$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.LocalLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\r}b\u0001B\"E\u0001=C\u0001B\u0017\u0001\u0003\u0006\u0004%\ta\u0017\u0005\tW\u0002\u0011\t\u0011)A\u00059\"AQ\u000e\u0001BC\u0002\u0013\u0005c\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003p\u0011!9\bA!b\u0001\n\u0003B\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0013}\u0004!Q1A\u0005R!C\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003z\u0011!\t\u0019\u0001\u0001C\u0001\u0011\u0006\u0015\u0001BCA\f\u0001\u0001\u0007I\u0011\u0001%\u0002\u001a!Q\u0011\u0011\u0005\u0001A\u0002\u0013\u0005\u0001*a\t\t\u0011\u0005=\u0002\u0001)Q\u0005\u00037Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002>\u0001!\t%a\r\t\r\u0005\u0005\u0003\u0001\"\u0011\\\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0018\u0001\t\u0003\tI\u0002C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAO\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\t9\u000e\u0001C\u0001\u0003?Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!1\u0002\u0001\u0005\u0002\t\u0005ra\u0002B\u0017\t\"\u0005!q\u0006\u0004\u0007\u0007\u0012C\tA!\r\t\u000f\u0005\rQ\u0004\"\u0001\u0003F\u001d9!qI\u000f\t\n\t%ca\u0002B';!%!q\n\u0005\b\u0003\u0007\u0001C\u0011\u0001B)\u0011%\u0011\u0019\u0006\tb\u0001\n\u0003\u0011)\u0006\u0003\u0005\u0003\\\u0001\u0002\u000b\u0011\u0002B,\u0011%\u0011i\u0006\tb\u0001\n\u0003\u0011)\u0006\u0003\u0005\u0003`\u0001\u0002\u000b\u0011\u0002B,\r\u0019\u0011\t\u0007\t!\u0003d!I!1\u000e\u0014\u0003\u0016\u0004%\tA\u001c\u0005\n\u0005[2#\u0011#Q\u0001\n=D!Ba\u001c'\u0005+\u0007I\u0011AA\u001a\u0011)\u0011\tH\nB\tB\u0003%\u0011Q\u0007\u0005\b\u0003\u00071C\u0011\u0001B:\u0011%\u0011iHJA\u0001\n\u0003\u0011y\bC\u0005\u0003\u0006\u001a\n\n\u0011\"\u0001\u0003\b\"I!1\u0014\u0014\u0012\u0002\u0013\u0005!Q\u0014\u0005\n\u0005C3\u0013\u0011!C!\u0005+B\u0011Ba)'\u0003\u0003%\t!a\r\t\u0013\t\u0015f%!A\u0005\u0002\t\u001d\u0006\"\u0003BYM\u0005\u0005I\u0011\tBZ\u0011%\u0011\tMJA\u0001\n\u0003\u0011\u0019\rC\u0005\u0003N\u001a\n\t\u0011\"\u0011\u0003P\"I!\u0011\u001b\u0014\u0002\u0002\u0013\u0005#1\u001b\u0005\n\u0005+4\u0013\u0011!C!\u0005/<\u0011Ba7!\u0003\u0003E\tA!8\u0007\u0013\t\u0005\u0004%!A\t\u0002\t}\u0007bBA\u0002q\u0011\u0005!Q\u001e\u0005\n\u0005#D\u0014\u0011!C#\u0005'D\u0011Ba<9\u0003\u0003%\tI!=\t\u0013\t]\b(!A\u0005\u0002\ne\b\"CB\u0004q\u0005\u0005I\u0011BB\u0005\u0011\u001d\t\t\b\tC\u0001\u0007#Aqaa\b!\t\u0003\u0019\t\u0003C\u0004\u0004 u!\te!\f\t\u0015\rUR$%A\u0005\u0002!\u001b9\u0004C\u0005\u0004\bu\t\t\u0011\"\u0003\u0004\n\tiAj\\2bY2#\u0015)T8eK2T!!\u0012$\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002H\u0011\u0006)Q\u000e\u001c7jE*\u0011\u0011JS\u0001\u0006gB\f'o\u001b\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001F\u000b\u0005\u0002R%6\tA)\u0003\u0002T\t\nAA\nR!N_\u0012,G\u000e\u0005\u0002V16\taKC\u0001X\u0003\u0015\u00198-\u00197b\u0013\tIfK\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004u_BL7m]\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qLR\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0005t&AB'biJL\u0007\u0010K\u0002\u0002G&\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002iK\n)1+\u001b8dK\u0006\n!.A\u00032]Mr\u0003'A\u0004u_BL7m\u001d\u0011)\u0007\t\u0019\u0017.\u0001\te_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]V\tq\u000e\u0005\u0002^a&\u0011\u0011O\u0018\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\r\u00197/I\u0001u\u0003\u0015\td&\u000e\u00181\u0003E!wnY\"p]\u000e,g\u000e\u001e:bi&|g\u000e\t\u0015\u0004\t\r\u001c\u0018A\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:,\u0012!\u001f\t\u0003+jL!a\u001f,\u0003\r\u0011{WO\u00197fQ\r)1m]\u0001\u0014i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g\u000e\t\u0015\u0004\r\r\u001c\u0018AC4b[6\f7\u000b[1qK\u0006Yq-Y7nCNC\u0017\r]3!\u0003\u0019a\u0014N\\5u}QQ\u0011qAA\u0005\u0003\u001b\t\t\"!\u0006\u0011\u0005E\u0003\u0001\"\u0002.\n\u0001\u0004a\u0006\u0006BA\u0005G&DQ!\\\u0005A\u0002=DC!!\u0004dg\")q/\u0003a\u0001s\"\"\u0011\u0011C2t\u0011\u001dy\u0018\u0002%AA\u0002e\fAa]3fIV\u0011\u00111\u0004\t\u0004+\u0006u\u0011bAA\u0010-\n!Aj\u001c8h\u0003!\u0019X-\u001a3`I\u0015\fH\u0003BA\u0013\u0003W\u00012!VA\u0014\u0013\r\tIC\u0016\u0002\u0005+:LG\u000fC\u0005\u0002.-\t\t\u00111\u0001\u0002\u001c\u0005\u0019\u0001\u0010J\u0019\u0002\u000bM,W\r\u001a\u0011\u0002\u0003-,\"!!\u000e\u0011\u0007U\u000b9$C\u0002\u0002:Y\u00131!\u00138uQ\ri1-[\u0001\nm>\u001c\u0017MY*ju\u0016D3AD2j\u00031!x\u000e]5dg6\u000bGO]5yQ\ry1-[\u0001\u000fI\u0016\u001c8M]5cKR{\u0007/[2t)\u0011\tI%!\u0017\u0011\u000bU\u000bY%a\u0014\n\u0007\u00055cKA\u0003BeJ\f\u0017\u0010E\u0004V\u0003#\n)&a\u0016\n\u0007\u0005McK\u0001\u0004UkBdWM\r\t\u0006+\u0006-\u0013Q\u0007\t\u0005+\u0006-\u0013\u0010C\u0004\u0002\\A\u0001\r!!\u000e\u0002!5\f\u0007\u0010V3s[N\u0004VM\u001d+pa&\u001c\u0007f\u0001\tdS\u00069q-\u001a;TK\u0016$\u0007\u0006B\td\u0003G\n#!!\u001a\u0002\u000bIrCG\f\u0019\u0002\u000fM,GoU3fIR!\u00111NA7\u001b\u0005\u0001\u0001bBA\f%\u0001\u0007\u00111\u0004\u0015\u0005%\r\f\u0019'\u0001\u0003tCZ,GCBA\u0013\u0003k\n\t\tC\u0004\u0002xM\u0001\r!!\u001f\u0002\u0005M\u001c\u0007\u0003BA>\u0003{j\u0011\u0001S\u0005\u0004\u0003\u007fB%\u0001D*qCJ\\7i\u001c8uKb$\bbBAB'\u0001\u0007\u0011QQ\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002\b\u0006Ue\u0002BAE\u0003#\u00032!a#W\u001b\t\tiIC\u0002\u0002\u0010:\u000ba\u0001\u0010:p_Rt\u0014bAAJ-\u00061\u0001K]3eK\u001aLA!a&\u0002\u001a\n11\u000b\u001e:j]\u001eT1!a%WQ\r\u00192m]\u0001\u000eY><G*[6fY&Dwn\u001c3\u0015\u0007e\f\t\u000bC\u0004\u0002$R\u0001\r!!*\u0002\u0013\u0011|7-^7f]R\u001c\bCBAT\u0003[\u000b\t,\u0004\u0002\u0002**\u0019\u00111\u0016%\u0002\u0007I$G-\u0003\u0003\u00020\u0006%&a\u0001*E\tB1Q+!\u0015\u0002\u001c=D3\u0001F2t)\rI\u0018q\u0017\u0005\b\u0003G+\u0002\u0019AA]!\u001d\tY,!2\u0002J>l!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\u0005U\u00064\u0018MC\u0002\u0002D\"\u000b1!\u00199j\u0013\u0011\t9-!0\u0003\u0017)\u000bg/\u0019)bSJ\u0014F\t\u0012\t\u0005\u0003\u0017\f\u0019.\u0004\u0002\u0002N*!\u0011qZAi\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0016\u0002BA\u0010\u0003\u001bD3!F2t\u00035awn\u001a)feBdW\r_5usR\u0019\u00110a7\t\u000f\u0005\rf\u00031\u0001\u0002&\"\u001aacY:\u0015\u0007e\f\t\u000fC\u0004\u0002$^\u0001\r!!/)\u0007]\u00197/\u0001\nm_\u001ed\u0015n[3mS\"|w\u000e\u001a\"pk:$GcD=\u0002j\u0006-\u0018q^Az\u0005\u000b\u00119A!\u0003\t\u000f\u0005\r\u0006\u00041\u0001\u0002&\"1\u0011Q\u001e\rA\u0002=\fQ!\u00197qQ\u0006Da!!=\u0019\u0001\u0004I\u0018aA3uC\"9\u0011Q\u001f\rA\u0002\u0005]\u0018A\u00027b[\n$\u0017\rE\u0003\u0002z\n\u0005\u00110\u0004\u0002\u0002|*\u0019q,!@\u000b\u0005\u0005}\u0018A\u00022sK\u0016TX-\u0003\u0003\u0003\u0004\u0005m(a\u0003#f]N,W*\u0019;sSbDQa \rA\u0002eDq!!\r\u0019\u0001\u0004\t)\u0004C\u0004\u0002>a\u0001\r!a\u0007\u0002%Q|\u0007/[2ESN$(/\u001b2vi&|gn\u001d\u000b\u0005\u0003K\u0013y\u0001C\u0004\u0002$f\u0001\r!!*)\u0007e\u0019\u0017.A\tu_BL7\rR5tiJL'-\u001e;j_:$2a\u001cB\f\u0011\u0019\u0011IB\u0007a\u0001_\u0006AAm\\2v[\u0016tG\u000f\u000b\u0003\u001bG\nu\u0011E\u0001B\u0010\u0003\u0015\u0011d\u0006\r\u00181)\u0011\tILa\t\t\u000f\u0005\r6\u00041\u0001\u0002:\"\"1d\u0019B\u0014C\t\u0011I#A\u00032]Qr\u0013\u0007K\u0002\u0001G&\fQ\u0002T8dC2dE)Q'pI\u0016d\u0007CA)\u001e'\u0019i\"1\u0007B\u001d)B\u0019QK!\u000e\n\u0007\t]bK\u0001\u0004B]f\u0014VM\u001a\t\u0007\u0005w\u0011\t%a\u0002\u000e\u0005\tu\"b\u0001B \r\u0006!Q\u000f^5m\u0013\u0011\u0011\u0019E!\u0010\u0003\r1{\u0017\rZ3s)\t\u0011y#\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007E\u0002\u0003L\u0001j\u0011!\b\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0004A\tMBC\u0001B%\u0003E!\b.[:G_Jl\u0017\r\u001e,feNLwN\\\u000b\u0003\u0005/\u0002B!a3\u0003Z%!\u0011qSAg\u0003I!\b.[:G_Jl\u0017\r\u001e,feNLwN\u001c\u0011\u0002\u001bQD\u0017n]\"mCN\u001ch*Y7f\u00039!\b.[:DY\u0006\u001c8OT1nK\u0002\u0012A\u0001R1uCN1aEa\r\u0003fQ\u00032!\u0016B4\u0013\r\u0011IG\u0016\u0002\b!J|G-^2u\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dA\u0005)\u0011N\u001c3fq\u00061\u0011N\u001c3fq\u0002\"bA!\u001e\u0003z\tm\u0004c\u0001B<M5\t\u0001\u0005\u0003\u0004\u0003l-\u0002\ra\u001c\u0005\b\u0005_Z\u0003\u0019AA\u001b\u0003\u0011\u0019w\u000e]=\u0015\r\tU$\u0011\u0011BB\u0011!\u0011Y\u0007\fI\u0001\u0002\u0004y\u0007\"\u0003B8YA\u0005\t\u0019AA\u001b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!#+\u0007=\u0014Yi\u000b\u0002\u0003\u000eB!!q\u0012BL\u001b\t\u0011\tJ\u0003\u0003\u0003\u0014\nU\u0015!C;oG\",7m[3e\u0015\t1g+\u0003\u0003\u0003\u001a\nE%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BPU\u0011\t)Da#\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!+\u00030B\u0019QKa+\n\u0007\t5fKA\u0002B]fD\u0011\"!\f2\u0003\u0003\u0005\r!!\u000e\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!.\u0011\r\t]&Q\u0018BU\u001b\t\u0011ILC\u0002\u0003<Z\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yL!/\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u000b\u0014Y\rE\u0002V\u0005\u000fL1A!3W\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\f4\u0003\u0003\u0005\rA!+\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0016\u0002\r\u0015\fX/\u00197t)\u0011\u0011)M!7\t\u0013\u00055b'!AA\u0002\t%\u0016\u0001\u0002#bi\u0006\u00042Aa\u001e9'\u0011A$\u0011\u001d+\u0011\u0013\t\r(\u0011^8\u00026\tUTB\u0001Bs\u0015\r\u00119OV\u0001\beVtG/[7f\u0013\u0011\u0011YO!:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003^\u0006)\u0011\r\u001d9msR1!Q\u000fBz\u0005kDaAa\u001b<\u0001\u0004y\u0007b\u0002B8w\u0001\u0007\u0011QG\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011Ypa\u0001\u0011\u000bU\u0013ip!\u0001\n\u0007\t}hK\u0001\u0004PaRLwN\u001c\t\u0007+\u0006Es.!\u000e\t\u0013\r\u0015A(!AA\u0002\tU\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0001\u0005\u0003\u0002L\u000e5\u0011\u0002BB\b\u0003\u001b\u0014aa\u00142kK\u000e$HCDA\u0013\u0007'\u0019)ba\u0006\u0004\u001a\rm1Q\u0004\u0005\b\u0003or\u0004\u0019AA=\u0011\u001d\t\u0019I\u0010a\u0001\u0003\u000bCa!!\u0011?\u0001\u0004a\u0006\"B7?\u0001\u0004y\u0007\"B<?\u0001\u0004I\b\"B@?\u0001\u0004I\u0018\u0001\u00027pC\u0012$B\"a\u0002\u0004$\r\u00152qEB\u0015\u0007WAq!a\u001e@\u0001\u0004\tI\bC\u0004\u0002\u0004~\u0002\r!!\"\t\u000b5|\u0004\u0019A8\t\u000b]|\u0004\u0019A=\t\u000b}|\u0004\u0019A=\u0015\r\u0005\u001d1qFB\u0019\u0011\u001d\t9\b\u0011a\u0001\u0003sBq!a!A\u0001\u0004\t)\tK\u0002AGN\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAB\u001dU\rI(1\u0012\u0015\u0004;\r\u001c\bf\u0001\u000fdg\u0002")
public class LocalLDAModel
extends LDAModel
implements scala.Serializable {
    private final Matrix topics;
    private final Vector docConcentration;
    private final double topicConcentration;
    private final double gammaShape;
    private long seed;

    public static LocalLDAModel load(SparkContext sparkContext, String string) {
        return LocalLDAModel$.MODULE$.load(sparkContext, string);
    }

    public Matrix topics() {
        return this.topics;
    }

    @Override
    public Vector docConcentration() {
        return this.docConcentration;
    }

    @Override
    public double topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public double gammaShape() {
        return this.gammaShape;
    }

    public long seed() {
        return this.seed;
    }

    public void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    @Override
    public int k() {
        return this.topics().numCols();
    }

    @Override
    public int vocabSize() {
        return this.topics().numRows();
    }

    @Override
    public Matrix topicsMatrix() {
        return this.topics();
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        DenseMatrix brzTopics = this.topics().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        return (Tuple2[])((TraversableOnce)package$.MODULE$.Range().apply(0, this.k()).map((Function1 & Serializable & scala.Serializable)topicIndex -> LocalLDAModel.$anonfun$describeTopics$1(brzTopics, maxTermsPerTopic, BoxesRunTime.unboxToInt((Object)topicIndex)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public long getSeed() {
        return this.seed();
    }

    public LocalLDAModel setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    @Override
    public void save(SparkContext sc, String path) {
        LocalLDAModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.topicsMatrix(), this.docConcentration(), this.topicConcentration(), this.gammaShape());
    }

    public double logLikelihood(RDD<Tuple2<Object, Vector>> documents) {
        return this.logLikelihoodBound(documents, this.docConcentration(), this.topicConcentration(), (DenseMatrix<Object>)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), this.gammaShape(), this.k(), this.vocabSize());
    }

    public double logLikelihood(JavaPairRDD<Long, Vector> documents) {
        return this.logLikelihood((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    public double logPerplexity(RDD<Tuple2<Object, Vector>> documents) {
        double corpusTokenCount = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logPerplexity$1(x0$1)), ClassTag$.MODULE$.Double())).sum();
        return -this.logLikelihood(documents) / corpusTokenCount;
    }

    public double logPerplexity(JavaPairRDD<Long, Vector> documents) {
        return this.logPerplexity((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private double logLikelihoodBound(RDD<Tuple2<Object, Vector>> documents, Vector alpha, double eta, DenseMatrix<Object> lambda, double gammaShape, int k, long vocabSize) {
        DenseVector brzAlpha = alpha.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
        DenseMatrix Elogbeta = (DenseMatrix)LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)lambda.t(HasOps$.MODULE$.canTranspose_DM()))).t(HasOps$.MODULE$.canTranspose_DM());
        Broadcast ElogbetaBc = documents.sparkContext().broadcast((Object)Elogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        long gammaSeed = this.seed();
        double corpusPart = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalLDAModel.$anonfun$logLikelihoodBound$1(x$3))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logLikelihoodBound$2(ElogbetaBc, brzAlpha, gammaShape, k, gammaSeed, x0$1)), ClassTag$.MODULE$.Double())).sum();
        ElogbetaBc.destroy();
        double sumEta = eta * (double)vocabSize;
        double topicsPart = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)eta))).$minus(lambda, HasOps$.MODULE$.s_dm_op_Double_OpSub())).$times$colon$times((Object)Elogbeta, HasOps$.MODULE$.op_DM_DM_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply(lambda, HasOps$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(eta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)), HasOps$.MODULE$.op_DM_S_Double_OpSub()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(sumEta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)))).$minus(package.lgamma$.MODULE$.apply(sum$.MODULE$.apply(lambda.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(HasOps$.MODULE$.handholdCanMapRows_DM())), sum$.MODULE$.vectorizeCols_Double(sum$.MODULE$.helper_Double())), HasOps$.MODULE$.liftUFunc(HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())), HasOps$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))), HasOps$.MODULE$.impl_Op_LHS_DVt_eq_R_cast(HasOps$.MODULE$.s_dm_op_Double_OpSub())), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.canTraverseValues())));
        return corpusPart + topicsPart;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions(RDD<Tuple2<Object, Vector>> documents) {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()).t(HasOps$.MODULE$.canTranspose_DM()))).t(HasOps$.MODULE$.canTranspose_DM()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())));
        Broadcast expElogbetaBc = documents.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return documents.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long id = tuple2._1$mcJ$sp();
                Vector termCounts = (Vector)tuple2._2();
                long l = id;
                if (termCounts != null) {
                    Vector vector = termCounts;
                    if (vector.numNonzeros() == 0) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.zeros(k));
                    }
                    Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc.value()), docConcentrationBrz, gammaShape, k, gammaSeed + l);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    DenseVector gamma = (DenseVector)tuple3._1();
                    DenseVector gamma2 = gamma;
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv(), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).toArray$mcD$sp(ClassTag$.MODULE$.Double())));
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector topicDistribution(Vector document) {
        long gammaSeed = this.seed();
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()).t(HasOps$.MODULE$.canTranspose_DM()))).t(HasOps$.MODULE$.canTranspose_DM()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())));
        if (document.numNonzeros() == 0) {
            return Vectors$.MODULE$.zeros(this.k());
        }
        Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(document, (DenseMatrix<Object>)expElogbeta, this.docConcentration().asBreeze(), this.gammaShape(), this.k(), gammaSeed);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        DenseVector gamma = (DenseVector)tuple3._1();
        DenseVector gamma2 = gamma;
        return Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv(), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
    }

    public JavaPairRDD<Long, Vector> topicDistributions(JavaPairRDD<Long, Vector> documents) {
        RDD<Tuple2<Object, Vector>> distributions = this.topicDistributions((RDD<Tuple2<Object, Vector>>)documents.rdd());
        return JavaPairRDD$.MODULE$.fromRDD(distributions, ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(Vector.class));
    }

    public static final /* synthetic */ double $anonfun$describeTopics$2(Tuple2 x$1) {
        return -x$1._1$mcD$sp();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeTopics$1(DenseMatrix brzTopics$1, int maxTermsPerTopic$1, int topicIndex) {
        DenseVector topic = (DenseVector)normalize$.MODULE$.apply(brzTopics$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)topicIndex), HasOps$.MODULE$.canSliceCol()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv(), norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(topic.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$describeTopics$2(x$1)), (Ordering)Ordering.Double$.MODULE$))).take(maxTermsPerTopic$1))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] termWeights = (double[])tuple2._1();
        int[] terms = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)termWeights, (Object)terms);
        double[] termWeights2 = (double[])tuple22._1();
        int[] terms2 = (int[])tuple22._2();
        return new Tuple2((Object)terms2, (Object)termWeights2);
    }

    public static final /* synthetic */ double $anonfun$logPerplexity$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Vector termCounts = (Vector)tuple2._2();
            return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termCounts.toArray())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$logLikelihoodBound$1(Tuple2 x$3) {
        return ((Vector)x$3._2()).numNonzeros() > 0;
    }

    public static final /* synthetic */ double $anonfun$logLikelihoodBound$2(Broadcast ElogbetaBc$1, DenseVector brzAlpha$1, double gammaShape$1, int k$1, long gammaSeed$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long id = tuple2._1$mcJ$sp();
            Vector termCounts = (Vector)tuple2._2();
            long l = id;
            if (termCounts != null) {
                DenseVector gammad;
                Vector vector = termCounts;
                DenseMatrix localElogbeta = (DenseMatrix)ElogbetaBc$1.value();
                DoubleRef docBound = DoubleRef.create((double)0.0);
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)package.exp$.MODULE$.apply((Object)localElogbeta, HasOps$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())))), (breeze.linalg.Vector<Object>)brzAlpha$1, gammaShape$1, k$1, gammaSeed$1 + l);
                if (tuple3 == null || (gammad = (DenseVector)tuple3._1()) == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector denseVector = gammad;
                DenseVector gammad2 = denseVector;
                DenseVector<Object> Elogthetad = LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad2);
                vector.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                    if (sp2 != null) {
                        int idx = sp2._1$mcI$sp();
                        double count = sp2._2$mcD$sp();
                        docBound$1.elem += count * LDAUtils$.MODULE$.logSumExp((DenseVector<Object>)((DenseVector)Elogthetad.$plus(((ImmutableNumericOps)localElogbeta.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRow())).t(HasOps$.MODULE$.canUntranspose()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())));
                        return;
                    }
                    throw new MatchError((Object)sp2);
                });
                docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)brzAlpha$1.$minus((Object)gammad2, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).$times$colon$times(Elogthetad, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues())));
                docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply((Object)gammad2, HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus(package.lgamma$.MODULE$.apply((Object)brzAlpha$1, HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues())));
                docBound.elem += package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)brzAlpha$1, sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$) - package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad2, sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$);
                return docBound.elem;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public LocalLDAModel(Matrix topics, Vector docConcentration, double topicConcentration, double gammaShape) {
        this.topics = topics;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.gammaShape = gammaShape;
        this.seed = Utils$.MODULE$.random().nextLong();
    }
}

