/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.support.CanZipMapValues;
import breeze.math.Semiring$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.ExpectationAggregator;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0010!\u0001-B\u0001\"\u0010\u0001\u0003\u0006\u0004%\tE\u0010\u0005\t+\u0002\u0011\t\u0011)A\u0005\u007f!)q\u000b\u0001C\u00011\")Q\f\u0001C!=\")q\u000b\u0001C\u0001Q\")!\u000e\u0001C\u0001W\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001s\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005u\u0002\u0001)A\u0005\u0003\u0007Aq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u0011\u0011\u001b\u0001\u0005\n\u0005MwaBAqA!\u0005\u00111\u001d\u0004\u0007?\u0001B\t!!:\t\r]3B\u0011AA}\u0011)\tYP\u0006b\u0001\n\u0003\u0001\u00131\b\u0005\t\u0003{4\u0002\u0015!\u0003\u0002\u0004!9\u0011q \f\u0005B\t\u0005\u0001\u0002\u0003B\u0005-\u0011\u0005\u0001Ea\u0003\t\u000f\tma\u0003\"\u0003\u0003\u001e!A!Q\u0006\f\u0005\u0002\u0001\u0012y\u0003C\u0005\u0003DY\t\t\u0011\"\u0003\u0003F\tyq)Y;tg&\fg.T5yiV\u0014XM\u0003\u0002\"E\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\r\"\u0013AA7m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0005\u00011\"t\u0007E\u0002.]Aj\u0011AI\u0005\u0003_\t\u0012\u0011\"R:uS6\fGo\u001c:\u0011\u0005E\u0012T\"\u0001\u0011\n\u0005M\u0002#\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,G\u000e\u0005\u00022k%\u0011a\u0007\t\u0002\u0016\u000f\u0006,8o]5b]6K\u0007\u0010^;sKB\u000b'/Y7t!\tA4(D\u0001:\u0015\tQ$%\u0001\u0003vi&d\u0017B\u0001\u001f:\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005y\u0004C\u0001!J\u001d\t\tu\t\u0005\u0002C\u000b6\t1I\u0003\u0002EU\u00051AH]8pizR\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*\u0012\u0015\u0004\u00035\u001b\u0006C\u0001(R\u001b\u0005y%B\u0001)%\u0003)\tgN\\8uCRLwN\\\u0005\u0003%>\u0013QaU5oG\u0016\f\u0013\u0001V\u0001\u0006e9\u0002d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003\u001bN\u000ba\u0001P5oSRtDCA-[!\t\t\u0004\u0001C\u0003>\u0007\u0001\u0007q\bK\u0002[\u001bNC3aA'T\u0003\u0011\u0019w\u000e]=\u0015\u0005e{\u0006\"\u00021\u0005\u0001\u0004\t\u0017!B3yiJ\f\u0007C\u00012f\u001b\u0005\u0019'B\u00013#\u0003\u0015\u0001\u0018M]1n\u0013\t17M\u0001\u0005QCJ\fW.T1qQ\r!Qj\u0015\u000b\u00023\"\u001aQ!T*\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011A.\\\u0007\u0002\u0001!)aN\u0002a\u0001\u007f\u0005)a/\u00197vK\"\u001aa!T*\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGC\u00017s\u0011\u0015qw\u00011\u0001@Q\r9QjU\u0001\u0012g\u0016$\bK]8cC\nLG.\u001b;z\u0007>dGC\u00017w\u0011\u0015q\u0007\u00021\u0001@Q\rAQjU\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0003YjDQA\\\u0005A\u0002}B3!C'}C\u0005i\u0018!B\u001a/a9\u0002\u0014\u0001B:fi.#2\u0001\\A\u0001\u0011\u0019q'\u00021\u0001\u0002\u0004A!\u0011QAA\u0004\u001b\u0005)\u0015bAA\u0005\u000b\n\u0019\u0011J\u001c;)\u0007)i5+\u0001\u0006tKRl\u0015\r_%uKJ$2\u0001\\A\t\u0011\u0019q7\u00021\u0001\u0002\u0004!\u001a1\"T*\u0002\rM,G\u000fV8m)\ra\u0017\u0011\u0004\u0005\u0007]2\u0001\r!a\u0007\u0011\t\u0005\u0015\u0011QD\u0005\u0004\u0003?)%A\u0002#pk\ndW\rK\u0002\r\u001bN\u000bqa]3u'\u0016,G\rF\u0002m\u0003OAaA\\\u0007A\u0002\u0005%\u0002\u0003BA\u0003\u0003WI1!!\fF\u0005\u0011auN\\4)\u00075i5+A\ntKR\fum\u001a:fO\u0006$\u0018n\u001c8EKB$\b\u000eF\u0002m\u0003kAaA\u001c\bA\u0002\u0005\r\u0001f\u0001\bNy\u0006Qa.^7TC6\u0004H.Z:\u0016\u0005\u0005\r\u0011a\u00038v[N\u000bW\u000e\u001d7fg\u0002\n1AZ5u)\r\u0001\u00141\t\u0005\b\u0003\u000b\n\u0002\u0019AA$\u0003\u001d!\u0017\r^1tKR\u0004D!!\u0013\u0002ZA1\u00111JA)\u0003+j!!!\u0014\u000b\u0007\u0005=C%A\u0002tc2LA!a\u0015\u0002N\t9A)\u0019;bg\u0016$\b\u0003BA,\u00033b\u0001\u0001\u0002\u0007\u0002\\\u0005\r\u0013\u0011!A\u0001\u0006\u0003\tiFA\u0002`II\nB!a\u0018\u0002fA!\u0011QAA1\u0013\r\t\u0019'\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\t)!a\u001a\n\u0007\u0005%TIA\u0002B]fD3!E'T\u0003%!(/Y5o\u00136\u0004H\u000e\u0006\u0007\u0002r\u0005]\u0014QSAP\u0003[\u000b\t\f\u0005\u0005\u0002\u0006\u0005M\u00141DA\u0002\u0013\r\t)(\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005e$\u00031\u0001\u0002|\u0005I\u0011N\\:uC:\u001cWm\u001d\t\u0007\u0003{\n\u0019)a\"\u000e\u0005\u0005}$bAAAI\u0005\u0019!\u000f\u001a3\n\t\u0005\u0015\u0015q\u0010\u0002\u0004%\u0012#\u0005\u0003CA\u0003\u0003g\nI)a\u0007\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$#\u0003\u0019a\u0017N\\1mO&!\u00111SAG\u0005\u00191Vm\u0019;pe\"9\u0011q\u0013\nA\u0002\u0005e\u0015aB<fS\u001eDGo\u001d\t\u0007\u0003\u000b\tY*a\u0007\n\u0007\u0005uUIA\u0003BeJ\f\u0017\u0010C\u0004\u0002\"J\u0001\r!a)\u0002\u0013\u001d\fWo]:jC:\u001c\bCBA\u0003\u00037\u000b)\u000b\u0005\u0005\u0002\u0006\u0005M\u0014qUAT!\u0011\tY)!+\n\t\u0005-\u0016Q\u0012\u0002\f\t\u0016t7/\u001a,fGR|'\u000fC\u0004\u00020J\u0001\r!a\u0001\u0002\u00179,XNR3biV\u0014Xm\u001d\u0005\b\u0003g\u0013\u0002\u0019AA[\u0003\u0015Ign\u001d;s!\rA\u0014qW\u0005\u0004\u0003sK$aD%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a0\u0002LB!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u00065\u0013!\u0002;za\u0016\u001c\u0018\u0002BAe\u0003\u0007\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tim\u0005a\u0001\u0003\u007f\u000baa]2iK6\f\u0007fA\nN'\u0006Q\u0011N\\5u%\u0006tGm\\7\u0015\u0011\u0005U\u0017q[Am\u0003;\u0004\u0002\"!\u0002\u0002t\u0005e\u00151\u0015\u0005\b\u0003s\"\u0002\u0019AA>\u0011\u001d\tY\u000e\u0006a\u0001\u0003\u0007\t1B\\;n\u00072,8\u000f^3sg\"9\u0011q\u0016\u000bA\u0002\u0005\r\u0001f\u0001\u0001N'\u0006yq)Y;tg&\fg.T5yiV\u0014X\r\u0005\u00022-M9a#a:\u0002n\u0006M\b\u0003BA\u0003\u0003SL1!a;F\u0005\u0019\te.\u001f*fMB!\u0001(a<Z\u0013\r\t\t0\u000f\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\u0011\t)!!>\n\u0007\u0005]XI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002d\u0006\u0001R*\u0011-`\u001dVkuLR#B)V\u0013ViU\u0001\u0012\u001b\u0006CvLT+N?\u001a+\u0015\tV+S\u000bN\u0003\u0013\u0001\u00027pC\u0012$2!\u0017B\u0002\u0011\u0019\u0011)A\u0007a\u0001\u007f\u0005!\u0001/\u0019;iQ\rQRjU\u0001\u001ck:\u0004\u0018mY6VaB,'\u000f\u0016:jC:<W\u000f\\1s\u001b\u0006$(/\u001b=\u0015\r\t5!1\u0003B\f!\u0011\tYIa\u0004\n\t\tE\u0011Q\u0012\u0002\f\t\u0016t7/Z'biJL\u0007\u0010C\u0004\u0003\u0016m\u0001\r!a\u0001\u0002\u00039DqA!\u0007\u001c\u0001\u0004\tI*\u0001\tue&\fgnZ;mCJ4\u0016\r\\;fg\u0006\tR.\u001a:hK^+\u0017n\u001a5ug6+\u0017M\\:\u0015\r\t}!Q\u0005B\u0015!1\t)A!\t\u0002(\u0006\u001d\u00161DA\u000e\u0013\r\u0011\u0019#\u0012\u0002\u0007)V\u0004H.\u001a\u001b\t\u000f\t\u001dB\u00041\u0001\u0003 \u0005\t\u0011\rC\u0004\u0003,q\u0001\rAa\b\u0002\u0003\t\f\u0011$\u001e9eCR,w+Z5hQR\u001c\u0018I\u001c3HCV\u001c8/[1ogRQ!\u0011\u0007B\u001a\u0005o\u0011YDa\u0010\u0011\u0011\u0005\u0015\u00111OA\u000e\u0003KCqA!\u000e\u001e\u0001\u0004\t9+\u0001\u0003nK\u0006t\u0007b\u0002B\u001d;\u0001\u0007\u0011qU\u0001\u0004G>4\bb\u0002B\u001f;\u0001\u0007\u00111D\u0001\u0007o\u0016Lw\r\u001b;\t\u000f\t\u0005S\u00041\u0001\u0002\u001c\u0005Q1/^7XK&<\u0007\u000e^:\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000f\u0002BA!\u0013\u0003T5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%\u0001\u0003mC:<'B\u0001B)\u0003\u0011Q\u0017M^1\n\t\tU#1\n\u0002\u0007\u001f\nTWm\u0019;)\u0007Yi5\u000bK\u0002\u0016\u001bN\u0003")
public class GaussianMixture
extends Estimator<GaussianMixtureModel>
implements GaussianMixtureParams,
DefaultParamsWritable {
    private final String uid;
    private final int numSamples;
    private final IntParam k;
    private final IntParam aggregationDepth;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> weightCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static GaussianMixture load(String string) {
        return GaussianMixture$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixture> read() {
        return GaussianMixture$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GaussianMixture copy(ParamMap extra) {
        return (GaussianMixture)this.defaultCopy(extra);
    }

    public GaussianMixture setFeaturesCol(String value) {
        return (GaussianMixture)this.set(this.featuresCol(), value);
    }

    public GaussianMixture setPredictionCol(String value) {
        return (GaussianMixture)this.set(this.predictionCol(), value);
    }

    public GaussianMixture setProbabilityCol(String value) {
        return (GaussianMixture)this.set(this.probabilityCol(), value);
    }

    public GaussianMixture setWeightCol(String value) {
        return (GaussianMixture)this.set(this.weightCol(), value);
    }

    public GaussianMixture setK(int value) {
        return (GaussianMixture)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setMaxIter(int value) {
        return (GaussianMixture)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setTol(double value) {
        return (GaussianMixture)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public GaussianMixture setSeed(long value) {
        return (GaussianMixture)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public GaussianMixture setAggregationDepth(int value) {
        return (GaussianMixture)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    private int numSamples() {
        return this.numSamples;
    }

    @Override
    public GaussianMixtureModel fit(Dataset<?> dataset) {
        return (GaussianMixtureModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            SparkSession spark = dataset.sparkSession();
            int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            Predef$.MODULE$.require(numFeatures < GaussianMixture$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(131).append("GaussianMixture cannot handle more ").append("than ").append(GaussianMixture$.MODULE$.MAX_NUM_FEATURES()).append(" features because the size of the covariance").append(" matrix is quadratic in the number of features.").toString());
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.probabilityCol(), this.weightCol(), this.k(), this.maxIter(), this.seed(), this.tol(), this.aggregationDepth()}));
            instr.logNumFeatures(numFeatures);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixture.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixture$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_clustering_GaussianMixture$$typecreator5$1(GaussianMixture $outer) {
                }
            }
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkNonNanVectors(DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()))), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()))})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixture$$typecreator5$1(null)))).rdd().setName("training instances");
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> tuple2 = this.initRandom((RDD<Tuple2<org.apache.spark.ml.linalg.Vector, Object>>)instances, BoxesRunTime.unboxToInt((Object)this.$(this.k())), numFeatures);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double[] weights = (double[])tuple2._1();
            Tuple2[] gaussians = (Tuple2[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)weights, (Object)gaussians);
            double[] weights2 = (double[])tuple22._1();
            Tuple2[] gaussians2 = (Tuple2[])tuple22._2();
            Tuple2<Object, Object> tuple23 = this.trainImpl((RDD<Tuple2<org.apache.spark.ml.linalg.Vector, Object>>)instances, weights2, (Tuple2<DenseVector, DenseVector>[])gaussians2, numFeatures, (Instrumentation)instr);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            double logLikelihood = tuple23._1$mcD$sp();
            int iteration = tuple23._2$mcI$sp();
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(logLikelihood, iteration);
            double logLikelihood2 = sp2._1$mcD$sp();
            int iteration2 = sp2._2$mcI$sp();
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            MultivariateGaussian[] gaussianDists = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians2)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DenseVector mean = (DenseVector)tuple2._1();
                    DenseVector covVec = (DenseVector)tuple2._2();
                    DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix(numFeatures, covVec.values());
                    return new MultivariateGaussian((org.apache.spark.ml.linalg.Vector)mean, (Matrix)cov);
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = ((Model)this.copyValues(new GaussianMixtureModel(this.uid(), weights2, gaussianDists), this.copyValues$default$2())).setParent(this);
            GaussianMixtureSummary summary = new GaussianMixtureSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.probabilityCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), logLikelihood2, iteration2);
            instr.logNamedValue("logLikelihood", logLikelihood2);
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            return (GaussianMixtureModel)model.setSummary((Option<GaussianMixtureSummary>)new Some((Object)summary));
        });
    }

    private Tuple2<Object, Object> trainImpl(RDD<Tuple2<org.apache.spark.ml.linalg.Vector, Object>> instances, double[] weights, Tuple2<DenseVector, DenseVector>[] gaussians, int numFeatures, Instrumentation instr) {
        SparkContext sc = instances.sparkContext();
        double logLikelihood = Double$.MODULE$.MinValue();
        double logLikelihoodPrev = 0.0;
        IntRef iteration = IntRef.create((int)0);
        while (iteration.elem < BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())) && scala.math.package$.MODULE$.abs(logLikelihood - logLikelihoodPrev) > BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))) {
            DoubleAccumulator weightSumAccum = iteration.elem == 0 ? sc.doubleAccumulator() : null;
            DoubleAccumulator logLikelihoodAccum = sc.doubleAccumulator();
            Broadcast bcWeights = sc.broadcast((Object)weights, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcGaussians = sc.broadcast(gaussians, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(instances.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                if (iter.nonEmpty()) {
                    ExpectationAggregator agg = new ExpectationAggregator(numFeatures, (Broadcast<double[]>)bcWeights, (Broadcast<Tuple2<DenseVector, DenseVector>[]>)bcGaussians);
                    while (iter.hasNext()) {
                        agg.add((Tuple2<org.apache.spark.ml.linalg.Vector, Object>)((Tuple2)iter.next()));
                    }
                    double ws = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(agg.weights())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    if (iteration$1.elem == 0) {
                        weightSumAccum.add(ws);
                    }
                    logLikelihoodAccum.add(agg.logLikelihood());
                    return scala.package$.MODULE$.Iterator().tabulate(((double[])bcWeights.value()).length, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$trainImpl$2(agg, ws, BoxesRunTime.unboxToInt((Object)i)));
                }
                return scala.package$.MODULE$.Iterator().empty();
            }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple4.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(a, b) -> GaussianMixture$.MODULE$.org$apache$spark$ml$clustering$GaussianMixture$$mergeWeightsMeans((Tuple4<DenseVector, DenseVector, Object, Object>)a, (Tuple4<DenseVector, DenseVector, Object, Object>)b)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple4.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple4 tuple4 = x0$1;
                if (tuple4 != null) {
                    DenseVector mean = (DenseVector)tuple4._1();
                    DenseVector cov = (DenseVector)tuple4._2();
                    double w = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double ws = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    return GaussianMixture$.MODULE$.updateWeightsAndGaussians(mean, cov, w, ws);
                }
                throw new MatchError((Object)tuple4);
            }).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                GaussianMixture.$anonfun$trainImpl$5(weights, gaussians, x0$2);
                return BoxedUnit.UNIT;
            });
            bcWeights.destroy();
            bcGaussians.destroy();
            if (iteration.elem == 0) {
                instr.logNumExamples(weightSumAccum.count());
                instr.logSumOfWeights(Predef$.MODULE$.Double2double(weightSumAccum.value()));
            }
            logLikelihoodPrev = logLikelihood;
            logLikelihood = Predef$.MODULE$.Double2double(logLikelihoodAccum.value());
            instr.logNamedValue(new StringBuilder(18).append("logLikelihood@iter").append(iteration.elem).toString(), logLikelihood);
            ++iteration.elem;
        }
        return new Tuple2.mcDI.sp(logLikelihood, iteration.elem);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    private Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> initRandom(RDD<Tuple2<org.apache.spark.ml.linalg.Vector, Object>> instances, int numClusters, int numFeatures) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances.takeSample(true, numClusters * this.numSamples(), BoxesRunTime.unboxToLong((Object)this.$(this.seed()))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        org.apache.spark.ml.linalg.Vector[] samples = (org.apache.spark.ml.linalg.Vector[])tuple2._1();
        double[] sampleWeights = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)samples, (Object)sampleWeights);
        org.apache.spark.ml.linalg.Vector[] samples2 = (org.apache.spark.ml.linalg.Vector[])tuple22._1();
        double[] sampleWeights2 = (double[])tuple22._2();
        double[] weights = new double[numClusters];
        double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sampleWeights2)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        Tuple2[] gaussians = (Tuple2[])Array$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$initRandom$1(this, samples2, sampleWeights2, weights, weightSum, numFeatures, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2((Object)weights, (Object)gaussians);
    }

    public static final /* synthetic */ Tuple2 $anonfun$trainImpl$2(ExpectationAggregator agg$1, double ws$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new Tuple4((Object)agg$1.means()[i], (Object)agg$1.covs()[i], (Object)BoxesRunTime.boxToDouble((double)agg$1.weights()[i]), (Object)BoxesRunTime.boxToDouble((double)ws$1)));
    }

    public static final /* synthetic */ void $anonfun$trainImpl$5(double[] weights$1, Tuple2[] gaussians$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                double weight = tuple22._1$mcD$sp();
                Tuple2 gaussian = (Tuple2)tuple22._2();
                weights$1[i] = weight;
                gaussians$1[i] = gaussian;
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$initRandom$1(GaussianMixture $this, org.apache.spark.ml.linalg.Vector[] samples$1, double[] sampleWeights$1, double[] weights$2, double weightSum$1, int numFeatures$3, int i2) {
        int start = i2 * $this.numSamples();
        int end = start + $this.numSamples();
        IndexedSeqView sampleSlice = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples$1)).view().slice(start, end);
        IndexedSeqView weightSlice = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sampleWeights$1)).view().slice(start, end);
        double localWeightSum = BoxesRunTime.unboxToDouble((Object)weightSlice.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        weights$2[i2] = localWeightSum / weightSum$1;
        DenseVector v2 = new DenseVector(new double[numFeatures$3]);
        for (int j = 0; j < $this.numSamples(); ++j) {
            BLAS$.MODULE$.axpy(BoxesRunTime.unboxToDouble((Object)weightSlice.apply(j)), (org.apache.spark.ml.linalg.Vector)sampleSlice.apply(j), (org.apache.spark.ml.linalg.Vector)v2);
        }
        BLAS$.MODULE$.scal(1.0 / localWeightSum, (org.apache.spark.ml.linalg.Vector)v2);
        DenseVector mean = v2;
        Vector ss = new DenseVector(new double[numFeatures$3]).asBreeze();
        for (int j = 0; j < $this.numSamples(); ++j) {
            Vector v3 = (Vector)((org.apache.spark.ml.linalg.Vector)sampleSlice.apply(j)).asBreeze().$minus((Object)mean.asBreeze(), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpSub());
            ss.$plus$eq(((ImmutableNumericOps)v3.$times((Object)v3, HasOps$.MODULE$.impl_T_S_eq_U_from_ZipMap(Vector$.MODULE$.scalarOf(), OpMulMatrix$.MODULE$.opMulMatrixFromSemiring(Semiring$.MODULE$.semiringD()), (CanZipMapValues)HasOps$.MODULE$.canZipMapValues_V(ClassTag$.MODULE$.Double())))).$times(weightSlice.apply(j), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_V_Idempotent_Double_OpAdd());
        }
        org.apache.spark.ml.linalg.Vector diagVec = Vectors$.MODULE$.fromBreeze(ss);
        BLAS$.MODULE$.scal(1.0 / localWeightSum, diagVec);
        DenseVector covVec = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures$3 * (numFeatures$3 + 1) / 2, ClassTag$.MODULE$.Double()));
        diagVec.foreach((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
            covVec$1.values()[i + i * (i + 1) / 2] = v;
        });
        DenseVector cov = covVec;
        return new Tuple2((Object)mean, (Object)cov);
    }

    public GaussianMixture(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        HasAggregationDepth.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.numSamples = 5;
    }

    public GaussianMixture() {
        this(Identifiable$.MODULE$.randomUID("GaussianMixture"));
    }
}

