/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class LinearDataGenerator$ {
    public static LinearDataGenerator$ MODULE$;

    static {
        new LinearDataGenerator$();
    }

    public List<LabeledPoint> generateLinearInputAsList(double intercept, double[] weights, int nPoints, int seed, double eps) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.generateLinearInput(intercept, weights, nPoints, seed, eps)).asJava();
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, int nPoints, int seed, double eps) {
        return this.generateLinearInput(intercept, weights, (double[])Array$.MODULE$.ofDim(weights.length, ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.fill(weights.length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.3333333333333333, ClassTag$.MODULE$.Double()), nPoints, seed, eps);
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, double[] xMean, double[] xVariance, int nPoints, int seed, double eps) {
        return this.generateLinearInput(intercept, weights, xMean, xVariance, nPoints, seed, eps, 0.0);
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, double[] xMean, double[] xVariance, int nPoints, int seed, double eps, double sparsity) {
        Predef$.MODULE$.require(0.0 <= sparsity && sparsity <= 1.0);
        Random rnd = new Random(seed);
        if (sparsity == 0.0) {
            return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)x$1 -> LinearDataGenerator$.$anonfun$generateLinearInput$2(weights, intercept, eps, rnd, xVariance, xMean, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)x$3 -> LinearDataGenerator$.$anonfun$generateLinearInput$4(weights, rnd, sparsity, intercept, eps, xVariance, xMean, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public double generateLinearInput$default$5() {
        return 0.1;
    }

    public RDD<LabeledPoint> generateLinearRDD(SparkContext sc, int nexamples, int nfeatures, double eps, int nparts, double intercept) {
        Random random = new Random(42);
        double[] w = (double[])Array$.MODULE$.fill(nfeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextDouble() - 0.5, ClassTag$.MODULE$.Double());
        RDD data = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nparts), nparts, ClassTag$.MODULE$.Int()).flatMap((Function1 & Serializable & scala.Serializable)p -> LinearDataGenerator$.$anonfun$generateLinearRDD$2(nexamples, nparts, intercept, w, eps, BoxesRunTime.unboxToInt((Object)p)), ClassTag$.MODULE$.apply(LabeledPoint.class));
        return data;
    }

    public int generateLinearRDD$default$5() {
        return 2;
    }

    public double generateLinearRDD$default$6() {
        return 0.0;
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: LinearDataGenerator <master> <output_dir> [num_examples] [num_features] [num_partitions]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 1000;
        int nfeatures = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 100;
        int parts = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 2;
        int eps = 10;
        SparkContext sc = new SparkContext(sparkMaster, "LinearDataGenerator");
        RDD<LabeledPoint> data = this.generateLinearRDD(sc, nexamples, nfeatures, eps, parts, this.generateLinearRDD$default$6());
        data.saveAsTextFile(outputPath);
        sc.stop();
    }

    private static final double rndElement$1(int i, Random rnd$1, double[] xVariance$1, double[] xMean$1) {
        return (rnd$1.nextDouble() - 0.5) * package$.MODULE$.sqrt(12.0 * xVariance$1[i]) + xMean$1[i];
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateLinearInput$2(double[] weights$1, double intercept$1, double eps$1, Random rnd$1, double[] xVariance$1, double[] xMean$1, int x$1) {
        Vector features = Vectors$.MODULE$.dense((double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights$1)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> LinearDataGenerator$.rndElement$1(x$2, rnd$1, xVariance$1, xMean$1), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
        double label = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(weights$1), features) + intercept$1 + eps$1 * rnd$1.nextGaussian();
        return new LabeledPoint(label, features);
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateLinearInput$4(double[] weights$1, Random rnd$1, double sparsity$1, double intercept$1, double eps$1, double[] xVariance$1, double[] xMean$1, int x$3) {
        IndexedSeq indices = (IndexedSeq)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights$1)).indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> rnd$1.nextDouble() <= sparsity$1);
        IndexedSeq values = (IndexedSeq)indices.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$5 -> LinearDataGenerator$.rndElement$1(x$5, rnd$1, xVariance$1, xMean$1), IndexedSeq$.MODULE$.canBuildFrom());
        Vector features = Vectors$.MODULE$.sparse(weights$1.length, (int[])indices.toArray(ClassTag$.MODULE$.Int()), (double[])values.toArray(ClassTag$.MODULE$.Double()));
        double label = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(weights$1), features) + intercept$1 + eps$1 * rnd$1.nextGaussian();
        return new LabeledPoint(label, features);
    }

    public static final /* synthetic */ Seq $anonfun$generateLinearRDD$2(int nexamples$1, int nparts$1, double intercept$2, double[] w$1, double eps$2, int p) {
        int seed = 42 + p;
        int examplesInPartition = nexamples$1 / nparts$1;
        return MODULE$.generateLinearInput(intercept$2, w$1, examplesInPartition, seed, eps$2);
    }

    private LinearDataGenerator$() {
        MODULE$ = this;
    }
}

