/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class FieldName
implements Serializable {
    @JsonValue
    private String value = null;
    private static final Cache cache = new Cache();

    public FieldName(String value) {
        this.setValue(value);
    }

    public boolean isInterned() {
        WeakReference reference = (WeakReference)cache.get(this.getValue());
        if (reference != null) {
            FieldName cachedName = (FieldName)reference.get();
            return cachedName == this;
        }
        return false;
    }

    public FieldName intern() {
        return FieldName.create(this.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FieldName) {
            FieldName that = (FieldName)object;
            return this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    final Object readResolve() {
        return this.intern();
    }

    @JsonCreator
    public static FieldName create(String value) {
        FieldName cachedName;
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException();
        }
        WeakReference reference = (WeakReference)cache.get(value);
        if (reference != null && (cachedName = (FieldName)reference.get()) != null) {
            return cachedName;
        }
        FieldName name = new FieldName(value);
        cache.put(value, new WeakReference<FieldName>(name));
        return name;
    }

    public static void compact() {
        FieldName.cache.compact();
    }

    private static class Cache
    extends ConcurrentHashMap<String, WeakReference<FieldName>> {
        private AtomicLong counter = new AtomicLong();

        private Cache() {
        }

        @Override
        public WeakReference<FieldName> put(String key, WeakReference<FieldName> value) {
            WeakReference<FieldName> result = super.put(key, value);
            if (this.counter.incrementAndGet() % 100L == 0L) {
                this.compact();
            }
            return result;
        }

        private void compact() {
            Collection references = this.values();
            Iterator it = references.iterator();
            while (it.hasNext()) {
                WeakReference reference = (WeakReference)it.next();
                FieldName cachedName = (FieldName)reference.get();
                if (cachedName != null) continue;
                it.remove();
            }
        }
    }
}

