/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.util.Random;

public final class SVMDataGenerator$
implements ScalaObject {
    public static final SVMDataGenerator$ MODULE$;

    static {
        new SVMDataGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: SVMGenerator <master> <output_dir> [num_examples] [num_features] [num_partitions]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? Predef$.MODULE$.augmentString(args[2]).toInt() : 1000;
        int nfeatures$1 = args.length > 3 ? Predef$.MODULE$.augmentString(args[3]).toInt() : 2;
        int parts = args.length > 4 ? Predef$.MODULE$.augmentString(args[4]).toInt() : 2;
        SparkContext sc = new SparkContext(sparkMaster, "SVMGenerator", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
        Random globalRnd$1 = new Random(94720);
        DoubleMatrix trueWeights$1 = new DoubleMatrix(1, nfeatures$1 + 1, (double[])Array$.MODULE$.fill(nfeatures$1 + 1, (Function0)new Serializable(globalRnd$1){
            public static final long serialVersionUID;
            public final Random globalRnd$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply() {
                return this.globalRnd$1.nextGaussian();
            }

            public double apply$mcD$sp() {
                return this.globalRnd$1.nextGaussian();
            }
            {
                this.globalRnd$1 = random;
            }
        }, (ClassManifest)Manifest$.MODULE$.Double()));
        RDD data = sc.parallelize((Seq)Predef$.MODULE$.intWrapper(0).until(nexamples), parts, (ClassManifest)Manifest$.MODULE$.Int()).map((Function1)new Serializable(nfeatures$1, trueWeights$1){
            public static final long serialVersionUID;
            public final int nfeatures$1;
            public final DoubleMatrix trueWeights$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LabeledPoint apply(int idx) {
                Random rnd$1 = new Random(42 + idx);
                double[] x = (double[])Array$.MODULE$.fill(this.nfeatures$1, (Function0)new Serializable(this, rnd$1){
                    public static final long serialVersionUID;
                    public final Random rnd$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply() {
                        return this.rnd$1.nextDouble() * 2.0 - 1.0;
                    }

                    public double apply$mcD$sp() {
                        return this.rnd$1.nextDouble() * 2.0 - 1.0;
                    }
                    {
                        this.rnd$1 = random;
                    }
                }, (ClassManifest)Manifest$.MODULE$.Double());
                double yD = new DoubleMatrix(1, x.length, x).dot(this.trueWeights$1) + rnd$1.nextGaussian() * 0.1;
                double y = yD < 0.0 ? 0.0 : 1.0;
                return new LabeledPoint(y, x);
            }
            {
                this.nfeatures$1 = n;
                this.trueWeights$1 = doubleMatrix;
            }
        }, ClassManifest$.MODULE$.classType(LabeledPoint.class));
        MLUtils$.MODULE$.saveLabeledData((RDD<LabeledPoint>)data, outputPath);
        sc.stop();
    }

    private SVMDataGenerator$() {
        MODULE$ = this;
    }
}

