/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KMeans$
implements ScalaObject,
Serializable {
    public static final KMeans$ MODULE$;
    private final String RANDOM;
    private final String K_MEANS_PARALLEL;

    static {
        new KMeans$();
    }

    public String RANDOM() {
        return this.RANDOM;
    }

    public String K_MEANS_PARALLEL() {
        return this.K_MEANS_PARALLEL;
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations, int runs, String initializationMode) {
        return new KMeans().setK(k).setMaxIterations(maxIterations).setRuns(runs).setInitializationMode(initializationMode).run(data);
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations, int runs) {
        return this.train(data, k, maxIterations, runs, this.K_MEANS_PARALLEL());
    }

    public KMeansModel train(RDD<double[]> data, int k, int maxIterations) {
        return this.train(data, k, maxIterations, 1, this.K_MEANS_PARALLEL());
    }

    public Tuple2<Object, Object> findClosest(double[][] centers$2, double[] point$2) {
        DoubleRef bestDistance$1 = new DoubleRef(Double.POSITIVE_INFINITY);
        IntRef bestIndex$1 = new IntRef(0);
        Predef$.MODULE$.intWrapper(0).until(centers$2.length).foreach$mVc$sp((Function1)new Serializable(centers$2, point$2, bestDistance$1, bestIndex$1){
            public static final long serialVersionUID;
            private final double[][] centers$2;
            private final double[] point$2;
            private final DoubleRef bestDistance$1;
            private final IntRef bestIndex$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                double distance = MLUtils$.MODULE$.squaredDistance(this.point$2, this.centers$2[v1]);
                if (distance < this.bestDistance$1.elem) {
                    this.bestDistance$1.elem = distance;
                    this.bestIndex$1.elem = v1;
                }
            }
            {
                this.centers$2 = dArray;
                this.point$2 = dArray2;
                this.bestDistance$1 = doubleRef;
                this.bestIndex$1 = intRef;
            }
        });
        return new Tuple2.mcID.sp(bestIndex$1.elem, bestDistance$1.elem);
    }

    public double pointCost(double[][] centers$4, double[] point$4) {
        DoubleRef bestDistance$2 = new DoubleRef(Double.POSITIVE_INFINITY);
        Predef$.MODULE$.intWrapper(0).until(centers$4.length).foreach$mVc$sp((Function1)new Serializable(centers$4, point$4, bestDistance$2){
            public static final long serialVersionUID;
            private final double[][] centers$4;
            private final double[] point$4;
            private final DoubleRef bestDistance$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                double distance = MLUtils$.MODULE$.squaredDistance(this.point$4, this.centers$4[v1]);
                if (distance < this.bestDistance$2.elem) {
                    this.bestDistance$2.elem = distance;
                }
            }
            {
                this.centers$4 = dArray;
                this.point$4 = dArray2;
                this.bestDistance$2 = doubleRef;
            }
        });
        return bestDistance$2.elem;
    }

    public void main(String[] args) {
        Tuple4 tuple4;
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"Usage: KMeans <master> <input_file> <k> <max_iterations> [<runs>]");
            System.exit(1);
        }
        if ((tuple4 = new Tuple4((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(args[2]).toInt()), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(args[3]).toInt()))) != null) {
            Tuple4 tuple42 = new Tuple4(tuple4._1(), tuple4._2(), tuple4._3(), tuple4._4());
            String master = (String)tuple42._1();
            String inputFile = (String)tuple42._2();
            int k = BoxesRunTime.unboxToInt((Object)tuple42._3());
            int iters = BoxesRunTime.unboxToInt((Object)tuple42._4());
            int runs = args.length >= 5 ? Predef$.MODULE$.augmentString(args[4]).toInt() : 1;
            SparkContext sc = new SparkContext(master, "KMeans", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
            RDD data = sc.textFile(inputFile, sc.textFile$default$2()).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final double[] apply(String line) {
                    return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(line).split(' ')).map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final double apply(String string) {
                            return Predef$.MODULE$.augmentString(string).toDouble();
                        }
                    }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Double()));
                }
            }, ClassManifest$.MODULE$.arrayType((OptManifest)Manifest$.MODULE$.Double())).cache();
            KMeansModel model = this.train((RDD<double[]>)data, k, iters, runs);
            double cost = model.computeCost((RDD<double[]>)data);
            Predef$.MODULE$.println((Object)"Cluster centers:");
            Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(double[] c) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"  ").append((Object)Predef$.MODULE$.doubleArrayOps(c).mkString(" ")).toString());
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Cost: ").append((Object)BoxesRunTime.boxToDouble((double)cost)).toString());
            System.exit(0);
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private KMeans$() {
        MODULE$ = this;
        this.RANDOM = "random";
        this.K_MEANS_PARALLEL = "k-means||";
    }
}

