/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.Logging;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GradientDescent$
implements Logging {
    public static final GradientDescent$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new GradientDescent$();
    }

    public final Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public final void org$apache$spark$Logging$$log__$eq(Logger logger) {
        this.org$apache$spark$Logging$$log_ = logger;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initLogging() {
        Logging.class.initLogging((Logging)this);
    }

    public Tuple2<double[], double[]> runMiniBatchSGD(RDD<Tuple2<Object, double[]>> data$1, Gradient gradient$1, Updater updater$1, double stepSize$1, int numIterations, double regParam$1, double miniBatchFraction$1, double[] initialWeights) {
        ArrayBuffer stochasticLossHistory$1 = new ArrayBuffer(numIterations);
        long nexamples = data$1.count();
        double miniBatchSize$1 = (double)nexamples * miniBatchFraction$1;
        ObjectRef weights$1 = new ObjectRef((Object)new DoubleMatrix(initialWeights.length, 1, initialWeights));
        DoubleRef regVal$1 = new DoubleRef(0.0);
        Predef$.MODULE$.intWrapper(1).to(numIterations).foreach$mVc$sp((Function1)new Serializable(data$1, gradient$1, updater$1, stepSize$1, regParam$1, miniBatchFraction$1, stochasticLossHistory$1, miniBatchSize$1, weights$1, regVal$1){
            public static final long serialVersionUID;
            private final RDD data$1;
            public final Gradient gradient$1;
            private final Updater updater$1;
            private final double stepSize$1;
            private final double regParam$1;
            private final double miniBatchFraction$1;
            private final ArrayBuffer stochasticLossHistory$1;
            private final double miniBatchSize$1;
            public final ObjectRef weights$1;
            private final DoubleRef regVal$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                Tuple2 tuple2 = (Tuple2)this.data$1.sample(false, this.miniBatchFraction$1, 42 + v1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.runMiniBatchSGD.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<DoubleMatrix, Object> apply(Tuple2<Object, double[]> tuple2) {
                        Tuple2<Object, double[]> tuple22 = tuple2;
                        if (tuple22 != null) {
                            double y;
                            double d = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                            double[] dArray = (double[])tuple22._2();
                            double[] features = dArray;
                            DoubleMatrix featuresCol = new DoubleMatrix(features.length, 1, features);
                            Tuple2<DoubleMatrix, Object> tuple23 = this.$outer.gradient$1.compute(featuresCol, y = d, (DoubleMatrix)this.$outer.weights$1.elem);
                            if (tuple23 != null) {
                                Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                                DoubleMatrix grad = (DoubleMatrix)tuple24._1();
                                double loss = tuple24._2$mcD$sp();
                                return new Tuple2((Object)grad, (Object)BoxesRunTime.boxToDouble((double)loss));
                            }
                            throw new MatchError(tuple23);
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(DoubleMatrix.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Double()}))).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<DoubleMatrix, Object> apply(Tuple2<DoubleMatrix, Object> a, Tuple2<DoubleMatrix, Object> b) {
                        return new Tuple2((Object)((DoubleMatrix)a._1()).addi((DoubleMatrix)b._1()), (Object)BoxesRunTime.boxToDouble((double)(a._2$mcD$sp() + b._2$mcD$sp())));
                    }
                });
                if (tuple2 != null) {
                    Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                    DoubleMatrix gradientSum = (DoubleMatrix)tuple22._1();
                    double lossSum = tuple22._2$mcD$sp();
                    this.stochasticLossHistory$1.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{lossSum / this.miniBatchSize$1 + this.regVal$1.elem}));
                    Tuple2<DoubleMatrix, Object> update = this.updater$1.compute((DoubleMatrix)this.weights$1.elem, gradientSum.div(this.miniBatchSize$1), this.stepSize$1, v1, this.regParam$1);
                    this.weights$1.elem = (DoubleMatrix)update._1();
                    this.regVal$1.elem = update._2$mcD$sp();
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.data$1 = rDD;
                this.gradient$1 = gradient;
                this.updater$1 = updater;
                this.stepSize$1 = d;
                this.regParam$1 = d2;
                this.miniBatchFraction$1 = d3;
                this.stochasticLossHistory$1 = arrayBuffer;
                this.miniBatchSize$1 = d4;
                this.weights$1 = objectRef;
                this.regVal$1 = doubleRef;
            }
        });
        this.logInfo((Function0)new Serializable(stochasticLossHistory$1){
            public static final long serialVersionUID;
            private final ArrayBuffer stochasticLossHistory$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("GradientDescent finished. Last 10 stochastic losses %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.stochasticLossHistory$1.takeRight(10)).mkString(", ")}));
            }
            {
                this.stochasticLossHistory$1 = arrayBuffer;
            }
        });
        return new Tuple2((Object)((DoubleMatrix)weights$1.elem).toArray(), stochasticLossHistory$1.toArray((ClassManifest)Manifest$.MODULE$.Double()));
    }

    private GradientDescent$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

