/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class MFDataGenerator$
implements ScalaObject {
    public static final MFDataGenerator$ MODULE$;

    static {
        new MFDataGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: MFDataGenerator <master> <outputDir> [m] [n] [rank] [trainSampFact] [noise] [sigma] [test] [testSampFact]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int m = args.length > 2 ? Predef$.MODULE$.augmentString(args[2]).toInt() : 100;
        int n = args.length > 3 ? Predef$.MODULE$.augmentString(args[3]).toInt() : 100;
        int rank = args.length > 4 ? Predef$.MODULE$.augmentString(args[4]).toInt() : 10;
        double trainSampFact = args.length > 5 ? Predef$.MODULE$.augmentString(args[5]).toDouble() : 1.0;
        boolean noise = args.length > 6 ? Predef$.MODULE$.augmentString(args[6]).toBoolean() : false;
        double sigma$1 = args.length > 7 ? Predef$.MODULE$.augmentString(args[7]).toDouble() : 0.1;
        boolean test = args.length > 8 ? Predef$.MODULE$.augmentString(args[8]).toBoolean() : false;
        double testSampFact = args.length > 9 ? Predef$.MODULE$.augmentString(args[9]).toDouble() : 0.1;
        SparkContext sc = new SparkContext(sparkMaster, "MFDataGenerator", SparkContext$.MODULE$.init$default$3(), SparkContext$.MODULE$.init$default$4(), SparkContext$.MODULE$.init$default$5(), SparkContext$.MODULE$.init$default$6());
        DoubleMatrix A = DoubleMatrix.randn((int)m, (int)rank);
        DoubleMatrix B = DoubleMatrix.randn((int)rank, (int)n);
        double z = 1.0 / package$.MODULE$.sqrt(package$.MODULE$.sqrt((double)rank));
        A.mmuli(z);
        B.mmuli(z);
        DoubleMatrix fullData$1 = A.mmul(B);
        int df = rank * (m + n - rank);
        int sampSize = (int)package$.MODULE$.min(package$.MODULE$.round(trainSampFact * (double)df), package$.MODULE$.round(0.99 * (double)m * (double)n));
        Random rand$1 = new Random();
        int mn = m * n;
        IndexedSeq shuffled = (IndexedSeq)rand$1.shuffle((TraversableOnce)Predef$.MODULE$.intWrapper(1).to(mn).toIterable(), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq omega = (IndexedSeq)shuffled.slice(0, sampSize);
        int[] ordered = (int[])((TraversableOnce)omega.sortWith((Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int n, int n2) {
                return this.apply$mcZII$sp(n, n2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return v1 < v2;
            }
        })).toArray((ClassManifest)Manifest$.MODULE$.Int());
        RDD trainData = sc.parallelize((Seq)Predef$.MODULE$.wrapIntArray(ordered), sc.parallelize$default$2(), (ClassManifest)Manifest$.MODULE$.Int()).map((Function1)new Serializable(fullData$1){
            public static final long serialVersionUID;
            private final DoubleMatrix fullData$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple3<Object, Object, Object> apply(int x) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.fullData$1.indexRows(x - 1)), (Object)BoxesRunTime.boxToInteger((int)this.fullData$1.indexColumns(x - 1)), (Object)BoxesRunTime.boxToDouble((double)this.fullData$1.get(x - 1)));
            }
            {
                this.fullData$1 = doubleMatrix;
            }
        }, ClassManifest$.MODULE$.classType(Tuple3.class, (OptManifest)Manifest$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int(), Manifest$.MODULE$.Double()})));
        Object object = noise ? trainData.map((Function1)new Serializable(sigma$1, rand$1){
            public static final long serialVersionUID;
            private final double sigma$1;
            private final Random rand$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3(x._1(), x._2(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)x._3()) + this.rand$1.nextGaussian() * this.sigma$1)));
            }
            {
                this.sigma$1 = d;
                this.rand$1 = random;
            }
        }, ClassManifest$.MODULE$.classType(Tuple3.class, (OptManifest)Manifest$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int(), Manifest$.MODULE$.Double()}))) : BoxedUnit.UNIT;
        trainData.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple3<Object, Object, Object> x) {
                return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)x._1())).append((Object)",").append(x._2()).append((Object)",").append(x._3()).toString();
            }
        }, ClassManifest$.MODULE$.classType(String.class)).saveAsTextFile(outputPath);
        if (test) {
            int testSampSize = (int)package$.MODULE$.min(package$.MODULE$.round((double)sampSize * testSampFact), (long)package$.MODULE$.round((float)(mn - sampSize)));
            IndexedSeq testOmega = (IndexedSeq)shuffled.slice(sampSize, sampSize + testSampSize);
            int[] testOrdered = (int[])((TraversableOnce)testOmega.sortWith((Function2)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(int n, int n2) {
                    return this.apply$mcZII$sp(n, n2);
                }

                public boolean apply$mcZII$sp(int v1, int v2) {
                    return v1 < v2;
                }
            })).toArray((ClassManifest)Manifest$.MODULE$.Int());
            RDD testData = sc.parallelize((Seq)Predef$.MODULE$.wrapIntArray(testOrdered), sc.parallelize$default$2(), (ClassManifest)Manifest$.MODULE$.Int()).map((Function1)new Serializable(fullData$1){
                public static final long serialVersionUID;
                private final DoubleMatrix fullData$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple3<Object, Object, Object> apply(int x) {
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.fullData$1.indexRows(x - 1)), (Object)BoxesRunTime.boxToInteger((int)this.fullData$1.indexColumns(x - 1)), (Object)BoxesRunTime.boxToDouble((double)this.fullData$1.get(x - 1)));
                }
                {
                    this.fullData$1 = doubleMatrix;
                }
            }, ClassManifest$.MODULE$.classType(Tuple3.class, (OptManifest)Manifest$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int(), Manifest$.MODULE$.Double()})));
            testData.map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple3<Object, Object, Object> x) {
                    return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)x._1())).append((Object)",").append(x._2()).append((Object)",").append(x._3()).toString();
                }
            }, ClassManifest$.MODULE$.classType(String.class)).saveAsTextFile(outputPath);
        }
        sc.stop();
    }

    private MFDataGenerator$() {
        MODULE$ = this;
    }
}

