/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1fE\u0003\u0001\u001f]Y\u0012\u0005\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tA\u0012$D\u0001\u0007\u0013\tQbAA\u0004M_\u001e<\u0017N\\4\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005q\u0011\u0013BA\u0012\u001e\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003c\u0001\u0015\u0001S5\t!\u0001\u0005\u0002+W1\u0001A!\u0002\u0017\u0001\u0005\u0004i#!A'\u0012\u00059\n\u0004C\u0001\u000f0\u0013\t\u0001TDA\u0004O_RD\u0017N\\4\u0011\u0005!\u0012\u0014BA\u001a\u0003\u0005Y9UM\\3sC2L'0\u001a3MS:,\u0017M]'pI\u0016d\u0007bB\u001b\u0001\u0005\u0004%\tBN\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u001cX#A\u001c\u0011\u0007a\u00025I\u0004\u0002:}9\u0011!(P\u0007\u0002w)\u0011A\bD\u0001\u0007yI|w\u000e\u001e \n\u0003yI!aP\u000f\u0002\u000fA\f7m[1hK&\u0011\u0011I\u0011\u0002\u0004'\u0016\f(BA \u001e!\u0011aBIR(\n\u0005\u0015k\"!\u0003$v]\u000e$\u0018n\u001c82!\r9%\nT\u0007\u0002\u0011*\u0011\u0011JB\u0001\u0004e\u0012$\u0017BA&I\u0005\r\u0011F\t\u0012\t\u0003Q5K!A\u0014\u0002\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\u0011\u0005q\u0001\u0016BA)\u001e\u0005\u001d\u0011un\u001c7fC:Daa\u0015\u0001!\u0002\u00139\u0014a\u0003<bY&$\u0017\r^8sg\u0002Bq!\u0016\u0001C\u0002\u001b\u0005a+A\u0005paRLW.\u001b>feV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[\t\u0005aq\u000e\u001d;j[&T\u0018\r^5p]&\u0011A,\u0017\u0002\n\u001fB$\u0018.\\5{KJDqA\u0018\u0001A\u0002\u0013Eq,\u0001\u0007bI\u0012Le\u000e^3sG\u0016\u0004H/F\u0001P\u0011\u001d\t\u0007\u00011A\u0005\u0012\t\f\u0001#\u00193e\u0013:$XM]2faR|F%Z9\u0015\u0005\r4\u0007C\u0001\u000fe\u0013\t)WD\u0001\u0003V]&$\bbB4a\u0003\u0003\u0005\raT\u0001\u0004q\u0012\n\u0004BB5\u0001A\u0003&q*A\u0007bI\u0012Le\u000e^3sG\u0016\u0004H\u000f\t\u0005\bW\u0002\u0001\r\u0011\"\u0005`\u000311\u0018\r\\5eCR,G)\u0019;b\u0011\u001di\u0007\u00011A\u0005\u00129\f\u0001C^1mS\u0012\fG/\u001a#bi\u0006|F%Z9\u0015\u0005\r|\u0007bB4m\u0003\u0003\u0005\ra\u0014\u0005\u0007c\u0002\u0001\u000b\u0015B(\u0002\u001bY\fG.\u001b3bi\u0016$\u0015\r^1!\u0011\u0015\u0019\bA\"\u0005u\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\u0007%*X\u0010C\u0003we\u0002\u0007q/A\u0004xK&<\u0007\u000e^:\u0011\u0007qA(0\u0003\u0002z;\t)\u0011I\u001d:bsB\u0011Ad_\u0005\u0003yv\u0011a\u0001R8vE2,\u0007\"\u0002@s\u0001\u0004Q\u0018!C5oi\u0016\u00148-\u001a9u\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\tAb]3u\u0013:$XM]2faR$B!!\u0002\u0002\b5\t\u0001\u0001C\u0003_\u007f\u0002\u0007q\nC\u0004\u0002\f\u0001!\t!!\u0004\u0002\u001fM,GOV1mS\u0012\fG/\u001a#bi\u0006$B!!\u0002\u0002\u0010!11.!\u0003A\u0002=Cq!a\u0005\u0001\t\u0003\t)\"A\u0002sk:$2!KA\f\u0011\u001d\tI\"!\u0005A\u0002\u0019\u000bQ!\u001b8qkRDq!a\u0005\u0001\t\u0003\ti\u0002F\u0003*\u0003?\t\t\u0003C\u0004\u0002\u001a\u0005m\u0001\u0019\u0001$\t\u000f\u0005\r\u00121\u0004a\u0001o\u0006q\u0011N\\5uS\u0006dw+Z5hQR\u001c\b")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable,
ScalaObject {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private transient Logger org$apache$spark$Logging$$log_;

    public final Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public final void org$apache$spark$Logging$$log__$eq(Logger logger) {
        this.org$apache$spark$Logging$$log_ = logger;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initLogging() {
        Logging.class.initLogging((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean bl) {
        this.addIntercept = bl;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean bl) {
        this.validateData = bl;
    }

    public abstract M createModel(double[] var1, double var2);

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public M run(RDD<LabeledPoint> input) {
        int nfeatures = ((LabeledPoint)input.first()).features().length;
        double[] initialWeights = (double[])Array$.MODULE$.fill(nfeatures, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, (ClassManifest)Manifest$.MODULE$.Double());
        return this.run(input, initialWeights);
    }

    public M run(RDD<LabeledPoint> input$1, double[] initialWeights) {
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input$1){
            public static final long serialVersionUID;
            private final RDD input$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = generalizedLinearAlgorithm;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        RDD data = this.addIntercept() ? input$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, double[]> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)Array$.MODULE$.apply(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(labeledPoint.features())));
            }
        }, ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.arrayType((OptManifest)Manifest$.MODULE$.Double())}))) : input$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, double[]> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)labeledPoint.features());
            }
        }, ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.arrayType((OptManifest)Manifest$.MODULE$.Double())})));
        double[] initialWeightsWithIntercept = this.addIntercept() ? Array$.MODULE$.apply(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(initialWeights)) : initialWeights;
        double[] weights = this.optimizer().optimize((RDD<Tuple2<Object, double[]>>)data, initialWeightsWithIntercept);
        double intercept = weights[0];
        double[] weightsScaled = (double[])Predef$.MODULE$.doubleArrayOps(weights).tail();
        M model$1 = this.createModel(weightsScaled, intercept);
        this.logInfo((Function0)new Serializable(this, model$1){
            public static final long serialVersionUID;
            private final GeneralizedLinearModel model$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Final model weights ").append((Object)Predef$.MODULE$.doubleArrayOps(this.model$1.weights()).mkString(",")).toString();
            }
            {
                this.model$1 = generalizedLinearAlgorithm;
            }
        });
        this.logInfo((Function0)new Serializable(this, model$1){
            public static final long serialVersionUID;
            private final GeneralizedLinearModel model$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Final model intercept ").append((Object)BoxesRunTime.boxToDouble((double)this.model$1.intercept())).toString();
            }
            {
                this.model$1 = generalizedLinearAlgorithm;
            }
        });
        return model$1;
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = true;
        this.validateData = true;
    }
}

