/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.jblas.DoubleMatrix;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MLUtils$
implements ScalaObject {
    public static final MLUtils$ MODULE$;

    static {
        new MLUtils$();
    }

    public RDD<LabeledPoint> loadLabeledData(SparkContext sc, String dir) {
        return sc.textFile(dir, sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LabeledPoint apply(String line) {
                String[] parts = Predef$.MODULE$.augmentString(line).split(',');
                double label = Predef$.MODULE$.augmentString(parts[0]).toDouble();
                double[] features = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(parts[1].trim()).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply(String string) {
                        return Predef$.MODULE$.augmentString(string).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Double()));
                return new LabeledPoint(label, features);
            }
        }, ClassManifest$.MODULE$.classType(LabeledPoint.class));
    }

    public void saveLabeledData(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(LabeledPoint x) {
                return new StringBuilder().append(x.label()).append((Object)",").append((Object)Predef$.MODULE$.doubleArrayOps(x.features()).mkString(" ")).toString();
            }
        }, ClassManifest$.MODULE$.classType(String.class));
        dataStr.saveAsTextFile(dir);
    }

    public Tuple3<Object, DoubleMatrix, DoubleMatrix> computeStats(RDD<LabeledPoint> data, int nfeatures, long nexamples) {
        double yMean = BoxesRunTime.unboxToDouble((Object)data.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(LabeledPoint labeledPoint) {
                return labeledPoint.label();
            }
        }, (ClassManifest)Manifest$.MODULE$.Double()).reduce((Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double d, double d2) {
                return this.apply$mcDDD$sp(d, d2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return v1 + v2;
            }
        })) / (double)nexamples;
        RDD xColSumSq = SparkContext$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterator apply(LabeledPoint labeledPoint$1) {
                int nCols = labeledPoint$1.features().length;
                return scala.package$.MODULE$.Iterator().tabulate(nCols, (Function1)new Serializable(this, labeledPoint$1){
                    public static final long serialVersionUID;
                    private final LabeledPoint labeledPoint$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<Object, Tuple2<Object, Object>> apply(int i) {
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new Tuple2.mcDD.sp(this.labeledPoint$1.features()[i], this.labeledPoint$1.features()[i] * this.labeledPoint$1.features()[i]));
                    }
                    {
                        this.labeledPoint$1 = labeledPoint;
                    }
                });
            }
        }, ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Double()}))}))), (ClassManifest)Manifest$.MODULE$.Int(), ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Double()}))).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> tuple2, Tuple2<Object, Object> tuple22) {
                Tuple2 tuple23 = new Tuple2(tuple2, tuple22);
                if (tuple23 != null) {
                    Tuple2 tuple24 = (Tuple2)tuple23._1();
                    Tuple2 tuple25 = (Tuple2)tuple23._2();
                    Tuple2 x1 = tuple24;
                    Tuple2 x2 = tuple25;
                    return new Tuple2.mcDD.sp(x1._1$mcD$sp() + x2._1$mcD$sp(), x1._2$mcD$sp() + x2._2$mcD$sp());
                }
                throw new MatchError((Object)tuple23);
            }
        });
        Map xColSumsMap = SparkContext$.MODULE$.rddToPairRDDFunctions(xColSumSq, (ClassManifest)Manifest$.MODULE$.Int(), ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Double()}))).collectAsMap();
        DoubleMatrix xColMean = DoubleMatrix.zeros((int)nfeatures, (int)1);
        DoubleMatrix xColSd = DoubleMatrix.zeros((int)nfeatures, (int)1);
        for (int col = 0; col < nfeatures; ++col) {
            xColMean.put(col, ((Tuple2)xColSumsMap.apply((Object)BoxesRunTime.boxToInteger((int)col)))._1$mcD$sp() / (double)nexamples);
            double variance = (((Tuple2)xColSumsMap.apply((Object)BoxesRunTime.boxToInteger((int)col)))._2$mcD$sp() - package$.MODULE$.pow(((Tuple2)xColSumsMap.apply((Object)BoxesRunTime.boxToInteger((int)col)))._1$mcD$sp(), 2.0) / (double)nexamples) / (double)nexamples;
            xColSd.put(col, package$.MODULE$.sqrt(variance));
        }
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)yMean), (Object)xColMean, (Object)xColSd);
    }

    public double squaredDistance(double[] v1, double[] v2) {
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vector sizes don't match");
        }
        double sum = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            sum += (v1[i] - v2[i]) * (v1[i] - v2[i]);
        }
        return sum;
    }

    private MLUtils$() {
        MODULE$ = this;
    }
}

