/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.SqlGraphElementRegistrationException;
import org.apache.spark.sql.pipelines.graph.SqlGraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.utils.PipelineTest;
import org.apache.spark.sql.pipelines.utils.TestGraphRegistrationContext;
import org.apache.spark.sql.pipelines.utils.TestGraphRegistrationContext$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005m2A\u0001C\u0005\u0001-!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB\u0018\u0001A\u0003%\u0011\u0006C\u00041\u0001\t\u0007I\u0011\u0002\u0015\t\rE\u0002\u0001\u0015!\u0003*\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u0015Q\u0004\u0001\"\u00114\u0005A\u0019\u0016\u000f\u001c)ja\u0016d\u0017N\\3Tk&$XM\u0003\u0002\u000b\u0017\u0005)qM]1qQ*\u0011A\"D\u0001\na&\u0004X\r\\5oKNT!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f\u001e!\tA2$D\u0001\u001a\u0015\tQ2\"A\u0003vi&d7/\u0003\u0002\u001d3\ta\u0001+\u001b9fY&tW\rV3tiB\u0011a$I\u0007\u0002?)\u0011\u0001%D\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\t\u00112\u000b[1sK\u0012\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t\u0011\"A\nfqR,'O\\1m)\u0006\u0014G.Z\u0019JI\u0016tG/F\u0001*!\tQS&D\u0001,\u0015\taS\"\u0001\u0005dCR\fG._:u\u0013\tq3FA\bUC\ndW-\u00133f]RLg-[3s\u0003Q)\u0007\u0010^3s]\u0006dG+\u00192mKFJE-\u001a8uA\u0005\u0019R\r\u001f;fe:\fG\u000eV1cY\u0016\u0014\u0014\nZ3oi\u0006!R\r\u001f;fe:\fG\u000eV1cY\u0016\u0014\u0014\nZ3oi\u0002\n!BY3g_J,W)Y2i)\u0005!\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$\u0001B+oSR\f\u0011\"\u00194uKJ,\u0015m\u00195")
public class SqlPipelineSuite
extends PipelineTest
implements SharedSparkSession {
    private final TableIdentifier externalTable1Ident;
    private final TableIdentifier externalTable2Ident;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        super.beforeEach();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        super.afterEach();
    }

    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
    }

    public org.apache.spark.sql.classic.SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public SQLConf sqlConf() {
        return SharedSparkSessionBase.sqlConf$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    private TableIdentifier externalTable1Ident() {
        return this.externalTable1Ident;
    }

    private TableIdentifier externalTable2Ident() {
        return this.externalTable2Ident;
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
        this.spark().sql("CREATE TABLE " + this.externalTable1Ident() + " AS SELECT * FROM RANGE(3)");
        this.spark().sql("CREATE TABLE " + this.externalTable2Ident() + " AS SELECT * FROM RANGE(4)");
    }

    @Override
    public void afterEach() {
        this.spark().sql("DROP TABLE IF EXISTS " + this.externalTable1Ident());
        this.spark().sql("DROP TABLE IF EXISTS " + this.externalTable2Ident());
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    public static final /* synthetic */ boolean $anonfun$new$2(SqlPipelineSuite $this, ResolvedFlow x$1) {
        TableIdentifier tableIdentifier = x$1.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("mv", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(SqlPipelineSuite $this, ResolvedFlow x$3) {
        TableIdentifier tableIdentifier = x$3.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("st", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$5(SqlPipelineSuite $this, ResolvedFlow x$4) {
        TableIdentifier tableIdentifier = x$4.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("v", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$6(SqlPipelineSuite $this, ResolvedFlow x$5) {
        TableIdentifier tableIdentifier = x$5.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("f", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$10(SqlPipelineSuite $this, ResolvedFlow x$6) {
        TableIdentifier tableIdentifier = x$6.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("a", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$13(SqlPipelineSuite $this, ResolvedFlow f) {
        TableIdentifier tableIdentifier = f.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("hyphen-mv", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null) && !f.df().isStreaming();
    }

    public static final /* synthetic */ boolean $anonfun$new$14(SqlPipelineSuite $this, ResolvedFlow f) {
        TableIdentifier tableIdentifier = f.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("other-hyphen-mv", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null) && !f.df().isStreaming();
    }

    public static final /* synthetic */ boolean $anonfun$new$17(SqlPipelineSuite $this, String datasetName$1, ResolvedFlow x$7) {
        TableIdentifier tableIdentifier = x$7.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier(datasetName$1, $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$16(SqlPipelineSuite $this, DataflowGraph resolvedDataflowGraph$1, String datasetName) {
        ResolvedFlow backingFlow = (ResolvedFlow)Option$.MODULE$.option2Iterable(resolvedDataflowGraph$1.resolvedFlows().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$17($this, datasetName, x$7)))).head();
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> backingFlow.df(), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$new$28(SqlPipelineSuite $this, Table x$8) {
        TableIdentifier tableIdentifier = x$8.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("a", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$31(SqlPipelineSuite $this, TableCatalog catalog$1, Seq expected$1, String tableName) {
        org.apache.spark.sql.connector.catalog.Table table = catalog$1.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"test_db"})), (String)tableName));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.partitioning()), (Function1 & Serializable)x$9 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$9.references()))).fieldNames())), ClassTag$.MODULE$.apply(String.class)));
        String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"id_mod"});
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().sql("SELECT * FROM " + $this.fullyQualifiedIdentifier(tableName, $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4())), (Seq<Row>)expected$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$37(SqlPipelineSuite $this, Table x$10) {
        TableIdentifier tableIdentifier = x$10.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("st", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$39(SqlPipelineSuite $this, Flow x$11) {
        TableIdentifier tableIdentifier = x$11.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("a", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$40(SqlPipelineSuite $this, Flow x$12) {
        TableIdentifier tableIdentifier = x$12.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("b", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$41(SqlPipelineSuite $this, Flow x$13) {
        TableIdentifier tableIdentifier = x$13.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("c", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$49(SqlPipelineSuite $this, String fileFormat) {
        String tmpDir = Utils$.MODULE$.createTempDir().getAbsolutePath();
        $this.spark().sql("SELECT * FROM RANGE(3)").write().format(fileFormat).mode("overwrite").save(tmpDir);
        TableIdentifier externalTableIdent = $this.fullyQualifiedIdentifier("t", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        $this.spark().sql("CREATE TABLE " + externalTableIdent + " AS SELECT * FROM " + fileFormat + ".`" + tmpDir + "`");
        $this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{externalTableIdent.quotedString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = $this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE MATERIALIZED VIEW a AS SELECT * FROM " + fileFormat + ".`" + tmpDir + "`;\n             |CREATE STREAMING TABLE b AS SELECT * FROM STREAM " + externalTableIdent + "\n             |")), $this.unresolvedDataflowGraphFromSql$default$2());
            $this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)datasetName -> {
                String datasetFullyQualifiedName = $this.fullyQualifiedIdentifier((String)datasetName, $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4()).quotedString();
                String string = fileFormat;
                String string2 = "csv";
                Set expectedRows = !(string != null ? !string.equals(string2) : string2 != null) ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2"})) : (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
                Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapRefArray((Object[])$this.spark().sql("SELECT * FROM " + datasetFullyQualifiedName).collect()).toSet();
                Set $org_scalatest_assert_macro_right = (Set)expectedRows.map((Function1 & Serializable)x$14 -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x$14})));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
            });
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$54(SqlPipelineSuite $this, ResolutionFailedFlow x$15) {
        TableIdentifier tableIdentifier = x$15.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("a", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$53(SqlPipelineSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String path = (String)tuple2._1();
            String expectedErrorMsg = (String)tuple2._2();
            DataflowGraph unresolvedDataflowGraph = $this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                     |CREATE MATERIALIZED VIEW a AS SELECT * FROM " + path + ";\n                     |")), $this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            String $org_scalatest_assert_macro_left = ((Throwable)((ResolutionFailedFlow)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.resolutionFailedFlows().find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$54($this, x$15)))).head()).failure().head()).getMessage();
            String $org_scalatest_assert_macro_right = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$60(SqlPipelineSuite $this, ResolvedFlow x$16) {
        TableIdentifier tableIdentifier = x$16.identifier();
        TableIdentifier tableIdentifier2 = $this.fullyQualifiedIdentifier("a", $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4());
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$87(SqlPipelineSuite $this, String flowIdentifier) {
        AnalysisException ex;
        AnalysisException x$1 = ex = (AnalysisException)$this.intercept((Function0 & Serializable)() -> $this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |CREATE STREAMING TABLE st;\n               |CREATE FLOW " + flowIdentifier + " AS INSERT INTO st BY NAME\n               |SELECT * FROM STREAM " + $this.externalTable1Ident() + "\n               |")), $this.unresolvedDataflowGraphFromSql$default$2()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        String x$2 = "MULTIPART_FLOW_NAME_NOT_SUPPORTED";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flowIdentifier)}));
        Option x$4 = $this.checkError$default$3();
        boolean x$5 = $this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$1, "MULTIPART_FLOW_NAME_NOT_SUPPORTED", x$4, x$3, x$5, x$6);
    }

    public SqlPipelineSuite() {
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        this.externalTable1Ident = this.fullyQualifiedIdentifier("external_t1", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
        this.externalTable2Ident = this.fullyQualifiedIdentifier("external_t2", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
        this.test("Simple register SQL dataset test", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE MATERIALIZED VIEW mv AS SELECT 1;\n                   |CREATE STREAMING TABLE st AS SELECT * FROM STREAM " + this.externalTable1Ident() + ";\n                   |CREATE VIEW v AS SELECT * FROM mv;\n                   |CREATE FLOW f AS INSERT INTO st BY NAME\n                   |SELECT * FROM STREAM " + this.externalTable2Ident() + ";\n                   |")), this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            Seq $org_scalatest_assert_macro_left = resolvedDataflowGraph.flows();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Seq $org_scalatest_assert_macro_left2 = resolvedDataflowGraph.tables();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Seq $org_scalatest_assert_macro_left3 = resolvedDataflowGraph.views();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            ResolvedFlow mvFlow = (ResolvedFlow)((IterableOps)resolvedDataflowGraph.resolvedFlows().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$2(this, x$1)))).head();
            Set $org_scalatest_assert_macro_left4 = (Set)mvFlow.inputs().map((Function1 & Serializable)x$2 -> x$2.table());
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set = $org_scalatest_assert_macro_left4;
            Set set2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TableIdentifier $org_scalatest_assert_macro_left5 = mvFlow.destinationIdentifier();
            TableIdentifier $org_scalatest_assert_macro_right5 = this.fullyQualifiedIdentifier("mv", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left5;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            ResolvedFlow stFlow = (ResolvedFlow)((IterableOps)resolvedDataflowGraph.resolvedFlows().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$4(this, x$3)))).head();
            Set $org_scalatest_assert_macro_left6 = stFlow.funcResult().usedExternalInputs();
            Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.externalTable1Ident()}));
            Set set3 = $org_scalatest_assert_macro_left6;
            Set set4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Set $org_scalatest_assert_macro_left7 = stFlow.inputs();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            TableIdentifier $org_scalatest_assert_macro_left8 = stFlow.destinationIdentifier();
            TableIdentifier $org_scalatest_assert_macro_right7 = this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier3 = $org_scalatest_assert_macro_left8;
            TableIdentifier tableIdentifier4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right7, !(tableIdentifier3 != null ? !tableIdentifier3.equals(tableIdentifier4) : tableIdentifier4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            ResolvedFlow viewFlow = (ResolvedFlow)((IterableOps)resolvedDataflowGraph.resolvedFlows().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$5(this, x$4)))).head();
            Set $org_scalatest_assert_macro_left9 = viewFlow.inputs();
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.fullyQualifiedIdentifier("mv", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())}));
            Set set5 = $org_scalatest_assert_macro_left9;
            Set set6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right8, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            TableIdentifier $org_scalatest_assert_macro_left10 = viewFlow.destinationIdentifier();
            TableIdentifier $org_scalatest_assert_macro_right9 = this.fullyQualifiedIdentifier("v", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier5 = $org_scalatest_assert_macro_left10;
            TableIdentifier tableIdentifier6 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right9, !(tableIdentifier5 != null ? !tableIdentifier5.equals(tableIdentifier6) : tableIdentifier6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            ResolvedFlow namedFlow = (ResolvedFlow)((IterableOps)resolvedDataflowGraph.resolvedFlows().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$6(this, x$5)))).head();
            Set $org_scalatest_assert_macro_left11 = namedFlow.funcResult().usedExternalInputs();
            Set $org_scalatest_assert_macro_right10 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.externalTable2Ident()}));
            Set set7 = $org_scalatest_assert_macro_left11;
            Set set8 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right10, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Set $org_scalatest_assert_macro_left12 = namedFlow.inputs();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TableIdentifier $org_scalatest_assert_macro_left13 = namedFlow.destinationIdentifier();
            TableIdentifier $org_scalatest_assert_macro_right11 = this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier7 = $org_scalatest_assert_macro_left13;
            TableIdentifier tableIdentifier8 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right11, !(tableIdentifier7 != null ? !tableIdentifier7.equals(tableIdentifier8) : tableIdentifier8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("Duplicate table name across different SQL files fails", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            sqlGraphRegistrationContext.processSqlFile("CREATE STREAMING TABLE table;", "a.sql", (SparkSession)this.spark());
            sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE VIEW table AS SELECT 1;\n                  |")), "b.sql", (SparkSession)this.spark());
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> graphRegistrationContext.toDataflowGraph(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109)), "PIPELINE_DUPLICATE_IDENTIFIERS.DATASET", Option$.MODULE$.apply((Object)"42710"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetName"), (Object)this.fullyQualifiedIdentifier("table", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetType1"), (Object)"TABLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetType2"), (Object)"VIEW")})), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("Static pipeline dataset resolves correctly", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE MATERIALIZED VIEW a COMMENT 'this is a comment' AS SELECT * FROM range(1, 4)", this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            ResolvedFlow flowA = (ResolvedFlow)((IterableOps)resolvedDataflowGraph.resolvedFlows().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$10(this, x$6)))).head();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> flowA.df(), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("Special characters in dataset name allowed when escaped", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE MATERIALIZED VIEW `hyphen-mv` AS SELECT * FROM range(1, 4);\n                  |CREATE MATERIALIZED VIEW `other-hyphen-mv` AS SELECT * FROM `hyphen-mv`\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(resolvedDataflowGraph.resolvedFlows().exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$13(this, f))), "resolvedDataflowGraph.resolvedFlows.exists(((f: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => f.identifier.==(SqlPipelineSuite.this.fullyQualifiedIdentifier(\"hyphen-mv\", SqlPipelineSuite.this.fullyQualifiedIdentifier$default$2, SqlPipelineSuite.this.fullyQualifiedIdentifier$default$3, SqlPipelineSuite.this.fullyQualifiedIdentifier$default$4)).&&(f.df.isStreaming.unary_!)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(resolvedDataflowGraph.resolvedFlows().exists((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$14(this, f))), "resolvedDataflowGraph.resolvedFlows.exists(((f: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => f.identifier.==(SqlPipelineSuite.this.fullyQualifiedIdentifier(\"other-hyphen-mv\", SqlPipelineSuite.this.fullyQualifiedIdentifier$default$2, SqlPipelineSuite.this.fullyQualifiedIdentifier$default$3, SqlPipelineSuite.this.fullyQualifiedIdentifier$default$4)).&&(f.df.isStreaming.unary_!)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Pipeline with batch dependencies is correctly resolved", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE VIEW b as SELECT * FROM a;\n                  |CREATE VIEW a AS SELECT * FROM range(1, 4);\n                  |CREATE VIEW c AS SELECT * FROM `b`;\n                  |CREATE VIEW d AS SELECT * FROM c\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)datasetName -> {
                SqlPipelineSuite.$anonfun$new$16(this, resolvedDataflowGraph, datasetName);
                return BoxedUnit.UNIT;
            });
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("Pipeline dataset can be referenced in subquery", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE MATERIALIZED VIEW A AS SELECT * FROM RANGE(5);\n                  |CREATE MATERIALIZED VIEW B AS SELECT * FROM RANGE(5)\n                  |WHERE id = (SELECT max(id) FROM A);\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + this.fullyQualifiedIdentifier("B", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("Pipeline datasets can have dependency on streaming table", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE STREAMING TABLE a AS SELECT * FROM STREAM(" + this.externalTable1Ident() + ");\n                   |CREATE MATERIALIZED VIEW b AS SELECT * FROM a;\n                   |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("SQL aggregation works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |CREATE MATERIALIZED VIEW a AS SELECT id AS value, (id % 2) AS isOdd FROM range(1,10);\n          |CREATE MATERIALIZED VIEW b AS SELECT isOdd, max(value) AS\n          |maximum FROM a GROUP BY isOdd LIMIT 2;\n          |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)8)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)9)})), (List)Nil$.MODULE$)));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("SQL join works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE TEMPORARY VIEW a AS SELECT id FROM range(1,3);\n                  |CREATE TEMPORARY VIEW b AS SELECT id FROM range(1,3);\n                  |CREATE MATERIALIZED VIEW c AS SELECT a.id AS id1, b.id AS id2\n                  |FROM a JOIN b ON a.id=b.id\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + this.fullyQualifiedIdentifier("c", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("Partition cols correctly registered", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE MATERIALIZED VIEW a\n                  |PARTITIONED BY (id1, id2)\n                  |AS SELECT id as id1, id as id2 FROM range(1,2) ")), this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            Option $org_scalatest_assert_macro_left = ((Table)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.tables().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$28(this, x$8)))).head()).partitionCols();
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"id1", (List)new .colon.colon((Object)"id2", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("MV/ST with partition columns works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mv", "st"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |CREATE MATERIALIZED VIEW mv\n            |PARTITIONED BY (id_mod)\n            |AS\n            |SELECT\n            |  id,\n            |  id % 2 AS id_mod\n            |FROM range(3);\n            |\n            |CREATE STREAMING TABLE st\n            |PARTITIONED BY (id_mod)\n            |AS\n            |SELECT * FROM STREAM(mv);\n            |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            .colon.colon expected = new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0)})), (List)Nil$.MODULE$)));
            TableCatalog catalog = (TableCatalog)this.spark().sessionState().catalogManager().currentCatalog();
            new .colon.colon((Object)"mv", (List)new .colon.colon((Object)"st", (List)Nil$.MODULE$)).foreach(arg_0 -> SqlPipelineSuite.$anonfun$new$31$adapted(this, catalog, (Seq)expected, arg_0));
        }), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("Exception is thrown when non-identity partition columns are used", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            SqlGraphElementRegistrationException ex = (SqlGraphElementRegistrationException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                    |CREATE MATERIALIZED VIEW a\n                    |PARTITIONED BY (year(id1))\n                    |AS SELECT id as id1, id as id2 FROM range(1,2)")), "a.sql", (SparkSession)this.spark()), ClassTag$.MODULE$.apply(SqlGraphElementRegistrationException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Invalid partitioning transform";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("Table properties are correctly registered", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE STREAMING TABLE st TBLPROPERTIES ('prop1'='foo', 'prop2'='bar') AS SELECT 1", this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            Map $org_scalatest_assert_macro_left = ((Table)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.tables().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$37(this, x$10)))).head()).properties();
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop1"), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop2"), (Object)"bar")}));
            Map map = $org_scalatest_assert_macro_left;
            Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.test("Spark confs are correctly registered", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE MATERIALIZED VIEW a AS SELECT id FROM range(1,2);\n                  |SET conf.test = a;\n                  |CREATE VIEW b AS SELECT id from range(1,2);\n                  |SET conf.test = b;\n                  |SET conf.test2 = c;\n                  |CREATE STREAMING TABLE c AS SELECT id FROM range(1,2);\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            Map $org_scalatest_assert_macro_left = ((Flow)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.flows().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$39(this, x$11)))).head()).sqlConf();
            Map $org_scalatest_assert_macro_right = Predef$.MODULE$.Map().empty();
            Map map = $org_scalatest_assert_macro_left;
            Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            Map $org_scalatest_assert_macro_left2 = ((Flow)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.flows().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$40(this, x$12)))).head()).sqlConf();
            Map $org_scalatest_assert_macro_right2 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf.test"), (Object)"a")}));
            Map map3 = $org_scalatest_assert_macro_left2;
            Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            Map $org_scalatest_assert_macro_left3 = ((Flow)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.flows().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$41(this, x$13)))).head()).sqlConf();
            Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf.test"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf.test2"), (Object)"c")}));
            Map map5 = $org_scalatest_assert_macro_left3;
            Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        this.test("Setting dataset location is disallowed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            ParseException ex = (ParseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("CREATE STREAMING TABLE a\n                    |LOCATION \"/path/to/table\"\n                    |AS SELECT * FROM range(1,2)")), "a.sql", (SparkSession)this.spark()), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Specifying location is not supported";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("Tables living in arbitrary schemas can be read from pipeline", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String database_name = "db_c215a150_c9c1_4c65_bc02_f7d50dea2f5d";
            String table_name = database_name + ".tbl";
            this.spark().sql("CREATE DATABASE " + database_name);
            this.spark().sql("CREATE TABLE " + table_name + " AS SELECT * FROM range(1,4)");
            this.withDatabase((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{database_name}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{table_name}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                       |CREATE MATERIALIZED VIEW a AS SELECT * FROM " + table_name + ";\n                       |CREATE STREAMING TABLE b AS SELECT * FROM STREAM(" + table_name + ");\n                       |CREATE TEMPORARY VIEW c AS SELECT * FROM a;\n                       |")), this.unresolvedDataflowGraphFromSql$default$2());
                this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
                new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)tableName -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> $this.spark().sql("SELECT * FROM " + $this.fullyQualifiedIdentifier(tableName, $this.fullyQualifiedIdentifier$default$2(), $this.fullyQualifiedIdentifier$default$3(), $this.fullyQualifiedIdentifier$default$4()).quotedString()), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$))));
                    return BoxedUnit.UNIT;
                });
            }));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.gridTest("Pipeline dataset can read from file based data sources", (Seq<Tag>)Nil$.MODULE$, new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"orc", (List)new .colon.colon((Object)"json", (List)new .colon.colon((Object)"csv", (List)Nil$.MODULE$)))), (Function1 & Serializable)fileFormat -> {
            SqlPipelineSuite.$anonfun$new$49(this, fileFormat);
            return BoxedUnit.UNIT;
        });
        this.gridTest("Invalid reads produce correct error message", (Seq<Tag>)Nil$.MODULE$, new .colon.colon((Object)new Tuple2((Object)"csv.``", (Object)"The location name cannot be empty string, but `` was given."), (List)new .colon.colon((Object)new Tuple2((Object)"csv.`/non/existing/file`", (Object)"Path does not exist: file:/non/existing/file"), (List)Nil$.MODULE$)), (Function1 & Serializable)x0$1 -> {
            SqlPipelineSuite.$anonfun$new$53(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.test("Pipeline dataset can be referenced in CTE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE MATERIALIZED VIEW a AS SELECT 1;\n                  |CREATE MATERIALIZED VIEW d AS\n                  |WITH c AS (\n                  | WITH b AS (\n                  |   SELECT * FROM a\n                  | )\n                  | SELECT * FROM b\n                  |)\n                  |SELECT * FROM c;\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + this.fullyQualifiedIdentifier("d", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString()), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        this.test("Unsupported SQL statements throws error", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            SqlGraphElementRegistrationException ex = (SqlGraphElementRegistrationException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> sqlGraphRegistrationContext.processSqlFile("CREATE TABLE t AS SELECT 1", "a.sql", (SparkSession)this.spark()), ClassTag$.MODULE$.apply(SqlGraphElementRegistrationException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Unsupported plan";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        this.test("Table schema is correctly parsed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  |CREATE MATERIALIZED VIEW a (id LONG COMMENT 'comment') AS SELECT * FROM RANGE(5);\n                  |")), this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph resolvedDataflowGraph = unresolvedDataflowGraph.resolve();
            resolvedDataflowGraph.validate();
            StructType expectedSchema = new StructType().add("id", (DataType)LongType$.MODULE$, false);
            StructType $org_scalatest_assert_macro_left = ((ResolvedFlow)Option$.MODULE$.option2Iterable(resolvedDataflowGraph.resolvedFlows().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)SqlPipelineSuite.$anonfun$new$60(this, x$16)))).head()).schema();
            StructType $org_scalatest_assert_macro_right = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        this.test("Multipart table names supported", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String database_name = "db_4159cf91_42c1_44d6_aa8c_9cd8a158230d";
            String database2_name = "db_a90d194f_9dfd_44bf_b473_26727e76be7a";
            this.spark().sql("CREATE DATABASE " + database_name);
            this.spark().sql("CREATE DATABASE " + database2_name);
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE MATERIALIZED VIEW " + database_name + ".mv1 AS SELECT 1;\n                   |CREATE MATERIALIZED VIEW " + database2_name + ".mv2 AS SELECT * FROM " + database_name + ".mv1\n                   |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + database_name + ".mv1"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.checkAnswer((Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + database2_name + ".mv2"), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        this.test("Flow cannot be created with multipart identifier", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            AnalysisException ex = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                     |CREATE STREAMING TABLE st;\n                     |CREATE FLOW some_database.f AS INSERT INTO st BY NAME\n                     |SELECT * FROM STREAM " + this.externalTable1Ident() + ";\n                     |")), "a.sql", (SparkSession)this.spark()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "Flow with multipart name 'some_database.f' is not supported";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        this.test("Temporary view cannot be created with multipart identifier", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            ParseException ex = (ParseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                    |CREATE TEMPORARY VIEW some_database.tv AS SELECT 1;\n                    |CREATE MATERIALIZED VIEW mv AS SELECT * FROM some_database.tv;\n                    |")), "a.sql", (SparkSession)this.spark()), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            Option $org_scalatest_assert_macro_left = ex.errorClass();
            String $org_scalatest_assert_macro_right = "TEMP_VIEW_NAME_TOO_MANY_NAME_PARTS";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("create view syntax for persisted views", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool bool;
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE VIEW b COMMENT 'my persisted comment' AS SELECT * FROM range(1, 4);", this.unresolvedDataflowGraphFromSql$default$2());
            DataflowGraph graph = unresolvedDataflowGraph.resolve().validate();
            View view = (View)graph.views().last();
            TableIdentifier $org_scalatest_assert_macro_left = view.identifier();
            TableIdentifier $org_scalatest_assert_macro_right = this.fullyQualifiedIdentifier("b", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4());
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            View $org_scalatest_assert_macro_left2 = view;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.pipelines.graph.PersistedView", $org_scalatest_assert_macro_left2 instanceof PersistedView, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.simpleMacroBool(view.sqlText().isDefined(), "view.sqlText.isDefined", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left3.value()) {
                String $org_scalatest_assert_macro_left4 = (String)view.sqlText().get();
                String $org_scalatest_assert_macro_right2 = "SELECT * FROM range(1, 4)";
                String string = $org_scalatest_assert_macro_left4;
                String string2 = $org_scalatest_assert_macro_right2;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
            String $org_scalatest_assert_macro_left5 = (String)view.comment().get();
            String $org_scalatest_assert_macro_right4 = "my persisted comment";
            String string = $org_scalatest_assert_macro_left5;
            String string3 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string3) : string3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        this.test("Use database and set catalog works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String pipelineCatalog = TestGraphRegistrationContext$.MODULE$.DEFAULT_CATALOG();
            String pipelineDatabase = TestGraphRegistrationContext$.MODULE$.DEFAULT_DATABASE();
            String otherCatalog = "c_bb3e5598_be3c_4250_a3e1_92c2a75bd3ce";
            String otherDatabase = "db_caa1d504_ceb5_40e5_b444_ada891288f07";
            String otherDatabase2 = "db_8b1e9b89_99d8_4f5e_91af_da5b9091143c";
            this.spark().conf().set("spark.sql.catalog." + otherCatalog, "org.apache.spark.sql.connector.catalog.InMemoryTableCatalog");
            this.spark().sql("CREATE DATABASE " + otherCatalog + "." + otherDatabase);
            this.spark().sql("CREATE DATABASE " + otherDatabase2);
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSqlFiles((Seq<PipelineTest.TestSqlFile>)new .colon.colon((Object)new PipelineTest.TestSqlFile(this, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |-- Create table in default (pipeline) catalog and database\n               |     CREATE MATERIALIZED VIEW mv AS SELECT * FROM RANGE(3);\n               |\n               |-- Change database\n               |USE DATABASE " + otherDatabase2 + ";\n               |\n               |-- Create mv2 under new database, implicitly\n               |CREATE MATERIALIZED VIEW mv2 AS SELECT * FROM RANGE(1, 5);\n               |\n               |-- Unqualified names in subquery should implicitly use current database.\n               |-- This should work as current database lives under test_db catalog\n               |-- Fully qualified names in subquery should use specified database.\n               |CREATE MATERIALIZED VIEW mv3 AS\n               |WITH mv AS (SELECT * FROM " + pipelineCatalog + "." + pipelineDatabase + ".mv)\n               |SELECT mv2.id FROM\n               |mv JOIN mv2 ON mv.id=mv2.id;\n               |\n               |-- Change to database that lives in another catalog. Same behavior expected.\n               |SET CATALOG " + otherCatalog + ";\n               |USE DATABASE " + otherDatabase + ";\n               |\n               |-- Create temporary view. Temporary views should always be created in the pipeline\n               |-- catalog and database, regardless of what the active catalog/database are.\n               |CREATE TEMPORARY VIEW tv AS SELECT * FROM " + pipelineCatalog + "." + pipelineDatabase + ".mv;\n               |\n               |CREATE MATERIALIZED VIEW mv4 AS\n               |WITH mv2 AS (SELECT * FROM " + pipelineCatalog + "." + otherDatabase2 + ".mv2)\n               |SELECT * FROM STREAM(mv2) WHERE mv2.id % 2 == 0;\n               |\n               |-- Use namespace command should also work, setting both catalog and database.\n               |USE NAMESPACE " + pipelineCatalog + "." + otherDatabase2 + ";\n               |-- mv2 was originally created in this same namespace, so implicit qualification\n               |-- should work.\n               |CREATE MATERIALIZED VIEW mv5 AS SELECT * FROM mv2;\n               |\n               |-- Temp views, which don't support name qualification, should always resolve to\n               |-- pipeline catalog and database despite the active catalog/database\n               |CREATE MATERIALIZED VIEW mv6 AS SELECT * FROM tv;\n               |")), "file1.sql"), (List)new .colon.colon((Object)new PipelineTest.TestSqlFile(this, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |-- The previous file's current catalog/database should not impact other files;\n               |-- the catalog/database should be reset to the pipeline's.\n               |--\n               |-- Should also be able to read dataset created in other file with custom catalog\n               |-- and database.\n               |CREATE MATERIALIZED VIEW mv6 AS SELECT * FROM " + pipelineCatalog + "." + otherDatabase2 + ".mv5;\n               |")), "file2.sql"), (List)Nil$.MODULE$)));
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + pipelineCatalog + "." + otherDatabase2 + ".mv3"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + otherCatalog + "." + otherDatabase + ".mv4"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + otherDatabase2 + ".mv5"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + otherDatabase2 + ".mv6"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + pipelineCatalog + "." + pipelineDatabase + ".mv6"), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)Nil$.MODULE$)))));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        this.test("Writing/reading datasets from fully and partially qualified names works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.spark().catalog().setCurrentCatalog(TestGraphRegistrationContext$.MODULE$.DEFAULT_CATALOG());
            this.spark().catalog().setCurrentDatabase(TestGraphRegistrationContext$.MODULE$.DEFAULT_DATABASE());
            String otherCatalog = "c_25fcf574_171a_4058_b17d_2e38622b702b";
            String otherDatabase = "db_3558273c_9843_4eac_8b9c_cf7a7d144371";
            String otherDatabase2 = "db_6ae79691_11f8_43a6_9120_ca7c7dee662a";
            this.spark().conf().set("spark.sql.catalog." + otherCatalog, "org.apache.spark.sql.connector.catalog.InMemoryTableCatalog");
            this.spark().sql("CREATE DATABASE " + otherCatalog + "." + otherDatabase);
            this.spark().sql("CREATE DATABASE " + otherDatabase2);
            new .colon.colon((Object)new Tuple2((Object)"upstream_mv", (Object)"downstream_mv"), (List)new .colon.colon((Object)new Tuple2((Object)"upstream_mv2", (Object)(otherDatabase2 + ".downstream_mv2")), (List)new .colon.colon((Object)new Tuple2((Object)"upstream_mv3", (Object)(otherCatalog + "." + otherDatabase + ".downstream_mv3")), (List)new .colon.colon((Object)new Tuple2((Object)(otherDatabase2 + ".upstream_mv4"), (Object)"downstream_mv4"), (List)new .colon.colon((Object)new Tuple2((Object)(otherCatalog + "." + otherDatabase + ".upstream_mv5"), (Object)"downstream_mv5"), (List)new .colon.colon((Object)new Tuple2((Object)(otherCatalog + "." + otherDatabase + ".upstream_mv6"), (Object)(otherDatabase2 + ".downstream_mv6")), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String table1Ident = (String)tuple2._1();
                    String table2Ident = (String)tuple2._2();
                    DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |CREATE MATERIALIZED VIEW " + table1Ident + " (id BIGINT) AS SELECT * FROM RANGE(10);\n             |CREATE MATERIALIZED VIEW " + table2Ident + " AS SELECT id FROM " + table1Ident + "\n             |WHERE (id%2)=0;\n             |")), this.unresolvedDataflowGraphFromSql$default$2());
                    this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + table2Ident), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8)})), (List)Nil$.MODULE$))))));
                    this.spark().sql("DROP TABLE " + table1Ident);
                    return this.spark().sql("DROP TABLE " + table2Ident);
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739));
        this.test("Creating streaming table without subquery works if streaming table is backed by flows", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE STREAMING TABLE st;\n                   |CREATE FLOW f AS INSERT INTO st BY NAME\n                   |SELECT * FROM STREAM " + this.externalTable1Ident() + ";\n                   |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable)() -> this.spark().sql("SELECT * FROM " + this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4())), (Seq<Row>)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
        this.test("groupby and rollup works with internal datasets", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool bool;
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE MATERIALIZED VIEW src AS\n                   |    SELECT id\n                   |    FROM range(3);\n                   |\n                   |CREATE MATERIALIZED VIEW groupby_result AS\n                   |    SELECT id, SUM(id) AS sum_id, COUNT(*) AS cnt\n                   |    FROM src\n                   |    GROUP BY id;\n                   |\n                   |CREATE MATERIALIZED VIEW rollup_result AS\n                   |    SELECT id, SUM(id) AS sum_id, COUNT(*) AS cnt\n                   |    FROM src\n                   |    GROUP BY ROLLUP(id);\n                   |")), this.unresolvedDataflowGraphFromSql$default$2());
            this.startPipelineAndWaitForCompletion(unresolvedDataflowGraph);
            org.apache.spark.sql.classic.Dataset groupbyDf = this.spark().table(this.fullyQualifiedIdentifier("groupby_result", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()));
            org.apache.spark.sql.classic.Dataset rollupDf = this.spark().table(this.fullyQualifiedIdentifier("rollup_result", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()));
            Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])groupbyDf.select("id", (Seq)Nil$.MODULE$).collect()), (Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.getLong(0)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
            long $org_scalatest_assert_macro_left2 = rollupDf.count();
            long $org_scalatest_assert_macro_right2 = groupbyDf.count() + 1L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
            Row totalRow = (Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])rollupDf.filter("id IS NULL").collect()));
            long $org_scalatest_assert_macro_left3 = totalRow.getLong(1);
            long $org_scalatest_assert_macro_right3 = 3L;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                long $org_scalatest_assert_macro_left5 = totalRow.getLong(2);
                long $org_scalatest_assert_macro_right4 = 3L;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
        this.test("Empty streaming table definition is disallowed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedDataflowGraph = this.unresolvedDataflowGraphFromSql("CREATE STREAMING TABLE st;", this.unresolvedDataflowGraphFromSql$default$2());
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> unresolvedDataflowGraph.resolve().validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846)), "PIPELINE_DATASET_WITHOUT_FLOW", Option$.MODULE$.apply((Object)"0A000"), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString())})), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
        this.test("Flow identifiers must be single part", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"a.b", (List)new .colon.colon((Object)"a.b.c", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)flowIdentifier -> {
            SqlPipelineSuite.$anonfun$new$87(this, flowIdentifier);
            return BoxedUnit.UNIT;
        }), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
        this.test("Duplicate standalone flow identifiers throw an exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException ex;
            AnalysisException x$7 = ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.unresolvedDataflowGraphFromSqlFiles((Seq<PipelineTest.TestSqlFile>)new .colon.colon((Object)new PipelineTest.TestSqlFile(this, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE STREAMING TABLE st;\n                 |CREATE FLOW f AS INSERT INTO st BY NAME\n                 |SELECT * FROM STREAM " + this.externalTable1Ident() + "\n                 |")), "file1.sql"), (List)new .colon.colon((Object)new PipelineTest.TestSqlFile(this, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE FLOW f AS INSERT INTO st BY NAME\n                 |SELECT * FROM STREAM " + this.externalTable1Ident() + "\n                 |")), "file2.sql"), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
            String x$8 = "PIPELINE_DUPLICATE_IDENTIFIERS.FLOW";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)this.fullyQualifiedIdentifier("f", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetNames"), (Object)this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString())}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "PIPELINE_DUPLICATE_IDENTIFIERS.FLOW", x$10, x$9, x$11, x$12);
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        this.test("Duplicate standalone implicit flow identifier throws exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException ex;
            AnalysisException x$13 = ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.unresolvedDataflowGraphFromSqlFiles((Seq<PipelineTest.TestSqlFile>)new .colon.colon((Object)new PipelineTest.TestSqlFile(this, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE STREAMING TABLE st AS SELECT * FROM STREAM " + this.externalTable1Ident() + ";\n                 |CREATE STREAMING TABLE st2;\n                 |")), "file1.sql"), (List)new .colon.colon((Object)new PipelineTest.TestSqlFile(this, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                 |CREATE FLOW st AS INSERT INTO st2 BY NAME\n                 |SELECT * FROM STREAM " + this.externalTable2Ident() + "\n                 |")), "file2.sql"), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
            String x$14 = "PIPELINE_DUPLICATE_IDENTIFIERS.FLOW";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetNames"), (Object)new .colon.colon((Object)this.fullyQualifiedIdentifier("st", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString(), (List)new .colon.colon((Object)this.fullyQualifiedIdentifier("st2", this.fullyQualifiedIdentifier$default$2(), this.fullyQualifiedIdentifier$default$3(), this.fullyQualifiedIdentifier$default$4()).quotedString(), (List)Nil$.MODULE$)).mkString(","))}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "PIPELINE_DUPLICATE_IDENTIFIERS.FLOW", x$16, x$15, x$17, x$18);
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
        this.test("No table defined pipeline fails with RUN_EMPTY_PIPELINE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            sqlGraphRegistrationContext.processSqlFile("", "a.sql", (SparkSession)this.spark());
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> graphRegistrationContext.toDataflowGraph(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956)), "RUN_EMPTY_PIPELINE", Option$.MODULE$.apply((Object)"42617"), Predef$.MODULE$.Map().empty(), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949));
        this.test("Pipeline with only temp views fails with RUN_EMPTY_PIPELINE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE TEMPORARY VIEW a AS SELECT id FROM range(1,3);\n                   |")), "a.sql", (SparkSession)this.spark());
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> graphRegistrationContext.toDataflowGraph(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978)), "RUN_EMPTY_PIPELINE", Option$.MODULE$.apply((Object)"42617"), Predef$.MODULE$.Map().empty(), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 965));
        this.test("Pipeline with only flow fails with RUN_EMPTY_PIPELINE", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            TestGraphRegistrationContext graphRegistrationContext = new TestGraphRegistrationContext(this.spark(), TestGraphRegistrationContext$.MODULE$.$lessinit$greater$default$2());
            SqlGraphRegistrationContext sqlGraphRegistrationContext = new SqlGraphRegistrationContext((GraphRegistrationContext)graphRegistrationContext);
            sqlGraphRegistrationContext.processSqlFile(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |CREATE FLOW f AS INSERT INTO a BY NAME\n                   |SELECT 1;\n                   |")), "a.sql", (SparkSession)this.spark());
            this.checkError((SparkThrowable)this.intercept((Function0 & Serializable)() -> graphRegistrationContext.toDataflowGraph(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001)), "RUN_EMPTY_PIPELINE", Option$.MODULE$.apply((Object)"42617"), Predef$.MODULE$.Map().empty(), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("SqlPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$new$31$adapted(SqlPipelineSuite $this, TableCatalog catalog$1, Seq expected$1, String tableName) {
        SqlPipelineSuite.$anonfun$new$31($this, catalog$1, expected$1, tableName);
        return BoxedUnit.UNIT;
    }
}

