/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryWrapper;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.GraphElement;
import org.apache.spark.sql.pipelines.graph.GraphExecution;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.StreamingFlowExecution;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.test.SQLTestData;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}3\u0001BB\u0004\u0011\u0002\u0007\u0005A#\u0016\u0005\u00067\u0001!\t\u0001\b\u0005\u0006A\u0001!I!\t\u0005\u0006\u007f\u0001!I\u0001\u0011\u0005\u0006\u000f\u0002!\t\u0002\u0013\u0005\u0006\u001d\u0002!\tb\u0014\u0002\u001a'f\u001cH/Z7NKR\fG-\u0019;b)\u0016\u001cH\u000fS3ma\u0016\u00148O\u0003\u0002\t\u0013\u0005)qM]1qQ*\u0011!bC\u0001\na&\u0004X\r\\5oKNT!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\tQ\u0004\u0005\u0002\u0017=%\u0011qd\u0006\u0002\u0005+:LG/\u0001\u0016hKR,\u0005\u0010]3di\u0016$g\t\\8x\u0007\",7m\u001b9pS:$H)\u001b:G_J$\u0016M\u00197f\u001fJ\u001c\u0016N\\6\u0015\u000b\tR\u0003'\u000e\u001e\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013A\u00014t\u0015\t9s\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003S\u0011\u0012A\u0001U1uQ\")1F\u0001a\u0001Y\u0005\u0011B/\u00192mK>\u00138+\u001b8l\u000b2,W.\u001a8u!\tic&D\u0001\b\u0013\tysA\u0001\u0007He\u0006\u0004\b.\u00127f[\u0016tG\u000fC\u00032\u0005\u0001\u0007!'A\u0006gY><X\t\\3nK:$\bCA\u00174\u0013\t!tA\u0001\u0003GY><\b\"\u0002\u001c\u0003\u0001\u00049\u0014!G3ya\u0016\u001cG/\u001a3DQ\u0016\u001c7\u000e]8j]R4VM]:j_:\u0004\"A\u0006\u001d\n\u0005e:\"aA%oi\")1H\u0001a\u0001y\u0005iQ\u000f\u001d3bi\u0016\u001cuN\u001c;fqR\u0004\"!L\u001f\n\u0005y:!!\u0006)ja\u0016d\u0017N\\3Va\u0012\fG/Z\"p]R,\u0007\u0010^\u0001)O\u0016$\u0018i\u0019;vC24En\\<DQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d$peR\u000b'\r\\3PeNKgn\u001b\u000b\u0004E\u0005\u0013\u0005\"B\u0019\u0004\u0001\u0004\u0011\u0004\"B\"\u0004\u0001\u0004!\u0015AD4sCBDW\t_3dkRLwN\u001c\t\u0003[\u0015K!AR\u0004\u0003\u001d\u001d\u0013\u0018\r\u001d5Fq\u0016\u001cW\u000f^5p]\u0006i\u0012m]:feR4En\\<DQ\u0016\u001c7\u000e]8j]R$\u0015N]#ySN$8\u000f\u0006\u0004#\u0013*[E*\u0014\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\u0006c\u0011\u0001\rA\r\u0005\u0006m\u0011\u0001\ra\u000e\u0005\u0006\u0007\u0012\u0001\r\u0001\u0012\u0005\u0006w\u0011\u0001\r\u0001P\u0001!CN\u001cXM\u001d;GY><8\t[3dWB|\u0017N\u001c;ESJtu\u000e^#ySN$8\u000f\u0006\u0004#!F\u00136\u000b\u0016\u0005\u0006W\u0015\u0001\r\u0001\f\u0005\u0006c\u0015\u0001\rA\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006w\u0015\u0001\r\u0001\u0010\n\u0004-bKf\u0001B,\u0001\u0001U\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"!\f\u0001\u0011\u0005ikV\"A.\u000b\u0005qK\u0011!B;uS2\u001c\u0018B\u00010\\\u00055)\u00050Z2vi&|g\u000eV3ti\u0002")
public interface SystemMetadataTestHelpers {
    private Path getExpectedFlowCheckpointDirForTableOrSink(GraphElement tableOrSinkElement, Flow flowElement, int expectedCheckpointVersion, PipelineUpdateContext updateContext) {
        GraphElement graphElement = tableOrSinkElement;
        if (!(graphElement instanceof Table) && !(graphElement instanceof Sink)) {
            throw ((Assertions)this).fail("unexpected table element type for assertFlowCheckpointDirForTableOrSink: " + tableOrSinkElement.getClass().getSimpleName(), new Position("SystemMetadataSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        }
        String expectedRawCheckPointDir = new Path(updateContext.storageRoot()).suffix("/_checkpoints/" + graphElement.identifier().table() + "/" + flowElement.identifier().table()).toString();
        return new Path("file://", expectedRawCheckPointDir).suffix("/" + expectedCheckpointVersion);
    }

    private Path getActualFlowCheckpointDirForTableOrSink(Flow flowElement, GraphExecution graphExecution) {
        StreamingQuery flowStream = ((StreamingFlowExecution)graphExecution.flowExecutions().apply((Object)flowElement.identifier())).getStreamingQuery();
        return new Path(((StreamingQueryWrapper)flowStream).streamingQuery().resolvedCheckpointRoot());
    }

    public static /* synthetic */ Path assertFlowCheckpointDirExists$(SystemMetadataTestHelpers $this, GraphElement tableOrSinkElement, Flow flowElement, int expectedCheckpointVersion, GraphExecution graphExecution, PipelineUpdateContext updateContext) {
        return $this.assertFlowCheckpointDirExists(tableOrSinkElement, flowElement, expectedCheckpointVersion, graphExecution, updateContext);
    }

    default public Path assertFlowCheckpointDirExists(GraphElement tableOrSinkElement, Flow flowElement, int expectedCheckpointVersion, GraphExecution graphExecution, PipelineUpdateContext updateContext) {
        Path expectedCheckPointDir = this.getExpectedFlowCheckpointDirForTableOrSink(tableOrSinkElement, flowElement, expectedCheckpointVersion, updateContext);
        Path actualCheckpointDir = this.getActualFlowCheckpointDirForTableOrSink(flowElement, graphExecution);
        FileSystem fs = expectedCheckPointDir.getFileSystem(((SQLTestData)this).spark().sessionState().newHadoopConf());
        Path $org_scalatest_assert_macro_left = actualCheckpointDir;
        Path $org_scalatest_assert_macro_right = expectedCheckPointDir;
        Path path = $org_scalatest_assert_macro_left;
        Path path2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SystemMetadataSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fs.exists(actualCheckpointDir), "fs.exists(actualCheckpointDir)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SystemMetadataSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        return actualCheckpointDir;
    }

    public static /* synthetic */ Path assertFlowCheckpointDirNotExists$(SystemMetadataTestHelpers $this, GraphElement tableOrSinkElement, Flow flowElement, int expectedCheckpointVersion, GraphExecution graphExecution, PipelineUpdateContext updateContext) {
        return $this.assertFlowCheckpointDirNotExists(tableOrSinkElement, flowElement, expectedCheckpointVersion, graphExecution, updateContext);
    }

    default public Path assertFlowCheckpointDirNotExists(GraphElement tableOrSinkElement, Flow flowElement, int expectedCheckpointVersion, GraphExecution graphExecution, PipelineUpdateContext updateContext) {
        Path expectedCheckPointDir = this.getExpectedFlowCheckpointDirForTableOrSink(tableOrSinkElement, flowElement, expectedCheckpointVersion, updateContext);
        Path actualCheckpointDir = this.getActualFlowCheckpointDirForTableOrSink(flowElement, graphExecution);
        FileSystem fs = expectedCheckPointDir.getFileSystem(((SQLTestData)this).spark().sessionState().newHadoopConf());
        Path $org_scalatest_assert_macro_left = actualCheckpointDir;
        Path $org_scalatest_assert_macro_right = expectedCheckPointDir;
        Path path = $org_scalatest_assert_macro_left;
        Path path2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, path == null ? path2 != null : !path.equals(path2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SystemMetadataSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fs.exists(expectedCheckPointDir), "fs.exists(expectedCheckPointDir)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SystemMetadataSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        return actualCheckpointDir;
    }

    public static void $init$(SystemMetadataTestHelpers $this) {
    }
}

