/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.util;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.pipelines.util.SchemaInferenceUtils$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\tI2k\u00195f[\u0006LeNZ3sK:\u001cW-\u0016;jYN\u001cV/\u001b;f\u0015\t!Q!\u0001\u0003vi&d'B\u0001\u0004\b\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0019\u0001")
public class SchemaInferenceUtilsSuite
extends SparkFunSuite {
    public static final /* synthetic */ boolean $anonfun$new$2(TableChange x0$1) {
        TableChange tableChange = x0$1;
        if (tableChange instanceof TableChange.AddColumn) {
            TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])addColumn.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"age"}));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$3(TableChange x0$2) {
        TableChange tableChange = x0$2;
        if (tableChange instanceof TableChange.AddColumn) {
            TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])addColumn.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"email"}));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(TableChange x0$3) {
        TableChange tableChange = x0$3;
        if (tableChange instanceof TableChange.UpdateColumnType) {
            TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$6(TableChange x0$4) {
        TableChange tableChange = x0$4;
        if (tableChange instanceof TableChange.UpdateColumnType) {
            TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(TableChange x0$5) {
        TableChange tableChange = x0$5;
        if (tableChange instanceof TableChange.UpdateColumnNullability) {
            TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])updateColumnNullability.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(TableChange x0$6) {
        TableChange tableChange = x0$6;
        if (tableChange instanceof TableChange.UpdateColumnNullability) {
            TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])updateColumnNullability.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$10(TableChange x0$7) {
        TableChange tableChange = x0$7;
        if (tableChange instanceof TableChange.UpdateColumnComment) {
            TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
            return Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"description"}));
        }
        return false;
    }

    public SchemaInferenceUtilsSuite() {
        this.test("determineColumnChanges - adding new columns", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType currentSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$);
            StructType targetSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$).add("age", (DataType)IntegerType$.MODULE$).add("email", (DataType)StringType$.MODULE$, true, "Email address");
            Seq changes = SchemaInferenceUtils$.MODULE$.diffSchemas(currentSchema, targetSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)changes.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TableChange.AddColumn ageChange = (TableChange.AddColumn)changes.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$2(x0$1))).get();
            TableChange.AddColumn emailChange = (TableChange.AddColumn)changes.find((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$3(x0$2))).get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(ageChange.dataType());
            IntegerType$ $org_scalatest_assert_macro_right2 = IntegerType$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ageChange.isNullable()));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(ageChange.comment());
            Null$ $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", null, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(emailChange.dataType());
            StringType$ $org_scalatest_assert_macro_right5 = StringType$.MODULE$;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)emailChange.isNullable()));
            boolean $org_scalatest_assert_macro_right6 = true;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(emailChange.comment());
            String $org_scalatest_assert_macro_right7 = "Email address";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("determineColumnChanges - updating column types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType currentSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("amount", (DataType)DoubleType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$);
            StructType targetSchema = new StructType().add("id", (DataType)LongType$.MODULE$, false).add("amount", (DataType)new DecimalType(10, 2)).add("timestamp", (DataType)TimestampType$.MODULE$);
            Seq changes = SchemaInferenceUtils$.MODULE$.diffSchemas(currentSchema, targetSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)changes.length()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TableChange.UpdateColumnType idChange = (TableChange.UpdateColumnType)changes.find((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$5(x0$3))).get();
            TableChange.UpdateColumnType amountChange = (TableChange.UpdateColumnType)changes.find((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$6(x0$4))).get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(idChange.newDataType());
            LongType$ $org_scalatest_assert_macro_right2 = LongType$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(amountChange.newDataType());
            DecimalType $org_scalatest_assert_macro_right3 = new DecimalType(10, 2);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("determineColumnChanges - updating nullability and comments", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType currentSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$, true).add("description", (DataType)StringType$.MODULE$, true, "Item description");
            StructType targetSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true).add("name", (DataType)StringType$.MODULE$, false).add("description", (DataType)StringType$.MODULE$, true, "Product description");
            Seq changes = SchemaInferenceUtils$.MODULE$.diffSchemas(currentSchema, targetSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)changes.length()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            TableChange.UpdateColumnNullability idNullabilityChange = (TableChange.UpdateColumnNullability)changes.find((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$8(x0$5))).get();
            TableChange.UpdateColumnNullability nameNullabilityChange = (TableChange.UpdateColumnNullability)changes.find((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$9(x0$6))).get();
            TableChange.UpdateColumnComment descriptionCommentChange = (TableChange.UpdateColumnComment)changes.find((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)SchemaInferenceUtilsSuite.$anonfun$new$10(x0$7))).get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)idNullabilityChange.nullable()));
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)nameNullabilityChange.nullable()));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(descriptionCommentChange.newComment());
            String $org_scalatest_assert_macro_right4 = "Product description";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("determineColumnChanges - complex changes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType currentSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$).add("old_field", (DataType)BooleanType$.MODULE$);
            StructType targetSchema = new StructType().add("id", (DataType)LongType$.MODULE$, true).add("name", (DataType)StringType$.MODULE$, false, "Full name").add("new_field", (DataType)StringType$.MODULE$);
            Seq changes = SchemaInferenceUtils$.MODULE$.diffSchemas(currentSchema, targetSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)changes.length()));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            int typeChanges = ((SeqOps)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof TableChange.UpdateColumnType) {
                        return (B1)BoxesRunTime.boxToInteger((int)1);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(TableChange x1) {
                    TableChange tableChange = x1;
                    return tableChange instanceof TableChange.UpdateColumnType;
                }
            })).size();
            int nullabilityChanges = ((SeqOps)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof TableChange.UpdateColumnNullability) {
                        return (B1)BoxesRunTime.boxToInteger((int)1);
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(TableChange x2) {
                    TableChange tableChange = x2;
                    return tableChange instanceof TableChange.UpdateColumnNullability;
                }
            })).size();
            int commentChanges = ((SeqOps)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof TableChange.UpdateColumnComment) {
                        return (B1)BoxesRunTime.boxToInteger((int)1);
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(TableChange x3) {
                    TableChange tableChange = x3;
                    return tableChange instanceof TableChange.UpdateColumnComment;
                }
            })).size();
            int addColumnChanges = ((SeqOps)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    if (A1 instanceof TableChange.AddColumn) {
                        return (B1)BoxesRunTime.boxToInteger((int)1);
                    }
                    return (B1)function1.apply(x4);
                }

                public final boolean isDefinedAt(TableChange x4) {
                    TableChange tableChange = x4;
                    return tableChange instanceof TableChange.AddColumn;
                }
            })).size();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)typeChanges));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)nullabilityChanges));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)commentChanges));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)addColumnChanges));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("determineColumnChanges - no changes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq changes;
            StructType schema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$);
            Seq $org_scalatest_assert_macro_left = changes = SchemaInferenceUtils$.MODULE$.diffSchemas(schema, schema);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("determineColumnChanges - deleting columns", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType currentSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$).add("age", (DataType)IntegerType$.MODULE$).add("email", (DataType)StringType$.MODULE$).add("phone", (DataType)StringType$.MODULE$);
            StructType targetSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("name", (DataType)StringType$.MODULE$);
            Seq changes = SchemaInferenceUtils$.MODULE$.diffSchemas(currentSchema, targetSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)changes.length()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            Seq deleteChanges = (Seq)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    A1 A1 = x5;
                    if (A1 instanceof TableChange.DeleteColumn) {
                        TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)A1;
                        return (B1)deleteColumn;
                    }
                    return (B1)function1.apply(x5);
                }

                public final boolean isDefinedAt(TableChange x5) {
                    TableChange tableChange = x5;
                    return tableChange instanceof TableChange.DeleteColumn;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deleteChanges.length()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            Set columnNames = ((IterableOnceOps)deleteChanges.map((Function1 & Serializable)x$1 -> x$1.fieldNames()[0])).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(columnNames);
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"age", "email", "phone"}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("determineColumnChanges - mixed additions and deletions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType currentSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("first_name", (DataType)StringType$.MODULE$).add("last_name", (DataType)StringType$.MODULE$).add("age", (DataType)IntegerType$.MODULE$);
            StructType targetSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, false).add("full_name", (DataType)StringType$.MODULE$).add("email", (DataType)StringType$.MODULE$).add("age", (DataType)IntegerType$.MODULE$);
            Seq changes = SchemaInferenceUtils$.MODULE$.diffSchemas(currentSchema, targetSchema);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)changes.length()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            Seq addChanges = (Seq)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    A1 A1 = x6;
                    if (A1 instanceof TableChange.AddColumn) {
                        TableChange.AddColumn addColumn = (TableChange.AddColumn)A1;
                        return (B1)addColumn;
                    }
                    return (B1)function1.apply(x6);
                }

                public final boolean isDefinedAt(TableChange x6) {
                    TableChange tableChange = x6;
                    return tableChange instanceof TableChange.AddColumn;
                }
            });
            Seq deleteChanges = (Seq)changes.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    A1 A1 = x7;
                    if (A1 instanceof TableChange.DeleteColumn) {
                        TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)A1;
                        return (B1)deleteColumn;
                    }
                    return (B1)function1.apply(x7);
                }

                public final boolean isDefinedAt(TableChange x7) {
                    TableChange tableChange = x7;
                    return tableChange instanceof TableChange.DeleteColumn;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)addChanges.length()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deleteChanges.length()));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            Set addedColumnNames = ((IterableOnceOps)addChanges.map((Function1 & Serializable)x$2 -> x$2.fieldNames()[0])).toSet();
            Set deletedColumnNames = ((IterableOnceOps)deleteChanges.map((Function1 & Serializable)x$3 -> x$3.fieldNames()[0])).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(addedColumnNames);
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"full_name", "email"}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(deletedColumnNames);
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"first_name", "last_name"}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        }, new Position("SchemaInferenceUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
    }
}

