/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.common.RunState$FAILED$;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DatasetManager$;
import org.apache.spark.sql.pipelines.graph.Input;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.RunCompletion;
import org.apache.spark.sql.pipelines.graph.RunTerminationReason;
import org.apache.spark.sql.pipelines.graph.State$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$;
import org.apache.spark.sql.pipelines.graph.UnresolvedPipelineException;
import org.apache.spark.sql.pipelines.logging.ConstructPipelineEvent$;
import org.apache.spark.sql.pipelines.logging.EventLevel$ERROR$;
import org.apache.spark.sql.pipelines.logging.EventLevel$INFO$;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.logging.PipelineEventOrigin;
import org.apache.spark.sql.pipelines.logging.RunProgress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00054Aa\u0004\t\u0001;!AA\u0005\u0001B\u0001B\u0003%Q\u0005C\u0003*\u0001\u0011\u0005!\u0006\u0003\u0005.\u0001\u0001\u0007I\u0011\u0001\n/\u0011!)\u0004\u00011A\u0005\u0002I1\u0004B\u0002\u001f\u0001A\u0003&q\u0006C\u0003>\u0001\u0011\u0005a\bC\u0003C\u0001\u0011\u00051\tC\u0003E\u0001\u0011\u00051\tC\u0003F\u0001\u0011\u00051\tC\u0003G\u0001\u0011%q\tC\u0003T\u0001\u0011%A\u000b\u0003\u0004Y\u0001\u0011\u0005Ac\u0011\u0005\u00063\u0002!IA\u0017\u0005\u0006A\u0002!\ta\u0011\u0002\u0012!&\u0004X\r\\5oK\u0016CXmY;uS>t'BA\t\u0013\u0003\u00159'/\u00199i\u0015\t\u0019B#A\u0005qSB,G.\u001b8fg*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\r|g\u000e^3yiB\u0011aeJ\u0007\u0002!%\u0011\u0001\u0006\u0005\u0002\u0016!&\u0004X\r\\5oKV\u0003H-\u0019;f\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u00111\u0006\f\t\u0003M\u0001AQ\u0001\n\u0002A\u0002\u0015\nab\u001a:ba\",\u00050Z2vi&|g.F\u00010!\ry\u0002GM\u0005\u0003c\u0001\u0012aa\u00149uS>t\u0007C\u0001\u00144\u0013\t!\u0004CA\fUe&<w-\u001a:fI\u001e\u0013\u0018\r\u001d5Fq\u0016\u001cW\u000f^5p]\u0006\u0011rM]1qQ\u0016CXmY;uS>tw\fJ3r)\t9$\b\u0005\u0002 q%\u0011\u0011\b\t\u0002\u0005+:LG\u000fC\u0004<\t\u0005\u0005\t\u0019A\u0018\u0002\u0007a$\u0013'A\bhe\u0006\u0004\b.\u0012=fGV$\u0018n\u001c8!\u0003A)\u00070Z2vi&|gn\u0015;beR,G-F\u0001@!\ty\u0002)\u0003\u0002BA\t9!i\\8mK\u0006t\u0017!D:uCJ$\b+\u001b9fY&tW\rF\u00018\u0003-\u0011XO\u001c)ja\u0016d\u0017N\\3\u0002\u001d\u0011\u0014\u0018PU;o!&\u0004X\r\\5oK\u0006I2m\u001c8tiJ,8\r\u001e+fe6Lg.\u0019;j_:,e/\u001a8u)\tAe\n\u0005\u0002J\u00196\t!J\u0003\u0002L%\u00059An\\4hS:<\u0017BA'K\u00055\u0001\u0016\u000e]3mS:,WI^3oi\")qJ\u0003a\u0001!\u0006\tB/\u001a:nS:\fG/[8o%\u0016\f7o\u001c8\u0011\u0005\u0019\n\u0016B\u0001*\u0011\u0005Q\u0011VO\u001c+fe6Lg.\u0019;j_:\u0014V-Y:p]\u0006a!/Z:pYZ,wI]1qQR\tQ\u000b\u0005\u0002'-&\u0011q\u000b\u0005\u0002\u000e\t\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5\u0002\u001f\u0005<\u0018-\u001b;D_6\u0004H.\u001a;j_:\fQ\u0003[1oI2,\u0017J\u001c<bY&$\u0007+\u001b9fY&tW\r\u0006\u000287\")A,\u0004a\u0001;\u0006\tQ\r\u0005\u0002'=&\u0011q\f\u0005\u0002\u001c+:\u0014Xm]8mm\u0016$\u0007+\u001b9fY&tW-\u0012=dKB$\u0018n\u001c8\u0002\u0019M$x\u000e\u001d)ja\u0016d\u0017N\\3")
public class PipelineExecution {
    private final PipelineUpdateContext context;
    private Option<TriggeredGraphExecution> graphExecution;

    public Option<TriggeredGraphExecution> graphExecution() {
        return this.graphExecution;
    }

    public void graphExecution_$eq(Option<TriggeredGraphExecution> x$1) {
        this.graphExecution = x$1;
    }

    public synchronized boolean executionStarted() {
        return this.graphExecution().nonEmpty();
    }

    public synchronized void startPipeline() {
        DataflowGraph resolvedGraph = this.resolveGraph();
        Seq<Input> seq = this.context.fullRefreshTables().nonEmpty() ? State$.MODULE$.reset(resolvedGraph, this.context) : BoxedUnit.UNIT;
        DataflowGraph initializedGraph = DatasetManager$.MODULE$.materializeDatasets(resolvedGraph, this.context);
        this.graphExecution_$eq((Option<TriggeredGraphExecution>)Option$.MODULE$.apply((Object)new TriggeredGraphExecution(initializedGraph, this.context, (Function1<RunTerminationReason, BoxedUnit>)(Function1 & Serializable)terminationReason -> {
            PipelineExecution.$anonfun$startPipeline$1(this, terminationReason);
            return BoxedUnit.UNIT;
        }, TriggeredGraphExecution$.MODULE$.$lessinit$greater$default$4())));
        this.graphExecution().foreach((Function1 & Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void runPipeline() {
        try {
            this.startPipeline();
            this.context.pipelineExecution().awaitCompletion();
        }
        catch (Throwable e) {
            None$ x$1 = None$.MODULE$;
            None$ x$2 = None$.MODULE$;
            None$ x$3 = None$.MODULE$;
            PipelineEventOrigin x$4 = new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3);
            String x$5 = "Pipeline execution failed.";
            RunProgress x$6 = new RunProgress(RunState$FAILED$.MODULE$);
            Option x$7 = Option$.MODULE$.apply((Object)e);
            EventLevel$ERROR$ x$8 = EventLevel$ERROR$.MODULE$;
            Option<Timestamp> x$9 = ConstructPipelineEvent$.MODULE$.apply$default$6();
            this.context.eventCallback().apply((Object)ConstructPipelineEvent$.MODULE$.apply(x$4, x$8, "Pipeline execution failed.", x$6, (Option<Throwable>)x$7, x$9));
        }
    }

    public synchronized void dryRunPipeline() {
        this.resolveGraph();
        this.context.eventCallback().apply((Object)this.constructTerminationEvent(new RunCompletion()));
    }

    private PipelineEvent constructTerminationEvent(RunTerminationReason terminationReason) {
        None$ x$1 = None$.MODULE$;
        None$ x$2 = None$.MODULE$;
        None$ x$3 = None$.MODULE$;
        return ConstructPipelineEvent$.MODULE$.apply(new PipelineEventOrigin((Option<String>)x$2, (Option<String>)x$1, (Option<QueryOrigin>)x$3), EventLevel$INFO$.MODULE$, terminationReason.message(), new RunProgress(terminationReason.terminalState()), terminationReason.cause(), ConstructPipelineEvent$.MODULE$.apply$default$6());
    }

    private DataflowGraph resolveGraph() {
        DataflowGraph dataflowGraph;
        try {
            dataflowGraph = this.context.unresolvedGraph().resolve().validate();
        }
        catch (UnresolvedPipelineException e) {
            this.handleInvalidPipeline(e);
            throw e;
        }
        return dataflowGraph;
    }

    public void awaitCompletion() {
        this.graphExecution().foreach((Function1 & Serializable)x$2 -> {
            x$2.awaitCompletion();
            return BoxedUnit.UNIT;
        });
    }

    private void handleInvalidPipeline(UnresolvedPipelineException e) {
        e.downstreamFailures().foreach((Function1 & Serializable)failure -> {
            PipelineExecution.$anonfun$handleInvalidPipeline$1(this, e, failure);
            return BoxedUnit.UNIT;
        });
        e.directFailures().foreach((Function1 & Serializable)failure -> {
            PipelineExecution.$anonfun$handleInvalidPipeline$2(this, e, failure);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void stopPipeline() {
        ((TriggeredGraphExecution)this.graphExecution().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Pipeline execution has not started yet.");
        })).stop();
    }

    public static final /* synthetic */ void $anonfun$startPipeline$1(PipelineExecution $this, RunTerminationReason terminationReason) {
        $this.context.eventCallback().apply((Object)$this.constructTerminationEvent(terminationReason));
    }

    public static final /* synthetic */ void $anonfun$handleInvalidPipeline$1(PipelineExecution $this, UnresolvedPipelineException e$1, Tuple2 failure) {
        Tuple2 tuple2 = failure;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableIdentifier flowIdentifier = (TableIdentifier)tuple2._1();
        Throwable ex = (Throwable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)flowIdentifier, (Object)ex);
        TableIdentifier flowIdentifier2 = (TableIdentifier)tuple22._1();
        Throwable ex2 = (Throwable)tuple22._2();
        ResolutionFailedFlow flow = (ResolutionFailedFlow)e$1.graph().resolutionFailedFlow().apply((Object)flowIdentifier2);
        $this.context.flowProgressEventLogger().recordFailed(flow, ex2, true, (Option<String>)Option$.MODULE$.apply((Object)("Failed to resolve flow due to upstream failure: '" + flow.displayName() + "'.")));
    }

    public static final /* synthetic */ void $anonfun$handleInvalidPipeline$2(PipelineExecution $this, UnresolvedPipelineException e$1, Tuple2 failure) {
        Tuple2 tuple2 = failure;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableIdentifier flowIdentifier = (TableIdentifier)tuple2._1();
        Throwable ex = (Throwable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)flowIdentifier, (Object)ex);
        TableIdentifier flowIdentifier2 = (TableIdentifier)tuple22._1();
        Throwable ex2 = (Throwable)tuple22._2();
        ResolutionFailedFlow flow = (ResolutionFailedFlow)e$1.graph().resolutionFailedFlow().apply((Object)flowIdentifier2);
        $this.context.flowProgressEventLogger().recordFailed(flow, ex2, true, (Option<String>)Option$.MODULE$.apply((Object)("Failed to resolve flow: '" + flow.displayName() + "'.")));
    }

    public PipelineExecution(PipelineUpdateContext context) {
        this.context = context;
        this.graphExecution = None$.MODULE$;
    }
}

