/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.AllTables$;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.FlowSystemMetadata;
import org.apache.spark.sql.pipelines.graph.Input;
import org.apache.spark.sql.pipelines.graph.NoTables$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.PipelinesTableProperties$;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.SomeTables;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.TableFilter;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class State$
implements Logging {
    public static final State$ MODULE$ = new State$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<Input> findElementsToReset(DataflowGraph graph, PipelineUpdateContext env) {
        Seq seq;
        Seq seq2;
        Seq specifiedTables = env.fullRefreshTables().filter(graph.tables());
        TableFilter tableFilter = env.fullRefreshTables();
        if (tableFilter instanceof SomeTables) {
            specifiedTables.foreach((Function1 & Serializable)t -> {
                State$.$anonfun$findElementsToReset$1(t);
                return BoxedUnit.UNIT;
            });
            seq2 = specifiedTables;
        } else if (AllTables$.MODULE$.equals(tableFilter)) {
            seq2 = (Seq)specifiedTables.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)State$.$anonfun$findElementsToReset$2(t)));
        } else if (NoTables$.MODULE$.equals(tableFilter)) {
            seq2 = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)tableFilter);
        }
        Seq specifiedTablesToReset = seq2;
        TableFilter tableFilter2 = env.fullRefreshTables();
        if (tableFilter2 instanceof SomeTables) {
            SomeTables someTables = (SomeTables)tableFilter2;
            Set<TableIdentifier> tablesAndSinks = someTables.selectedTables();
            seq = (Seq)graph.sinks().filter((Function1 & Serializable)sink -> BoxesRunTime.boxToBoolean((boolean)tablesAndSinks.contains((Object)sink.identifier())));
        } else if (AllTables$.MODULE$.equals(tableFilter2)) {
            seq = graph.sinks();
        } else if (NoTables$.MODULE$.equals(tableFilter2)) {
            seq = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)tableFilter2);
        }
        Seq specifiedSinksToReset = seq;
        return (Seq)((IterableOps)specifiedTablesToReset.flatMap((Function1 & Serializable)t -> {
            Table table = t;
            return (Seq)((SeqOps)graph.resolvedFlowsTo().apply((Object)t.identifier())).$plus$colon((Object)table);
        })).$plus$plus((IterableOnce)specifiedSinksToReset.flatMap((Function1 & Serializable)s -> (Seq)graph.resolvedFlowsTo().apply((Object)s.identifier())));
    }

    public Seq<Input> reset(DataflowGraph resolvedGraph, PipelineUpdateContext env) {
        Seq<Input> elementsToReset = this.findElementsToReset(resolvedGraph, env);
        elementsToReset.foreach((Function1 & Serializable)x0$1 -> {
            State$.$anonfun$reset$1(env, resolvedGraph, x0$1);
            return BoxedUnit.UNIT;
        });
        return elementsToReset;
    }

    private void reset(ResolvedFlow flow, PipelineUpdateContext env, DataflowGraph graph) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Clearing out state for flow ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FLOW_NAME, flow.displayName())}))));
        FlowSystemMetadata flowMetadata = new FlowSystemMetadata(env, flow, graph);
        ResolvedFlow resolvedFlow = flow;
        if (flowMetadata.latestCheckpointLocationOpt().isEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Skipping resetting flow " + resolvedFlow.identifier() + " since its destination not been previouslymaterialized and we can't find the checkpoint location.");
            return;
        }
        Configuration hadoopConf = env.spark().sessionState().newHadoopConf();
        Path checkpointDir = new Path(flowMetadata.latestCheckpointLocation());
        FileSystem fs1 = checkpointDir.getFileSystem(hadoopConf);
        if (fs1.exists(checkpointDir)) {
            int nextVersion = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(checkpointDir.getName())) + 1;
            Path nextPath = new Path(checkpointDir.getParent(), Integer.toString(nextVersion));
            fs1.mkdirs(nextPath);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Created new checkpoint for stream ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FLOW_NAME, flow.displayName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"at ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CHECKPOINT_PATH, nextPath.toString())})))));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findElementsToReset$1(Table t) {
        if (!BoxesRunTime.unboxToBoolean((Object)PipelinesTableProperties$.MODULE$.resetAllowed().fromMap(t.properties()))) {
            throw new AnalysisException("TABLE_NOT_RESETTABLE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)t.displayName())})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$findElementsToReset$2(Table t) {
        return BoxesRunTime.unboxToBoolean((Object)PipelinesTableProperties$.MODULE$.resetAllowed().fromMap(t.properties()));
    }

    public static final /* synthetic */ void $anonfun$reset$1(PipelineUpdateContext env$1, DataflowGraph resolvedGraph$1, Input x0$1) {
        Input input = x0$1;
        if (input instanceof ResolvedFlow) {
            ResolvedFlow resolvedFlow = (ResolvedFlow)input;
            MODULE$.reset(resolvedFlow, env$1, resolvedGraph$1);
            return;
        }
    }

    private State$() {
    }
}

