/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

final class BitArray {
    private final long[] data;
    private long bitCount;

    static int numWords(long numBits) {
        if (numBits <= 0L) {
            throw new IllegalArgumentException("numBits must be positive, but got " + numBits);
        }
        long numWords = (long)Math.ceil((double)numBits / 64.0);
        if (numWords > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't allocate enough space for " + numBits + " bits");
        }
        return (int)numWords;
    }

    BitArray(long numBits) {
        this(new long[BitArray.numWords(numBits)]);
    }

    private BitArray(long[] data) {
        this.data = data;
        long bitCount = 0L;
        for (long word : data) {
            bitCount += (long)Long.bitCount(word);
        }
        this.bitCount = bitCount;
    }

    boolean set(long index) {
        if (!this.get(index)) {
            int n = (int)(index >>> 6);
            this.data[n] = this.data[n] | 1L << (int)index;
            ++this.bitCount;
            return true;
        }
        return false;
    }

    boolean get(long index) {
        return (this.data[(int)(index >>> 6)] & 1L << (int)index) != 0L;
    }

    long bitSize() {
        return (long)this.data.length * 64L;
    }

    long cardinality() {
        return this.bitCount;
    }

    void putAll(BitArray array) {
        assert (this.data.length == array.data.length) : "BitArrays must be of equal length when merging";
        long bitCount = 0L;
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] | array.data[i];
            bitCount += (long)Long.bitCount(this.data[i]);
        }
        this.bitCount = bitCount;
    }

    void writeTo(DataOutputStream out) throws IOException {
        out.writeInt(this.data.length);
        for (long datum : this.data) {
            out.writeLong(datum);
        }
    }

    static BitArray readFrom(DataInputStream in) throws IOException {
        int numWords = in.readInt();
        long[] data = new long[numWords];
        for (int i = 0; i < numWords; ++i) {
            data[i] = in.readLong();
        }
        return new BitArray(data);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof BitArray)) {
            return false;
        }
        BitArray that = (BitArray)other;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

