/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal.types;

import java.util.HashMap;

public class SpatialReferenceSystemMapper {
    private static final SpatialReferenceSystemMapper Instance = new SpatialReferenceSystemMapper();
    private static final HashMap<Integer, String> sridToStringId = SpatialReferenceSystemMapper.buildSridToStringIdMap();
    private static final HashMap<String, Integer> stringIdToSrid = SpatialReferenceSystemMapper.buildStringIdToSridMap();

    private SpatialReferenceSystemMapper() {
    }

    public static SpatialReferenceSystemMapper get() {
        return Instance;
    }

    public String getStringId(int srid) {
        return sridToStringId.get(srid);
    }

    public Integer getSrid(String stringId) {
        return stringIdToSrid.get(stringId);
    }

    private static HashMap<Integer, String> buildSridToStringIdMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "SRID:0");
        map.put(3857, "EPSG:3857");
        map.put(4326, "OGC:CRS84");
        return map;
    }

    private static HashMap<String, Integer> buildStringIdToSridMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("SRID:0", 0);
        map.put("EPSG:3857", 3857);
        map.put("OGC:CRS84", 4326);
        return map;
    }
}

