/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter$;
import org.apache.spark.sql.kafka010.KafkaSource$;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceOffset$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.MockedSystemClock;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5f!B\u001c9\u0001a\u0012\u0005\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!\u0011!Q\u0001\n%D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001\"CA\n\u0001\t\u0005\t\u0015!\u0003u\u0011)\t)\u0002\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"a\u0012\u0001A\u0003%\u0011q\b\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017B\u0001\"a\u0015\u0001A\u0003%\u0011Q\n\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/B\u0001\"a\u0018\u0001A\u0003%\u0011\u0011\f\u0005\u000b\u0003C\u0002!\u0019!C\u0001q\u0005]\u0003\u0002CA2\u0001\u0001\u0006I!!\u0017\t\u0015\u0005\u0015\u0004A1A\u0005\u0002a\nY\u0005\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA'\u0011)\tI\u0007\u0001b\u0001\n\u0003A\u00141\u000e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002n!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u0002 !I\u0011q\u0010\u0001A\u0002\u0013%\u00111\n\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007C\u0001\"a$\u0001A\u0003&\u0011Q\n\u0005\f\u0003#\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\nC\u0006\u0002$\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0006bCAU\u0001\u0001\u0007\t\u0011)Q\u0005\u0003+C!\"a+\u0001\u0011\u000b\u0007I\u0011BAW\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bD\u0011\"!4\u0001\u0001\u0004%I!a4\t\u0013\u0005M\u0007\u00011A\u0005\n\u0005U\u0007\u0002CAm\u0001\u0001\u0006K!!5\t\u0013\u0005m\u0007\u00011A\u0005\n\u0005=\u0007\"CAo\u0001\u0001\u0007I\u0011BAp\u0011!\t\u0019\u000f\u0001Q!\n\u0005E\u0007\"CAs\u0001\t\u0007I\u0011BAt\u0011!\ty\u000f\u0001Q\u0001\n\u0005%\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqA!\u0006\u0001\t\u0003\u00129\u0002C\u0004\u0003\"\u0001!IAa\t\t\u000f\tM\u0002\u0001\"\u0003\u00036!9!\u0011\t\u0001\u0005B\t\r\u0003b\u0002B5\u0001\u0011\u0005#1\u000e\u0005\b\u0005[\u0002A\u0011\tB8\u0011\u001d\u0011\t\b\u0001C\u0005\u0005gBqA!\u001f\u0001\t\u0003\u0012Yg\u0002\u0005\u0003|aB\t\u0001\u000fB?\r\u001d9\u0004\b#\u00019\u0005\u007fBq!a\n4\t\u0003\u00119\tC\u0004\u0003\nN\"\tAa#\t\u000f\tU5\u0007\"\u0003\u0003\u0018\nY1*\u00194lCN{WO]2f\u0015\tI$(\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\tYD(A\u0002tc2T!!\u0010 \u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\n\u0006\u0001\r[U\u000b\u0018\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000bA\u0001\\1oO*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&F\u0005\u0019y%M[3diB\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\ngR\u0014X-Y7j]\u001eT!\u0001U)\u0002\tI,\u0017\r\u001a\u0006\u0003%j\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005Qk%aG*vaB|'\u000f^:Ue&<w-\u001a:Bm\u0006LG.\u00192mK:{w\u000f\u0005\u0002W56\tqK\u0003\u0002O1*\u0011\u0011LO\u0001\nKb,7-\u001e;j_:L!aW,\u0003\rM{WO]2f!\ti\u0006-D\u0001_\u0015\tyF(\u0001\u0005j]R,'O\\1m\u0013\t\tgLA\u0004M_\u001e<\u0017N\\4\u0002\u0015M\fHnQ8oi\u0016DHo\u0001\u0001\u0011\u0005\u00154W\"\u0001\u001e\n\u0005\u001dT$AC*R\u0019\u000e{g\u000e^3yi\u0006Y1.\u00194lCJ+\u0017\rZ3s!\tQ7.D\u00019\u0013\ta\u0007HA\tLC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJ\f1#\u001a=fGV$xN]&bM.\f\u0007+\u0019:b[N\u0004Ba\u001c:u\u00076\t\u0001O\u0003\u0002r\u000f\u0006!Q\u000f^5m\u0013\t\u0019\bOA\u0002NCB\u0004\"!\u001e@\u000f\u0005Yd\bCA<{\u001b\u0005A(BA=d\u0003\u0019a$o\\8u})\t10A\u0003tG\u0006d\u0017-\u0003\u0002~u\u00061\u0001K]3eK\u001aL1a`A\u0001\u0005\u0019\u0019FO]5oO*\u0011QP_\u0001\u000eg>,(oY3PaRLwN\\:\u0011\u000b\u0005\u001d\u0011q\u0002;\u000e\u0005\u0005%!bA9\u0002\f)\u0019\u0011Q\u0002\u001e\u0002\u0011\r\fG/\u00197zgRLA!!\u0005\u0002\n\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u00031iW\r^1eCR\f\u0007+\u0019;i\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bc\u00016\u0002\u001a%\u0019\u00111\u0004\u001d\u0003+-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,G*[7ji\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\b\u0003BA\u0011\u0003Gi\u0011A_\u0005\u0004\u0003KQ(a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005-\u0012QFA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u0002C\u00016\u0001\u0011\u0015\u0011\u0007\u00021\u0001e\u0011\u0015A\u0007\u00021\u0001j\u0011\u0015i\u0007\u00021\u0001o\u0011\u001d\t\u0019\u0001\u0003a\u0001\u0003\u000bAa!a\u0005\t\u0001\u0004!\bbBA\u000b\u0011\u0001\u0007\u0011q\u0003\u0005\b\u0003;A\u0001\u0019AA\u0010\u0003\t\u00198-\u0006\u0002\u0002@A!\u0011\u0011IA\"\u001b\u0005a\u0014bAA#y\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006\u00191o\u0019\u0011\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t+\t\ti\u0005\u0005\u0003\u0002\"\u0005=\u0013bAA)u\n!Aj\u001c8h\u00039\u0001x\u000e\u001c7US6,w.\u001e;Ng\u0002\nA#\\1y\u001f\u001a47/\u001a;t!\u0016\u0014HK]5hO\u0016\u0014XCAA-!\u0019\t\t#a\u0017\u0002N%\u0019\u0011Q\f>\u0003\r=\u0003H/[8o\u0003Ui\u0017\r_(gMN,Go\u001d)feR\u0013\u0018nZ4fe\u0002\n1#\\5o\u001f\u001a47/\u001a;QKJ$&/[4hKJ\fA#\\5o\u001f\u001a47/\u001a;QKJ$&/[4hKJ\u0004\u0013!E7bqR\u0013\u0018nZ4fe\u0012+G.Y=Ng\u0006\u0011R.\u0019=Ue&<w-\u001a:EK2\f\u00170T:!\u0003\u0015\u0019Gn\\2l+\t\ti\u0007\u0005\u0003\u0002p\u0005MTBAA9\u0015\t\tH(\u0003\u0003\u0002v\u0005E$!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\bj]\u000edW\u000fZ3IK\u0006$WM]:\u0016\u0005\u0005}\u0011aD5oG2,H-\u001a%fC\u0012,'o\u001d\u0011\u0002#1\f7\u000f\u001e+sS\u001e<WM]'jY2L7/A\u000bmCN$HK]5hO\u0016\u0014X*\u001b7mSN|F%Z9\u0015\t\u0005\u0015\u00151\u0012\t\u0005\u0003C\t9)C\u0002\u0002\nj\u0014A!\u00168ji\"I\u0011Q\u0012\r\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0004q\u0012\n\u0014A\u00057bgR$&/[4hKJl\u0015\u000e\u001c7jg\u0002\nQ$\u00197m\t\u0006$\u0018MR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^\u000b\u0003\u0003+\u0003B!a&\u0002\u001e:\u0019!.!'\n\u0007\u0005m\u0005(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0015\u0011\u0015\u0002\u0013!\u0006\u0014H/\u001b;j_:|eMZ:fi6\u000b\u0007OC\u0002\u0002\u001cb\n\u0011%\u00197m\t\u0006$\u0018MR8s)JLwmZ3s\u0003Z\f\u0017\u000e\\1cY\u0016tun^0%KF$B!!\"\u0002(\"I\u0011QR\u000e\u0002\u0002\u0003\u0007\u0011QS\u0001\u001fC2dG)\u0019;b\r>\u0014HK]5hO\u0016\u0014\u0018I^1jY\u0006\u0014G.\u001a(po\u0002\nq#\u001b8ji&\fG\u000eU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0016\u0005\u0005=\u0006cB;\u00022\u0006M\u0016QJ\u0005\u0004g\u0006\u0005\u0001\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005uf(A\u0003lC\u001a\\\u0017-\u0003\u0003\u0002B\u0006]&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0014O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e\u001e\u000b\u0003\u0003\u000f\u00042\u0001TAe\u0013\r\tY-\u0014\u0002\n%\u0016\fG\rT5nSR\fqcY;se\u0016tG\u000fU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0016\u0005\u0005E\u0007CBA\u0011\u00037\ny+A\u000edkJ\u0014XM\u001c;QCJ$\u0018\u000e^5p]>3gm]3ug~#S-\u001d\u000b\u0005\u0003\u000b\u000b9\u000eC\u0005\u0002\u000e\u0002\n\t\u00111\u0001\u0002R\u0006A2-\u001e:sK:$\b+\u0019:uSRLwN\\(gMN,Go\u001d\u0011\u0002-1\fG/Z:u!\u0006\u0014H/\u001b;j_:|eMZ:fiN\f!\u0004\\1uKN$\b+\u0019:uSRLwN\\(gMN,Go]0%KF$B!!\"\u0002b\"I\u0011QR\u0012\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u0018Y\u0006$Xm\u001d;QCJ$\u0018\u000e^5p]>3gm]3ug\u0002\n\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005%\bc\u00016\u0002l&\u0019\u0011Q\u001e\u001d\u00033-\u000bgm[1SK\u000e|'\u000f\u001a+p%><8i\u001c8wKJ$XM]\u0001\u000bG>tg/\u001a:uKJ\u0004\u0013AB:dQ\u0016l\u0017-\u0006\u0002\u0002vB!\u0011q_A\u007f\u001b\t\tIPC\u0002\u0002|j\nQ\u0001^=qKNLA!a@\u0002z\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0013\u001d,Go\u00144gg\u0016$XC\u0001B\u0003!\u0019\t\t#a\u0017\u0003\bA\u0019aK!\u0003\n\u0007\t-qK\u0001\u0004PM\u001a\u001cX\r^\u0001\u0013e\u0016\u0004xN\u001d;MCR,7\u000f^(gMN,G\u000f\u0006\u0002\u0003\u0012A\u0019AJa\u0005\n\u0007\t-Q*\u0001\u0007mCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0003\u0012\te!Q\u0004\u0005\b\u00057Q\u0003\u0019\u0001B\t\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t}!\u00061\u0001\u0002H\u0006)A.[7ji\u0006QA-\u001a7bs\n\u000bGo\u00195\u0015\u0015\u0005}!Q\u0005B\u0015\u0005[\u0011\t\u0004C\u0004\u0003(-\u0002\r!!\u0014\u0002\u00115Lg\u000eT5nSRDqAa\u000b,\u0001\u0004\ty+A\u0007mCR,7\u000f^(gMN,Go\u001d\u0005\b\u0005_Y\u0003\u0019AAX\u00039\u0019WO\u001d:f]R|eMZ:fiNDq!!\u001a,\u0001\u0004\ti%A\u0005sCR,G*[7jiRA\u0011q\u0016B\u001c\u0005s\u0011i\u0004C\u0004\u0003 1\u0002\r!!\u0014\t\u000f\tmB\u00061\u0001\u00020\u0006!aM]8n\u0011\u001d\u0011y\u0004\fa\u0001\u0003_\u000bQ!\u001e8uS2\f\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u0005\u000b\u0012\tG!\u001a\u0011\t\t\u001d#1\f\b\u0005\u0005\u0013\u0012IF\u0004\u0003\u0003L\t]c\u0002\u0002B'\u0005+rAAa\u0014\u0003T9\u0019qO!\u0015\n\u0003\u0005K!a\u0010!\n\u0005ur\u0014BA\u001e=\u0013\r\tYJO\u0005\u0005\u0005;\u0012yFA\u0005ECR\fgI]1nK*\u0019\u00111\u0014\u001e\t\u000f\t\rT\u00061\u0001\u0003\u0006\u0005)1\u000f^1si\"9!qM\u0017A\u0002\t\u001d\u0011aA3oI\u0006!1\u000f^8q)\t\t))\u0001\u0005u_N#(/\u001b8h)\u0005!\u0018A\u0004:fa>\u0014H\u000fR1uC2{7o\u001d\u000b\u0005\u0003\u000b\u0013)\b\u0003\u0004\u0003xA\u0002\r\u0001^\u0001\b[\u0016\u001c8/Y4f\u0003u\u0001(/\u001a9be\u00164uN\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><\u0018aC&bM.\f7k\\;sG\u0016\u0004\"A[\u001a\u0014\u0007M\u0012\t\t\u0005\u0003\u0002\"\t\r\u0015b\u0001BCu\n1\u0011I\\=SK\u001a$\"A! \u0002+\u001d,GoU8si\u0016$W\t_3dkR|'\u000fT5tiR!!Q\u0012BJ!\u0015\t\tCa$u\u0013\r\u0011\tJ\u001f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003w)\u0004\u0019AA \u0003\u001d\u0019w.\u001c9be\u0016$b!a\b\u0003\u001a\n%\u0006b\u0002BNm\u0001\u0007!QT\u0001\u0002CB!!q\u0014BS\u001b\t\u0011\tKC\u0002\u0003$r\n\u0011b]2iK\u0012,H.\u001a:\n\t\t\u001d&\u0011\u0015\u0002\u001a\u000bb,7-\u001e;pe\u000e\u000b7\r[3UCN\\Gj\\2bi&|g\u000eC\u0004\u0003,Z\u0002\rA!(\u0002\u0003\t\u0004")
public class KafkaSource
implements SupportsTriggerAvailableNow,
Source,
Logging {
    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets;
    private final SQLContext sqlContext;
    private final KafkaOffsetReader kafkaReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final SparkContext sc;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final Option<Object> minOffsetPerTrigger;
    private final long maxTriggerDelayMs;
    private final Clock clock;
    private final boolean includeHeaders;
    private long lastTriggerMillis;
    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets;
    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets;
    private final KafkaRecordToRowConverter converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String[] getSortedExecutorList(SparkContext sparkContext) {
        return KafkaSource$.MODULE$.getSortedExecutorList(sparkContext);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        Source.commit$((Source)this, (org.apache.spark.sql.execution.streaming.Offset)end);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    public Option<Object> minOffsetPerTrigger() {
        return this.minOffsetPerTrigger;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public Clock clock() {
        return this.clock;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private long lastTriggerMillis() {
        return this.lastTriggerMillis;
    }

    private void lastTriggerMillis_$eq(long x$1) {
        this.lastTriggerMillis = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> allDataForTriggerAvailableNow() {
        return this.allDataForTriggerAvailableNow;
    }

    private void allDataForTriggerAvailableNow_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.allDataForTriggerAvailableNow = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets$lzycompute() {
        KafkaSource kafkaSource = this;
        synchronized (kafkaSource) {
            if (!this.bitmap$0) {
                KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialPartitionOffsets = ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    void var3_12;
                    KafkaSourceOffset kafkaSourceOffset;
                    KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
                    if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchEarliestOffsets());
                    } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                        kafkaSourceOffset = new KafkaSourceOffset($this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
                    } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                        SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                            this.reportDataLoss(message);
                            return BoxedUnit.UNIT;
                        });
                    } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                        SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                        scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                        Enumeration.Value strategy = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchSpecificTimestampBasedOffsets(p, true, strategy);
                    } else if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
                        GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
                        long ts = globalTimestampRangeLimit.timestamp();
                        Enumeration.Value strategy = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
                        kafkaSourceOffset = $this.kafkaReader.fetchGlobalTimestampBasedOffsets(ts, true, strategy);
                    } else {
                        throw new MatchError((Object)kafkaOffsetRangeLimit);
                    }
                    KafkaSourceOffset offsets = kafkaSourceOffset;
                    metadataLog.add(0L, (Object)offsets);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
                    return var3_12;
                }))).partitionToOffsets();
                this.bitmap$0 = true;
            }
        }
        return this.initialPartitionOffsets;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> initialPartitionOffsets() {
        return !this.bitmap$0 ? this.initialPartitionOffsets$lzycompute() : this.initialPartitionOffsets;
    }

    public ReadLimit getDefaultReadLimit() {
        return this.minOffsetPerTrigger().isDefined() && this.maxOffsetsPerTrigger().isDefined() ? ReadLimit.compositeLimit((ReadLimit[])((ReadLimit[])((Object[])new ReadLimit[]{ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()), ReadLimit.maxRows((long)BoxesRunTime.unboxToLong((Object)this.maxOffsetsPerTrigger().get()))}))) : (this.minOffsetPerTrigger().isDefined() ? ReadLimit.minRows((long)BoxesRunTime.unboxToLong((Object)this.minOffsetPerTrigger().get()), (long)this.maxTriggerDelayMs()) : (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaSource.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReadLimit.allAvailable()));
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> currentPartitionOffsets() {
        return this.currentPartitionOffsets;
    }

    private void currentPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.currentPartitionOffsets = x$1;
    }

    private Option<scala.collection.immutable.Map<TopicPartition, Object>> latestPartitionOffsets() {
        return this.latestPartitionOffsets;
    }

    private void latestPartitionOffsets_$eq(Option<scala.collection.immutable.Map<TopicPartition, Object>> x$1) {
        this.latestPartitionOffsets = x$1;
    }

    private KafkaRecordToRowConverter converter() {
        return this.converter;
    }

    public StructType schema() {
        return KafkaRecordToRowConverter$.MODULE$.kafkaSchema(this.includeHeaders());
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset reportLatestOffset() {
        return (Offset)this.latestPartitionOffsets().map((Function1 & Serializable & scala.Serializable)x$3 -> new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)x$3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
    }

    public Offset latestOffset(Offset startOffset, ReadLimit limit2) {
        scala.collection.immutable.Map map;
        Seq seq;
        this.initialPartitionOffsets();
        Option currentOffsets = this.currentPartitionOffsets().orElse((Function0 & Serializable & scala.Serializable)() -> new Some(this.initialPartitionOffsets()));
        scala.collection.immutable.Map latest = this.allDataForTriggerAvailableNow() != null ? this.allDataForTriggerAvailableNow() : this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)currentOffsets);
        this.latestPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(latest));
        ReadLimit readLimit = limit2;
        if (readLimit instanceof CompositeReadLimit) {
            CompositeReadLimit compositeReadLimit = (CompositeReadLimit)readLimit;
            seq = Predef$.MODULE$.wrapRefArray((Object[])compositeReadLimit.getReadLimits());
        } else {
            seq = (Seq)new .colon.colon((Object)readLimit, (List)Nil$.MODULE$);
        }
        Seq limits = seq;
        if (limits.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$2(x$4)))) {
            map = latest;
        } else {
            Option lowerLimit = limits.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$3(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ReadMinRows)x$6);
            Option upperLimit = limits.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KafkaSource.$anonfun$latestOffset$5(x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> (ReadMaxRows)x$8);
            map = (scala.collection.immutable.Map)lowerLimit.flatMap((Function1 & Serializable & scala.Serializable)limit -> {
                None$ none$;
                boolean skipBatch = this.delayBatch(limit.minRows(), (scala.collection.immutable.Map<TopicPartition, Object>)latest, (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)currentOffsets.get()), limit.maxTriggerDelayMs());
                if (skipBatch) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Delaying batch as number of records available is less than minOffsetsPerTrigger");
                    none$ = new Some(currentOffsets.get());
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> upperLimit.map((Function1 & Serializable & scala.Serializable)limit -> this.rateLimit(limit.maxRows(), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)this.currentPartitionOffsets().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.initialPartitionOffsets())), (scala.collection.immutable.Map<TopicPartition, Object>)latest))).getOrElse((Function0 & Serializable & scala.Serializable)() -> latest);
        }
        scala.collection.immutable.Map offsets = map;
        this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(offsets));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("GetOffset: ").append(((SeqLike)offsets.toSeq().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).toString());
        return new KafkaSourceOffset(offsets);
    }

    private boolean delayBatch(long minLimit, scala.collection.immutable.Map<TopicPartition, Object> latestOffsets, scala.collection.immutable.Map<TopicPartition, Object> currentOffsets, long maxTriggerDelayMs) {
        boolean bl;
        if (this.clock().getTimeMillis() - this.lastTriggerMillis() >= maxTriggerDelayMs) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Maximum wait time is passed, triggering batch");
            this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
            bl = false;
        } else {
            double newRecords = BoxesRunTime.unboxToLong((Object)((MapLike)latestOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topic = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Iterable iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)(offset - BoxesRunTime.unboxToLong((Object)currentOffsets.getOrElse((Object)topic, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))))));
                return iterable;
            }, Map$.MODULE$.canBuildFrom())).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (newRecords < (double)minLimit) {
                bl = true;
            } else {
                this.lastTriggerMillis_$eq(this.clock().getTimeMillis());
                bl = false;
            }
        }
        return bl;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        LazyRef fromNew$lzy = new LazyRef();
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> this.fromNew$1(fromNew$lzy, until, from).get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaSource.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.fromNew$1(fromNew$lzy, until, from).apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("rateLimit ").append(tp).append(" prorated amount is ").append(prorate).toString());
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("rateLimit ").append(tp).append(" new offset is ").append(off).toString());
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        Option<org.apache.spark.sql.execution.streaming.Offset> option;
        this.initialPartitionOffsets();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("GetBatch called with start = ").append(start).append(", end = ").append(end).toString());
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = KafkaSourceOffset$.MODULE$.getPartitionOffsets(end);
        if (this.currentPartitionOffsets().isEmpty()) {
            this.currentPartitionOffsets_$eq((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(untilPartitionOffsets));
        }
        if (start.isDefined()) {
            Object object = start.get();
            org.apache.spark.sql.execution.streaming.Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
            }
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.execution.streaming.Offset prevBatchEndOffset = (org.apache.spark.sql.execution.streaming.Offset)some.value();
            map = KafkaSourceOffset$.MODULE$.getPartitionOffsets(prevBatchEndOffset);
        } else if (None$.MODULE$.equals(option)) {
            map = this.initialPartitionOffsets();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = map;
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaReader.getOffsetRangesFromResolvedOffsets(fromPartitionOffsets, untilPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        RDD rdd = this.includeHeaders() ? new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithHeaders(), ClassTag$.MODULE$.apply(InternalRow.class)) : new KafkaSourceRDD(this.sc(), this.executorKafkaParams, offsetRanges, this.pollTimeoutMs(), this.failOnDataLoss).map(this.converter().toInternalRowWithoutHeaders(), ClassTag$.MODULE$.apply(InternalRow.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(((TraversableOnce)offsetRanges.sortBy((Function1 & Serializable & scala.Serializable)x$10 -> x$10.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        return this.sqlContext.internalCreateDataFrame(rdd.setName("kafka"), this.schema(), true);
    }

    public synchronized void stop() {
        this.kafkaReader.close();
    }

    public String toString() {
        return new StringBuilder(15).append("KafkaSourceV1[").append(this.kafkaReader).append("]").toString();
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    public void prepareForTriggerAvailableNow() {
        this.allDataForTriggerAvailableNow_$eq(this.kafkaReader.fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(this.initialPartitionOffsets())));
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$minOffsetPerTrigger$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$2(ReadLimit x$4) {
        return x$4 instanceof ReadAllAvailable;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$3(ReadLimit x$5) {
        return x$5 instanceof ReadMinRows;
    }

    public static final /* synthetic */ boolean $anonfun$latestOffset$5(ReadLimit x$7) {
        return x$7 instanceof ReadMaxRows;
    }

    private final /* synthetic */ scala.collection.immutable.Map fromNew$lzycompute$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = fromNew$lzy$1;
        synchronized (lazyRef) {
            map = fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : (scala.collection.immutable.Map)fromNew$lzy$1.initialize(this.kafkaReader.fetchEarliestOffsets((Seq<TopicPartition>)until$1.keySet().diff((GenSet)from$1.keySet()).toSeq()));
        }
        return map;
    }

    private final scala.collection.immutable.Map fromNew$1(LazyRef fromNew$lzy$1, scala.collection.immutable.Map until$1, scala.collection.immutable.Map from$1) {
        return fromNew$lzy$1.initialized() ? (scala.collection.immutable.Map)fromNew$lzy$1.value() : this.fromNew$lzycompute$1(fromNew$lzy$1, until$1, from$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaSource $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaSource(SQLContext sqlContext, KafkaOffsetReader kafkaReader, Map<String, Object> executorKafkaParams, CaseInsensitiveMap<String> sourceOptions, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.sqlContext = sqlContext;
        this.kafkaReader = kafkaReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.sc = sqlContext.sparkContext();
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), (Function0 & Serializable & scala.Serializable)() -> Long.toString(BoxesRunTime.unboxToLong((Object)this.sc().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L)))).toLong();
        this.maxOffsetsPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaSource.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.minOffsetPerTrigger = sourceOptions.get(KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)KafkaSource.$anonfun$minOffsetPerTrigger$1(x$2)));
        this.maxTriggerDelayMs = Utils$.MODULE$.timeStringAsMs((String)sourceOptions.get(KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY()).getOrElse((Function0 & Serializable & scala.Serializable)() -> KafkaSourceProvider$.MODULE$.DEFAULT_MAX_TRIGGER_DELAY()));
        this.clock = sourceOptions.contains(KafkaSourceProvider$.MODULE$.MOCK_SYSTEM_TIME()) ? new MockedSystemClock() : new SystemClock();
        this.includeHeaders = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        this.lastTriggerMillis = 0L;
        this.currentPartitionOffsets = None$.MODULE$;
        this.latestPartitionOffsets = None$.MODULE$;
        this.converter = new KafkaRecordToRowConverter();
    }
}

