/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.types.StringType$;

public final class STRING$
extends NativeColumnType<StringType$> {
    public static final STRING$ MODULE$;

    static {
        new STRING$();
    }

    @Override
    public int actualSize(Row row, int ordinal) {
        return row.getString(ordinal).getBytes("utf-8").length + 4;
    }

    @Override
    public void append(String v, ByteBuffer buffer) {
        byte[] stringBytes = v.getBytes("utf-8");
        buffer.putInt(stringBytes.length).put(stringBytes, 0, stringBytes.length);
    }

    @Override
    public String extract(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] stringBytes = new byte[length];
        buffer.get(stringBytes, 0, length);
        return new String(stringBytes, "utf-8");
    }

    @Override
    public void setField(MutableRow row, int ordinal, String value) {
        row.setString(ordinal, value);
    }

    @Override
    public String getField(Row row, int ordinal) {
        return row.getString(ordinal);
    }

    @Override
    public void copyField(Row from, int fromOrdinal, MutableRow to, int toOrdinal) {
        to.setString(toOrdinal, from.getString(fromOrdinal));
    }

    private STRING$() {
        super(StringType$.MODULE$, 7, 8);
        MODULE$ = this;
    }
}

