/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.compression.Encoder$class;
import org.apache.spark.sql.columnar.compression.LongDelta$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NativeType;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005exAB\u0001\u0003\u0011\u00033a\"A\u0005M_:<G)\u001a7uC*\u00111\u0001B\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002\u0006\r\u0005A1m\u001c7v[:\f'O\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u0004\"a\u0004\t\u000e\u0003\t1a!\u0005\u0002\t\u0002\u001a\u0011\"!\u0003'p]\u001e$U\r\u001c;b'\u0015\u00012#\u0007\u000f !\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011qBG\u0005\u00037\t\u0011\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\t!R$\u0003\u0002\u001f+\t9\u0001K]8ek\u000e$\bC\u0001\u000b!\u0013\t\tSC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003$!\u0011\u0005Q%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001\"B\u0014\u0011\t\u0003B\u0013A\u0002;za\u0016LE-F\u0001*!\t!\"&\u0003\u0002,+\t\u0019\u0011J\u001c;\t\u000b5\u0002B\u0011\t\u0018\u0002\u000f\u0011,7m\u001c3feV\u0011q&\u000e\u000b\u0004a\u0005[\u0005cA\b2g%\u0011!G\u0001\u0002\b\t\u0016\u001cw\u000eZ3s!\t!T\u0007\u0004\u0001\u0005\u000bYb#\u0019A\u001c\u0003\u0003Q\u000b\"\u0001O\u001e\u0011\u0005QI\u0014B\u0001\u001e\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0004\u0002\u000bQL\b/Z:\n\u0005\u0001k$A\u0003(bi&4X\rV=qK\")!\t\fa\u0001\u0007\u00061!-\u001e4gKJ\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u00079LwNC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%A\u0003\"zi\u0016\u0014UO\u001a4fe\")A\n\fa\u0001\u001b\u0006Q1m\u001c7v[:$\u0016\u0010]3\u0011\u00079{5'D\u0001\u0005\u0013\t\u0001FA\u0001\tOCRLg/Z\"pYVlg\u000eV=qK\")!\u000b\u0005C!'\u00069QM\\2pI\u0016\u0014XC\u0001+Z)\t)&\fE\u0002\u0010-bK!a\u0016\u0002\u0003\u000f\u0015s7m\u001c3feB\u0011A'\u0017\u0003\u0006mE\u0013\ra\u000e\u0005\u0006\u0019F\u0003\ra\u0017\t\u0004\u001d>C\u0006\"B/\u0011\t\u0003r\u0016\u0001C:vaB|'\u000f^:\u0015\u0005}\u0013\u0007C\u0001\u000ba\u0013\t\tWCA\u0004C_>dW-\u00198\t\u000b1c\u0006\u0019A21\u0007\u0011Dw\u000e\u0005\u0003OK\u001et\u0017B\u00014\u0005\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0003i!$\u0011\"\u001b2\u0002\u0002\u0003\u0005)\u0011\u00016\u0003\t}#\u0013'M\t\u0003q-\u0004\"\u0001\u00067\n\u00055,\"aA!osB\u0011Ag\u001c\u0003\na\n\f\t\u0011!A\u0003\u0002)\u0014Aa\u0018\u00132e\u0019!q\u000b\u0005\u0001s'\r\t8c\u001d\t\u0004\u001fY#hB\u0001\u001fv\u0013\t1X(\u0001\u0005M_:<G+\u001f9f\u0011\u0015\u0019\u0013\u000f\"\u0001y)\u0005I\bC\u0001>r\u001b\u0005\u0001\u0002b\u0002?r\u0001\u0004%\t\u0002K\u0001\u0010?\u000e|W\u000e\u001d:fgN,GmU5{K\"9a0\u001da\u0001\n#y\u0018aE0d_6\u0004(/Z:tK\u0012\u001c\u0016N_3`I\u0015\fH\u0003BA\u0001\u0003\u000f\u00012\u0001FA\u0002\u0013\r\t)!\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0002\nu\f\t\u00111\u0001*\u0003\rAH%\r\u0005\b\u0003\u001b\t\b\u0015)\u0003*\u0003Ay6m\\7qe\u0016\u001c8/\u001a3TSj,\u0007\u0005\u0003\u0005\u0002\u0012E\u0004\r\u0011\"\u0005)\u0003EyVO\\2p[B\u0014Xm]:fINK'0\u001a\u0005\n\u0003+\t\b\u0019!C\t\u0003/\tQcX;oG>l\u0007O]3tg\u0016$7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005e\u0001\"CA\u0005\u0003'\t\t\u00111\u0001*\u0011\u001d\ti\"\u001dQ!\n%\n!cX;oG>l\u0007O]3tg\u0016$7+\u001b>fA!1\u0011\u0011E9\u0005B!\nabY8naJ,7o]3e'&TX\r\u0003\u0004\u0002&E$\t\u0005K\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016D1\"!\u000br\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\u0005I\u0001O]3w-\u0006dW/Z\u000b\u0003\u0003[\u00012\u0001FA\u0018\u0013\r\t\t$\u0006\u0002\u0005\u0019>tw\rC\u0006\u00026E\u0004\r\u00111A\u0005\n\u0005]\u0012!\u00049sKZ4\u0016\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005e\u0002BCA\u0005\u0003g\t\t\u00111\u0001\u0002.!A\u0011QH9!B\u0013\ti#\u0001\u0006qe\u00164h+\u00197vK\u0002Bq!!\u0011r\t\u0003\n\u0019%\u0001\u000ehCRDWM]\"p[B\u0014Xm]:jE&d\u0017\u000e^=Ti\u0006$8\u000f\u0006\u0004\u0002\u0002\u0005\u0015\u0013\u0011\u000b\u0005\t\u0003\u000f\ny\u00041\u0001\u0002J\u0005\u0019!o\\<\u0011\t\u0005-\u0013QJ\u0007\u0002\r%\u0019\u0011q\n\u0004\u0003\u0007I{w\u000fC\u0004\u0002T\u0005}\u0002\u0019A\u0015\u0002\u000f=\u0014H-\u001b8bY\"9\u0011qK9\u0005B\u0005e\u0013\u0001C2p[B\u0014Xm]:\u0015\u000b\r\u000bY&a\u0018\t\u000f\u0005u\u0013Q\u000ba\u0001\u0007\u0006!aM]8n\u0011\u001d\t\t'!\u0016A\u0002\r\u000b!\u0001^8\u0007\u000bI\u0002\u0002!!\u001a\u0014\u000b\u0005\r4#a\u001a\u0011\u0007=\tD\u000fC\u0005C\u0003G\u0012\t\u0011)A\u0005\u0007\"QA*a\u0019\u0003\u0002\u0003\u0006I!!\u001c\u0011\u00079{E\u000fC\u0004$\u0003G\"\t!!\u001d\u0015\r\u0005M\u0014QOA<!\rQ\u00181\r\u0005\u0007\u0005\u0006=\u0004\u0019A\"\t\u000f1\u000by\u00071\u0001\u0002n!a\u00111PA2\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\u0005!\u0001O]3w\u00111\ty(a\u0019A\u0002\u0003\u0007I\u0011BAA\u0003!\u0001(/\u001a<`I\u0015\fH\u0003BA\u0001\u0003\u0007C!\"!\u0003\u0002~\u0005\u0005\t\u0019AA\u0017\u0011%\t9)a\u0019!B\u0013\ti#A\u0003qe\u00164\b\u0005\u0003\u0005\u0002\f\u0006\rD\u0011IAG\u0003\u001dA\u0017m\u001d(fqR,\u0012a\u0018\u0005\t\u0003#\u000b\u0019\u0007\"\u0011\u0002\u0014\u0006!a.\u001a=u)\u0019\t\t!!&\u0002(\"A\u0011qIAH\u0001\u0004\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003C3\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u0015\u00161\u0014\u0002\u000b\u001bV$\u0018M\u00197f%><\bbBA*\u0003\u001f\u0003\r!\u000b\u0005\n\u0003W\u0003\u0012\u0011!C!\u0003[\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[\u000f\u0006!A.\u00198h\u0013\u0011\tI,a-\u0003\rM#(/\u001b8h\u0011!\ti\fEA\u0001\n\u0003A\u0013\u0001\u00049s_\u0012,8\r^!sSRL\b\"CAa!\u0005\u0005I\u0011AAb\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a[Ac\u0011%\tI!a0\u0002\u0002\u0003\u0007\u0011\u0006C\u0005\u0002JB\t\t\u0011\"\u0011\u0002L\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002NB)\u0011qZAkW6\u0011\u0011\u0011\u001b\u0006\u0004\u0003',\u0012AC2pY2,7\r^5p]&!\u0011q[Ai\u0005!IE/\u001a:bi>\u0014\b\"CAn!\u0005\u0005I\u0011AAo\u0003!\u0019\u0017M\\#rk\u0006dGcA0\u0002`\"I\u0011\u0011BAm\u0003\u0003\u0005\ra\u001b\u0005\n\u0003G\u0004\u0012\u0011!C!\u0003K\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002S!I\u0011\u0011\u001e\t\u0002\u0002\u0013\u0005\u00131^\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0016\u0005\n\u0003_\u0004\u0012\u0011!C\u0005\u0003c\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001f\t\u0005\u0003c\u000b)0\u0003\u0003\u0002x\u0006M&AB(cU\u0016\u001cG\u000f")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?, ?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends NativeType> org.apache.spark.sql.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends NativeType> org.apache.spark.sql.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Encoder
    implements org.apache.spark.sql.columnar.compression.Encoder<LongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return Encoder$class.compressionRatio(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(Row row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            Encoder$class.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }

    public static class Decoder
    implements org.apache.spark.sql.columnar.compression.Decoder<LongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(MutableRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : this.buffer.getLong());
            row.setLong(ordinal, this.prev());
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<LongType$> columnType) {
            this.buffer = buffer;
        }
    }
}

