/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.json;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.json.JSONRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001m3Q!\u0001\u0002\u0001\t1\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011Q7o\u001c8\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0003\u0001\u001bMIB\u0004\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0011\tqa]8ve\u000e,7/\u0003\u0002\u0019+\t\u0001\"+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003)iI!aG\u000b\u0003-M\u001b\u0007.Z7b%\u0016d\u0017\r^5p]B\u0013xN^5eKJ\u0004\"\u0001F\u000f\n\u0005y)\"!G\"sK\u0006$\u0018M\u00197f%\u0016d\u0017\r^5p]B\u0013xN^5eKJDQ\u0001\t\u0001\u0005\u0002\t\na\u0001P5oSRt4\u0001\u0001\u000b\u0002GA\u0011A\u0005A\u0007\u0002\u0005!)a\u0005\u0001C\u0005O\u0005I1\r[3dWB\u000bG\u000f\u001b\u000b\u0003Q=\u0002\"!\u000b\u0017\u000f\u00059Q\u0013BA\u0016\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-z\u0001\"\u0002\u0019&\u0001\u0004\t\u0014A\u00039be\u0006lW\r^3sgB!\u0011F\r\u0015)\u0013\t\u0019dFA\u0002NCBDQ!\u000e\u0001\u0005BY\nab\u0019:fCR,'+\u001a7bi&|g\u000eF\u00028u\u0001\u0003\"\u0001\u0006\u001d\n\u0005e*\"\u0001\u0004\"bg\u0016\u0014V\r\\1uS>t\u0007\"B\u001e5\u0001\u0004a\u0014AC:rY\u000e{g\u000e^3yiB\u0011QHP\u0007\u0002\t%\u0011q\b\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\"\u0002\u00195\u0001\u0004\t\u0004\"B\u001b\u0001\t\u0003\u0012E\u0003B\u001cD\t\u0016CQaO!A\u0002qBQ\u0001M!A\u0002EBQAR!A\u0002\u001d\u000baa]2iK6\f\u0007C\u0001%L\u001b\u0005I%B\u0001&\u0005\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0015J\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u000e\u0001\u0005B9#RaN(Q+ZCQaO'A\u0002qBQ!U'A\u0002I\u000bA!\\8eKB\u0011QhU\u0005\u0003)\u0012\u0011\u0001bU1wK6{G-\u001a\u0005\u0006a5\u0003\r!\r\u0005\u0006/6\u0003\r\u0001W\u0001\u0005I\u0006$\u0018\r\u0005\u0002>3&\u0011!\f\u0002\u0002\n\t\u0006$\u0018M\u0012:b[\u0016\u0004")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    private String checkPath(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)"path", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("'path' must be specified for json data.");
            }
        });
    }

    @Override
    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        String path = this.checkPath(parameters);
        double samplingRatio = BoxesRunTime.unboxToDouble((Object)parameters.get((Object)"samplingRatio").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }));
        return new JSONRelation(path, samplingRatio, (Option<StructType>)None$.MODULE$, sqlContext);
    }

    @Override
    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        String path = this.checkPath(parameters);
        double samplingRatio = BoxesRunTime.unboxToDouble((Object)parameters.get((Object)"samplingRatio").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toDouble();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }));
        return new JSONRelation(path, samplingRatio, (Option<StructType>)new Some((Object)schema), sqlContext);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, DataFrame data) {
        boolean bl;
        String path = this.checkPath(parameters);
        Path filesystemPath = new Path(path);
        FileSystem fs = filesystemPath.getFileSystem(sqlContext.sparkContext().hadoopConfiguration());
        if (fs.exists(filesystemPath)) {
            boolean bl2;
            block11: {
                SaveMode saveMode = mode;
                SaveMode saveMode2 = SaveMode.Append;
                SaveMode saveMode3 = saveMode;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Append mode is not supported by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getCanonicalName()})));
                }
                SaveMode saveMode4 = SaveMode.Overwrite;
                SaveMode saveMode5 = saveMode;
                if (!(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null)) {
                    block10: {
                        boolean success = false;
                        try {
                            success = fs.delete(filesystemPath, true);
                            if (!success) break block10;
                            bl2 = true;
                            break block11;
                        }
                        catch (IOException iOException) {
                            void var6_6;
                            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to clear output directory ", " prior"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6.toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to writing to JSON table:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.toString()}))).toString());
                        }
                    }
                    throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to clear output directory ", " prior"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filesystemPath.toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to writing to JSON table."})).s((Seq)Nil$.MODULE$)).toString());
                }
                SaveMode saveMode6 = SaveMode.ErrorIfExists;
                SaveMode saveMode7 = saveMode;
                if (!(saveMode6 != null ? !((Object)((Object)saveMode6)).equals((Object)saveMode7) : saveMode7 != null)) {
                    throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                }
                SaveMode saveMode8 = SaveMode.Ignore;
                SaveMode saveMode9 = saveMode;
                if (saveMode8 == null) {
                    if (saveMode9 != null) {
                        throw new MatchError((Object)saveMode);
                    }
                } else if (!((Object)((Object)saveMode8)).equals((Object)saveMode9)) throw new MatchError((Object)saveMode);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = true;
        }
        boolean doSave = bl;
        if (!doSave) return this.createRelation(sqlContext, parameters, data.schema());
        data.toJSON().saveAsTextFile(path);
        return this.createRelation(sqlContext, parameters, data.schema());
    }
}

