/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrame$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.jdbc.JDBCPartition;
import org.apache.spark.sql.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.jdbc.JDBCRelation;
import org.apache.spark.sql.jdbc.JDBCRelation$;
import org.apache.spark.sql.json.JSONRelation;
import org.apache.spark.sql.json.JsonRDD$;
import org.apache.spark.sql.parquet.ParquetRelation2;
import org.apache.spark.sql.sources.LogicalRelation;
import org.apache.spark.sql.sources.PartitionSpec;
import org.apache.spark.sql.sources.ResolvedDataSource;
import org.apache.spark.sql.sources.ResolvedDataSource$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tQ1+\u0015'D_:$X\r\u001f;\t\re\u0001A\u0011\u0001\u0002\u001b\u0003\u0019a\u0014N\\5u}Q\u00111\u0004\b\t\u0003+\u0001AQa\u0005\rA\u0002QAQA\b\u0001\u0005\u0002}\taAZ8s[\u0006$HCA\u000e!\u0011\u0015\tS\u00041\u0001#\u0003\u0019\u0019x.\u001e:dKB\u00111E\n\b\u0003\u001b\u0011J!!\n\b\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K9AQA\u000b\u0001\u0005\u0002-\naa]2iK6\fGCA\u000e-\u0011\u0015Q\u0013\u00061\u0001.!\tq\u0013'D\u00010\u0015\t\u0001$!A\u0003usB,7/\u0003\u00023_\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bQ\u0002A\u0011A\u001b\u0002\r=\u0004H/[8o)\rYb\u0007\u000f\u0005\u0006oM\u0002\rAI\u0001\u0004W\u0016L\b\"B\u001d4\u0001\u0004\u0011\u0013!\u0002<bYV,\u0007\"B\u001e\u0001\t\u0003a\u0014aB8qi&|gn\u001d\u000b\u00037uBQa\u000f\u001eA\u0002y\u0002Ba\u0010\"#E5\t\u0001I\u0003\u0002B\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\r\u0003%aA'ba\")1\b\u0001C\u0001\u000bR\u00111D\u0012\u0005\u0006w\u0011\u0003\ra\u0012\t\u0005\u00116\u0013#%D\u0001J\u0015\tQ5*\u0001\u0003vi&d'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u0007&CQa\u0014\u0001\u0005\u0002A\u000bA\u0001\\8bIR\u0011\u0011\u000b\u0016\t\u0003+IK!a\u0015\u0002\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B+O\u0001\u0004\u0011\u0013\u0001\u00029bi\"DQa\u0014\u0001\u0005\u0002]#\u0012!\u0015\u0005\u00063\u0002!\tAW\u0001\u0005U\u0012\u00147\r\u0006\u0003R7v{\u0006\"\u0002/Y\u0001\u0004\u0011\u0013aA;sY\")a\f\u0017a\u0001E\u0005)A/\u00192mK\")\u0001\r\u0017a\u0001C\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005!\u0013\u0017BA2J\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u00063\u0002!\t!\u001a\u000b\t#\u001a<\u0007N[8rm\")A\f\u001aa\u0001E!)a\f\u001aa\u0001E!)\u0011\u000e\u001aa\u0001E\u0005Q1m\u001c7v[:t\u0015-\\3\t\u000b-$\u0007\u0019\u00017\u0002\u00151|w/\u001a:C_VtG\r\u0005\u0002\u000e[&\u0011aN\u0004\u0002\u0005\u0019>tw\rC\u0003qI\u0002\u0007A.\u0001\u0006vaB,'OQ8v]\u0012DQA\u001d3A\u0002M\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bCA\u0007u\u0013\t)hBA\u0002J]RDQa\u001e3A\u0002\u0005\fAcY8o]\u0016\u001cG/[8o!J|\u0007/\u001a:uS\u0016\u001c\b\"B-\u0001\t\u0003IHCB){wr\f\u0019\u0001C\u0003]q\u0002\u0007!\u0005C\u0003_q\u0002\u0007!\u0005C\u0003~q\u0002\u0007a0\u0001\u0006qe\u0016$\u0017nY1uKN\u00042!D@#\u0013\r\t\tA\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006ob\u0004\r!\u0019\u0005\u00073\u0002!I!a\u0002\u0015\u0013E\u000bI!a\u0003\u0002\u000e\u0005m\u0001B\u0002/\u0002\u0006\u0001\u0007!\u0005\u0003\u0004_\u0003\u000b\u0001\rA\t\u0005\t\u0003\u001f\t)\u00011\u0001\u0002\u0012\u0005)\u0001/\u0019:ugB!Qb`A\n!\u0011\t)\"a\u0006\u000e\u0003\u0011I1!!\u0007\u0005\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0004x\u0003\u000b\u0001\r!\u0019\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003\u0011Q7o\u001c8\u0015\u0007E\u000b\u0019\u0003\u0003\u0004V\u0003;\u0001\rA\t\u0005\b\u0003?\u0001A\u0011AA\u0014)\r\t\u0016\u0011\u0006\u0005\t\u0003W\t)\u00031\u0001\u0002.\u00059!n]8o%\u0012#\u0005#BA\u0018\u0003o\u0011SBAA\u0019\u0015\ra\u00151\u0007\u0006\u0004\u0003k!\u0011aA1qS&!\u0011\u0011HA\u0019\u0005\u001dQ\u0015M^1S\t\u0012Cq!a\b\u0001\t\u0003\ti\u0004F\u0002R\u0003\u007fA\u0001\"a\u000b\u0002<\u0001\u0007\u0011\u0011\t\t\u0006\u0003\u0007\nIEI\u0007\u0003\u0003\u000bR1!a\u0012\u0005\u0003\r\u0011H\rZ\u0005\u0005\u0003\u0017\n)EA\u0002S\t\u0012Cq!a\u0014\u0001\t\u0003\t\t&A\u0004qCJ\fX/\u001a;\u0015\u0007E\u000b\u0019\u0006\u0003\u0005\u0002V\u00055\u0003\u0019AA,\u0003\u0015\u0001\u0018\r\u001e5t!\u0011i\u0011\u0011\f\u0012\n\u0007\u0005mcB\u0001\u0006=e\u0016\u0004X-\u0019;fIzBC!!\u0014\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f9\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI'a\u0019\u0003\u000fY\f'/\u0019:hg\"1a\f\u0001C\u0001\u0003[\"2!UA8\u0011\u001d\t\t(a\u001bA\u0002\t\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u0011\u0005\u0002\u0001\u0019!C\u0005\u0003k*\u0012A\t\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003w\n!b]8ve\u000e,w\fJ3r)\u0011\ti(a!\u0011\u00075\ty(C\u0002\u0002\u0002:\u0011A!\u00168ji\"I\u0011QQA<\u0003\u0003\u0005\rAI\u0001\u0004q\u0012\n\u0004bBAE\u0001\u0001\u0006KAI\u0001\bg>,(oY3!\u0011%\ti\t\u0001a\u0001\n\u0013\ty)A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0002\u0012B!Q\"a%.\u0013\r\t)J\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005e\u0005\u00011A\u0005\n\u0005m\u0015aF;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fw\fJ3r)\u0011\ti(!(\t\u0015\u0005\u0015\u0015qSA\u0001\u0002\u0004\t\t\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0015BAI\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA!I\u0011Q\u0015\u0001A\u0002\u0013%\u0011qU\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0003S\u0003b!a+\u00022\n\u0012SBAAW\u0015\r\ty\u000bQ\u0001\b[V$\u0018M\u00197f\u0013\u0011\t\u0019,!,\u0003\u000f!\u000b7\u000f['ba\"I\u0011q\u0017\u0001A\u0002\u0013%\u0011\u0011X\u0001\u0011Kb$(/Y(qi&|gn]0%KF$B!! \u0002<\"Q\u0011QQA[\u0003\u0003\u0005\r!!+\t\u0011\u0005}\u0006\u0001)Q\u0005\u0003S\u000bQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0002DB!\u0011QYAe\u001b\t\t9MC\u0002\u0002f\u0011IA!a3\u0002H\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class DataFrameReader {
    private final SQLContext sqlContext;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;

    public DataFrame parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema2));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader options(Map<String, String> options2) {
        this.extraOptions().$plus$plus$eq(options2);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options2) {
        this.options((Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(options2));
        return this;
    }

    public DataFrame load(String path) {
        return this.option("path", path).load();
    }

    public DataFrame load() {
        ResolvedDataSource resolved = ResolvedDataSource$.MODULE$.apply(this.sqlContext, this.userSpecifiedSchema(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), this.source(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()));
        return DataFrame$.MODULE$.apply(this.sqlContext, (LogicalPlan)new LogicalRelation(resolved.relation()));
    }

    public DataFrame jdbc(String url, String table, Properties properties) {
        return this.jdbc(url, table, JDBCRelation$.MODULE$.columnPartition(null), properties);
    }

    public DataFrame jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        JDBCPartitioningInfo partitioning = new JDBCPartitioningInfo(columnName, lowerBound, upperBound, numPartitions);
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(partitioning);
        return this.jdbc(url, table, parts, connectionProperties);
    }

    public DataFrame jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        return this.jdbc(url, table, parts, connectionProperties);
    }

    private DataFrame jdbc(String url, String table, Partition[] parts, Properties connectionProperties) {
        JDBCRelation relation = new JDBCRelation(url, table, parts, connectionProperties, this.sqlContext);
        return this.sqlContext.baseRelationToDataFrame(relation);
    }

    public DataFrame json(String path) {
        return this.format("json").load(path);
    }

    public DataFrame json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public DataFrame json(RDD<String> jsonRDD) {
        DataFrame dataFrame;
        double samplingRatio = new StringOps(Predef$.MODULE$.augmentString((String)this.extraOptions().getOrElse((Object)"samplingRatio", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "1.0";
            }
        }))).toDouble();
        if (this.sqlContext.conf().useJacksonStreamingAPI()) {
            dataFrame = this.sqlContext.baseRelationToDataFrame(new JSONRelation((Function0<RDD<String>>)new Serializable(this, jsonRDD){
                public static final long serialVersionUID = 0L;
                private final RDD jsonRDD$1;

                public final RDD<String> apply() {
                    return this.jsonRDD$1;
                }
                {
                    this.jsonRDD$1 = jsonRDD$1;
                }
            }, (Option<String>)None$.MODULE$, samplingRatio, this.userSpecifiedSchema(), this.sqlContext));
        } else {
            String columnNameOfCorruptJsonRecord = this.sqlContext.conf().columnNameOfCorruptRecord();
            StructType appliedSchema = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, jsonRDD, columnNameOfCorruptJsonRecord){
                public static final long serialVersionUID = 0L;
                private final RDD jsonRDD$1;
                private final String columnNameOfCorruptJsonRecord$1;

                public final StructType apply() {
                    return JsonRDD$.MODULE$.nullTypeToStringType(JsonRDD$.MODULE$.inferSchema((RDD<String>)this.jsonRDD$1, 1.0, this.columnNameOfCorruptJsonRecord$1));
                }
                {
                    this.jsonRDD$1 = jsonRDD$1;
                    this.columnNameOfCorruptJsonRecord$1 = columnNameOfCorruptJsonRecord$1;
                }
            });
            RDD<Row> rowRDD = JsonRDD$.MODULE$.jsonStringToRow(jsonRDD, appliedSchema, columnNameOfCorruptJsonRecord);
            dataFrame = this.sqlContext.createDataFrame(rowRDD, appliedSchema, false);
        }
        return dataFrame;
    }

    public DataFrame parquet(Seq<String> paths) {
        DataFrame dataFrame;
        if (paths.isEmpty()) {
            dataFrame = this.sqlContext.emptyDataFrame();
        } else {
            SparkHadoopUtil sparkHadoopUtil = SparkHadoopUtil$.MODULE$.get();
            Path[] globbedPaths = (Path[])((TraversableOnce)((TraversableLike)paths.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Path apply(String x$1) {
                    return new Path(x$1);
                }
            }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, sparkHadoopUtil){
                public static final long serialVersionUID = 0L;
                private final SparkHadoopUtil eta$0$1$1;

                public final Seq<Path> apply(Path pattern) {
                    return this.eta$0$1$1.globPath(pattern);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Path.class));
            dataFrame = this.sqlContext.baseRelationToDataFrame(new ParquetRelation2((String[])Predef$.MODULE$.refArrayOps((Object[])globbedPaths).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Path x$2) {
                    return x$2.toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), (Option<StructType>)None$.MODULE$, (Option<PartitionSpec>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.sqlContext));
        }
        return dataFrame;
    }

    public DataFrame table(String tableName) {
        return DataFrame$.MODULE$.apply(this.sqlContext, this.sqlContext.catalog().lookupRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})), this.sqlContext.catalog().lookupRelation$default$2()));
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataFrameReader(SQLContext sqlContext) {
        this.sqlContext = sqlContext;
        this.source = sqlContext.conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

