/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.HiveTypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.util.DateUtils$;
import org.apache.spark.sql.json.JsonRDD$;
import org.apache.spark.sql.json.JsonRDD$$anonfun$org$apache$spark$sql$json$JsonRDD$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UTF8String;
import org.apache.spark.sql.types.UTF8String$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.Wrappers;
import scala.collection.convert.Wrappers$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.sys.package$;

public final class JsonRDD$
implements Logging {
    public static final JsonRDD$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JsonRDD$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Row> jsonStringToRow(RDD<String> json2, StructType schema2, String columnNameOfCorruptRecords) {
        return this.parseJson(json2, columnNameOfCorruptRecords).map((Function1)new Serializable(schema2){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Row apply(Map<String, Object> parsed) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$asRow(parsed, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public StructType inferSchema(RDD<String> json2, double samplingRatio, String columnNameOfCorruptRecords) {
        Predef$.MODULE$.require(samplingRatio > 0.0, (Function0)new Serializable(samplingRatio){
            public static final long serialVersionUID = 0L;
            private final double samplingRatio$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.samplingRatio$1)}));
            }
            {
                this.samplingRatio$1 = samplingRatio$1;
            }
        });
        RDD schemaData = samplingRatio > 0.99 ? json2 : json2.sample(false, samplingRatio, 1L);
        Set allKeys = schemaData.isEmpty() ? Predef$.MODULE$.Set().empty() : (Set)this.parseJson((RDD<String>)schemaData, columnNameOfCorruptRecords).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, DataType>> apply(Map<String, Object> m) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(m);
            }
        }, ClassTag$.MODULE$.apply(Set.class)).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, DataType>> apply(Set<Tuple2<String, DataType>> x$1, Set<Tuple2<String, DataType>> x$2) {
                return (Set)x$1.$plus$plus(x$2);
            }
        });
        return this.createSchema((Set<Tuple2<String, DataType>>)allKeys);
    }

    public double inferSchema$default$2() {
        return 1.0;
    }

    private StructType createSchema(Set<Tuple2<String, DataType>> allKeys) {
        scala.collection.immutable.Map resolved = (scala.collection.immutable.Map)allKeys.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, DataType> x0$1) {
                Tuple2<String, DataType> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key;
                    String string = key = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<String>, DataType> apply(Tuple2<String, Set<Tuple2<String, DataType>>> x0$2) {
                Tuple2<String, Set<Tuple2<String, DataType>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Set typeSet = (Set)tuple2._2();
                    Seq fieldName = Predef$.MODULE$.refArrayOps((Object[])key.substring(1, key.length() - 1).split("`.`")).toSeq();
                    DataType dataType = (DataType)((TraversableOnce)typeSet.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(Tuple2<String, DataType> x0$3) {
                            Tuple2<String, DataType> tuple2 = x0$3;
                            if (tuple2 != null) {
                                DataType dataType;
                                DataType dataType2 = dataType = (DataType)tuple2._2();
                                return dataType2;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Set$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(DataType type1, DataType type2) {
                            return JsonRDD$.MODULE$.compatibleType(type1, type2);
                        }
                    });
                    Tuple2 tuple22 = new Tuple2((Object)fieldName, (Object)dataType);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return this.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(resolved.keySet().toSeq(), (Seq)Nil$.MODULE$, resolved);
    }

    public StructType nullTypeToStringType(StructType struct2) {
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])struct2.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField x0$6) {
                StructField structField;
                block2: {
                    DataType dataType;
                    block8: {
                        StringType$ stringType$;
                        boolean nullable;
                        String fieldName;
                        block4: {
                            block7: {
                                block6: {
                                    ArrayType arrayType;
                                    boolean bl;
                                    block5: {
                                        block3: {
                                            structField = x0$6;
                                            if (structField == null) break block2;
                                            fieldName = structField.name();
                                            DataType dataType2 = structField.dataType();
                                            nullable = structField.nullable();
                                            bl = false;
                                            arrayType = null;
                                            dataType = dataType2;
                                            NullType$ nullType$ = NullType$.MODULE$;
                                            DataType dataType3 = dataType;
                                            if (nullType$ != null ? !nullType$.equals(dataType3) : dataType3 != null) break block3;
                                            stringType$ = StringType$.MODULE$;
                                            break block4;
                                        }
                                        if (!(dataType instanceof ArrayType)) break block5;
                                        bl = true;
                                        arrayType = (ArrayType)dataType;
                                        DataType dataType4 = arrayType.elementType();
                                        boolean containsNull = arrayType.containsNull();
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType5 = dataType4;
                                        if (nullType$ != null ? !nullType$.equals(dataType5) : dataType5 != null) break block5;
                                        stringType$ = new ArrayType((DataType)StringType$.MODULE$, containsNull);
                                        break block4;
                                    }
                                    if (!bl) break block6;
                                    DataType struct2 = arrayType.elementType();
                                    boolean containsNull = arrayType.containsNull();
                                    if (!(struct2 instanceof StructType)) break block6;
                                    StructType structType = (StructType)struct2;
                                    stringType$ = new ArrayType((DataType)JsonRDD$.MODULE$.nullTypeToStringType(structType), containsNull);
                                    break block4;
                                }
                                if (!(dataType instanceof StructType)) break block7;
                                StructType structType = (StructType)dataType;
                                stringType$ = JsonRDD$.MODULE$.nullTypeToStringType(structType);
                                break block4;
                            }
                            if (dataType == null) break block8;
                            DataType dataType6 = dataType;
                            stringType$ = dataType6;
                        }
                        StringType$ newType = stringType$;
                        StructField structField2 = new StructField(fieldName, (DataType)newType, nullable, StructField$.MODULE$.apply$default$4());
                        return structField2;
                    }
                    throw new MatchError((Object)dataType);
                }
                throw new MatchError((Object)structField);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(fields);
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        Option option;
        block4: {
            Tuple2 tuple2;
            block10: {
                DataType dataType;
                block3: {
                    StringType$ stringType$;
                    block6: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        block2: {
                                            DataType commonType;
                                            option = (Option)HiveTypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2);
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            dataType = commonType = (DataType)some.x();
                                            break block3;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option2 = option;
                                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                        tuple2 = new Tuple2((Object)t1, (Object)t2);
                                        if (tuple2 == null) break block5;
                                        DataType other = (DataType)tuple2._1();
                                        DataType dataType2 = (DataType)tuple2._2();
                                        if (other == null) break block5;
                                        DataType dataType3 = other;
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType4 = dataType2;
                                        if (nullType$ != null ? !nullType$.equals(dataType4) : dataType4 != null) break block5;
                                        stringType$ = dataType3;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    DataType dataType5 = (DataType)tuple2._1();
                                    DataType other = (DataType)tuple2._2();
                                    NullType$ nullType$ = NullType$.MODULE$;
                                    DataType dataType6 = dataType5;
                                    if ((nullType$ != null ? !nullType$.equals(dataType6) : dataType6 != null) || other == null) break block7;
                                    DataType dataType7 = other;
                                    stringType$ = dataType7;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                DataType dataType8 = (DataType)tuple2._1();
                                DataType dataType9 = (DataType)tuple2._2();
                                if (!(dataType8 instanceof StructType)) break block8;
                                StructType structType = (StructType)dataType8;
                                StructField[] fields1 = structType.fields();
                                if (!(dataType9 instanceof StructType)) break block8;
                                StructType structType2 = (StructType)dataType9;
                                StructField[] fields2 = structType2.fields();
                                scala.collection.immutable.Iterable newFields = (scala.collection.immutable.Iterable)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).groupBy((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(StructField field) {
                                        return field.name();
                                    }
                                }).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final StructField apply(Tuple2<String, StructField[]> x0$7) {
                                        Tuple2<String, StructField[]> tuple2 = x0$7;
                                        if (tuple2 != null) {
                                            String name = (String)tuple2._1();
                                            StructField[] fieldTypes = (StructField[])tuple2._2();
                                            DataType dataType = (DataType)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fieldTypes).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final DataType apply(StructField field) {
                                                    return field.dataType();
                                                }
                                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))).reduce((Function2)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final DataType apply(DataType type1, DataType type2) {
                                                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                                                }
                                            });
                                            StructField structField = new StructField(name, dataType, true, StructField$.MODULE$.apply$default$4());
                                            return structField;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                stringType$ = StructType$.MODULE$.apply((Seq)newFields.toSeq().sortBy((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(StructField x$9) {
                                        return x$9.name();
                                    }
                                }, (Ordering)Ordering.String$.MODULE$));
                                break block6;
                            }
                            if (tuple2 == null) break block9;
                            DataType dataType10 = (DataType)tuple2._1();
                            DataType dataType11 = (DataType)tuple2._2();
                            if (!(dataType10 instanceof ArrayType)) break block9;
                            ArrayType arrayType = (ArrayType)dataType10;
                            DataType elementType1 = arrayType.elementType();
                            boolean containsNull1 = arrayType.containsNull();
                            if (!(dataType11 instanceof ArrayType)) break block9;
                            ArrayType arrayType2 = (ArrayType)dataType11;
                            DataType elementType2 = arrayType2.elementType();
                            boolean containsNull2 = arrayType2.containsNull();
                            stringType$ = new ArrayType(this.compatibleType(elementType1, elementType2), containsNull1 || containsNull2);
                            break block6;
                        }
                        if (tuple2 == null) break block10;
                        stringType$ = StringType$.MODULE$;
                    }
                    dataType = stringType$;
                }
                return dataType;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)option);
    }

    public PartialFunction<Object, DataType> org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue() {
        Serializable useLongType = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof Integer ? LongType$.MODULE$ : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Integer;
                return bl;
            }
        };
        return useLongType.orElse(ScalaReflection$.MODULE$.typeOfObject()).orElse((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = A1 instanceof BigInteger ? DecimalType$.MODULE$.Unlimited() : (A1 instanceof BigDecimal ? DecimalType$.MODULE$.Unlimited() : StringType$.MODULE$);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof BigInteger ? true : (object instanceof BigDecimal ? true : true);
                return bl;
            }
        });
    }

    public ArrayType org$apache$spark$sql$json$JsonRDD$$typeOfArray(Seq<Object> l) {
        ArrayType arrayType;
        Seq elements = (Seq)l.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Object v) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(v));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (elements.isEmpty()) {
            arrayType = new ArrayType((DataType)NullType$.MODULE$, true);
        } else {
            DataType elementType = (DataType)((TraversableOnce)elements.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(Object e) {
                    StructType structType;
                    Object object = e;
                    if (object instanceof Map) {
                        structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
                    } else if (object instanceof Seq) {
                        Seq seq = (Seq)object;
                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                    } else {
                        structType = (DataType)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue().apply(object);
                    }
                    return structType;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType apply(DataType type1, DataType type2) {
                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                }
            });
            arrayType = new ArrayType(elementType, true);
        }
        return arrayType;
    }

    public Set<Tuple2<String, DataType>> org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(Map<String, Object> m) {
        Set keyValuePairs = ((TraversableOnce)m.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$8) {
                Tuple2<String, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toSet();
        return (Set)keyValuePairs.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, DataType>> apply(Tuple2<String, Object> x0$9) {
                Tuple2<String, Object> tuple2;
                block6: {
                    List list;
                    block3: {
                        block5: {
                            block4: {
                                block2: {
                                    tuple2 = x0$9;
                                    if (tuple2 == null) break block2;
                                    String key = (String)tuple2._1();
                                    Object struct2 = tuple2._2();
                                    if (key == null) break block2;
                                    String string = key;
                                    if (!(struct2 instanceof Map)) break block2;
                                    Map map = (Map)struct2;
                                    list = ((SetLike)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes((Map<String, Object>)map).map((Function1)new Serializable(this, string){
                                        public static final long serialVersionUID = 0L;
                                        private final String x2$1;

                                        public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$10) {
                                            Tuple2<String, DataType> tuple2 = x0$10;
                                            if (tuple2 != null) {
                                                String k = (String)tuple2._1();
                                                DataType dataType = (DataType)tuple2._2();
                                                Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1, k})), (Object)dataType);
                                                return tuple22;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.x2$1 = x2$1;
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)string, (Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$))})));
                                    break block3;
                                }
                                if (tuple2 == null) break block4;
                                String key = (String)tuple2._1();
                                Object array2 = tuple2._2();
                                if (key == null) break block4;
                                String string = key;
                                if (!(array2 instanceof Seq)) break block4;
                                Seq seq = (Seq)array2;
                                ArrayType elementType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                                list = (Iterable)this.org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(seq, (DataType)elementType, string).$colon$plus((Object)new Tuple2((Object)string, (Object)elementType), Seq$.MODULE$.canBuildFrom());
                                break block3;
                            }
                            if (tuple2 == null) break block5;
                            String key = (String)tuple2._1();
                            Object value = tuple2._2();
                            if (key == null) break block5;
                            String string = key;
                            Object object = value;
                            String string2 = "";
                            if ((object == null ? string2 != null : !object.equals(string2)) && value != null) break block5;
                            Tuple2 tuple22 = new Tuple2((Object)string, (Object)NullType$.MODULE$);
                            list = Nil$.MODULE$.$colon$colon((Object)tuple22);
                            break block3;
                        }
                        if (tuple2 == null) break block6;
                        String key = (String)tuple2._1();
                        Object value = tuple2._2();
                        if (key == null) break block6;
                        String string = key;
                        Tuple2 tuple23 = new Tuple2((Object)string, JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue().apply(value));
                        list = Nil$.MODULE$.$colon$colon((Object)tuple23);
                    }
                    return list;
                }
                throw new MatchError(tuple2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Seq org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(Object v, DataType t, String x4$1) {
                boolean bl = false;
                ArrayType arrayType = null;
                DataType dataType = t;
                if (dataType instanceof ArrayType) {
                    bl = true;
                    arrayType = (ArrayType)dataType;
                    DataType e = arrayType.elementType();
                    if (e instanceof StructType) {
                        return (Seq)((TraversableLike)((TraversableLike)((Seq)v).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<Map<String, Object>> apply(Map<String, Object> x$10) {
                                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$10));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<Tuple2<String, DataType>> apply(Map<String, Object> element) {
                                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(element);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, x4$1){
                            public static final long serialVersionUID = 0L;
                            private final String x4$1;

                            public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$11) {
                                Tuple2<String, DataType> tuple2 = x0$11;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    DataType t = (DataType)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x4$1, k})), (Object)t);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }
                if (!bl) return Nil$.MODULE$;
                DataType t1 = arrayType.elementType();
                return (Seq)((TraversableLike)((Seq)v).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Object> apply(Object x$11) {
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$11));
                    }
                }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, t1, x4$1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes$1 $outer;
                    private final DataType t1$1;
                    private final String x4$1;

                    public final Seq<Tuple2<String, DataType>> apply(Object element) {
                        return this.$outer.org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(element, this.t1$1, this.x4$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.t1$1 = t1$1;
                        this.x4$1 = x4$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public Object org$apache$spark$sql$json$JsonRDD$$scalafy(Object obj) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object2;
            object = new Wrappers.JMapWrapper((Wrappers)Wrappers$.MODULE$, map).mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x) {
                    return (Tuple2)Predef$.MODULE$.identity(x);
                }
            }, Map$.MODULE$.canBuildFrom());
        } else if (object2 instanceof java.util.List) {
            java.util.List list = (java.util.List)object2;
            object = new Wrappers.JListWrapper((Wrappers)Wrappers$.MODULE$, list).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }, Buffer$.MODULE$.canBuildFrom());
        } else {
            object = object2;
        }
        return object;
    }

    private RDD<Map<String, Object>> parseJson(RDD<String> json2, String columnNameOfCorruptRecords) {
        return json2.mapPartitions((Function1)new Serializable(columnNameOfCorruptRecords){
            public static final long serialVersionUID = 0L;
            public final String columnNameOfCorruptRecords$1;

            public final Iterator<Map<String, Object>> apply(Iterator<String> iter) {
                ObjectMapper mapper = new ObjectMapper();
                return iter.flatMap((Function1)new Serializable(this, mapper){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseJson.1 $outer;
                    private final ObjectMapper mapper$1;

                    public final GenTraversableOnce<Map<String, Object>> apply(String record) {
                        Seq seq;
                        try {
                            Seq parsed;
                            Seq seq2;
                            Object object = this.mapper$1.readValue(record, Object.class);
                            if (object instanceof java.util.Map) {
                                java.util.Map map = (java.util.Map)object;
                                Map map2 = (Map)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(map);
                                seq2 = Nil$.MODULE$.$colon$colon((Object)map2);
                            } else if (object instanceof java.util.List) {
                                java.util.List list = (java.util.List)object;
                                seq2 = (Seq)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(list);
                            } else {
                                throw package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse record ", ". Please make sure that each line of the file "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record}))).append((Object)"(or each string in the RDD) is a valid JSON object or an array of JSON objects.").toString());
                            }
                            seq = parsed = seq2;
                        }
                        catch (JsonProcessingException jsonProcessingException) {
                            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.columnNameOfCorruptRecords$1), (Object)UTF8String$.MODULE$.apply(record))}));
                            seq = Nil$.MODULE$.$colon$colon((Object)map);
                        }
                        return seq;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mapper$1 = mapper$1;
                    }
                });
            }
            {
                this.columnNameOfCorruptRecords$1 = columnNameOfCorruptRecords$1;
            }
        }, json2.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Map.class));
    }

    private long toLong(Object value) {
        Object object;
        block4: {
            long l;
            block3: {
                block2: {
                    object = value;
                    if (!(object instanceof Integer)) break block2;
                    Integer n = (Integer)object;
                    l = BoxesRunTime.unboxToInt((Object)n);
                    break block3;
                }
                if (!(object instanceof Long)) break block4;
                Long l2 = (Long)object;
                l = BoxesRunTime.unboxToLong((Object)l2);
            }
            return l;
        }
        throw new MatchError(object);
    }

    private double toDouble(Object value) {
        Object object;
        block5: {
            double d;
            block3: {
                block4: {
                    block2: {
                        object = value;
                        if (!(object instanceof Integer)) break block2;
                        Integer n = (Integer)object;
                        d = BoxesRunTime.unboxToInt((Object)n);
                        break block3;
                    }
                    if (!(object instanceof Long)) break block4;
                    Long l = (Long)object;
                    d = BoxesRunTime.unboxToLong((Object)l);
                    break block3;
                }
                if (!(object instanceof Double)) break block5;
                Double d2 = (Double)object;
                d = BoxesRunTime.unboxToDouble((Object)d2);
            }
            return d;
        }
        throw new MatchError(object);
    }

    private Decimal toDecimal(Object value) {
        Object object;
        block7: {
            Decimal decimal;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = value;
                                if (!(object instanceof Integer)) break block2;
                                Integer n = (Integer)object;
                                decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Integer2int(n));
                                break block3;
                            }
                            if (!(object instanceof Long)) break block4;
                            Long l = (Long)object;
                            decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Long2long(l));
                            break block3;
                        }
                        if (!(object instanceof BigInteger)) break block5;
                        BigInteger bigInteger = (BigInteger)object;
                        decimal = Decimal$.MODULE$.apply(new BigDecimal(bigInteger));
                        break block3;
                    }
                    if (!(object instanceof Double)) break block6;
                    Double d = (Double)object;
                    decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Double2double(d));
                    break block3;
                }
                if (!(object instanceof BigDecimal)) break block7;
                BigDecimal bigDecimal = (BigDecimal)object;
                decimal = Decimal$.MODULE$.apply(bigDecimal);
            }
            return decimal;
        }
        throw new MatchError(object);
    }

    private String toJsonArrayString(Seq<Object> seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        IntRef count = new IntRef(0);
        seq.foreach((Function1)new Serializable(builder, count){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;
            private final IntRef count$1;

            public final StringBuilder apply(Object element) {
                Object object = this.count$1.elem > 0 ? this.builder$1.append(",") : BoxedUnit.UNIT;
                ++this.count$1.elem;
                return this.builder$1.append(JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(element));
            }
            {
                this.builder$1 = builder$1;
                this.count$1 = count$1;
            }
        });
        builder.append("]");
        return builder.toString();
    }

    private String toJsonObjectString(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        IntRef count = new IntRef(0);
        map.foreach((Function1)new Serializable(builder, count){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$2;
            private final IntRef count$2;

            public final StringBuilder apply(Tuple2<String, Object> x0$12) {
                Tuple2<String, Object> tuple2 = x0$12;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.count$2.elem > 0 ? this.builder$2.append(",") : BoxedUnit.UNIT;
                    ++this.count$2.elem;
                    String stringValue = value instanceof String ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})) : JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(value);
                    StringBuilder stringBuilder = this.builder$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, stringValue})));
                    return stringBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
                this.count$2 = count$2;
            }
        });
        builder.append("}");
        return builder.toString();
    }

    public String org$apache$spark$sql$json$JsonRDD$$toString(Object value) {
        String string;
        Object object = value;
        if (object instanceof Map) {
            Map map = (Map)object;
            string = this.toJsonObjectString((Map<String, Object>)map);
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            string = this.toJsonArrayString((Seq<Object>)seq);
        } else {
            string = (String)Option$.MODULE$.apply(object).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Object x$16) {
                    return x$16.toString();
                }
            }).orNull(Predef$.MODULE$.conforms());
        }
        return string;
    }

    private int toDate(Object value) {
        Object object;
        block4: {
            int n;
            block3: {
                block2: {
                    object = value;
                    if (!(object instanceof String)) break block2;
                    String string = (String)object;
                    n = DateUtils$.MODULE$.millisToDays(DateUtils$.MODULE$.stringToTime(string).getTime());
                    break block3;
                }
                if (!(object instanceof Date)) break block4;
                Date date = (Date)object;
                n = DateUtils$.MODULE$.fromJavaDate(date);
            }
            return n;
        }
        throw new MatchError(object);
    }

    private Timestamp toTimestamp(Object value) {
        Object object;
        while (true) {
            block5: {
                Timestamp timestamp;
                block4: {
                    block3: {
                        if (!((object = value) instanceof Integer)) break block3;
                        Integer n = (Integer)object;
                        timestamp = new Timestamp(BoxesRunTime.unboxToInt((Object)n));
                        break block4;
                    }
                    if (!(object instanceof Long)) break block5;
                    Long l = (Long)object;
                    timestamp = new Timestamp(Predef$.MODULE$.Long2long(l));
                }
                return timestamp;
            }
            if (!(object instanceof String)) break;
            String string = (String)object;
            value = BoxesRunTime.boxToLong((long)DateUtils$.MODULE$.stringToTime(string).getTime());
        }
        throw new MatchError(object);
    }

    public Object enforceCorrectType(Object value, DataType desiredType) {
        DataType dataType;
        block18: {
            UTF8String uTF8String;
            block3: {
                Object object;
                block5: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block9: {
                                                        block8: {
                                                            block7: {
                                                                block6: {
                                                                    block4: {
                                                                        block2: {
                                                                            if (value != null) break block2;
                                                                            uTF8String = null;
                                                                            break block3;
                                                                        }
                                                                        dataType = desiredType;
                                                                        StringType$ stringType$ = StringType$.MODULE$;
                                                                        DataType dataType2 = dataType;
                                                                        if (stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null) break block4;
                                                                        object = UTF8String$.MODULE$.apply(this.org$apache$spark$sql$json$JsonRDD$$toString(value));
                                                                        break block5;
                                                                    }
                                                                    if (value == null) break block6;
                                                                    Object object2 = value;
                                                                    String string = "";
                                                                    if (object2 != null ? !object2.equals(string) : string != null) break block7;
                                                                }
                                                                object = null;
                                                                break block5;
                                                            }
                                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                            DataType dataType3 = dataType;
                                                            if (integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null) break block8;
                                                            object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value));
                                                            break block5;
                                                        }
                                                        LongType$ longType$ = LongType$.MODULE$;
                                                        DataType dataType4 = dataType;
                                                        if (longType$ != null ? !longType$.equals(dataType4) : dataType4 != null) break block9;
                                                        object = BoxesRunTime.boxToLong((long)this.toLong(value));
                                                        break block5;
                                                    }
                                                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                    DataType dataType5 = dataType;
                                                    if (doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null) break block10;
                                                    object = BoxesRunTime.boxToDouble((double)this.toDouble(value));
                                                    break block5;
                                                }
                                                if (!DecimalType$.MODULE$.unapply(dataType)) break block11;
                                                object = this.toDecimal(value);
                                                break block5;
                                            }
                                            BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                            DataType dataType6 = dataType;
                                            if (booleanType$ != null ? !booleanType$.equals(dataType6) : dataType6 != null) break block12;
                                            object = BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value));
                                            break block5;
                                        }
                                        NullType$ nullType$ = NullType$.MODULE$;
                                        DataType dataType7 = dataType;
                                        if (nullType$ != null ? !nullType$.equals(dataType7) : dataType7 != null) break block13;
                                        object = null;
                                        break block5;
                                    }
                                    if (!(dataType instanceof ArrayType)) break block14;
                                    ArrayType arrayType = (ArrayType)dataType;
                                    DataType elementType = arrayType.elementType();
                                    object = ((Seq)value).map((Function1)new Serializable(elementType){
                                        public static final long serialVersionUID = 0L;
                                        private final DataType elementType$1;

                                        public final Object apply(Object x$17) {
                                            return JsonRDD$.MODULE$.enforceCorrectType(x$17, this.elementType$1);
                                        }
                                        {
                                            this.elementType$1 = elementType$1;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block5;
                                }
                                if (!(dataType instanceof MapType)) break block15;
                                MapType mapType = (MapType)dataType;
                                DataType dataType8 = mapType.keyType();
                                DataType valueType = mapType.valueType();
                                StringType$ stringType$ = StringType$.MODULE$;
                                DataType dataType9 = dataType8;
                                if (stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null) break block15;
                                Map map = (Map)value;
                                object = ((TraversableLike)map.map((Function1)new Serializable(valueType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType valueType$1;

                                    public final Tuple2<UTF8String, Object> apply(Tuple2<String, Object> x0$13) {
                                        Tuple2<String, Object> tuple2 = x0$13;
                                        if (tuple2 != null) {
                                            String k = (String)tuple2._1();
                                            Object v = tuple2._2();
                                            Tuple2 tuple22 = new Tuple2((Object)UTF8String$.MODULE$.apply(k), JsonRDD$.MODULE$.enforceCorrectType(v, this.valueType$1));
                                            return tuple22;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        this.valueType$1 = valueType$1;
                                    }
                                }, Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<UTF8String, Object> apply(Tuple2<UTF8String, Object> x) {
                                        return (Tuple2)Predef$.MODULE$.identity(x);
                                    }
                                }, Map$.MODULE$.canBuildFrom());
                                break block5;
                            }
                            if (!(dataType instanceof StructType)) break block16;
                            StructType structType = (StructType)dataType;
                            object = this.org$apache$spark$sql$json$JsonRDD$$asRow((Map<String, Object>)((Map)value), structType);
                            break block5;
                        }
                        DateType$ dateType$ = DateType$.MODULE$;
                        DataType dataType10 = dataType;
                        if (dateType$ != null ? !dateType$.equals(dataType10) : dataType10 != null) break block17;
                        object = BoxesRunTime.boxToInteger((int)this.toDate(value));
                        break block5;
                    }
                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                    DataType dataType11 = dataType;
                    if (timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null) break block18;
                    object = this.toTimestamp(value);
                }
                uTF8String = object;
            }
            return uTF8String;
        }
        throw new MatchError((Object)dataType);
    }

    /*
     * WARNING - void declaration
     */
    public Row org$apache$spark$sql$json$JsonRDD$$asRow(Map<String, Object> json2, StructType schema2) {
        void var3_3;
        GenericMutableRow row = new GenericMutableRow(schema2.fields().length);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(json2, row){
            public static final long serialVersionUID = 0L;
            private final Map json$1;
            private final GenericMutableRow row$1;

            public final void apply(Tuple2<StructField, Object> x0$14) {
                Tuple2<StructField, Object> tuple2 = x0$14;
                if (tuple2 != null) {
                    StructField structField = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (structField != null) {
                        String name = structField.name();
                        DataType dataType = structField.dataType();
                        this.row$1.update(i, this.json$1.get((Object)name).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<Object> apply(Object v) {
                                return Option$.MODULE$.apply(v);
                            }
                        }).map((Function1)new Serializable(this, dataType){
                            public static final long serialVersionUID = 0L;
                            private final DataType dataType$1;

                            public final Object apply(Object x$18) {
                                return JsonRDD$.MODULE$.enforceCorrectType(x$18, this.dataType$1);
                            }
                            {
                                this.dataType$1 = dataType$1;
                            }
                        }).orNull(Predef$.MODULE$.conforms()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.json$1 = json$1;
                this.row$1 = row$1;
            }
        });
        return var3_3;
    }

    public final StructType org$apache$spark$sql$json$JsonRDD$$makeStruct$1(Seq values, Seq prefix, scala.collection.immutable.Map resolved$1) {
        Tuple2 tuple2 = values.partition((Function1)new anonfun.8());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq topLevel = (Seq)tuple2._1();
            Seq structLike = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topLevel, (Object)structLike);
            Seq topLevel2 = (Seq)tuple23._1();
            Seq structLike2 = (Seq)tuple23._2();
            Seq topLevelFields = (Seq)((TraversableLike)topLevel2.filter((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final boolean apply(Seq<String> name) {
                    ArrayType arrayType;
                    DataType elementType;
                    DataType dataType = (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(name, Seq$.MODULE$.canBuildFrom())).get();
                    boolean bl = dataType instanceof ArrayType ? !this.hasInnerStruct$1(elementType = (arrayType = (ArrayType)dataType).elementType()) : !(dataType instanceof StructType);
                    return bl;
                }

                private final boolean hasInnerStruct$1(DataType t) {
                    boolean bl;
                    block2: {
                        while (true) {
                            DataType t1;
                            DataType dataType;
                            if ((dataType = t) instanceof StructType) {
                                bl = true;
                                break block2;
                            }
                            if (!(dataType instanceof ArrayType)) break;
                            ArrayType arrayType = (ArrayType)dataType;
                            t = t1 = arrayType.elementType();
                        }
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final StructField apply(Seq<String> a) {
                    return new StructField((String)a.head(), (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(a, Seq$.MODULE$.canBuildFrom())).get(), true, StructField$.MODULE$.apply$default$4());
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq topLevelFieldNameSet = (Seq)topLevelFields.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$5) {
                    return x$5.name();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq structFields = ((TraversableOnce)((TraversableLike)((TraversableLike)structLike2.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Seq<String> x$6) {
                    return (String)x$6.apply(0);
                }
            }).filter((Function1)new Serializable(topLevelFieldNameSet){
                public static final long serialVersionUID = 0L;
                private final Seq topLevelFieldNameSet$1;

                public final boolean apply(Tuple2<String, Seq<Seq<String>>> x0$4) {
                    Tuple2<String, Seq<Seq<String>>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        boolean bl = !this.topLevelFieldNameSet$1.contains((Object)name);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topLevelFieldNameSet$1 = topLevelFieldNameSet$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final Option<StructField> apply(Tuple2<String, Seq<Seq<String>>> x0$5) {
                    Tuple2<String, Seq<Seq<String>>> tuple2;
                    block2: {
                        DataType dataType;
                        block6: {
                            None$ none$;
                            block4: {
                                block5: {
                                    StructType structType;
                                    String name;
                                    block3: {
                                        tuple2 = x0$5;
                                        if (tuple2 == null) break block2;
                                        name = (String)tuple2._1();
                                        Seq fields = (Seq)tuple2._2();
                                        Seq nestedFields = (Seq)fields.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Seq<String> apply(Seq<String> x$7) {
                                                return (Seq)x$7.tail();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(nestedFields, (Seq)this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()), this.resolved$1);
                                        DataType dataType2 = (DataType)this.resolved$1.get(this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).get();
                                        dataType = dataType2;
                                        if (!(dataType instanceof ArrayType)) break block3;
                                        ArrayType arrayType = (ArrayType)dataType;
                                        none$ = new Some((Object)new StructField(name, (DataType)this.getActualArrayType$1(structType, arrayType), true, StructField$.MODULE$.apply$default$4()));
                                        break block4;
                                    }
                                    if (!(dataType instanceof StructType)) break block5;
                                    none$ = new Some((Object)new StructField(name, (DataType)structType, true, StructField$.MODULE$.apply$default$4()));
                                    break block4;
                                }
                                StringType$ stringType$ = StringType$.MODULE$;
                                DataType dataType3 = dataType;
                                if (stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null) break block6;
                                none$ = None$.MODULE$;
                            }
                            None$ none$2 = none$;
                            return none$2;
                        }
                        throw new MatchError((Object)dataType);
                    }
                    throw new MatchError(tuple2);
                }

                private final ArrayType getActualArrayType$1(StructType innerStruct, ArrayType currentArray) {
                    ArrayType arrayType;
                    block4: {
                        ArrayType arrayType2;
                        block3: {
                            block2: {
                                arrayType = currentArray;
                                if (arrayType == null) break block2;
                                DataType s = arrayType.elementType();
                                boolean containsNull = arrayType.containsNull();
                                if (!(s instanceof StructType)) break block2;
                                arrayType2 = new ArrayType((DataType)innerStruct, containsNull);
                                break block3;
                            }
                            if (arrayType == null) break block4;
                            DataType a = arrayType.elementType();
                            boolean containsNull = arrayType.containsNull();
                            if (!(a instanceof ArrayType)) break block4;
                            ArrayType arrayType3 = (ArrayType)a;
                            arrayType2 = new ArrayType((DataType)this.getActualArrayType$1(innerStruct, arrayType3), containsNull);
                        }
                        return arrayType2;
                    }
                    throw new MatchError((Object)arrayType);
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<StructField> apply(Option<StructField> field) {
                    return Option$.MODULE$.option2Iterable(field);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            return StructType$.MODULE$.apply((Seq)((SeqLike)topLevelFields.$plus$plus((GenTraversableOnce)structFields, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$8) {
                    return x$8.name();
                }
            }, (Ordering)Ordering.String$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    private JsonRDD$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

