/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import jodd.datetime.JDateTime;
import org.apache.spark.sql.parquet.timestamp.NanoTime;
import org.apache.spark.sql.parquet.timestamp.NanoTime$;
import parquet.io.api.Binary;

public final class CatalystTimestampConverter$ {
    public static final CatalystTimestampConverter$ MODULE$;
    private final ThreadLocal<Calendar> parquetTsCalendar;
    private final long NANOS_PER_SECOND;
    private final long SECONDS_PER_MINUTE;
    private final long MINUTES_PER_HOUR;
    private final long NANOS_PER_MILLI;

    static {
        new CatalystTimestampConverter$();
    }

    public ThreadLocal<Calendar> parquetTsCalendar() {
        return this.parquetTsCalendar;
    }

    public Calendar getCalendar() {
        if (this.parquetTsCalendar().get() == null) {
            this.parquetTsCalendar().set(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        }
        return this.parquetTsCalendar().get();
    }

    public long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public long SECONDS_PER_MINUTE() {
        return this.SECONDS_PER_MINUTE;
    }

    public long MINUTES_PER_HOUR() {
        return this.MINUTES_PER_HOUR;
    }

    public long NANOS_PER_MILLI() {
        return this.NANOS_PER_MILLI;
    }

    public Timestamp convertToTimestamp(Binary value) {
        NanoTime nt = NanoTime$.MODULE$.fromBinary(value);
        long timeOfDayNanos = nt.getTimeOfDayNanos();
        int julianDay = nt.getJulianDay();
        JDateTime jDateTime = new JDateTime((double)julianDay);
        Calendar calendar = this.getCalendar();
        calendar.set(1, jDateTime.getYear());
        calendar.set(2, jDateTime.getMonth() - 1);
        calendar.set(5, jDateTime.getDay());
        long remainder = timeOfDayNanos;
        calendar.set(11, (int)(remainder / (this.NANOS_PER_SECOND() * this.SECONDS_PER_MINUTE() * this.MINUTES_PER_HOUR())));
        calendar.set(12, (int)((remainder %= this.NANOS_PER_SECOND() * this.SECONDS_PER_MINUTE() * this.MINUTES_PER_HOUR()) / (this.NANOS_PER_SECOND() * this.SECONDS_PER_MINUTE())));
        calendar.set(13, (int)((remainder %= this.NANOS_PER_SECOND() * this.SECONDS_PER_MINUTE()) / this.NANOS_PER_SECOND()));
        long nanos = remainder % this.NANOS_PER_SECOND();
        Timestamp ts = new Timestamp(calendar.getTimeInMillis());
        ts.setNanos((int)nanos);
        return ts;
    }

    public Binary convertFromTimestamp(Timestamp ts) {
        Calendar calendar = this.getCalendar();
        calendar.setTime(ts);
        JDateTime jDateTime = new JDateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        int julianDay = jDateTime.getJulianDayNumber();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int nanos = ts.getNanos();
        long nanosOfDay = (long)nanos + (long)second * this.NANOS_PER_SECOND() + (long)minute * this.NANOS_PER_SECOND() * this.SECONDS_PER_MINUTE() + (long)hour * this.NANOS_PER_SECOND() * this.SECONDS_PER_MINUTE() * this.MINUTES_PER_HOUR();
        return NanoTime$.MODULE$.apply(julianDay, nanosOfDay).toBinary();
    }

    private CatalystTimestampConverter$() {
        MODULE$ = this;
        this.parquetTsCalendar = new ThreadLocal();
        this.NANOS_PER_SECOND = 1000000000L;
        this.SECONDS_PER_MINUTE = 60L;
        this.MINUTES_PER_HOUR = 60L;
        this.NANOS_PER_MILLI = 1000000L;
    }
}

