/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.parquet.ParquetFilters$;
import org.apache.spark.sql.parquet.ParquetRelation2$;
import org.apache.spark.sql.parquet.ParquetRelation2$$anonfun$readSchema$1$$anonfun$21$;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.parquet.RowWriteSupport$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.metadata.FileMetaData;
import parquet.schema.MessageType;
import parquet.schema.Type;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ParquetRelation2$
implements Logging {
    public static final ParquetRelation2$ MODULE$;
    private final String MERGE_SCHEMA;
    private final String METASTORE_SCHEMA;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ParquetRelation2$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String MERGE_SCHEMA() {
        return this.MERGE_SCHEMA;
    }

    public String METASTORE_SCHEMA() {
        return this.METASTORE_SCHEMA;
    }

    public void initializeLocalJobFunc(String[] requiredColumns, Filter[] filters, StructType dataSchema2, boolean useMetadataCache, boolean parquetFilterPushDown, Job job) {
        Configuration conf = job.getConfiguration();
        conf.set("parquet.read.support.class", RowReadSupport.class.getName());
        if (parquetFilterPushDown) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filters).flatMap((Function1)new Serializable(dataSchema2){
                public static final long serialVersionUID = 0L;
                private final StructType dataSchema$1;

                public final Iterable<FilterPredicate> apply(Filter x$11) {
                    return Option$.MODULE$.option2Iterable(ParquetFilters$.MODULE$.createFilter(this.dataSchema$1, x$11));
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterPredicate.class)))).reduceOption((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                    return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
                }
            }).foreach((Function1)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;

                public final void apply(FilterPredicate x$12) {
                    ParquetInputFormat.setFilterPredicate((Configuration)this.conf$1, (FilterPredicate)x$12);
                }
                {
                    this.conf$1 = conf$1;
                }
            });
        }
        StructType requestedSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(dataSchema2){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;

            public final StructField apply(String x$13) {
                return this.dataSchema$1.apply(x$13);
            }
            {
                this.dataSchema$1 = dataSchema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        conf.set(RowReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetTypesConverter$.MODULE$.convertToString((Seq<Attribute>)requestedSchema.toAttributes()));
        conf.set(RowWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), ParquetTypesConverter$.MODULE$.convertToString((Seq<Attribute>)dataSchema2.toAttributes()));
        conf.set(SQLConf$.MODULE$.PARQUET_CACHE_METADATA(), ((Object)BoxesRunTime.boxToBoolean((boolean)useMetadataCache)).toString());
    }

    public void initializeDriverSideJobFunc(FileStatus[] inputFiles, Job job) {
        if (Predef$.MODULE$.refArrayOps((Object[])inputFiles).nonEmpty()) {
            FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])Predef$.MODULE$.refArrayOps((Object[])inputFiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Path apply(FileStatus x$14) {
                    return x$14.getPath();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))));
        }
    }

    public Option<StructType> readSchema(Seq<Footer> footers, SQLContext sqlContext) {
        return ((TraversableOnce)footers.map((Function1)new Serializable(sqlContext){
            public static final long serialVersionUID = 0L;
            public final SQLContext sqlContext$1;

            public final StructType apply(Footer footer) {
                FileMetaData metadata = footer.getParquetMetadata().getFileMetaData();
                MessageType parquetSchema = metadata.getSchema();
                Option maybeSparkSchema = JavaConversions$.MODULE$.mapAsScalaMap(metadata.getKeyValueMetaData()).toMap(Predef$.MODULE$.conforms()).get((Object)RowReadSupport$.MODULE$.SPARK_METADATA_KEY()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<StructType> apply(String serializedSchema) {
                        return Try$.MODULE$.apply((Function0)new Serializable(this, serializedSchema){
                            public static final long serialVersionUID = 0L;
                            private final String serializedSchema$1;

                            public final DataType apply() {
                                return DataType$.MODULE$.fromJson(this.serializedSchema$1);
                            }
                            {
                                this.serializedSchema$1 = serializedSchema$1;
                            }
                        }).recover((PartialFunction)new Serializable(this, serializedSchema){
                            public static final long serialVersionUID = 0L;
                            private final String serializedSchema$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 != null) {
                                    ParquetRelation2$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Serialized Spark schema in Parquet key-value metadata is not in JSON format, "})).s((Seq)Nil$.MODULE$)).append((Object)"falling back to the deprecated DataType.fromCaseClassString parser.").toString();
                                        }
                                    });
                                    object = DataType$.MODULE$.fromCaseClassString(this.serializedSchema$1);
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable = x1;
                                boolean bl = throwable != null;
                                return bl;
                            }
                            {
                                this.serializedSchema$1 = serializedSchema$1;
                            }
                        }).recover((PartialFunction)new Serializable(this, serializedSchema){
                            public static final long serialVersionUID = 0L;
                            public final String serializedSchema$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x2;
                                if (A1 != null) {
                                    A1 A12 = A1;
                                    ParquetRelation2$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$readSchema$1$$anonfun$21$$anonfun$apply$1 $outer;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse serialized Spark schema in Parquet key-value metadata:\n                   |\\t", "\n                 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serializedSchema$1})))).stripMargin();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, A12);
                                    object = BoxedUnit.UNIT;
                                } else {
                                    object = function1.apply(x2);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Throwable x2) {
                                Throwable throwable = x2;
                                boolean bl = throwable != null;
                                return bl;
                            }
                            {
                                this.serializedSchema$1 = serializedSchema$1;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StructType apply(Object x$15) {
                                return (StructType)x$15;
                            }
                        }).toOption();
                    }
                });
                return (StructType)maybeSparkSchema.getOrElse((Function0)new Serializable(this, parquetSchema){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.readSchema.1 $outer;
                    private final MessageType parquetSchema$2;

                    public final StructType apply() {
                        return StructType$.MODULE$.fromAttributes(ParquetTypesConverter$.MODULE$.convertToAttributes((Type)this.parquetSchema$2, this.$outer.sqlContext$1.conf().isParquetBinaryAsString(), this.$outer.sqlContext$1.conf().isParquetINT96AsTimestamp()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.parquetSchema$2 = parquetSchema$2;
                    }
                });
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(StructType left, StructType right) {
                try {
                    return left.merge(right);
                }
                catch (Throwable throwable) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to merge incompatible schemas ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left, right})), throwable);
                }
            }
        });
    }

    public StructType mergeMetastoreParquetSchema(StructType metastoreSchema, StructType parquetSchema) {
        StructType mergedParquetSchema = this.mergeMissingNullableFields(metastoreSchema, parquetSchema);
        Predef$.MODULE$.assert(metastoreSchema.size() <= mergedParquetSchema.size(), (Function0)new Serializable(metastoreSchema, parquetSchema){
            public static final long serialVersionUID = 0L;
            private final StructType metastoreSchema$1;
            private final StructType parquetSchema$1;

            public final String apply() {
                return ParquetRelation2$.MODULE$.org$apache$spark$sql$parquet$ParquetRelation2$$schemaConflictMessage$1(this.metastoreSchema$1, this.parquetSchema$1);
            }
            {
                this.metastoreSchema$1 = metastoreSchema$1;
                this.parquetSchema$1 = parquetSchema$1;
            }
        });
        Map ordinalMap = ((TraversableOnce)((TraversableLike)metastoreSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<StructField, Object> x0$2) {
                Tuple2<StructField, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)field.name().toLowerCase()), (Object)BoxesRunTime.boxToInteger((int)index));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Seq reorderedParquetSchema = (Seq)mergedParquetSchema.sortBy((Function1)new Serializable(metastoreSchema, ordinalMap){
            public static final long serialVersionUID = 0L;
            public final StructType metastoreSchema$1;
            private final Map ordinalMap$1;

            public final int apply(StructField f) {
                return BoxesRunTime.unboxToInt((Object)this.ordinalMap$1.getOrElse((Object)f.name().toLowerCase(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.23 $outer;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.metastoreSchema$1.size() + 1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.metastoreSchema$1 = metastoreSchema$1;
                this.ordinalMap$1 = ordinalMap$1;
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        return StructType$.MODULE$.apply((Seq)((TraversableLike)metastoreSchema.zip((GenIterable)reorderedParquetSchema, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(metastoreSchema, parquetSchema){
            public static final long serialVersionUID = 0L;
            private final StructType metastoreSchema$1;
            private final StructType parquetSchema$1;

            public final StructField apply(Tuple2<StructField, StructField> x0$3) {
                Tuple2<StructField, StructField> tuple2 = x0$3;
                if (tuple2 != null) {
                    StructField mSchema = (StructField)tuple2._1();
                    StructField pSchema = (StructField)tuple2._2();
                    String string = mSchema.name().toLowerCase();
                    String string2 = pSchema.name().toLowerCase();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        StructField structField = mSchema.copy(pSchema.name(), mSchema.copy$default$2(), mSchema.copy$default$3(), mSchema.copy$default$4());
                        return structField;
                    }
                }
                throw new SparkException(ParquetRelation2$.MODULE$.org$apache$spark$sql$parquet$ParquetRelation2$$schemaConflictMessage$1(this.metastoreSchema$1, this.parquetSchema$1));
            }
            {
                this.metastoreSchema$1 = metastoreSchema$1;
                this.parquetSchema$1 = parquetSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public StructType mergeMissingNullableFields(StructType metastoreSchema, StructType parquetSchema) {
        Map fieldMap = ((TraversableOnce)metastoreSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)f.name().toLowerCase()), (Object)f);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Seq missingFields = (Seq)((TraversableLike)((TraversableLike)((SeqLike)metastoreSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$16) {
                return x$16.name().toLowerCase();
            }
        }, Seq$.MODULE$.canBuildFrom())).diff((GenSeq)parquetSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$17) {
                return x$17.name().toLowerCase();
            }
        }, Seq$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            private final Map fieldMap$1;

            public final StructField apply(String x$18) {
                return (StructField)this.fieldMap$1.apply((Object)x$18);
            }
            {
                this.fieldMap$1 = fieldMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$19) {
                return x$19.nullable();
            }
        });
        return StructType$.MODULE$.apply((Seq)parquetSchema.$plus$plus((GenTraversableOnce)missingFields, Seq$.MODULE$.canBuildFrom()));
    }

    public final String org$apache$spark$sql$parquet$ParquetRelation2$$schemaConflictMessage$1(StructType metastoreSchema$1, StructType parquetSchema$1) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converting Hive Metastore Parquet, but detected conflicting schemas. Metastore schema:\n         |", "\n         |\n         |Parquet schema:\n         |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metastoreSchema$1.prettyJson(), parquetSchema$1.prettyJson()})))).stripMargin();
    }

    private ParquetRelation2$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.MERGE_SCHEMA = "mergeSchema";
        this.METASTORE_SCHEMA = "metastoreSchema";
    }
}

