/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.parquet.CatalystConverter$;
import org.apache.spark.sql.parquet.ParquetRelation$;
import org.apache.spark.sql.parquet.ParquetTypeInfo;
import org.apache.spark.sql.parquet.ParquetTypeInfo$;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.parquet.RowReadSupport$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.ConversionPatterns;
import parquet.schema.DecimalMetadata;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Try$;

public final class ParquetTypesConverter$
implements Logging {
    public static final ParquetTypesConverter$ MODULE$;
    private final int[] BYTES_FOR_PRECISION;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ParquetTypesConverter$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public boolean isPrimitiveType(DataType ctype) {
        DataType dataType;
        block11: {
            boolean bl;
            block10: {
                block9: {
                    boolean bl2;
                    dataType = ctype;
                    if (dataType instanceof NumericType) {
                        bl2 = true;
                    } else {
                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                        DataType dataType2 = dataType;
                        if (!(booleanType$ != null ? !booleanType$.equals(dataType2) : dataType2 != null)) {
                            bl2 = true;
                        } else {
                            StringType$ stringType$ = StringType$.MODULE$;
                            DataType dataType3 = dataType;
                            if (!(stringType$ != null ? !stringType$.equals(dataType3) : dataType3 != null)) {
                                bl2 = true;
                            } else {
                                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                DataType dataType4 = dataType;
                                bl2 = !(binaryType$ != null ? !binaryType$.equals(dataType4) : dataType4 != null);
                            }
                        }
                    }
                    if (!bl2) break block9;
                    bl = true;
                    break block10;
                }
                if (dataType == null) break block11;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)dataType);
    }

    public DataType toPrimitiveDataType(PrimitiveType parquetType, boolean binaryAsString, boolean int96AsTimestamp) {
        block14: {
            BinaryType$ binaryType$;
            block5: {
                PrimitiveType.PrimitiveTypeName primitiveTypeName;
                boolean bl;
                DecimalMetadata decimalInfo;
                OriginalType originalType;
                block13: {
                    PrimitiveType.PrimitiveTypeName primitiveTypeName2;
                    block12: {
                        block11: {
                            boolean bl2;
                            block10: {
                                PrimitiveType.PrimitiveTypeName primitiveTypeName3;
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                boolean bl3;
                                                block4: {
                                                    originalType = parquetType.getOriginalType();
                                                    decimalInfo = parquetType.getDecimalMetadata();
                                                    bl3 = false;
                                                    PrimitiveType.PrimitiveTypeName primitiveTypeName4 = null;
                                                    bl2 = false;
                                                    primitiveTypeName3 = null;
                                                    bl = false;
                                                    primitiveTypeName2 = null;
                                                    primitiveTypeName = parquetType.getPrimitiveTypeName();
                                                    PrimitiveType.PrimitiveTypeName primitiveTypeName5 = PrimitiveType.PrimitiveTypeName.BINARY;
                                                    PrimitiveType.PrimitiveTypeName primitiveTypeName6 = primitiveTypeName;
                                                    if (primitiveTypeName5 != null ? !primitiveTypeName5.equals(primitiveTypeName6) : primitiveTypeName6 != null) break block4;
                                                    bl3 = true;
                                                    primitiveTypeName4 = primitiveTypeName;
                                                    OriginalType originalType2 = originalType;
                                                    OriginalType originalType3 = OriginalType.UTF8;
                                                    if ((originalType2 == null ? originalType3 != null : !originalType2.equals(originalType3)) && !binaryAsString) break block4;
                                                    binaryType$ = StringType$.MODULE$;
                                                    break block5;
                                                }
                                                if (!bl3) break block6;
                                                binaryType$ = BinaryType$.MODULE$;
                                                break block5;
                                            }
                                            PrimitiveType.PrimitiveTypeName primitiveTypeName7 = PrimitiveType.PrimitiveTypeName.BOOLEAN;
                                            PrimitiveType.PrimitiveTypeName primitiveTypeName8 = primitiveTypeName;
                                            if (primitiveTypeName7 != null ? !primitiveTypeName7.equals(primitiveTypeName8) : primitiveTypeName8 != null) break block7;
                                            binaryType$ = BooleanType$.MODULE$;
                                            break block5;
                                        }
                                        PrimitiveType.PrimitiveTypeName primitiveTypeName9 = PrimitiveType.PrimitiveTypeName.DOUBLE;
                                        PrimitiveType.PrimitiveTypeName primitiveTypeName10 = primitiveTypeName;
                                        if (primitiveTypeName9 != null ? !primitiveTypeName9.equals(primitiveTypeName10) : primitiveTypeName10 != null) break block8;
                                        binaryType$ = DoubleType$.MODULE$;
                                        break block5;
                                    }
                                    PrimitiveType.PrimitiveTypeName primitiveTypeName11 = PrimitiveType.PrimitiveTypeName.FLOAT;
                                    PrimitiveType.PrimitiveTypeName primitiveTypeName12 = primitiveTypeName;
                                    if (primitiveTypeName11 != null ? !primitiveTypeName11.equals(primitiveTypeName12) : primitiveTypeName12 != null) break block9;
                                    binaryType$ = FloatType$.MODULE$;
                                    break block5;
                                }
                                PrimitiveType.PrimitiveTypeName primitiveTypeName13 = PrimitiveType.PrimitiveTypeName.INT32;
                                PrimitiveType.PrimitiveTypeName primitiveTypeName14 = primitiveTypeName;
                                if (primitiveTypeName13 != null ? !primitiveTypeName13.equals(primitiveTypeName14) : primitiveTypeName14 != null) break block10;
                                bl2 = true;
                                primitiveTypeName3 = primitiveTypeName;
                                OriginalType originalType4 = originalType;
                                OriginalType originalType5 = OriginalType.DATE;
                                if (originalType4 != null ? !originalType4.equals(originalType5) : originalType5 != null) break block10;
                                binaryType$ = DateType$.MODULE$;
                                break block5;
                            }
                            if (!bl2) break block11;
                            binaryType$ = IntegerType$.MODULE$;
                            break block5;
                        }
                        PrimitiveType.PrimitiveTypeName primitiveTypeName15 = PrimitiveType.PrimitiveTypeName.INT64;
                        PrimitiveType.PrimitiveTypeName primitiveTypeName16 = primitiveTypeName;
                        if (primitiveTypeName15 != null ? !primitiveTypeName15.equals(primitiveTypeName16) : primitiveTypeName16 != null) break block12;
                        binaryType$ = LongType$.MODULE$;
                        break block5;
                    }
                    PrimitiveType.PrimitiveTypeName primitiveTypeName17 = PrimitiveType.PrimitiveTypeName.INT96;
                    PrimitiveType.PrimitiveTypeName primitiveTypeName18 = primitiveTypeName;
                    if (primitiveTypeName17 != null ? !primitiveTypeName17.equals(primitiveTypeName18) : primitiveTypeName18 != null) break block13;
                    bl = true;
                    primitiveTypeName2 = primitiveTypeName;
                    if (!int96AsTimestamp) break block13;
                    binaryType$ = TimestampType$.MODULE$;
                    break block5;
                }
                if (bl) {
                    throw package$.MODULE$.error("Potential loss of precision: cannot convert INT96");
                }
                PrimitiveType.PrimitiveTypeName primitiveTypeName19 = PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
                PrimitiveType.PrimitiveTypeName primitiveTypeName20 = primitiveTypeName;
                if (primitiveTypeName19 != null ? !primitiveTypeName19.equals(primitiveTypeName20) : primitiveTypeName20 != null) break block14;
                OriginalType originalType6 = originalType;
                OriginalType originalType7 = OriginalType.DECIMAL;
                if ((originalType6 != null ? !originalType6.equals(originalType7) : originalType7 != null) || decimalInfo.getPrecision() > 18) break block14;
                binaryType$ = DecimalType$.MODULE$.apply(decimalInfo.getPrecision(), decimalInfo.getScale());
            }
            return binaryType$;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported parquet datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parquetType})));
    }

    public DataType toDataType(Type parquetType, boolean isBinaryAsString, boolean isInt96AsTimestamp) {
        DataType dataType;
        if (parquetType.isPrimitive()) {
            dataType = this.toPrimitiveDataType(parquetType.asPrimitiveType(), isBinaryAsString, isInt96AsTimestamp);
        } else {
            StructType structType;
            GroupType groupType = parquetType.asGroupType();
            OriginalType originalType = parquetType.getOriginalType();
            OriginalType originalType2 = OriginalType.LIST;
            OriginalType originalType3 = originalType;
            if (!(originalType2 != null ? !originalType2.equals(originalType3) : originalType3 != null)) {
                ArrayType arrayType;
                Predef$.MODULE$.assert(groupType.getFieldCount() == 1);
                Type field = (Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0);
                String string = field.getName();
                String string2 = CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    GroupType bag = field.asGroupType();
                    Predef$.MODULE$.assert(bag.getFieldCount() == 1);
                    arrayType = new ArrayType(this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(bag.getFields()).apply(0), isBinaryAsString, isInt96AsTimestamp), true);
                } else {
                    arrayType = new ArrayType(this.toDataType(field, isBinaryAsString, isInt96AsTimestamp), false);
                }
                structType = arrayType;
            } else {
                OriginalType originalType4 = OriginalType.MAP;
                OriginalType originalType5 = originalType;
                if (!(originalType4 != null ? !originalType4.equals(originalType5) : originalType5 != null)) {
                    Predef$.MODULE$.assert(!((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).isPrimitive(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Parquet Map type malformatted: expected nested group for map!";
                        }
                    });
                    GroupType keyValueGroup = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).asGroupType();
                    Predef$.MODULE$.assert(keyValueGroup.getFieldCount() == 2, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Parquet Map type malformatted: nested group should have 2 (key, value) fields!";
                        }
                    });
                    Type.Repetition repetition = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0)).getRepetition();
                    Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                    Predef$.MODULE$.assert(!(repetition != null ? !repetition.equals(repetition2) : repetition2 != null));
                    DataType keyType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0), isBinaryAsString, isInt96AsTimestamp);
                    DataType valueType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1), isBinaryAsString, isInt96AsTimestamp);
                    Type.Repetition repetition3 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1)).getRepetition();
                    Type.Repetition repetition4 = Type.Repetition.REQUIRED;
                    structType = new MapType(keyType, valueType, repetition3 != null ? !repetition3.equals(repetition4) : repetition4 != null);
                } else {
                    StructType structType2;
                    if (this.correspondsToMap$1(groupType)) {
                        GroupType keyValueGroup = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).asGroupType();
                        Type.Repetition repetition = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0)).getRepetition();
                        Type.Repetition repetition5 = Type.Repetition.REQUIRED;
                        Predef$.MODULE$.assert(!(repetition != null ? !repetition.equals(repetition5) : repetition5 != null));
                        DataType keyType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0), isBinaryAsString, isInt96AsTimestamp);
                        DataType valueType = this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1), isBinaryAsString, isInt96AsTimestamp);
                        Type.Repetition repetition6 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1)).getRepetition();
                        Type.Repetition repetition7 = Type.Repetition.REQUIRED;
                        boolean bl = repetition6 != null ? !repetition6.equals(repetition7) : repetition7 != null;
                        structType2 = new MapType(keyType, valueType, bl);
                    } else if (this.correspondsToArray$1(groupType)) {
                        Type field = (Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0);
                        String string = field.getName();
                        String string3 = CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME();
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            GroupType bag = field.asGroupType();
                            Predef$.MODULE$.assert(bag.getFieldCount() == 1);
                            structType2 = new ArrayType(this.toDataType((Type)JavaConversions$.MODULE$.asScalaBuffer(bag.getFields()).apply(0), isBinaryAsString, isInt96AsTimestamp), true);
                        } else {
                            structType2 = new ArrayType(this.toDataType(field, isBinaryAsString, isInt96AsTimestamp), false);
                        }
                    } else {
                        Buffer fields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).map((Function1)new Serializable(isBinaryAsString, isInt96AsTimestamp){
                            public static final long serialVersionUID = 0L;
                            private final boolean isBinaryAsString$2;
                            private final boolean isInt96AsTimestamp$2;

                            public final StructField apply(Type ptype) {
                                Type.Repetition repetition = ptype.getRepetition();
                                Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                                return new StructField(ptype.getName(), ParquetTypesConverter$.MODULE$.toDataType(ptype, this.isBinaryAsString$2, this.isInt96AsTimestamp$2), repetition != null ? !repetition.equals(repetition2) : repetition2 != null, StructField$.MODULE$.$lessinit$greater$default$4());
                            }
                            {
                                this.isBinaryAsString$2 = isBinaryAsString$2;
                                this.isInt96AsTimestamp$2 = isInt96AsTimestamp$2;
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                        structType2 = StructType$.MODULE$.apply((Seq)fields);
                    }
                    structType = structType2;
                }
            }
            dataType = structType;
        }
        return dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<ParquetTypeInfo> fromPrimitiveDataType(DataType ctype) {
        DataType dataType = ctype;
        StringType$ stringType$ = StringType$.MODULE$;
        DataType dataType2 = dataType;
        if (stringType$ == null) {
            if (dataType2 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.BINARY, (Option<OriginalType>)new Some((Object)OriginalType.UTF8), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (stringType$.equals(dataType2)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.BINARY, (Option<OriginalType>)new Some((Object)OriginalType.UTF8), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        DataType dataType3 = dataType;
        if (binaryType$ == null) {
            if (dataType3 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.BINARY, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (binaryType$.equals(dataType3)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.BINARY, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        DataType dataType4 = dataType;
        if (booleanType$ == null) {
            if (dataType4 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.BOOLEAN, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (booleanType$.equals(dataType4)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.BOOLEAN, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        DataType dataType5 = dataType;
        if (doubleType$ == null) {
            if (dataType5 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (doubleType$.equals(dataType5)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        FloatType$ floatType$ = FloatType$.MODULE$;
        DataType dataType6 = dataType;
        if (floatType$ == null) {
            if (dataType6 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (floatType$.equals(dataType6)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        DataType dataType7 = dataType;
        if (integerType$ == null) {
            if (dataType7 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (integerType$.equals(dataType7)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        ShortType$ shortType$ = ShortType$.MODULE$;
        DataType dataType8 = dataType;
        if (shortType$ == null) {
            if (dataType8 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (shortType$.equals(dataType8)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        ByteType$ byteType$ = ByteType$.MODULE$;
        DataType dataType9 = dataType;
        if (byteType$ == null) {
            if (dataType9 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (byteType$.equals(dataType9)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        DateType$ dateType$ = DateType$.MODULE$;
        DataType dataType10 = dataType;
        if (dateType$ == null) {
            if (dataType10 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, (Option<OriginalType>)new Some((Object)OriginalType.DATE), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (dateType$.equals(dataType10)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT32, (Option<OriginalType>)new Some((Object)OriginalType.DATE), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        LongType$ longType$ = LongType$.MODULE$;
        DataType dataType11 = dataType;
        if (longType$ == null) {
            if (dataType11 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT64, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (longType$.equals(dataType11)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT64, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        DataType dataType12 = dataType;
        if (timestampType$ == null) {
            if (dataType12 == null) return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT96, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        } else if (timestampType$.equals(dataType12)) {
            return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.INT96, ParquetTypeInfo$.MODULE$.apply$default$2(), ParquetTypeInfo$.MODULE$.apply$default$3(), ParquetTypeInfo$.MODULE$.apply$default$4()));
        }
        if (!(dataType instanceof DecimalType)) return None$.MODULE$;
        DecimalType decimalType = (DecimalType)dataType;
        Option option = DecimalType.Fixed$.MODULE$.unapply(decimalType);
        if (option.isEmpty()) return None$.MODULE$;
        int precision = ((Tuple2)option.get())._1$mcI$sp();
        int scale = ((Tuple2)option.get())._2$mcI$sp();
        if (precision > 18) return None$.MODULE$;
        return new Some((Object)new ParquetTypeInfo(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Option<OriginalType>)new Some((Object)OriginalType.DECIMAL), (Option<DecimalMetadata>)new Some((Object)new DecimalMetadata(precision, scale)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.BYTES_FOR_PRECISION()[precision]))));
    }

    public int[] BYTES_FOR_PRECISION() {
        return this.BYTES_FOR_PRECISION;
    }

    public Type fromDataType(DataType ctype, String name, boolean nullable, boolean inArray, boolean toThriftSchemaNames) {
        Type.Repetition repetition = inArray ? Type.Repetition.REPEATED : (nullable ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
        String arraySchemaName = toThriftSchemaNames ? new StringBuilder().append((Object)name).append((Object)CatalystConverter$.MODULE$.THRIFT_ARRAY_ELEMENTS_SCHEMA_NAME_SUFFIX()).toString() : CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME();
        Option<ParquetTypeInfo> typeInfo = this.fromPrimitiveDataType(ctype);
        return (Type)typeInfo.map((Function1)new Serializable(name, repetition){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Type.Repetition repetition$1;

            public final PrimitiveType apply(ParquetTypeInfo x0$1) {
                ParquetTypeInfo parquetTypeInfo = x0$1;
                if (parquetTypeInfo != null) {
                    PrimitiveType.PrimitiveTypeName primitiveType = parquetTypeInfo.primitiveType();
                    Option<OriginalType> originalType = parquetTypeInfo.originalType();
                    Option<DecimalMetadata> decimalMetadata = parquetTypeInfo.decimalMetadata();
                    Option<Object> length = parquetTypeInfo.length();
                    Types.PrimitiveBuilder builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)primitiveType, (Type.Repetition)this.repetition$1).as((OriginalType)originalType.orNull(Predef$.MODULE$.conforms()));
                    length.foreach((Function1)new Serializable(this, builder){
                        public static final long serialVersionUID = 0L;
                        private final Types.PrimitiveBuilder builder$1;

                        public final Types.PrimitiveBuilder<PrimitiveType> apply(int len) {
                            return this.builder$1.length(len);
                        }
                        {
                            this.builder$1 = builder$1;
                        }
                    });
                    decimalMetadata.foreach((Function1)new Serializable(this, builder){
                        public static final long serialVersionUID = 0L;
                        private final Types.PrimitiveBuilder builder$1;

                        public final Types.PrimitiveBuilder<PrimitiveType> apply(DecimalMetadata metadata) {
                            return this.builder$1.precision(metadata.getPrecision()).scale(metadata.getScale());
                        }
                        {
                            this.builder$1 = builder$1;
                        }
                    });
                    PrimitiveType primitiveType2 = (PrimitiveType)builder.named(this.name$1);
                    return primitiveType2;
                }
                throw new MatchError((Object)parquetTypeInfo);
            }
            {
                this.name$1 = name$1;
                this.repetition$1 = repetition$1;
            }
        }).getOrElse((Function0)new Serializable(ctype, name, nullable, inArray, toThriftSchemaNames, repetition, arraySchemaName){
            public static final long serialVersionUID = 0L;
            private final DataType ctype$1;
            private final String name$1;
            private final boolean nullable$1;
            private final boolean inArray$1;
            public final boolean toThriftSchemaNames$2;
            private final Type.Repetition repetition$1;
            private final String arraySchemaName$1;

            public final Type apply() {
                block7: {
                    Type type;
                    block3: {
                        DataType dataType;
                        block6: {
                            block5: {
                                ArrayType arrayType;
                                boolean bl;
                                block4: {
                                    block2: {
                                        bl = false;
                                        arrayType = null;
                                        dataType = this.ctype$1;
                                        if (!(dataType instanceof UserDefinedType)) break block2;
                                        UserDefinedType userDefinedType = (UserDefinedType)dataType;
                                        type = ParquetTypesConverter$.MODULE$.fromDataType(userDefinedType.sqlType(), this.name$1, this.nullable$1, this.inArray$1, this.toThriftSchemaNames$2);
                                        break block3;
                                    }
                                    if (!(dataType instanceof ArrayType)) break block4;
                                    bl = true;
                                    arrayType = (ArrayType)dataType;
                                    DataType elementType = arrayType.elementType();
                                    boolean bl2 = arrayType.containsNull();
                                    if (bl2) break block4;
                                    Type parquetElementType = ParquetTypesConverter$.MODULE$.fromDataType(elementType, this.arraySchemaName$1, false, true, this.toThriftSchemaNames$2);
                                    type = ConversionPatterns.listType((Type.Repetition)this.repetition$1, (String)this.name$1, (Type)parquetElementType);
                                    break block3;
                                }
                                if (!bl) break block5;
                                DataType elementType = arrayType.elementType();
                                boolean bl3 = arrayType.containsNull();
                                if (!bl3) break block5;
                                Type parquetElementType = ParquetTypesConverter$.MODULE$.fromDataType(elementType, this.arraySchemaName$1, true, false, this.toThriftSchemaNames$2);
                                type = ConversionPatterns.listType((Type.Repetition)this.repetition$1, (String)this.name$1, (Type)new GroupType(Type.Repetition.REPEATED, CatalystConverter$.MODULE$.ARRAY_CONTAINS_NULL_BAG_SCHEMA_NAME(), new Type[]{parquetElementType}));
                                break block3;
                            }
                            if (!(dataType instanceof StructType)) break block6;
                            StructType structType = (StructType)dataType;
                            StructField[] structFields = structType.fields();
                            Type[] fields = (Type[])Predef$.MODULE$.refArrayOps((Object[])structFields).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.fromDataType.2 $outer;

                                public final Type apply(StructField field) {
                                    return ParquetTypesConverter$.MODULE$.fromDataType(field.dataType(), field.name(), field.nullable(), false, this.$outer.toThriftSchemaNames$2);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Type.class)));
                            type = new GroupType(this.repetition$1, this.name$1, JavaConversions$.MODULE$.seqAsJavaList(Predef$.MODULE$.refArrayOps((Object[])fields).toSeq()));
                            break block3;
                        }
                        if (!(dataType instanceof MapType)) break block7;
                        MapType mapType = (MapType)dataType;
                        DataType keyType = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        boolean valueContainsNull = mapType.valueContainsNull();
                        Type parquetKeyType = ParquetTypesConverter$.MODULE$.fromDataType(keyType, CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME(), false, false, this.toThriftSchemaNames$2);
                        Type parquetValueType = ParquetTypesConverter$.MODULE$.fromDataType(valueType, CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME(), valueContainsNull, false, this.toThriftSchemaNames$2);
                        type = ConversionPatterns.mapType((Type.Repetition)this.repetition$1, (String)this.name$1, (Type)parquetKeyType, (Type)parquetValueType);
                    }
                    return type;
                }
                throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ctype$1})));
            }
            {
                this.ctype$1 = ctype$1;
                this.name$1 = name$1;
                this.nullable$1 = nullable$1;
                this.inArray$1 = inArray$1;
                this.toThriftSchemaNames$2 = toThriftSchemaNames$2;
                this.repetition$1 = repetition$1;
                this.arraySchemaName$1 = arraySchemaName$1;
            }
        });
    }

    public boolean fromDataType$default$3() {
        return true;
    }

    public boolean fromDataType$default$4() {
        return false;
    }

    public boolean fromDataType$default$5() {
        return false;
    }

    public Seq<Attribute> convertToAttributes(Type parquetSchema, boolean isBinaryAsString, boolean isInt96AsTimestamp) {
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(parquetSchema.asGroupType().getFields()).map((Function1)new Serializable(isBinaryAsString, isInt96AsTimestamp){
            public static final long serialVersionUID = 0L;
            private final boolean isBinaryAsString$1;
            private final boolean isInt96AsTimestamp$1;

            public final AttributeReference apply(Type field) {
                String x$6 = field.getName();
                DataType x$7 = ParquetTypesConverter$.MODULE$.toDataType(field, this.isBinaryAsString$1, this.isInt96AsTimestamp$1);
                Type.Repetition repetition = field.getRepetition();
                Type.Repetition repetition2 = Type.Repetition.REQUIRED;
                boolean x$8 = repetition != null ? !repetition.equals(repetition2) : repetition2 != null;
                Metadata x$9 = AttributeReference$.MODULE$.$lessinit$greater$default$4();
                ExprId x$10 = AttributeReference$.MODULE$.$lessinit$greater$default$5(x$6, x$7, x$8, x$9);
                Seq x$11 = AttributeReference$.MODULE$.$lessinit$greater$default$6(x$6, x$7, x$8, x$9);
                return new AttributeReference(x$6, x$7, x$8, x$9, x$10, x$11);
            }
            {
                this.isBinaryAsString$1 = isBinaryAsString$1;
                this.isInt96AsTimestamp$1 = isInt96AsTimestamp$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public MessageType convertFromAttributes(Seq<Attribute> attributes, boolean toThriftSchemaNames) {
        this.checkSpecialCharacters(attributes);
        Seq fields = (Seq)attributes.map((Function1)new Serializable(toThriftSchemaNames){
            public static final long serialVersionUID = 0L;
            private final boolean toThriftSchemaNames$1;

            public final Type apply(Attribute attribute) {
                DataType x$12 = attribute.dataType();
                String x$13 = attribute.name();
                boolean x$14 = attribute.nullable();
                boolean x$15 = this.toThriftSchemaNames$1;
                boolean x$16 = ParquetTypesConverter$.MODULE$.fromDataType$default$4();
                return ParquetTypesConverter$.MODULE$.fromDataType(x$12, x$13, x$14, x$16, x$15);
            }
            {
                this.toThriftSchemaNames$1 = toThriftSchemaNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new MessageType("root", JavaConversions$.MODULE$.seqAsJavaList(fields));
    }

    public boolean convertFromAttributes$default$2() {
        return false;
    }

    public Seq<Attribute> convertFromString(String string) {
        DataType dataType = (DataType)Try$.MODULE$.apply((Function0)new anonfun.5(string)).getOrElse((Function0)new anonfun.6(string));
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq seq = structType.toAttributes();
            return seq;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can convert ", " to row"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private void checkSpecialCharacters(Seq<Attribute> schema2) {
        ((IterableLike)schema2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String name) {
                if (name.matches(".*[ ,;{}()\n\t=].*")) {
                    throw package$.MODULE$.error(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute name \"", "\" contains invalid character(s) among \" ,;{}()\\n\\t=\".\n             |Please use alias to rename it.\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})))).stripMargin().split("\n")).mkString(" "));
                }
            }
        });
    }

    public String convertToString(Seq<Attribute> schema2) {
        this.checkSpecialCharacters(schema2);
        return StructType$.MODULE$.fromAttributes(schema2).json();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeMetaData(Seq<Attribute> attributes, Path origPath, Configuration conf) {
        Object object;
        if (origPath == null) {
            throw new IllegalArgumentException("Unable to write Parquet metadata: path is null");
        }
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to write Parquet metadata: path ", " is incorrectly formatted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        if (fs.exists(path) && !fs.getFileStatus(path).isDir()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to write to directory ", " but found file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        Path metadataPath = new Path(path, "_metadata");
        if (fs.exists(metadataPath)) {
            try {
                object = BoxesRunTime.boxToBoolean((boolean)fs.delete(metadataPath, true));
            }
            catch (IOException iOException) {
                void var6_6;
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete previous PARQUET_METADATA_FILE at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})));
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put(RowReadSupport$.MODULE$.SPARK_METADATA_KEY(), this.convertToString(attributes));
        MessageType parquetSchema = this.convertFromAttributes(attributes, this.convertFromAttributes$default$2());
        FileMetaData metaData = new FileMetaData(parquetSchema, extraMetadata, "Spark");
        ParquetRelation$.MODULE$.enableLogForwarding();
        Footer footer = new Footer(path, new ParquetMetadata(metaData, JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$)));
        ParquetFileWriter.writeMetadataFile((Configuration)conf, (Path)path, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$.$colon$colon((Object)footer)));
    }

    public ParquetMetadata readMetaData(Path origPath, Option<Configuration> configuration) {
        if (origPath == null) {
            throw new IllegalArgumentException("Unable to read Parquet metadata: path is null");
        }
        Job job = new Job();
        Configuration conf = (Configuration)configuration.getOrElse((Function0)new Serializable(job){
            public static final long serialVersionUID = 0L;
            private final Job job$1;

            public final Configuration apply() {
                return ContextUtil.getConfiguration((JobContext)this.job$1);
            }
            {
                this.job$1 = job$1;
            }
        });
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrectly formatted Parquet metadata path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        FileStatus[] children = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.globStatus(path)).flatMap((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            public final IterableLike<FileStatus, Object> apply(FileStatus status) {
                return status.isDir() ? Predef$.MODULE$.refArrayOps((Object[])this.fs$1.listStatus(status.getPath())) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status}));
            }
            {
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(FileStatus status) {
                String name = status.getPath().getName();
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 0) != '.') {
                    if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 0) != '_') return false;
                }
                String string = name;
                String string2 = "_metadata";
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }
        });
        ParquetRelation$.MODULE$.enableLogForwarding();
        return (ParquetMetadata)Predef$.MODULE$.refArrayOps((Object[])children).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_metadata";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        }).orElse((Function0)new Serializable(children){
            public static final long serialVersionUID = 0L;
            private final FileStatus[] children$1;

            public final Option<FileStatus> apply() {
                return Predef$.MODULE$.refArrayOps((Object[])this.children$1).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$4) {
                        String string = x$4.getPath().getName();
                        String string2 = "_metadata";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                });
            }
            {
                this.children$1 = children$1;
            }
        }).map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final ParquetMetadata apply(FileStatus x$5) {
                return ParquetFileReader.readFooter((Configuration)this.conf$1, (FileStatus)x$5, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            }
            {
                this.conf$1 = conf$1;
            }
        }).getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final Path path$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Parquet metadata at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1})));
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    public Seq<Attribute> readSchemaFromFile(Path origPath, Option<Configuration> conf, boolean isBinaryAsString, boolean isInt96AsTimestamp) {
        Seq<Attribute> seq;
        Map keyValueMetadata = this.readMetaData(origPath, conf).getFileMetaData().getKeyValueMetaData();
        if (keyValueMetadata.get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()) == null) {
            Seq<Attribute> attributes = this.convertToAttributes((Type)this.readMetaData(origPath, conf).getFileMetaData().getSchema(), isBinaryAsString, isInt96AsTimestamp);
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to schema conversion from Parquet types; result: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attributes})));
            seq = attributes;
        } else {
            seq = this.convertFromString((String)keyValueMetadata.get(RowReadSupport$.MODULE$.SPARK_METADATA_KEY()));
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean correspondsToMap$1(GroupType groupType) {
        if (groupType.getFieldCount() != 1) return false;
        if (((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).isPrimitive()) {
            return false;
        }
        GroupType keyValueGroup = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).asGroupType();
        Type.Repetition repetition = keyValueGroup.getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (repetition == null) {
            if (repetition2 != null) {
                return false;
            }
        } else if (!repetition.equals(repetition2)) return false;
        String string = keyValueGroup.getName();
        String string2 = CatalystConverter$.MODULE$.MAP_SCHEMA_NAME();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (keyValueGroup.getFieldCount() != 2) return false;
        String string3 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(0)).getName();
        String string4 = CatalystConverter$.MODULE$.MAP_KEY_SCHEMA_NAME();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = ((Type)JavaConversions$.MODULE$.asScalaBuffer(keyValueGroup.getFields()).apply(1)).getName();
        String string6 = CatalystConverter$.MODULE$.MAP_VALUE_SCHEMA_NAME();
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean correspondsToArray$1(GroupType groupType) {
        if (groupType.getFieldCount() != 1) return false;
        String string = groupType.getFieldName(0);
        String string2 = CatalystConverter$.MODULE$.ARRAY_ELEMENTS_SCHEMA_NAME();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Type.Repetition repetition = ((Type)JavaConversions$.MODULE$.asScalaBuffer(groupType.getFields()).apply(0)).getRepetition();
        Type.Repetition repetition2 = Type.Repetition.REPEATED;
        if (repetition == null) {
            if (repetition2 == null) return true;
            return false;
        } else {
            if (!repetition.equals(repetition2)) return false;
            return true;
        }
    }

    private ParquetTypesConverter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.BYTES_FOR_PRECISION = (int[])Array$.MODULE$.tabulate(38, (Function1)new anonfun.1(), ClassTag$.MODULE$.Int());
    }
}

