/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CaseInsensitiveMap;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.HadoopFsRelation;
import org.apache.spark.sql.sources.HadoopFsRelationProvider;
import org.apache.spark.sql.sources.InsertIntoHadoopFsRelation;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.ResolvedDataSource;
import org.apache.spark.sql.sources.ResolvedDataSource$;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class ResolvedDataSource$
implements Serializable {
    public static final ResolvedDataSource$ MODULE$;
    private final Map<String, String> builtinSources;

    static {
        new ResolvedDataSource$();
    }

    private Map<String, String> builtinSources() {
        return this.builtinSources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class<?> lookupDataSource(String provider) {
        Class<?> clazz;
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        if (this.builtinSources().contains((Object)provider)) {
            return loader.loadClass((String)this.builtinSources().apply((Object)provider));
        }
        try {
            clazz = loader.loadClass(provider);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = loader.loadClass(new StringBuilder().append((Object)provider).append((Object)".DefaultSource").toString());
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                if (!provider.startsWith("org.apache.spark.sql.hive.orc")) throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load class for data source: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider})));
                throw package$.MODULE$.error("The ORC data source must be used with Hive support enabled.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResolvedDataSource apply(SQLContext sqlContext, Option<StructType> userSpecifiedSchema, String[] partitionColumns2, String provider, Map<String, String> options2) {
        Option<StructType> option;
        block10: {
            void var6_6;
            Object obj;
            block13: {
                BaseRelation baseRelation;
                Class<?> clazz;
                block9: {
                    BaseRelation baseRelation2;
                    block12: {
                        block11: {
                            block5: {
                                Object obj2;
                                block8: {
                                    BaseRelation baseRelation3;
                                    block7: {
                                        StructType structType;
                                        block6: {
                                            Some some;
                                            StructType schema2;
                                            clazz = this.lookupDataSource(provider);
                                            option = userSpecifiedSchema;
                                            if (!(option instanceof Some) || (schema2 = (StructType)(some = (Some)option).x()) == null) break block5;
                                            structType = schema2;
                                            obj2 = clazz.newInstance();
                                            if (!(obj2 instanceof SchemaRelationProvider)) break block6;
                                            Object obj3 = obj2;
                                            baseRelation3 = ((SchemaRelationProvider)obj3).createRelation(sqlContext, new CaseInsensitiveMap(options2), structType);
                                            break block7;
                                        }
                                        if (!(obj2 instanceof HadoopFsRelationProvider)) break block8;
                                        Object obj4 = obj2;
                                        None$ maybePartitionsSchema = Predef$.MODULE$.refArrayOps((Object[])partitionColumns2).isEmpty() ? None$.MODULE$ : new Some((Object)this.partitionColumnsSchema(structType, partitionColumns2));
                                        CaseInsensitiveMap caseInsensitiveOptions = new CaseInsensitiveMap(options2);
                                        Path patternPath = new Path((String)caseInsensitiveOptions.apply("path"));
                                        String[] paths = (String[])((TraversableOnce)SparkHadoopUtil$.MODULE$.get().globPath(patternPath).map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(Path x$1) {
                                                return x$1.toString();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                                        StructType dataSchema2 = StructType$.MODULE$.apply((Seq)structType.filterNot((Function1)new Serializable(partitionColumns2){
                                            public static final long serialVersionUID = 0L;
                                            private final String[] partitionColumns$2;

                                            public final boolean apply(StructField f) {
                                                return Predef$.MODULE$.refArrayOps((Object[])this.partitionColumns$2).contains((Object)f.name());
                                            }
                                            {
                                                this.partitionColumns$2 = partitionColumns$2;
                                            }
                                        })).asNullable();
                                        baseRelation3 = ((HadoopFsRelationProvider)obj4).createRelation(sqlContext, paths, (Option<StructType>)new Some((Object)dataSchema2), (Option<StructType>)maybePartitionsSchema, caseInsensitiveOptions);
                                    }
                                    baseRelation = baseRelation3;
                                    break block9;
                                }
                                if (obj2 instanceof RelationProvider) {
                                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not allow user-specified schemas."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1(clazz)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
                                }
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a RelationProvider."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1(clazz)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
                            }
                            None$ none$ = None$.MODULE$;
                            Option<StructType> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                            obj = clazz.newInstance();
                            if (!(obj instanceof RelationProvider)) break block11;
                            Object obj5 = obj;
                            baseRelation2 = ((RelationProvider)obj5).createRelation(sqlContext, new CaseInsensitiveMap(options2));
                            break block12;
                        }
                        if (!(obj instanceof HadoopFsRelationProvider)) break block13;
                        Object obj6 = obj;
                        CaseInsensitiveMap caseInsensitiveOptions = new CaseInsensitiveMap(options2);
                        Path patternPath = new Path((String)caseInsensitiveOptions.apply("path"));
                        String[] paths = (String[])((TraversableOnce)SparkHadoopUtil$.MODULE$.get().globPath(patternPath).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Path x$2) {
                                return x$2.toString();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        baseRelation2 = ((HadoopFsRelationProvider)obj6).createRelation(sqlContext, paths, (Option<StructType>)None$.MODULE$, (Option<StructType>)None$.MODULE$, caseInsensitiveOptions);
                    }
                    baseRelation = baseRelation2;
                }
                BaseRelation relation = baseRelation;
                return new ResolvedDataSource(clazz, relation);
            }
            if (obj instanceof SchemaRelationProvider) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A schema needs to be specified when using ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1((Class)var6_6)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is neither a RelationProvider nor a FSBasedRelationProvider."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1((Class)var6_6)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
        throw new MatchError(option);
    }

    private StructType partitionColumnsSchema(StructType schema2, String[] partitionColumns2) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])partitionColumns2).map((Function1)new Serializable(schema2){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;

            public final StructField apply(String col2) {
                return (StructField)this.schema$1.find((Function1)new Serializable(this, col2){
                    public static final long serialVersionUID = 0L;
                    private final String col$1;

                    public final boolean apply(StructField x$3) {
                        String string = x$3.name();
                        String string2 = this.col$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.col$1 = col$1;
                    }
                }).getOrElse((Function0)new Serializable(this, col2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.partitionColumnsSchema.1 $outer;
                    private final String col$1;

                    public final Nothing$ apply() {
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column ", " not found in schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1, this.$outer.schema$1})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.schema$1 = schema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).asNullable();
    }

    /*
     * WARNING - void declaration
     */
    public ResolvedDataSource apply(SQLContext sqlContext, String provider, String[] partitionColumns2, SaveMode mode, Map<String, String> options2, DataFrame data) {
        void var7_7;
        block4: {
            BaseRelation baseRelation;
            Class<?> clazz;
            block3: {
                Object obj;
                block2: {
                    clazz = this.lookupDataSource(provider);
                    obj = clazz.newInstance();
                    if (!(obj instanceof CreatableRelationProvider)) break block2;
                    Object obj2 = obj;
                    baseRelation = ((CreatableRelationProvider)obj2).createRelation(sqlContext, mode, options2, data);
                    break block3;
                }
                if (!(obj instanceof HadoopFsRelationProvider)) break block4;
                Object obj3 = obj;
                CaseInsensitiveMap caseInsensitiveOptions = new CaseInsensitiveMap(options2);
                Path path = new Path((String)caseInsensitiveOptions.apply("path"));
                FileSystem fs = path.getFileSystem(sqlContext.sparkContext().hadoopConfiguration());
                Path outputPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
                StructType dataSchema2 = StructType$.MODULE$.apply((Seq)data.schema().filterNot((Function1)new Serializable(partitionColumns2){
                    public static final long serialVersionUID = 0L;
                    private final String[] partitionColumns$1;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.partitionColumns$1).contains((Object)f.name());
                    }
                    {
                        this.partitionColumns$1 = partitionColumns$1;
                    }
                }));
                HadoopFsRelation r = ((HadoopFsRelationProvider)obj3).createRelation(sqlContext, (String[])((Object[])new String[]{outputPath.toString()}), (Option<StructType>)new Some((Object)dataSchema2.asNullable()), (Option<StructType>)new Some((Object)this.partitionColumnsSchema(data.schema(), partitionColumns2)), caseInsensitiveOptions);
                sqlContext.executePlan(new InsertIntoHadoopFsRelation(r, data.logicalPlan(), mode)).toRdd();
                baseRelation = r;
            }
            BaseRelation relation = baseRelation;
            return new ResolvedDataSource(clazz, relation);
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not allow create table as select."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7.getCanonicalName()})));
    }

    public ResolvedDataSource apply(Class<?> provider, BaseRelation relation) {
        return new ResolvedDataSource(provider, relation);
    }

    public Option<Tuple2<Class<Object>, BaseRelation>> unapply(ResolvedDataSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.provider(), (Object)x$0.relation()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final String className$1(Class clazz$1) {
        return clazz$1.getCanonicalName();
    }

    private ResolvedDataSource$() {
        MODULE$ = this;
        this.builtinSources = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"jdbc"), (Object)"org.apache.spark.sql.jdbc.DefaultSource"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"json"), (Object)"org.apache.spark.sql.json.DefaultSource"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"parquet"), (Object)"org.apache.spark.sql.parquet.DefaultSource"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"orc"), (Object)"org.apache.spark.sql.hive.orc.DefaultSource")}));
    }
}

