/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.compression.Encoder$class;
import org.apache.spark.sql.columnar.compression.LongDelta$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.LongType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005MxAB\u0001\u0003\u0011\u00033a\"A\u0005M_:<G)\u001a7uC*\u00111\u0001B\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002\u0006\r\u0005A1m\u001c7v[:\f'O\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u0004\"a\u0004\t\u000e\u0003\t1a!\u0005\u0002\t\u0002\u001a\u0011\"!\u0003'p]\u001e$U\r\u001c;b'\u0015\u00012#\u0007\u000f !\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011qBG\u0005\u00037\t\u0011\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\t!R$\u0003\u0002\u001f+\t9\u0001K]8ek\u000e$\bC\u0001\u000b!\u0013\t\tSC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003$!\u0011\u0005Q%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001\"B\u0014\u0011\t\u0003B\u0013A\u0002;za\u0016LE-F\u0001*!\t!\"&\u0003\u0002,+\t\u0019\u0011J\u001c;\t\u000b5\u0002B\u0011\t\u0018\u0002\u000f\u0011,7m\u001c3feV\u0011q&\u000e\u000b\u0004a\u0005[\u0005cA\b2g%\u0011!G\u0001\u0002\b\t\u0016\u001cw\u000eZ3s!\t!T\u0007\u0004\u0001\u0005\u000bYb#\u0019A\u001c\u0003\u0003Q\u000b\"\u0001O\u001e\u0011\u0005QI\u0014B\u0001\u001e\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0004\u0002\u000bQL\b/Z:\n\u0005\u0001k$AC!u_6L7\rV=qK\")!\t\fa\u0001\u0007\u00061!-\u001e4gKJ\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u00079LwNC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%A\u0003\"zi\u0016\u0014UO\u001a4fe\")A\n\fa\u0001\u001b\u0006Q1m\u001c7v[:$\u0016\u0010]3\u0011\u00079{5'D\u0001\u0005\u0013\t\u0001FA\u0001\tOCRLg/Z\"pYVlg\u000eV=qK\")!\u000b\u0005C!'\u00069QM\\2pI\u0016\u0014XC\u0001+Z)\t)&\fE\u0002\u0010-bK!a\u0016\u0002\u0003\u000f\u0015s7m\u001c3feB\u0011A'\u0017\u0003\u0006mE\u0013\ra\u000e\u0005\u0006\u0019F\u0003\ra\u0017\t\u0004\u001d>C\u0006\"B/\u0011\t\u0003r\u0016\u0001C:vaB|'\u000f^:\u0015\u0005}\u0013\u0007C\u0001\u000ba\u0013\t\tWCA\u0004C_>dW-\u00198\t\u000b1c\u0006\u0019A21\u0005\u0011D\u0007c\u0001(fO&\u0011a\r\u0002\u0002\u000b\u0007>dW/\u001c8UsB,\u0007C\u0001\u001bi\t%I'-!A\u0001\u0002\u000b\u0005!NA\u0002`IY\n\"\u0001O6\u0011\u0005Qa\u0017BA7\u0016\u0005\r\te.\u001f\u0004\u0005/B\u0001qnE\u0002o'A\u00042a\u0004,r\u001d\ta$/\u0003\u0002t{\u0005AAj\u001c8h)f\u0004X\rC\u0003$]\u0012\u0005Q\u000fF\u0001w!\t9h.D\u0001\u0011\u0011\u001dIh\u000e1A\u0005\u0012!\nqbX2p[B\u0014Xm]:fINK'0\u001a\u0005\bw:\u0004\r\u0011\"\u0005}\u0003My6m\\7qe\u0016\u001c8/\u001a3TSj,w\fJ3r)\ri\u0018\u0011\u0001\t\u0003)yL!a`\u000b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0007Q\u0018\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\t\u000f\u0005\u001da\u000e)Q\u0005S\u0005\u0001rlY8naJ,7o]3e'&TX\r\t\u0005\t\u0003\u0017q\u0007\u0019!C\tQ\u0005\tr,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\t\u0013\u0005=a\u000e1A\u0005\u0012\u0005E\u0011!F0v]\u000e|W\u000e\u001d:fgN,GmU5{K~#S-\u001d\u000b\u0004{\u0006M\u0001\"CA\u0002\u0003\u001b\t\t\u00111\u0001*\u0011\u001d\t9B\u001cQ!\n%\n!cX;oG>l\u0007O]3tg\u0016$7+\u001b>fA!1\u00111\u00048\u0005B!\nabY8naJ,7o]3e'&TX\r\u0003\u0004\u0002 9$\t\u0005K\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016D1\"a\to\u0001\u0004\u0005\r\u0011\"\u0003\u0002&\u0005I\u0001O]3w-\u0006dW/Z\u000b\u0003\u0003O\u00012\u0001FA\u0015\u0013\r\tY#\u0006\u0002\u0005\u0019>tw\rC\u0006\u000209\u0004\r\u00111A\u0005\n\u0005E\u0012!\u00049sKZ4\u0016\r\\;f?\u0012*\u0017\u000fF\u0002~\u0003gA!\"a\u0001\u0002.\u0005\u0005\t\u0019AA\u0014\u0011!\t9D\u001cQ!\n\u0005\u001d\u0012A\u00039sKZ4\u0016\r\\;fA!9\u00111\b8\u0005B\u0005u\u0012AG4bi\",'oQ8naJ,7o]5cS2LG/_*uCR\u001cH#B?\u0002@\u0005=\u0003\u0002CA!\u0003s\u0001\r!a\u0011\u0002\u0007I|w\u000f\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tIEB\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QJA$\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005E\u0013\u0011\ba\u0001S\u00059qN\u001d3j]\u0006d\u0007bBA+]\u0012\u0005\u0013qK\u0001\tG>l\u0007O]3tgR)1)!\u0017\u0002^!9\u00111LA*\u0001\u0004\u0019\u0015\u0001\u00024s_6Dq!a\u0018\u0002T\u0001\u00071)\u0001\u0002u_\u001a)!\u0007\u0005\u0001\u0002dM)\u0011\u0011M\n\u0002fA\u0019q\"M9\t\u0013\t\u000b\tG!A!\u0002\u0013\u0019\u0005B\u0003'\u0002b\t\u0005\t\u0015!\u0003\u0002lA\u0019ajT9\t\u000f\r\n\t\u0007\"\u0001\u0002pQ1\u0011\u0011OA:\u0003k\u00022a^A1\u0011\u0019\u0011\u0015Q\u000ea\u0001\u0007\"9A*!\u001cA\u0002\u0005-\u0004\u0002DA=\u0003C\u0002\r\u00111A\u0005\n\u0005\u0015\u0012\u0001\u00029sKZDA\"! \u0002b\u0001\u0007\t\u0019!C\u0005\u0003\u007f\n\u0001\u0002\u001d:fm~#S-\u001d\u000b\u0004{\u0006\u0005\u0005BCA\u0002\u0003w\n\t\u00111\u0001\u0002(!I\u0011QQA1A\u0003&\u0011qE\u0001\u0006aJ,g\u000f\t\u0005\t\u0003\u0013\u000b\t\u0007\"\u0011\u0002\f\u00069\u0001.Y:OKb$X#A0\t\u0011\u0005=\u0015\u0011\rC!\u0003#\u000bAA\\3yiR)Q0a%\u0002\"\"A\u0011\u0011IAG\u0001\u0004\t)\n\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*a\u0012\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003?\u000bIJ\u0001\u0006NkR\f'\r\\3S_^Dq!!\u0015\u0002\u000e\u0002\u0007\u0011\u0006C\u0005\u0002&B\t\t\u0011\"\u0011\u0002(\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!+\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,H\u0003\u0011a\u0017M\\4\n\t\u0005M\u0016Q\u0016\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005]\u0006#!A\u0005\u0002!\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"a/\u0011\u0003\u0003%\t!!0\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191.a0\t\u0013\u0005\r\u0011\u0011XA\u0001\u0002\u0004I\u0003\"CAb!\u0005\u0005I\u0011IAc\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAd!\u0015\tI-a4l\u001b\t\tYMC\u0002\u0002NV\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t.a3\u0003\u0011%#XM]1u_JD\u0011\"!6\u0011\u0003\u0003%\t!a6\u0002\u0011\r\fg.R9vC2$2aXAm\u0011%\t\u0019!a5\u0002\u0002\u0003\u00071\u000eC\u0005\u0002^B\t\t\u0011\"\u0011\u0002`\u0006A\u0001.Y:i\u0007>$W\rF\u0001*\u0011%\t\u0019\u000fEA\u0001\n\u0003\n)/\u0001\u0005u_N#(/\u001b8h)\t\tI\u000bC\u0005\u0002jB\t\t\u0011\"\u0003\u0002l\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u000f\u0005\u0003\u0002,\u0006=\u0018\u0002BAy\u0003[\u0013aa\u00142kK\u000e$\b")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Encoder
    implements org.apache.spark.sql.columnar.compression.Encoder<LongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return Encoder$class.compressionRatio(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            Encoder$class.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }

    public static class Decoder
    implements org.apache.spark.sql.columnar.compression.Decoder<LongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(MutableRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : this.buffer.getLong());
            row.setLong(ordinal, this.prev());
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<LongType$> columnType) {
            this.buffer = buffer;
        }
    }
}

