/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.jdbc.AggregatedDialect;
import org.apache.spark.sql.jdbc.DB2Dialect$;
import org.apache.spark.sql.jdbc.DerbyDialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoopDialect$;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.jdbc.PostgresDialect$;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

@DeveloperApi
public final class JdbcDialects$ {
    public static final JdbcDialects$ MODULE$;
    private List<JdbcDialect> dialects;

    static {
        new JdbcDialects$();
    }

    public void registerDialect(JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        this.dialects = ((List)this.dialects.filterNot((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$1;

            public final boolean apply(JdbcDialect x$1) {
                JdbcDialect jdbcDialect = x$1;
                JdbcDialect jdbcDialect2 = this.dialect$1;
                return !(jdbcDialect != null ? !jdbcDialect.equals(jdbcDialect2) : jdbcDialect2 != null);
            }
            {
                this.dialect$1 = dialect$1;
            }
        })).$colon$colon((Object)jdbcDialect);
    }

    public void unregisterDialect(JdbcDialect dialect) {
        this.dialects = (List)this.dialects.filterNot((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$2;

            public final boolean apply(JdbcDialect x$3) {
                JdbcDialect jdbcDialect = x$3;
                JdbcDialect jdbcDialect2 = this.dialect$2;
                return !(jdbcDialect != null ? !jdbcDialect.equals(jdbcDialect2) : jdbcDialect2 != null);
            }
            {
                this.dialect$2 = dialect$2;
            }
        });
    }

    public JdbcDialect get(String url) {
        JdbcDialect jdbcDialect;
        List matchingDialects = (List)this.dialects.filter((Function1)new Serializable(url){
            public static final long serialVersionUID = 0L;
            private final String url$1;

            public final boolean apply(JdbcDialect x$4) {
                return x$4.canHandle(this.url$1);
            }
            {
                this.url$1 = url$1;
            }
        });
        int n = matchingDialects.length();
        switch (n) {
            default: {
                jdbcDialect = new AggregatedDialect((List<JdbcDialect>)matchingDialects);
                break;
            }
            case 1: {
                jdbcDialect = (JdbcDialect)matchingDialects.head();
                break;
            }
            case 0: {
                jdbcDialect = NoopDialect$.MODULE$;
            }
        }
        return jdbcDialect;
    }

    private JdbcDialects$() {
        MODULE$ = this;
        this.dialects = Nil$.MODULE$;
        this.registerDialect(MySQLDialect$.MODULE$);
        this.registerDialect(PostgresDialect$.MODULE$);
        this.registerDialect(DB2Dialect$.MODULE$);
        this.registerDialect(MsSqlServerDialect$.MODULE$);
        this.registerDialect(DerbyDialect$.MODULE$);
        this.registerDialect(OracleDialect$.MODULE$);
    }
}

