/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Connection;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;

public final class PostgresDialect$
extends JdbcDialect {
    public static final PostgresDialect$ MODULE$;

    static {
        new PostgresDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:postgresql");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return sqlType == -7 && typeName.equals("bit") && size != 1 ? new Some((Object)BinaryType$.MODULE$) : (sqlType == 1111 ? this.toCatalystType(typeName).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType x$1) {
                DataType dataType = x$1;
                StringType$ stringType$ = StringType$.MODULE$;
                return !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null);
            }
        }) : (sqlType == 2003 && typeName.length() > 1 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(typeName), 0) == '_' ? this.toCatalystType((String)new StringOps(Predef$.MODULE$.augmentString(typeName)).drop(1)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayType apply(DataType x$2) {
                return ArrayType$.MODULE$.apply(x$2);
            }
        }) : None$.MODULE$));
    }

    private Option<DataType> toCatalystType(String typeName) {
        Object object;
        String string;
        String string2 = string = typeName;
        if (!("bool" != null ? !"bool".equals(string2) : string2 != null)) {
            object = new Some((Object)BooleanType$.MODULE$);
        } else {
            String string3 = string;
            if (!("bit" != null ? !"bit".equals(string3) : string3 != null)) {
                object = new Some((Object)BinaryType$.MODULE$);
            } else {
                String string4 = string;
                if (!("int2" != null ? !"int2".equals(string4) : string4 != null)) {
                    object = new Some((Object)ShortType$.MODULE$);
                } else {
                    String string5 = string;
                    if (!("int4" != null ? !"int4".equals(string5) : string5 != null)) {
                        object = new Some((Object)IntegerType$.MODULE$);
                    } else {
                        boolean bl;
                        String string6 = string;
                        if (!("int8" != null ? !"int8".equals(string6) : string6 != null)) {
                            bl = true;
                        } else {
                            String string7 = string;
                            bl = !("oid" != null ? !"oid".equals(string7) : string7 != null);
                        }
                        if (bl) {
                            object = new Some((Object)LongType$.MODULE$);
                        } else {
                            String string8 = string;
                            if (!("float4" != null ? !"float4".equals(string8) : string8 != null)) {
                                object = new Some((Object)FloatType$.MODULE$);
                            } else {
                                boolean bl2;
                                String string9 = string;
                                if (!("money" != null ? !"money".equals(string9) : string9 != null)) {
                                    bl2 = true;
                                } else {
                                    String string10 = string;
                                    bl2 = !("float8" != null ? !"float8".equals(string10) : string10 != null);
                                }
                                if (bl2) {
                                    object = new Some((Object)DoubleType$.MODULE$);
                                } else {
                                    boolean bl3;
                                    String string11 = string;
                                    if (!("text" != null ? !"text".equals(string11) : string11 != null)) {
                                        bl3 = true;
                                    } else {
                                        String string12 = string;
                                        if (!("varchar" != null ? !"varchar".equals(string12) : string12 != null)) {
                                            bl3 = true;
                                        } else {
                                            String string13 = string;
                                            if (!("char" != null ? !"char".equals(string13) : string13 != null)) {
                                                bl3 = true;
                                            } else {
                                                String string14 = string;
                                                if (!("cidr" != null ? !"cidr".equals(string14) : string14 != null)) {
                                                    bl3 = true;
                                                } else {
                                                    String string15 = string;
                                                    if (!("inet" != null ? !"inet".equals(string15) : string15 != null)) {
                                                        bl3 = true;
                                                    } else {
                                                        String string16 = string;
                                                        if (!("json" != null ? !"json".equals(string16) : string16 != null)) {
                                                            bl3 = true;
                                                        } else {
                                                            String string17 = string;
                                                            if (!("jsonb" != null ? !"jsonb".equals(string17) : string17 != null)) {
                                                                bl3 = true;
                                                            } else {
                                                                String string18 = string;
                                                                bl3 = !("uuid" != null ? !"uuid".equals(string18) : string18 != null);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (bl3) {
                                        object = new Some((Object)StringType$.MODULE$);
                                    } else {
                                        String string19 = string;
                                        if (!("bytea" != null ? !"bytea".equals(string19) : string19 != null)) {
                                            object = new Some((Object)BinaryType$.MODULE$);
                                        } else {
                                            boolean bl4;
                                            String string20 = string;
                                            if (!("timestamp" != null ? !"timestamp".equals(string20) : string20 != null)) {
                                                bl4 = true;
                                            } else {
                                                String string21 = string;
                                                if (!("timestamptz" != null ? !"timestamptz".equals(string21) : string21 != null)) {
                                                    bl4 = true;
                                                } else {
                                                    String string22 = string;
                                                    if (!("time" != null ? !"time".equals(string22) : string22 != null)) {
                                                        bl4 = true;
                                                    } else {
                                                        String string23 = string;
                                                        bl4 = !("timetz" != null ? !"timetz".equals(string23) : string23 != null);
                                                    }
                                                }
                                            }
                                            if (bl4) {
                                                object = new Some((Object)TimestampType$.MODULE$);
                                            } else {
                                                String string24 = string;
                                                if (!("date" != null ? !"date".equals(string24) : string24 != null)) {
                                                    object = new Some((Object)DateType$.MODULE$);
                                                } else {
                                                    String string25 = string;
                                                    object = !("numeric" != null ? !"numeric".equals(string25) : string25 != null) ? new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT()) : None$.MODULE$;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Some some;
        DataType dataType = dt;
        StringType$ stringType$ = StringType$.MODULE$;
        DataType dataType2 = dataType;
        if (!(stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null)) {
            some = new Some((Object)new JdbcType("TEXT", 1));
        } else {
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            DataType dataType3 = dataType;
            if (!(binaryType$ != null ? !binaryType$.equals(dataType3) : dataType3 != null)) {
                some = new Some((Object)new JdbcType("BYTEA", -2));
            } else {
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                DataType dataType4 = dataType;
                if (!(booleanType$ != null ? !booleanType$.equals(dataType4) : dataType4 != null)) {
                    some = new Some((Object)new JdbcType("BOOLEAN", 16));
                } else {
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    DataType dataType5 = dataType;
                    if (!(floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null)) {
                        some = new Some((Object)new JdbcType("FLOAT4", 6));
                    } else {
                        ArrayType arrayType;
                        DataType et;
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                        DataType dataType6 = dataType;
                        if (!(doubleType$ != null ? !doubleType$.equals(dataType6) : dataType6 != null)) {
                            some = new Some((Object)new JdbcType("FLOAT8", 8));
                        } else if (dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType) {
                            some = this.getJDBCType(et).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(JdbcType x$3) {
                                    return x$3.databaseTypeDefinition();
                                }
                            }).orElse((Function0)new Serializable(et){
                                public static final long serialVersionUID = 0L;
                                private final DataType et$1;

                                public final Option<String> apply() {
                                    return JdbcUtils$.MODULE$.getCommonJDBCType(this.et$1).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(JdbcType x$4) {
                                            return x$4.databaseTypeDefinition();
                                        }
                                    });
                                }
                                {
                                    this.et$1 = et$1;
                                }
                            }).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final JdbcType apply(String typeName) {
                                    return new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), 2003);
                                }
                            });
                        } else {
                            ByteType$ byteType$ = ByteType$.MODULE$;
                            DataType dataType7 = dataType;
                            if (!(byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null)) {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type in postgresql: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt})));
                            }
                            some = None$.MODULE$;
                        }
                    }
                }
            }
        }
        return some;
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
    }

    @Override
    public void beforeFetch(Connection connection, Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (new StringOps(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)"fetchsize", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "0";
            }
        }))).toInt() > 0) {
            connection.setAutoCommit(false);
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PostgresDialect$() {
        MODULE$ = this;
    }
}

