/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.AlterTableRenamePartitionCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001>\u0011\u0001%\u00117uKJ$\u0016M\u00197f%\u0016t\u0017-\\3QCJ$\u0018\u000e^5p]\u000e{W.\\1oI*\u00111\u0001B\u0001\bG>lW.\u00198e\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000e\u001fIA\u0011\u0011\u0003G\u0007\u0002%)\u00111\u0003F\u0001\bY><\u0017nY1m\u0015\t)b#A\u0003qY\u0006t7O\u0003\u0002\u0018\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001a%\tAA*Z1g\u001d>$W\r\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0003;bE2,g*Y7f+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u00031yG\u000e\u001a)beRLG/[8o+\u0005\u0019\u0004C\u0001\u001bI\u001d\t)TI\u0004\u00027\u0007:\u0011qG\u0011\b\u0003q\u0005s!!\u000f!\u000f\u0005izdBA\u001e?\u001b\u0005a$BA\u001f\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!a\u0006\u0004\n\u0005\u00113\u0012aB2bi\u0006dwnZ\u0005\u0003\r\u001e\u000bAbQ1uC2|w\rV=qKNT!\u0001\u0012\f\n\u0005%S%A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eT!AR$\t\u00111\u0003!\u0011#Q\u0001\nM\nQb\u001c7e!\u0006\u0014H/\u001b;j_:\u0004\u0003\u0002\u0003(\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002\u00199,w\u000fU1si&$\u0018n\u001c8\t\u0011A\u0003!\u0011#Q\u0001\nM\nQB\\3x!\u0006\u0014H/\u001b;j_:\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016A\u0002\u001fj]&$h\b\u0006\u0003U+Z;\u0006CA\u000e\u0001\u0011\u0015A\u0013\u000b1\u0001+\u0011\u0015\t\u0014\u000b1\u00014\u0011\u0015q\u0015\u000b1\u00014\u0011\u0015I\u0006\u0001\"\u0011[\u0003\r\u0011XO\u001c\u000b\u00037\"\u00042\u0001X1e\u001d\tivL\u0004\u0002<=&\t\u0011%\u0003\u0002aA\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\r\u0019V-\u001d\u0006\u0003A\u0002\u0002\"!\u001a4\u000e\u0003\u0019I!a\u001a\u0004\u0003\u0007I{w\u000fC\u0003j1\u0002\u0007!.\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002fW&\u0011AN\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b]\u0002\t\t\u0011\"\u0001p\u0003\u0011\u0019w\u000e]=\u0015\tQ\u0003\u0018O\u001d\u0005\bQ5\u0004\n\u00111\u0001+\u0011\u001d\tT\u000e%AA\u0002MBqAT7\u0011\u0002\u0003\u00071\u0007C\u0004u\u0001E\u0005I\u0011A;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taO\u000b\u0002+o.\n\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003{\u0002\n!\"\u00198o_R\fG/[8o\u0013\ty(PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0001\u0001#\u0003%\t!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0001\u0016\u0003g]D\u0011\"a\u0003\u0001#\u0003%\t!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011q\u0002\u0001\u0002\u0002\u0013\u0005\u0013\u0011C\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001e\u0005!!.\u0019<b\u0013\u0011\t\t#a\u0006\u0003\rM#(/\u001b8h\u0011%\t)\u0003AA\u0001\n\u0003\t9#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002*A\u0019q$a\u000b\n\u0007\u00055\u0002EA\u0002J]RD\u0011\"!\r\u0001\u0003\u0003%\t!a\r\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QGA\u001e!\ry\u0012qG\u0005\u0004\u0003s\u0001#aA!os\"Q\u0011QHA\u0018\u0003\u0003\u0005\r!!\u000b\u0002\u0007a$\u0013\u0007C\u0005\u0002B\u0001\t\t\u0011\"\u0011\u0002D\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002FA1\u0011qIA'\u0003ki!!!\u0013\u000b\u0007\u0005-\u0003%\u0001\u0006d_2dWm\u0019;j_:LA!a\u0014\u0002J\tA\u0011\n^3sCR|'\u000fC\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002X\u0005u\u0003cA\u0010\u0002Z%\u0019\u00111\f\u0011\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QHA)\u0003\u0003\u0005\r!!\u000e\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\r\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002X\u0005\u0015\u0004BCA\u001f\u0003?\n\t\u00111\u0001\u00026\u001dI\u0011\u0011\u000e\u0002\u0002\u0002#\u0005\u00111N\u0001!\u00032$XM\u001d+bE2,'+\u001a8b[\u0016\u0004\u0016M\u001d;ji&|gnQ8n[\u0006tG\rE\u0002\u001c\u0003[2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qN\n\u0006\u0003[\n\t\b\n\t\t\u0003g\nIHK\u001a4)6\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0002\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003w\n)HA\tBEN$(/Y2u\rVt7\r^5p]NBqAUA7\t\u0003\ty\b\u0006\u0002\u0002l!Q\u00111QA7\u0003\u0003%)%!\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0005\t\u0015\u0005%\u0015QNA\u0001\n\u0003\u000bY)A\u0003baBd\u0017\u0010F\u0004U\u0003\u001b\u000by)!%\t\r!\n9\t1\u0001+\u0011\u0019\t\u0014q\u0011a\u0001g!1a*a\"A\u0002MB!\"!&\u0002n\u0005\u0005I\u0011QAL\u0003\u001d)h.\u00199qYf$B!!'\u0002&B)q$a'\u0002 &\u0019\u0011Q\u0014\u0011\u0003\r=\u0003H/[8o!\u0019y\u0012\u0011\u0015\u00164g%\u0019\u00111\u0015\u0011\u0003\rQ+\b\u000f\\34\u0011%\t9+a%\u0002\u0002\u0003\u0007A+A\u0002yIAB!\"a+\u0002n\u0005\u0005I\u0011BAW\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0006\u0003BA\u000b\u0003cKA!a-\u0002\u0018\t1qJ\u00196fGR\u0004")
public class AlterTableRenamePartitionCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Map<String, String> oldPartition;
    private final Map<String, String> newPartition;

    public static Function1<Tuple3<TableIdentifier, Map<String, String>, Map<String, String>>, AlterTableRenamePartitionCommand> tupled() {
        return AlterTableRenamePartitionCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Map<String, String>, Function1<Map<String, String>, AlterTableRenamePartitionCommand>>> curried() {
        return AlterTableRenamePartitionCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Map<String, String> oldPartition() {
        return this.oldPartition;
    }

    public Map<String, String> newPartition() {
        return this.newPartition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog2 = sparkSession.sessionState().catalog();
        CatalogTable table = catalog2.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog2, table, false);
        DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE RENAME PARTITION");
        Map<String, String> normalizedOldPartition = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.oldPartition(), (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
        Map<String, String> normalizedNewPartition = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.newPartition(), (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
        catalog2.renamePartitions(this.tableName(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{normalizedOldPartition})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{normalizedNewPartition})));
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableRenamePartitionCommand copy(TableIdentifier tableName, Map<String, String> oldPartition, Map<String, String> newPartition) {
        return new AlterTableRenamePartitionCommand(tableName, oldPartition, newPartition);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Map<String, String> copy$default$2() {
        return this.oldPartition();
    }

    public Map<String, String> copy$default$3() {
        return this.newPartition();
    }

    public String productPrefix() {
        return "AlterTableRenamePartitionCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                tableIdentifier = this.newPartition();
                break;
            }
            case 1: {
                tableIdentifier = this.oldPartition();
                break;
            }
            case 0: {
                tableIdentifier = this.tableName();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenamePartitionCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenamePartitionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenamePartitionCommand alterTableRenamePartitionCommand = (AlterTableRenamePartitionCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRenamePartitionCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map2 = this.oldPartition();
        Map<String, String> map3 = alterTableRenamePartitionCommand.oldPartition();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        Map<String, String> map4 = this.newPartition();
        Map<String, String> map5 = alterTableRenamePartitionCommand.newPartition();
        if (map4 == null) {
            if (map5 != null) {
                return false;
            }
        } else if (!map4.equals(map5)) return false;
        if (!alterTableRenamePartitionCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRenamePartitionCommand(TableIdentifier tableName, Map<String, String> oldPartition, Map<String, String> newPartition) {
        this.tableName = tableName;
        this.oldPartition = oldPartition;
        this.newPartition = newPartition;
        Command.class.$init$((Command)this);
    }
}

