/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.streaming.RateSourceProvider$;
import org.apache.spark.sql.execution.streaming.RateStreamSource;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u001f\t\u0011\"+\u0019;f'>,(oY3Qe>4\u0018\u000eZ3s\u0015\t\u0019A!A\u0005tiJ,\u0017-\\5oO*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00179A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u000fM|WO]2fg&\u00111\u0004\u0007\u0002\u0015'R\u0014X-Y7T_V\u00148-\u001a)s_ZLG-\u001a:\u0011\u0005]i\u0012B\u0001\u0010\u0019\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"B\u0013\u0001\t\u00032\u0013\u0001D:pkJ\u001cWmU2iK6\fG#B\u00148{\t#\u0005\u0003B\t)UEJ!!\u000b\n\u0003\rQ+\b\u000f\\33!\tYcF\u0004\u0002\u0012Y%\u0011QFE\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$AB*ue&twM\u0003\u0002.%A\u0011!'N\u0007\u0002g)\u0011AGB\u0001\u0006if\u0004Xm]\u0005\u0003mM\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015AD\u00051\u0001:\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003umj\u0011AB\u0005\u0003y\u0019\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0015qD\u00051\u0001@\u0003\u0019\u00198\r[3nCB\u0019\u0011\u0003Q\u0019\n\u0005\u0005\u0013\"AB(qi&|g\u000eC\u0003DI\u0001\u0007!&\u0001\u0007qe>4\u0018\u000eZ3s\u001d\u0006lW\rC\u0003FI\u0001\u0007a)\u0001\u0006qCJ\fW.\u001a;feN\u0004BaK$+U%\u0011\u0001\n\r\u0002\u0004\u001b\u0006\u0004\b\"\u0002&\u0001\t\u0003Z\u0015\u0001D2sK\u0006$XmU8ve\u000e,GC\u0002'P!J\u001bF\u000b\u0005\u0002$\u001b&\u0011aJ\u0001\u0002\u0007'>,(oY3\t\u000baJ\u0005\u0019A\u001d\t\u000bEK\u0005\u0019\u0001\u0016\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\t\u000byJ\u0005\u0019A \t\u000b\rK\u0005\u0019\u0001\u0016\t\u000b\u0015K\u0005\u0019\u0001$\t\u000bY\u0003A\u0011I,\u0002\u0013MDwN\u001d;OC6,G#\u0001\u0016\b\u000be\u0013\u0001\u0012\u0001.\u0002%I\u000bG/Z*pkJ\u001cW\r\u0015:pm&$WM\u001d\t\u0003Gm3Q!\u0001\u0002\t\u0002q\u001b\"a\u0017\t\t\u000b\u0001ZF\u0011\u00010\u0015\u0003iCq\u0001Y.C\u0002\u0013\u0005\u0011-\u0001\u0004T\u0007\"+U*Q\u000b\u0002c!11m\u0017Q\u0001\nE\nqaU\"I\u000b6\u000b\u0005\u0005C\u0004f7\n\u0007I\u0011\u00014\u0002\u000fY+%kU%P\u001dV\tq\r\u0005\u0002\u0012Q&\u0011\u0011N\u0005\u0002\u0004\u0013:$\bBB6\\A\u0003%q-\u0001\u0005W\u000bJ\u001b\u0016j\u0014(!\u0001")
public class RateSourceProvider
implements StreamSourceProvider,
DataSourceRegister {
    public static int VERSION() {
        return RateSourceProvider$.MODULE$.VERSION();
    }

    public static StructType SCHEMA() {
        return RateSourceProvider$.MODULE$.SCHEMA();
    }

    @Override
    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        return new Tuple2((Object)this.shortName(), (Object)RateSourceProvider$.MODULE$.SCHEMA());
    }

    @Override
    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        CaseInsensitiveMap params = CaseInsensitiveMap$.MODULE$.apply(parameters);
        long rowsPerSecond = BoxesRunTime.unboxToLong((Object)params.get("rowsPerSecond").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 1L;
            }
        }));
        if (rowsPerSecond <= 0L) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'rowsPerSecond' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.apply((Object)"rowsPerSecond")}))).append((Object)"must be positive").toString());
        }
        long rampUpTimeSeconds = BoxesRunTime.unboxToLong((Object)params.get("rampUpTime").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$2) {
                return JavaUtils.timeStringAsSec((String)x$2);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        if (rampUpTimeSeconds < 0L) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'rampUpTime' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.apply((Object)"rampUpTime")}))).append((Object)"must not be negative").toString());
        }
        int numPartitions = BoxesRunTime.unboxToInt((Object)params.get("numPartitions").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.sqlContext$1.sparkContext().defaultParallelism();
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        }));
        if (numPartitions <= 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "'. The option 'numPartitions' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.apply((Object)"numPartitions")}))).append((Object)"must be positive").toString());
        }
        return new RateStreamSource(sqlContext, metadataPath, rowsPerSecond, rampUpTimeSeconds, numPartitions, BoxesRunTime.unboxToBoolean((Object)params.get("useManualClock").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        })));
    }

    @Override
    public String shortName() {
        return "rate";
    }
}

