/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001>\u0011q\u0002T8bI\u0012\u000bG/Y\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\tqaY8n[\u0006tGM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001AQb\u0004\n\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0016-\u0005)\u0001\u000f\\1og*\u0011qCB\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011D\u0005\u0002\t\u0019\u0016\fgMT8eKB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u0010%Vtg.\u00192mK\u000e{W.\\1oIB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9\u0001K]8ek\u000e$\bCA\u0010&\u0013\t1\u0003E\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005)\u0001\tU\r\u0011\"\u0001*\u0003\u0015!\u0018M\u00197f+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\rQ\f'\r\\3!\u0011!\t\u0004A!f\u0001\n\u0003\u0011\u0014\u0001\u00029bi\",\u0012a\r\t\u0003i]r!aH\u001b\n\u0005Y\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\u0011\t\u0011m\u0002!\u0011#Q\u0001\nM\nQ\u0001]1uQ\u0002B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tAP\u0001\bSNdunY1m+\u0005y\u0004CA\u0010A\u0013\t\t\u0005EA\u0004C_>dW-\u00198\t\u0011\r\u0003!\u0011#Q\u0001\n}\n\u0001\"[:M_\u000e\fG\u000e\t\u0005\t\u000b\u0002\u0011)\u001a!C\u0001}\u0005Y\u0011n](wKJ<(/\u001b;f\u0011!9\u0005A!E!\u0002\u0013y\u0014\u0001D5t\u001fZ,'o\u001e:ji\u0016\u0004\u0003\u0002C%\u0001\u0005+\u0007I\u0011\u0001&\u0002\u0013A\f'\u000f^5uS>tW#A&\u0011\u0007}ae*\u0003\u0002NA\t1q\n\u001d;j_:\u0004\"aT2\u000f\u0005A\u0003gBA)_\u001d\t\u0011VL\u0004\u0002T9:\u0011Ak\u0017\b\u0003+js!AV-\u000e\u0003]S!\u0001\u0017\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003?Z\tqaY1uC2|w-\u0003\u0002bE\u0006a1)\u0019;bY><G+\u001f9fg*\u0011qLF\u0005\u0003I\u0016\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011\u0011M\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005\u0017\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000b%\u0004A\u0011\u00016\u0002\rqJg.\u001b;?)\u0019YG.\u001c8paB\u00111\u0004\u0001\u0005\u0006Q!\u0004\rA\u000b\u0005\u0006c!\u0004\ra\r\u0005\u0006{!\u0004\ra\u0010\u0005\u0006\u000b\"\u0004\ra\u0010\u0005\u0006\u0013\"\u0004\ra\u0013\u0005\u0006e\u0002!\te]\u0001\u0004eVtGc\u0001;\u0002\u0004A\u0019QO_?\u000f\u0005YDhB\u0001,x\u0013\u0005\t\u0013BA=!\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0007M+\u0017O\u0003\u0002zAA\u0011ap`\u0007\u0002\r%\u0019\u0011\u0011\u0001\u0004\u0003\u0007I{w\u000fC\u0004\u0002\u0006E\u0004\r!a\u0002\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0007y\fI!C\u0002\u0002\f\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\u0002\t\r|\u0007/\u001f\u000b\fW\u0006M\u0011QCA\f\u00033\tY\u0002\u0003\u0005)\u0003\u001b\u0001\n\u00111\u0001+\u0011!\t\u0014Q\u0002I\u0001\u0002\u0004\u0019\u0004\u0002C\u001f\u0002\u000eA\u0005\t\u0019A \t\u0011\u0015\u000bi\u0001%AA\u0002}B\u0001\"SA\u0007!\u0003\u0005\ra\u0013\u0005\n\u0003?\u0001\u0011\u0013!C\u0001\u0003C\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002$)\u001a!&!\n,\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\r!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\tYCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u000f\u0001#\u0003%\t!a\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\b\u0016\u0004g\u0005\u0015\u0002\"CA!\u0001E\u0005I\u0011AA\"\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u0012+\u0007}\n)\u0003C\u0005\u0002J\u0001\t\n\u0011\"\u0001\u0002D\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004\"CA'\u0001E\u0005I\u0011AA(\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!!\u0015+\u0007-\u000b)\u0003C\u0005\u0002V\u0001\t\t\u0011\"\u0011\u0002X\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005!A.\u00198h\u0015\t\t\u0019'\u0001\u0003kCZ\f\u0017b\u0001\u001d\u0002^!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111N\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003[\u00022aHA8\u0013\r\t\t\b\t\u0002\u0004\u0013:$\b\"CA;\u0001\u0005\u0005I\u0011AA<\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001f\u0002\u0000A\u0019q$a\u001f\n\u0007\u0005u\u0004EA\u0002B]fD!\"!!\u0002t\u0005\u0005\t\u0019AA7\u0003\rAH%\r\u0005\n\u0003\u000b\u0003\u0011\u0011!C!\u0003\u000f\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0013\u0003b!a#\u0002\u0012\u0006eTBAAG\u0015\r\ty\tI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAJ\u0003\u001b\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003/\u0003\u0011\u0011!C\u0001\u00033\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u007f\u0005m\u0005BCAA\u0003+\u000b\t\u00111\u0001\u0002z!I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0013\u0011U\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\n\u0019\u000b\u0003\u0006\u0002\u0002\u0006u\u0015\u0011!a\u0001\u0003s:\u0011\"a*\u0003\u0003\u0003E\t!!+\u0002\u001f1{\u0017\r\u001a#bi\u0006\u001cu.\\7b]\u0012\u00042aGAV\r!\t!!!A\t\u0002\u000556#BAV\u0003_#\u0003CCAY\u0003oS3gP LW6\u0011\u00111\u0017\u0006\u0004\u0003k\u0003\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003s\u000b\u0019LA\tBEN$(/Y2u\rVt7\r^5p]VBq![AV\t\u0003\ti\f\u0006\u0002\u0002*\"Q\u0011\u0011YAV\u0003\u0003%)%a1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0017\t\u0015\u0005\u001d\u00171VA\u0001\n\u0003\u000bI-A\u0003baBd\u0017\u0010F\u0006l\u0003\u0017\fi-a4\u0002R\u0006M\u0007B\u0002\u0015\u0002F\u0002\u0007!\u0006\u0003\u00042\u0003\u000b\u0004\ra\r\u0005\u0007{\u0005\u0015\u0007\u0019A \t\r\u0015\u000b)\r1\u0001@\u0011\u0019I\u0015Q\u0019a\u0001\u0017\"Q\u0011q[AV\u0003\u0003%\t)!7\u0002\u000fUt\u0017\r\u001d9msR!\u00111\\Ar!\u0011yB*!8\u0011\u0011}\tyNK\u001a@\u007f-K1!!9!\u0005\u0019!V\u000f\u001d7fk!I\u0011Q]Ak\u0003\u0003\u0005\ra[\u0001\u0004q\u0012\u0002\u0004BCAu\u0003W\u000b\t\u0011\"\u0003\u0002l\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u000f\u0005\u0003\u0002\\\u0005=\u0018\u0002BAy\u0003;\u0012aa\u00142kK\u000e$\b")
public class LoadDataCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final String path;
    private final boolean isLocal;
    private final boolean isOverwrite;
    private final Option<Map<String, String>> partition;

    public static Option<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>> unapply(LoadDataCommand loadDataCommand) {
        return LoadDataCommand$.MODULE$.unapply(loadDataCommand);
    }

    public static Function1<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>, LoadDataCommand> tupled() {
        return LoadDataCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<Object, Function1<Object, Function1<Option<Map<String, String>>, LoadDataCommand>>>>> curried() {
        return LoadDataCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String path() {
        return this.path;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isOverwrite() {
        return this.isOverwrite;
    }

    public Option<Map<String, String>> partition() {
        return this.partition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        URI loadPath;
        URI uRI;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable targetTable = catalog.getTableMetadata(this.table());
        String tableIdentwithDB = targetTable.identifier().quotedString();
        CatalogTableType catalogTableType = targetTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target table in LOAD DATA cannot be a view: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(targetTable)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA is not supported for datasource tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (targetTable.partitionColumnNames().nonEmpty()) {
            if (this.partition().isEmpty()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table ", " is partitioned, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but no partition spec is provided"})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (targetTable.partitionColumnNames().size() != ((TraversableOnce)this.partition().get()).size()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table ", " is partitioned, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but number of columns in provided partition spec (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((TraversableOnce)this.partition().get()).size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"do not match number of partitioned columns in table "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(s", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)targetTable.partitionColumnNames().size())}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            ((MapLike)this.partition().get()).keys().foreach((Function1)new Serializable(this, targetTable, tableIdentwithDB){
                public static final long serialVersionUID = 0L;
                private final CatalogTable targetTable$1;
                private final String tableIdentwithDB$1;

                public final void apply(String colName) {
                    if (this.targetTable$1.partitionColumnNames().contains((Object)colName)) {
                        return;
                    }
                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table ", " is partitioned, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentwithDB$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the specified partition spec refers to a column that is not partitioned: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                {
                    this.targetTable$1 = targetTable$1;
                    this.tableIdentwithDB$1 = tableIdentwithDB$1;
                }
            });
        } else if (this.partition().nonEmpty()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table ", " is not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned, but a partition spec was provided."})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isLocal()) {
            boolean exists;
            boolean bl;
            URI uri = Utils$.MODULE$.resolveURI(this.path());
            String filePath = uri.getPath();
            if (filePath.contains("*")) {
                FileSystem fileSystem = FileSystems.getDefault();
                Path pathPattern = fileSystem.getPath(filePath, new String[0]);
                String dir = ((Object)pathPattern.getParent()).toString();
                if (dir.contains("*")) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA input path allows only filename wildcard: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                File[] files = new File(dir).listFiles();
                if (files == null) {
                    bl = false;
                } else {
                    PathMatcher matcher = fileSystem.getPathMatcher(new StringBuilder().append((Object)"glob:").append((Object)pathPattern.toAbsolutePath()).toString());
                    bl = Predef$.MODULE$.refArrayOps((Object[])files).exists((Function1)new Serializable(this, fileSystem, matcher){
                        public static final long serialVersionUID = 0L;
                        private final FileSystem fileSystem$1;
                        private final PathMatcher matcher$1;

                        public final boolean apply(File f) {
                            return this.matcher$1.matches(this.fileSystem$1.getPath(f.getAbsolutePath(), new String[0]));
                        }
                        {
                            this.fileSystem$1 = fileSystem$1;
                            this.matcher$1 = matcher$1;
                        }
                    });
                }
            } else {
                bl = exists = new File(filePath).exists();
            }
            if (!exists) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA input path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            uRI = uri;
        } else {
            URI uri = new URI(this.path());
            if (uri.getScheme() == null || uri.getAuthority() == null) {
                String authority;
                String defaultFSConf = sparkSession.sessionState().newHadoopConf().get("fs.default.name");
                URI defaultFS = defaultFSConf == null ? new URI("") : new URI(defaultFSConf);
                String scheme = uri.getScheme() == null ? defaultFS.getScheme() : uri.getScheme();
                String string = authority = uri.getAuthority() == null ? defaultFS.getAuthority() : uri.getAuthority();
                if (scheme == null) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA: URI scheme is required for non-local input paths: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                String uriPath = uri.getPath();
                String absolutePath = uriPath != null && uriPath.startsWith("/") ? uriPath : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/user/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getProperty("user.name"), uriPath}));
                uRI = new URI(scheme, authority, absolutePath, uri.getQuery(), uri.getFragment());
            } else {
                uRI = loadPath = uri;
            }
        }
        if (this.partition().nonEmpty()) {
            catalog.loadPartition(targetTable.identifier(), loadPath.toString(), (Map)this.partition().get(), this.isOverwrite(), false, true);
            return (Seq)Seq$.MODULE$.empty();
        } else {
            catalog.loadTable(targetTable.identifier(), loadPath.toString(), this.isOverwrite(), false);
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public LoadDataCommand copy(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        return new LoadDataCommand(table, path, isLocal, isOverwrite, partition);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.isLocal();
    }

    public boolean copy$default$4() {
        return this.isOverwrite();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partition();
    }

    public String productPrefix() {
        return "LoadDataCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = this.partition();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isOverwrite());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isLocal());
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LoadDataCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LoadDataCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        LoadDataCommand loadDataCommand = (LoadDataCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = loadDataCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.path();
        String string2 = loadDataCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isLocal() != loadDataCommand.isLocal()) return false;
        if (this.isOverwrite() != loadDataCommand.isOverwrite()) return false;
        Option<Map<String, String>> option = this.partition();
        Option<Map<String, String>> option2 = loadDataCommand.partition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!loadDataCommand.canEqual(this)) return false;
        return true;
    }

    public LoadDataCommand(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        this.table = table;
        this.path = path;
        this.isLocal = isLocal;
        this.isOverwrite = isOverwrite;
        this.partition = partition;
        Command.class.$init$((Command)this);
    }
}

