/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PrunedInMemoryFileIndex;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001=\u0011\u0001cQ1uC2|wMR5mK&sG-\u001a=\u000b\u0005\r!\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u0013\u0019KG.Z%oI\u0016D\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005uqR\"\u0001\u0004\n\u0005}1!\u0001D*qCJ\\7+Z:tS>t\u0007\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000bQ\f'\r\\3\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000f\r\fG/\u00197pO*\u0011\u0001FB\u0001\tG\u0006$\u0018\r\\=ti&\u0011!&\n\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005G\u00051A/\u00192mK\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\teL\u0001\fg&TX-\u00138CsR,7/F\u00011!\t\t\u0012'\u0003\u00023%\t!Aj\u001c8h\u0011!!\u0004A!A!\u0002\u0013\u0001\u0014\u0001D:ju\u0016LeNQ=uKN\u0004\u0003\"\u0002\u001c\u0001\t\u00039\u0014A\u0002\u001fj]&$h\b\u0006\u00039siZ\u0004CA\f\u0001\u0011\u0015YR\u00071\u0001\u001d\u0011\u0015\tS\u00071\u0001$\u0011\u0015qS\u00071\u00011\u0011\u001di\u0004A1A\u0005\u0012y\n!\u0002[1e_>\u00048i\u001c8g+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0011S\u0011A\u00025bI>|\u0007/\u0003\u0002G\u0003\ni1i\u001c8gS\u001e,(/\u0019;j_:Da\u0001\u0013\u0001!\u0002\u0013y\u0014a\u00035bI>|\u0007oQ8oM\u0002BqA\u0013\u0001C\u0002\u0013%1*A\bgS2,7\u000b^1ukN\u001c\u0015m\u00195f+\u0005a\u0005CA\fN\u0013\tq%AA\bGS2,7\u000b^1ukN\u001c\u0015m\u00195f\u0011\u0019\u0001\u0006\u0001)A\u0005\u0019\u0006\u0001b-\u001b7f'R\fG/^:DC\u000eDW\r\t\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u00031\u0011\u0017m]3M_\u000e\fG/[8o+\u0005!\u0006cA\tV/&\u0011aK\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a[fBA\tZ\u0013\tQ&#\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.\u0013\u0011\u0019y\u0006\u0001)A\u0005)\u0006i!-Y:f\u0019>\u001c\u0017\r^5p]\u0002BQ!\u0019\u0001\u0005B\t\fq\u0002]1si&$\u0018n\u001c8TG\",W.Y\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011aMB\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0016\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015Q\u0007\u0001\"\u0011l\u0003%\u0011xn\u001c;QCRD7/F\u0001m!\riW\u000f\u001f\b\u0003]Nt!a\u001c:\u000e\u0003AT!!\u001d\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012B\u0001;\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0007M+\u0017O\u0003\u0002u%A\u0011\u0011\u0010`\u0007\u0002u*\u00111pQ\u0001\u0003MNL!! >\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u007f\u0002!\t%!\u0001\u0002\u00131L7\u000f\u001e$jY\u0016\u001cH\u0003BA\u0002\u0003\u0017\u0001B!\\;\u0002\u0006A\u0019q#a\u0002\n\u0007\u0005%!A\u0001\nQCJ$\u0018\u000e^5p]\u0012K'/Z2u_JL\bbBA\u0007}\u0002\u0007\u0011qB\u0001\bM&dG/\u001a:t!\u0011iW/!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005m\u0011Q\u0003\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\be\u00164'/Z:i)\t\t\u0019\u0003E\u0002\u0012\u0003KI1!a\n\u0013\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005\u0001b-\u001b7uKJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003_\t)\u0004E\u0002\u0018\u0003cI1!a\r\u0003\u0005EIe.T3n_JLh)\u001b7f\u0013:$W\r\u001f\u0005\t\u0003\u001b\tI\u00031\u0001\u0002\u0010!9\u0011\u0011\b\u0001\u0005B\u0005m\u0012AC5oaV$h)\u001b7fgV\u0011\u0011Q\b\t\u0005#\u0005}r+C\u0002\u0002BI\u0011Q!\u0011:sCfDq!!\u0012\u0001\t\u0003\n9%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0013\ny\u0005E\u0002\u0012\u0003\u0017J1!!\u0014\u0013\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0015\u0002D\u0001\u0007\u00111K\u0001\u0002_B\u0019\u0011#!\u0016\n\u0007\u0005]#CA\u0002B]fDq!a\u0017\u0001\t\u0003\ni&\u0001\u0005iCND7i\u001c3f)\t\ty\u0006E\u0002\u0012\u0003CJ1!a\u0019\u0013\u0005\rIe\u000e\u001e")
public class CatalogFileIndex
implements FileIndex {
    private final SparkSession sparkSession;
    private final CatalogTable table;
    private final long sizeInBytes;
    private final Configuration hadoopConf;
    private final FileStatusCache fileStatusCache;
    private final Option<String> baseLocation;

    public CatalogTable table() {
        return this.table;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileStatusCache fileStatusCache() {
        return this.fileStatusCache;
    }

    private Option<String> baseLocation() {
        return this.baseLocation;
    }

    @Override
    public StructType partitionSchema() {
        return this.table().partitionSchema();
    }

    @Override
    public Seq<Path> rootPaths() {
        return Option$.MODULE$.option2Iterable(this.baseLocation().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$1) {
                return new Path(x$1);
            }
        })).toSeq();
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> filters) {
        return this.filterPartitions(filters).listFiles((Seq<Expression>)Nil$.MODULE$);
    }

    @Override
    public void refresh() {
        this.fileStatusCache().invalidateAll();
    }

    public InMemoryFileIndex filterPartitions(Seq<Expression> filters) {
        InMemoryFileIndex inMemoryFileIndex;
        if (this.table().partitionColumnNames().nonEmpty()) {
            Seq selectedPartitions = this.sparkSession.sessionState().catalog().listPartitionsByFilter(this.table().identifier(), filters);
            Seq partitions = (Seq)selectedPartitions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CatalogFileIndex $outer;

                public final PartitionPath apply(CatalogTablePartition p) {
                    Path path = new Path(p.location());
                    FileSystem fs = path.getFileSystem(this.$outer.hadoopConf());
                    return new PartitionPath(p.toRow(this.$outer.partitionSchema()), path.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom());
            PartitionSpec partitionSpec2 = new PartitionSpec(this.partitionSchema(), (Seq<PartitionPath>)partitions);
            inMemoryFileIndex = new PrunedInMemoryFileIndex(this.sparkSession, new Path((String)this.baseLocation().get()), this.fileStatusCache(), partitionSpec2);
        } else {
            inMemoryFileIndex = new InMemoryFileIndex(this.sparkSession, this.rootPaths(), (Map<String, String>)this.table().storage().properties(), (Option<StructType>)None$.MODULE$, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        }
        return inMemoryFileIndex;
    }

    @Override
    public String[] inputFiles() {
        return this.filterPartitions((Seq<Expression>)Nil$.MODULE$).inputFiles();
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof CatalogFileIndex) {
            CatalogFileIndex catalogFileIndex = (CatalogFileIndex)object;
            TableIdentifier tableIdentifier = this.table().identifier();
            TableIdentifier tableIdentifier2 = catalogFileIndex.table().identifier();
            bl = !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.table().identifier().hashCode();
    }

    public CatalogFileIndex(SparkSession sparkSession, CatalogTable table, long sizeInBytes2) {
        this.sparkSession = sparkSession;
        this.table = table;
        this.sizeInBytes = sizeInBytes2;
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fileStatusCache = FileStatusCache$.MODULE$.newCache(sparkSession);
        Predef$.MODULE$.assert(table.identifier().database().isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The table identifier must be qualified in CatalogFileIndex";
            }
        });
        this.baseLocation = table.storage().locationUri();
    }
}

