/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.Platform;

public final class OffHeapColumnVector
extends ColumnVector {
    private static final boolean bigEndianPlatform = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private long nulls = 0L;
    private long data = 0L;
    private long lengthData = 0L;
    private long offsetData = 0L;

    protected OffHeapColumnVector(int capacity, DataType type) {
        super(capacity, type, MemoryMode.OFF_HEAP);
        this.reserveInternal(capacity);
        this.reset();
    }

    @Override
    public long valuesNativeAddress() {
        return this.data;
    }

    @Override
    public long nullsNativeAddress() {
        return this.nulls;
    }

    @Override
    public void close() {
        Platform.freeMemory((long)this.nulls);
        Platform.freeMemory((long)this.data);
        Platform.freeMemory((long)this.lengthData);
        Platform.freeMemory((long)this.offsetData);
        this.nulls = 0L;
        this.data = 0L;
        this.lengthData = 0L;
        this.offsetData = 0L;
    }

    @Override
    public void putNotNull(int rowId) {
        Platform.putByte(null, (long)(this.nulls + (long)rowId), (byte)0);
    }

    @Override
    public void putNull(int rowId) {
        Platform.putByte(null, (long)(this.nulls + (long)rowId), (byte)1);
        ++this.numNulls;
        this.anyNullsSet = true;
    }

    @Override
    public void putNulls(int rowId, int count2) {
        long offset = this.nulls + (long)rowId;
        int i = 0;
        while (i < count2) {
            Platform.putByte(null, (long)offset, (byte)1);
            ++i;
            ++offset;
        }
        this.anyNullsSet = true;
        this.numNulls += count2;
    }

    @Override
    public void putNotNulls(int rowId, int count2) {
        if (!this.anyNullsSet) {
            return;
        }
        long offset = this.nulls + (long)rowId;
        int i = 0;
        while (i < count2) {
            Platform.putByte(null, (long)offset, (byte)0);
            ++i;
            ++offset;
        }
    }

    @Override
    public boolean isNullAt(int rowId) {
        return Platform.getByte(null, (long)(this.nulls + (long)rowId)) == 1;
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        Platform.putByte(null, (long)(this.data + (long)rowId), (byte)((byte)(value ? 1 : 0)));
    }

    @Override
    public void putBooleans(int rowId, int count2, boolean value) {
        byte v = (byte)(value ? 1 : 0);
        for (int i = 0; i < count2; ++i) {
            Platform.putByte(null, (long)(this.data + (long)rowId + (long)i), (byte)v);
        }
    }

    @Override
    public boolean getBoolean(int rowId) {
        return Platform.getByte(null, (long)(this.data + (long)rowId)) == 1;
    }

    @Override
    public void putByte(int rowId, byte value) {
        Platform.putByte(null, (long)(this.data + (long)rowId), (byte)value);
    }

    @Override
    public void putBytes(int rowId, int count2, byte value) {
        for (int i = 0; i < count2; ++i) {
            Platform.putByte(null, (long)(this.data + (long)rowId + (long)i), (byte)value);
        }
    }

    @Override
    public void putBytes(int rowId, int count2, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)rowId), (long)count2);
    }

    @Override
    public byte getByte(int rowId) {
        if (this.dictionary == null) {
            return Platform.getByte(null, (long)(this.data + (long)rowId));
        }
        return (byte)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    @Override
    public void putShort(int rowId, short value) {
        Platform.putShort(null, (long)(this.data + (long)(2 * rowId)), (short)value);
    }

    @Override
    public void putShorts(int rowId, int count2, short value) {
        long offset = this.data + (long)(2 * rowId);
        int i = 0;
        while (i < count2) {
            Platform.putShort(null, (long)offset, (short)value);
            ++i;
            offset += 2L;
        }
    }

    @Override
    public void putShorts(int rowId, int count2, short[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.SHORT_ARRAY_OFFSET + srcIndex * 2), null, (long)(this.data + (long)(2 * rowId)), (long)(count2 * 2));
    }

    @Override
    public short getShort(int rowId) {
        if (this.dictionary == null) {
            return Platform.getShort(null, (long)(this.data + (long)(2 * rowId)));
        }
        return (short)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    @Override
    public void putInt(int rowId, int value) {
        Platform.putInt(null, (long)(this.data + (long)(4 * rowId)), (int)value);
    }

    @Override
    public void putInts(int rowId, int count2, int value) {
        long offset = this.data + (long)(4 * rowId);
        int i = 0;
        while (i < count2) {
            Platform.putInt(null, (long)offset, (int)value);
            ++i;
            offset += 4L;
        }
    }

    @Override
    public void putInts(int rowId, int count2, int[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.INT_ARRAY_OFFSET + srcIndex * 4), null, (long)(this.data + (long)(4 * rowId)), (long)(count2 * 4));
    }

    @Override
    public void putIntsLittleEndian(int rowId, int count2, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(srcIndex + Platform.BYTE_ARRAY_OFFSET), null, (long)(this.data + (long)(4 * rowId)), (long)(count2 * 4));
        } else {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            long offset = this.data + (long)(4 * rowId);
            int i = 0;
            while (i < count2) {
                Platform.putInt(null, (long)offset, (int)Integer.reverseBytes(Platform.getInt((Object)src, (long)srcOffset)));
                ++i;
                offset += 4L;
                srcOffset += 4;
            }
        }
    }

    @Override
    public int getInt(int rowId) {
        if (this.dictionary == null) {
            return Platform.getInt(null, (long)(this.data + (long)(4 * rowId)));
        }
        return this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    @Override
    public int getDictId(int rowId) {
        assert (this.dictionary == null) : "A ColumnVector dictionary should not have a dictionary for itself.";
        return Platform.getInt(null, (long)(this.data + (long)(4 * rowId)));
    }

    @Override
    public void putLong(int rowId, long value) {
        Platform.putLong(null, (long)(this.data + (long)(8 * rowId)), (long)value);
    }

    @Override
    public void putLongs(int rowId, int count2, long value) {
        long offset = this.data + (long)(8 * rowId);
        int i = 0;
        while (i < count2) {
            Platform.putLong(null, (long)offset, (long)value);
            ++i;
            offset += 8L;
        }
    }

    @Override
    public void putLongs(int rowId, int count2, long[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.LONG_ARRAY_OFFSET + srcIndex * 8), null, (long)(this.data + (long)(8 * rowId)), (long)(count2 * 8));
    }

    @Override
    public void putLongsLittleEndian(int rowId, int count2, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(srcIndex + Platform.BYTE_ARRAY_OFFSET), null, (long)(this.data + (long)(8 * rowId)), (long)(count2 * 8));
        } else {
            int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
            long offset = this.data + (long)(8 * rowId);
            int i = 0;
            while (i < count2) {
                Platform.putLong(null, (long)offset, (long)Long.reverseBytes(Platform.getLong((Object)src, (long)srcOffset)));
                ++i;
                offset += 8L;
                srcOffset += 8;
            }
        }
    }

    @Override
    public long getLong(int rowId) {
        if (this.dictionary == null) {
            return Platform.getLong(null, (long)(this.data + (long)(8 * rowId)));
        }
        return this.dictionary.decodeToLong(this.dictionaryIds.getDictId(rowId));
    }

    @Override
    public void putFloat(int rowId, float value) {
        Platform.putFloat(null, (long)(this.data + (long)(rowId * 4)), (float)value);
    }

    @Override
    public void putFloats(int rowId, int count2, float value) {
        long offset = this.data + (long)(4 * rowId);
        int i = 0;
        while (i < count2) {
            Platform.putFloat(null, (long)offset, (float)value);
            ++i;
            offset += 4L;
        }
    }

    @Override
    public void putFloats(int rowId, int count2, float[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.FLOAT_ARRAY_OFFSET + srcIndex * 4), null, (long)(this.data + (long)(4 * rowId)), (long)(count2 * 4));
    }

    @Override
    public void putFloats(int rowId, int count2, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)(rowId * 4)), (long)(count2 * 4));
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            long offset = this.data + (long)(4 * rowId);
            int i = 0;
            while (i < count2) {
                Platform.putFloat(null, (long)offset, (float)bb.getFloat(srcIndex + 4 * i));
                ++i;
                offset += 4L;
            }
        }
    }

    @Override
    public float getFloat(int rowId) {
        if (this.dictionary == null) {
            return Platform.getFloat(null, (long)(this.data + (long)(rowId * 4)));
        }
        return this.dictionary.decodeToFloat(this.dictionaryIds.getDictId(rowId));
    }

    @Override
    public void putDouble(int rowId, double value) {
        Platform.putDouble(null, (long)(this.data + (long)(rowId * 8)), (double)value);
    }

    @Override
    public void putDoubles(int rowId, int count2, double value) {
        long offset = this.data + (long)(8 * rowId);
        int i = 0;
        while (i < count2) {
            Platform.putDouble(null, (long)offset, (double)value);
            ++i;
            offset += 8L;
        }
    }

    @Override
    public void putDoubles(int rowId, int count2, double[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.DOUBLE_ARRAY_OFFSET + srcIndex * 8), null, (long)(this.data + (long)(8 * rowId)), (long)(count2 * 8));
    }

    @Override
    public void putDoubles(int rowId, int count2, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), null, (long)(this.data + (long)(rowId * 8)), (long)(count2 * 8));
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            long offset = this.data + (long)(8 * rowId);
            int i = 0;
            while (i < count2) {
                Platform.putDouble(null, (long)offset, (double)bb.getDouble(srcIndex + 8 * i));
                ++i;
                offset += 8L;
            }
        }
    }

    @Override
    public double getDouble(int rowId) {
        if (this.dictionary == null) {
            return Platform.getDouble(null, (long)(this.data + (long)(rowId * 8)));
        }
        return this.dictionary.decodeToDouble(this.dictionaryIds.getDictId(rowId));
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        assert (offset >= 0 && offset + length <= this.childColumns[0].capacity);
        Platform.putInt(null, (long)(this.lengthData + (long)(4 * rowId)), (int)length);
        Platform.putInt(null, (long)(this.offsetData + (long)(4 * rowId)), (int)offset);
    }

    @Override
    public int getArrayLength(int rowId) {
        return Platform.getInt(null, (long)(this.lengthData + (long)(4 * rowId)));
    }

    @Override
    public int getArrayOffset(int rowId) {
        return Platform.getInt(null, (long)(this.offsetData + (long)(4 * rowId)));
    }

    @Override
    public int putByteArray(int rowId, byte[] value, int offset, int length) {
        int result = this.arrayData().appendBytes(length, value, offset);
        Platform.putInt(null, (long)(this.lengthData + (long)(4 * rowId)), (int)length);
        Platform.putInt(null, (long)(this.offsetData + (long)(4 * rowId)), (int)result);
        return result;
    }

    @Override
    public void loadBytes(ColumnVector.Array array2) {
        if (array2.tmpByteArray.length < array2.length) {
            array2.tmpByteArray = new byte[array2.length];
        }
        Platform.copyMemory(null, (long)(this.data + (long)array2.offset), (Object)array2.tmpByteArray, (long)Platform.BYTE_ARRAY_OFFSET, (long)array2.length);
        array2.byteArray = array2.tmpByteArray;
        array2.byteArrayOffset = 0;
    }

    @Override
    protected void reserveInternal(int newCapacity) {
        if (this.resultArray != null) {
            this.lengthData = Platform.reallocateMemory((long)this.lengthData, (long)(this.elementsAppended * 4), (long)(newCapacity * 4));
            this.offsetData = Platform.reallocateMemory((long)this.offsetData, (long)(this.elementsAppended * 4), (long)(newCapacity * 4));
        } else if (this.type instanceof ByteType || this.type instanceof BooleanType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)this.elementsAppended, (long)newCapacity);
        } else if (this.type instanceof ShortType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)(this.elementsAppended * 2), (long)(newCapacity * 2));
        } else if (this.type instanceof IntegerType || this.type instanceof FloatType || this.type instanceof DateType || DecimalType.is32BitDecimalType((DataType)this.type)) {
            this.data = Platform.reallocateMemory((long)this.data, (long)(this.elementsAppended * 4), (long)(newCapacity * 4));
        } else if (this.type instanceof LongType || this.type instanceof DoubleType || DecimalType.is64BitDecimalType((DataType)this.type) || this.type instanceof TimestampType) {
            this.data = Platform.reallocateMemory((long)this.data, (long)(this.elementsAppended * 8), (long)(newCapacity * 8));
        } else if (this.resultStruct == null) {
            throw new RuntimeException("Unhandled " + this.type);
        }
        this.nulls = Platform.reallocateMemory((long)this.nulls, (long)this.elementsAppended, (long)newCapacity);
        Platform.setMemory((long)(this.nulls + (long)this.elementsAppended), (byte)0, (long)(newCapacity - this.elementsAppended));
        this.capacity = newCapacity;
    }
}

