/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001>\u0011Ad\u0011:fCR,G)\u0019;b'>,(oY3UC\ndWmQ8n[\u0006tGM\u0003\u0002\u0004\t\u000591m\\7nC:$'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!iqB\u0005\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u00059An\\4jG\u0006d'BA\u000b\u0017\u0003\u0015\u0001H.\u00198t\u0015\t9b!\u0001\u0005dCR\fG._:u\u0013\tI\"C\u0001\u0005MK\u00064gj\u001c3f!\tYB$D\u0001\u0003\u0013\ti\"AA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001d\u0001&o\u001c3vGR\u0004\"aH\u0013\n\u0005\u0019\u0002#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0015\u0001\u0005+\u0007I\u0011A\u0015\u0002\u000bQ\f'\r\\3\u0016\u0003)\u0002\"a\u000b\u0018\u000e\u00031R!!\f\f\u0002\u000f\r\fG/\u00197pO&\u0011q\u0006\f\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\tc\u0001\u0011\t\u0012)A\u0005U\u00051A/\u00192mK\u0002B\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001N\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t+\u0005)\u0004CA\u00107\u0013\t9\u0004EA\u0004C_>dW-\u00198\t\u0011e\u0002!\u0011#Q\u0001\nU\nq\"[4o_J,\u0017JZ#ySN$8\u000f\t\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007urt\b\u0005\u0002\u001c\u0001!)\u0001F\u000fa\u0001U!)1G\u000fa\u0001k!)\u0011\t\u0001C!\u0005\u0006\u0019!/\u001e8\u0015\u0005\r\u001b\u0006c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011:\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005-\u0003\u0013a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tY\u0005\u0005\u0005\u0002Q#6\ta!\u0003\u0002S\r\t\u0019!k\\<\t\u000bQ\u0003\u0005\u0019A+\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005A3\u0016BA,\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001dI\u0006!!A\u0005\u0002i\u000bAaY8qsR\u0019Qh\u0017/\t\u000f!B\u0006\u0013!a\u0001U!91\u0007\u0017I\u0001\u0002\u0004)\u0004b\u00020\u0001#\u0003%\taX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0001'F\u0001\u0016bW\u0005\u0011\u0007CA2i\u001b\u0005!'BA3g\u0003%)hn\u00195fG.,GM\u0003\u0002hA\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005%$'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"91\u000eAI\u0001\n\u0003a\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0002[*\u0012Q'\u0019\u0005\b_\u0002\t\t\u0011\"\u0011q\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\rM#(/\u001b8h\u0011\u001dQ\b!!A\u0005\u0002m\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001 \t\u0003?uL!A \u0011\u0003\u0007%sG\u000fC\u0005\u0002\u0002\u0001\t\t\u0011\"\u0001\u0002\u0004\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0003\u0003\u0017\u00012aHA\u0004\u0013\r\tI\u0001\t\u0002\u0004\u0003:L\b\u0002CA\u0007\u007f\u0006\u0005\t\u0019\u0001?\u0002\u0007a$\u0013\u0007C\u0005\u0002\u0012\u0001\t\t\u0011\"\u0011\u0002\u0014\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0016A1\u0011qCA\u000f\u0003\u000bi!!!\u0007\u000b\u0007\u0005m\u0001%\u0001\u0006d_2dWm\u0019;j_:LA!a\b\u0002\u001a\tA\u0011\n^3sCR|'\u000fC\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&\u0005A1-\u00198FcV\fG\u000eF\u00026\u0003OA!\"!\u0004\u0002\"\u0005\u0005\t\u0019AA\u0003\u0011%\tY\u0003AA\u0001\n\u0003\ni#\u0001\u0004fcV\fGn\u001d\u000b\u0004k\u0005=\u0002BCA\u0007\u0003S\t\t\u00111\u0001\u0002\u0006\u001dI\u00111\u0007\u0002\u0002\u0002#\u0005\u0011QG\u0001\u001d\u0007J,\u0017\r^3ECR\f7k\\;sG\u0016$\u0016M\u00197f\u0007>lW.\u00198e!\rY\u0012q\u0007\u0004\t\u0003\t\t\t\u0011#\u0001\u0002:M)\u0011qGA\u001eIA9\u0011QHA\"UUjTBAA \u0015\r\t\t\u0005I\u0001\beVtG/[7f\u0013\u0011\t)%a\u0010\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004<\u0003o!\t!!\u0013\u0015\u0005\u0005U\u0002BCA'\u0003o\t\t\u0011\"\u0012\u0002P\u0005AAo\\*ue&tw\rF\u0001r\u0011)\t\u0019&a\u000e\u0002\u0002\u0013\u0005\u0015QK\u0001\u0006CB\u0004H.\u001f\u000b\u0006{\u0005]\u0013\u0011\f\u0005\u0007Q\u0005E\u0003\u0019\u0001\u0016\t\rM\n\t\u00061\u00016\u0011)\ti&a\u000e\u0002\u0002\u0013\u0005\u0015qL\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t'!\u001c\u0011\u000b}\t\u0019'a\u001a\n\u0007\u0005\u0015\u0004E\u0001\u0004PaRLwN\u001c\t\u0006?\u0005%$&N\u0005\u0004\u0003W\u0002#A\u0002+va2,'\u0007C\u0005\u0002p\u0005m\u0013\u0011!a\u0001{\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005M\u0014qGA\u0001\n\u0013\t)(A\u0006sK\u0006$'+Z:pYZ,GCAA<!\r\u0011\u0018\u0011P\u0005\u0004\u0003w\u001a(AB(cU\u0016\u001cG\u000f")
public class CreateDataSourceTableCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final CatalogTable table;
    private final boolean ignoreIfExists;

    public static Option<Tuple2<CatalogTable, Object>> unapply(CreateDataSourceTableCommand createDataSourceTableCommand) {
        return CreateDataSourceTableCommand$.MODULE$.unapply(createDataSourceTableCommand);
    }

    public static Function1<Tuple2<CatalogTable, Object>, CreateDataSourceTableCommand> tupled() {
        return CreateDataSourceTableCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Object, CreateDataSourceTableCommand>> curried() {
        return CreateDataSourceTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public CatalogTable table() {
        return this.table;
    }

    public boolean ignoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        boolean x$36;
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null);
        Predef$.MODULE$.assert(this.table().provider().isDefined());
        SessionState sessionState2 = sparkSession.sessionState();
        if (sessionState2.catalog().tableExists(this.table().identifier())) {
            if (this.ignoreIfExists()) {
                return (Seq)Seq$.MODULE$.empty();
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().identifier().unquotedString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Option pathOption = this.table().storage().locationUri().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)x$1);
            }
        });
        Some x$8 = new Some(this.table().identifier().database().getOrElse((Function0)new Serializable(this, sessionState2){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$1;

            public final String apply() {
                return this.sessionState$1.catalog().getCurrentDatabase();
            }
            {
                this.sessionState$1 = sessionState$1;
            }
        }));
        String x$9 = this.table().identifier().copy$default$1();
        TableIdentifier x$10 = this.table().identifier().copy(x$9, (Option)x$8);
        boolean x$11 = sparkSession.sessionState().conf().manageFilesourcePartitions();
        CatalogTableType x$12 = this.table().copy$default$2();
        CatalogStorageFormat x$13 = this.table().copy$default$3();
        StructType x$14 = this.table().copy$default$4();
        Option x$15 = this.table().copy$default$5();
        Seq x$16 = this.table().copy$default$6();
        Option x$17 = this.table().copy$default$7();
        String x$18 = this.table().copy$default$8();
        long x$19 = this.table().copy$default$9();
        long x$20 = this.table().copy$default$10();
        Map x$21 = this.table().copy$default$11();
        Option x$22 = this.table().copy$default$12();
        Option x$23 = this.table().copy$default$13();
        Option x$24 = this.table().copy$default$14();
        Option x$25 = this.table().copy$default$15();
        Seq x$26 = this.table().copy$default$16();
        boolean x$27 = this.table().copy$default$18();
        CatalogTable tableWithDefaultOptions = this.table().copy(x$10, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$11, x$27);
        SparkSession x$28 = sparkSession;
        None$ x$29 = this.table().schema().isEmpty() ? None$.MODULE$ : new Some((Object)this.table().schema());
        Seq x$30 = this.table().partitionColumnNames();
        String x$31 = (String)this.table().provider().get();
        Option x$32 = this.table().bucketSpec();
        Map x$33 = this.table().storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        Some x$34 = new Some((Object)tableWithDefaultOptions);
        Seq<String> x$35 = DataSource$.MODULE$.apply$default$3();
        DataSource qual$1 = new DataSource(x$28, x$31, x$35, (Option<StructType>)x$29, (Seq<String>)x$30, (Option<BucketSpec>)x$32, (Map<String, String>)x$33, (Option<CatalogTable>)x$34);
        BaseRelation dataSource = qual$1.resolveRelation(x$36 = qual$1.resolveRelation$default$1());
        BaseRelation baseRelation = dataSource;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            CatalogTableType catalogTableType3 = this.table().tableType();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.EXTERNAL();
            if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null) && hadoopFsRelation.location().rootPaths().isEmpty()) {
                throw new AnalysisException("Cannot create a file-based external data source table without path", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (this.table().schema().nonEmpty()) {
            seq = this.table().partitionColumnNames();
        } else {
            Nil$ nil$;
            Predef$.MODULE$.assert(this.table().partitionColumnNames().isEmpty());
            BaseRelation baseRelation2 = dataSource;
            if (baseRelation2 instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation2;
                nil$ = Predef$.MODULE$.refArrayOps((Object[])hadoopFsRelation.partitionSchema().fieldNames()).toSeq();
            } else {
                nil$ = Nil$.MODULE$;
            }
            seq = nil$;
        }
        Seq partitionColumnNames = seq;
        StructType x$37 = dataSource.schema();
        Seq x$38 = partitionColumnNames;
        boolean x$39 = partitionColumnNames.nonEmpty() && sparkSession.sessionState().conf().manageFilesourcePartitions();
        TableIdentifier x$40 = this.table().copy$default$1();
        CatalogTableType x$41 = this.table().copy$default$2();
        CatalogStorageFormat x$42 = this.table().copy$default$3();
        Option x$43 = this.table().copy$default$5();
        Option x$44 = this.table().copy$default$7();
        String x$45 = this.table().copy$default$8();
        long x$46 = this.table().copy$default$9();
        long x$47 = this.table().copy$default$10();
        Map x$48 = this.table().copy$default$11();
        Option x$49 = this.table().copy$default$12();
        Option x$50 = this.table().copy$default$13();
        Option x$51 = this.table().copy$default$14();
        Option x$52 = this.table().copy$default$15();
        Seq x$53 = this.table().copy$default$16();
        boolean x$54 = this.table().copy$default$18();
        CatalogTable newTable = this.table().copy(x$40, x$41, x$42, x$37, x$43, x$38, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$39, x$54);
        sessionState2.catalog().createTable(newTable, false);
        return (Seq)Seq$.MODULE$.empty();
    }

    public CreateDataSourceTableCommand copy(CatalogTable table, boolean ignoreIfExists) {
        return new CreateDataSourceTableCommand(table, ignoreIfExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public boolean copy$default$2() {
        return this.ignoreIfExists();
    }

    public String productPrefix() {
        return "CreateDataSourceTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreIfExists());
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDataSourceTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateDataSourceTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createDataSourceTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        if (this.ignoreIfExists() != createDataSourceTableCommand.ignoreIfExists()) return false;
        if (!createDataSourceTableCommand.canEqual(this)) return false;
        return true;
    }

    public CreateDataSourceTableCommand(CatalogTable table, boolean ignoreIfExists) {
        this.table = table;
        this.ignoreIfExists = ignoreIfExists;
        Command.class.$init$((Command)this);
    }
}

