/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u00111$\u00117uKJ$\u0016M\u00197f\u0003\u0012$7i\u001c7v[:\u001c8i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\u0006i\u0006\u0014G.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0004uC\ndW\r\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u0005I1m\u001c7t)>\fE\rZ\u000b\u0002gA\u0019A\u0007P \u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002<A\u00059\u0001/Y2lC\u001e,\u0017BA\u001f?\u0005\r\u0019V-\u001d\u0006\u0003w\u0001\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0004\u0002\u000bQL\b/Z:\n\u0005\u0011\u000b%aC*ueV\u001cGOR5fY\u0012D\u0001B\u0012\u0001\u0003\u0012\u0003\u0006IaM\u0001\u000bG>d7\u000fV8BI\u0012\u0004\u0003\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\bF\u0002K\u00172\u0003\"a\u0007\u0001\t\u000b!:\u0005\u0019\u0001\u0016\t\u000bE:\u0005\u0019A\u001a\t\u000b9\u0003A\u0011I(\u0002\u0007I,h\u000e\u0006\u0002Q+B\u0019A\u0007P)\u0011\u0005I\u001bV\"\u0001\u0004\n\u0005Q3!a\u0001*po\")a+\u0014a\u0001/\u0006a1\u000f]1sWN+7o]5p]B\u0011!\u000bW\u0005\u00033\u001a\u0011Ab\u00159be.\u001cVm]:j_:DQa\u0017\u0001\u0005\nq\u000b\u0011D^3sS\u001aL\u0018\t\u001c;feR\u000b'\r\\3BI\u0012\u001cu\u000e\\;n]R\u0019QlY4\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0012aB2bi\u0006dwnZ\u0005\u0003E~\u0013AbQ1uC2|w\rV1cY\u0016DQ\u0001\u0019.A\u0002\u0011\u0004\"AX3\n\u0005\u0019|&AD*fgNLwN\\\"bi\u0006dwn\u001a\u0005\u0006Qi\u0003\rA\u000b\u0005\bS\u0002\t\t\u0011\"\u0001k\u0003\u0011\u0019w\u000e]=\u0015\u0007)[G\u000eC\u0004)QB\u0005\t\u0019\u0001\u0016\t\u000fEB\u0007\u0013!a\u0001g!9a\u000eAI\u0001\n\u0003y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002a*\u0012!&]\u0016\u0002eB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001e\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zi\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fm\u0004\u0011\u0013!C\u0001y\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#A?+\u0005M\n\b\u0002C@\u0001\u0003\u0003%\t%!\u0001\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005\u0019\u0019FO]5oO\"I\u0011Q\u0003\u0001\u0002\u0002\u0013\u0005\u0011qC\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00012aHA\u000e\u0013\r\ti\u0002\t\u0002\u0004\u0013:$\b\"CA\u0011\u0001\u0005\u0005I\u0011AA\u0012\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\n\u0002,A\u0019q$a\n\n\u0007\u0005%\u0002EA\u0002B]fD!\"!\f\u0002 \u0005\u0005\t\u0019AA\r\u0003\rAH%\r\u0005\n\u0003c\u0001\u0011\u0011!C!\u0003g\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0001b!a\u000e\u0002>\u0005\u0015RBAA\u001d\u0015\r\tY\u0004I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA \u0003s\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000b\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\ni\u0005E\u0002 \u0003\u0013J1!a\u0013!\u0005\u001d\u0011un\u001c7fC:D!\"!\f\u0002B\u0005\u0005\t\u0019AA\u0013\u0011%\t\t\u0006AA\u0001\n\u0003\n\u0019&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\n)\u0006\u0003\u0006\u0002.\u0005=\u0013\u0011!a\u0001\u0003K9\u0011\"!\u0017\u0003\u0003\u0003E\t!a\u0017\u00027\u0005cG/\u001a:UC\ndW-\u00113e\u0007>dW/\u001c8t\u0007>lW.\u00198e!\rY\u0012Q\f\u0004\t\u0003\t\t\t\u0011#\u0001\u0002`M)\u0011QLA1IA9\u00111MA5UMRUBAA3\u0015\r\t9\u0007I\u0001\beVtG/[7f\u0013\u0011\tY'!\u001a\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004I\u0003;\"\t!a\u001c\u0015\u0005\u0005m\u0003BCA:\u0003;\n\t\u0011\"\u0012\u0002v\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0004!Q\u0011\u0011PA/\u0003\u0003%\t)a\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b)\u000bi(a \t\r!\n9\b1\u0001+\u0011\u0019\t\u0014q\u000fa\u0001g!Q\u00111QA/\u0003\u0003%\t)!\"\u0002\u000fUt\u0017\r\u001d9msR!\u0011qQAJ!\u0015y\u0012\u0011RAG\u0013\r\tY\t\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b}\tyIK\u001a\n\u0007\u0005E\u0005E\u0001\u0004UkBdWM\r\u0005\n\u0003+\u000b\t)!AA\u0002)\u000b1\u0001\u001f\u00131\u0011)\tI*!\u0018\u0002\u0002\u0013%\u00111T\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u001eB!\u0011QAAP\u0013\u0011\t\t+a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableAddColumnsCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> colsToAdd;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand alterTableAddColumnsCommand) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(alterTableAddColumnsCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog2 = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(catalog2, this.table());
        try {
            sparkSession.catalog().uncacheTable(this.table().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().quotedString()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        catalog2.refreshTable(this.table());
        catalog2.alterTableDataSchema(this.table(), StructType$.MODULE$.apply((Seq)catalogTable.dataSchema().$plus$plus(this.colsToAdd(), Seq$.MODULE$.canBuildFrom())));
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private CatalogTable verifyAlterTableAddColumn(SessionCatalog catalog2, TableIdentifier table) {
        void var3_3;
        CatalogTable catalogTable = catalog2.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |ALTER ADD COLUMNS does not support views.\n          |You must drop and re-create the views for adding the new columns. Views: ", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get()).newInstance();
            boolean bl = obj instanceof JsonFileFormat ? true : (obj instanceof CSVFileFormat ? true : obj instanceof ParquetFileFormat);
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n              |ALTER ADD COLUMNS does not support datasource table with type ", ".\n              |You must drop and re-create the table for adding the new columns. Tables: ", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj, table})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        return var3_3;
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> colsToAdd) {
        return new AlterTableAddColumnsCommand(table, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.colsToAdd();
                break;
            }
            case 0: {
                tableIdentifier = this.table();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> colsToAdd) {
        this.table = table;
        this.colsToAdd = colsToAdd;
        Command.class.$init$((Command)this);
    }
}

