/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

@InterfaceStability.Evolving
public final class ColumnarArray
extends ArrayData {
    private final ColumnVector data;
    private final int offset;
    private final int length;

    public ColumnarArray(ColumnVector data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public int numElements() {
        return this.length;
    }

    public ArrayData copy() {
        throw new UnsupportedOperationException();
    }

    public boolean[] toBooleanArray() {
        return this.data.getBooleans(this.offset, this.length);
    }

    public byte[] toByteArray() {
        return this.data.getBytes(this.offset, this.length);
    }

    public short[] toShortArray() {
        return this.data.getShorts(this.offset, this.length);
    }

    public int[] toIntArray() {
        return this.data.getInts(this.offset, this.length);
    }

    public long[] toLongArray() {
        return this.data.getLongs(this.offset, this.length);
    }

    public float[] toFloatArray() {
        return this.data.getFloats(this.offset, this.length);
    }

    public double[] toDoubleArray() {
        return this.data.getDoubles(this.offset, this.length);
    }

    public Object[] array() {
        DataType dt = this.data.dataType();
        Object[] list = new Object[this.length];
        try {
            for (int i = 0; i < this.length; ++i) {
                if (this.data.isNullAt(this.offset + i)) continue;
                list[i] = this.get(i, dt);
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get the array", e);
        }
    }

    public boolean isNullAt(int ordinal) {
        return this.data.isNullAt(this.offset + ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.data.getBoolean(this.offset + ordinal);
    }

    public byte getByte(int ordinal) {
        return this.data.getByte(this.offset + ordinal);
    }

    public short getShort(int ordinal) {
        return this.data.getShort(this.offset + ordinal);
    }

    public int getInt(int ordinal) {
        return this.data.getInt(this.offset + ordinal);
    }

    public long getLong(int ordinal) {
        return this.data.getLong(this.offset + ordinal);
    }

    public float getFloat(int ordinal) {
        return this.data.getFloat(this.offset + ordinal);
    }

    public double getDouble(int ordinal) {
        return this.data.getDouble(this.offset + ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.data.getDecimal(this.offset + ordinal, precision, scale);
    }

    public UTF8String getUTF8String(int ordinal) {
        return this.data.getUTF8String(this.offset + ordinal);
    }

    public byte[] getBinary(int ordinal) {
        return this.data.getBinary(this.offset + ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        return this.data.getInterval(this.offset + ordinal);
    }

    public ColumnarRow getStruct(int ordinal, int numFields) {
        return this.data.getStruct(this.offset + ordinal);
    }

    public ColumnarArray getArray(int ordinal) {
        return this.data.getArray(this.offset + ordinal);
    }

    public ColumnarMap getMap(int ordinal) {
        return this.data.getMap(this.offset + ordinal);
    }

    public Object get(int ordinal, DataType dataType) {
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType t = (DecimalType)dataType;
            return this.getDecimal(ordinal, t.precision(), t.scale());
        }
        if (dataType instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType).fields().length);
        }
        if (dataType instanceof MapType) {
            return this.getMap(ordinal);
        }
        if (dataType instanceof CalendarIntervalType) {
            return this.getInterval(ordinal);
        }
        throw new UnsupportedOperationException("Datatype not supported " + dataType);
    }

    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setNullAt(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

