/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.EliminateBarriers$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class DDLUtils$ {
    public static final DDLUtils$ MODULE$;
    private final String HIVE_PROVIDER;

    static {
        new DDLUtils$();
    }

    public String HIVE_PROVIDER() {
        return this.HIVE_PROVIDER;
    }

    public boolean isHiveTable(CatalogTable table) {
        return this.isHiveTable((Option<String>)table.provider());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHiveTable(Option<String> provider) {
        if (!provider.isDefined()) return false;
        String string = ((String)provider.get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        if (!table.provider().isDefined()) return false;
        String string = ((String)table.provider().get()).toLowerCase(Locale.ROOT);
        String string2 = this.HIVE_PROVIDER();
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public void verifyPartitionProviderIsHive(SparkSession spark, CatalogTable table, String action) {
        String tableName = table.identifier().table();
        if (!spark.sqlContext().conf().manageFilesourcePartitions() && this.isDatasourceTable(table)) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not allowed on ", " since filesource partition management is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, tableName}))).append((Object)"disabled (spark.sql.hive.manageFilesourcePartitions = false).").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (!table.tracksPartitionsInCatalog() && this.isDatasourceTable(table)) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not allowed on ", " since its partition metadata is not stored in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, tableName}))).append((Object)"the Hive metastore. To import this information into the metastore, run ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`msck repair table ", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void verifyAlterTableType(SessionCatalog catalog2, CatalogTable tableMetadata, boolean isView) {
        if (!catalog2.isTemporaryTable(tableMetadata.identifier())) {
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !isView) {
                throw new AnalysisException("Cannot alter a view with ALTER TABLE. Please use ALTER VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && isView) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot alter a table with ALTER VIEW. Please use ALTER TABLE instead"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void checkDataColNames(CatalogTable table) {
        this.checkDataColNames(table, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])table.dataSchema().fieldNames()));
    }

    public void checkDataColNames(CatalogTable table, Seq<String> colNames) {
        table.provider().foreach((Function1)new Serializable(table, colNames){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$7;
            private final Seq colNames$1;

            /*
             * Unable to fully structure code
             */
            public final void apply(String x$12) {
                block9: {
                    block6: {
                        block8: {
                            block7: {
                                var2_2 = x$12.toLowerCase(Locale.ROOT);
                                v0 = DDLUtils$.MODULE$.HIVE_PROVIDER();
                                var3_3 = var2_2;
                                if (v0 != null ? v0.equals(var3_3) == false : var3_3 != null) break block6;
                                v1 = serde = this.table$7.storage().serde();
                                var6_5 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("orc").get()).serde();
                                if (v1 != null ? v1.equals(var6_5) == false : var6_5 != null) break block7;
                                OrcFileFormat$.MODULE$.checkFieldNames((Seq<String>)this.colNames$1);
                                v2 = BoxedUnit.UNIT;
                                break block8;
                            }
                            v3 = serde;
                            var7_6 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("parquet").get()).serde();
                            if (!(v3 == null ? var7_6 != null : v3.equals(var7_6) == false)) ** GOTO lbl-1000
                            v4 = serde;
                            var8_7 = new Some((Object)"parquet.hive.serde.ParquetHiveSerDe");
                            if (!(v4 != null ? v4.equals(var8_7) == false : var8_7 != null)) lbl-1000:
                            // 2 sources

                            {
                                ParquetSchemaConverter$.MODULE$.checkFieldNames((Seq<String>)this.colNames$1);
                                v2 = BoxedUnit.UNIT;
                            } else {
                                v2 = BoxedUnit.UNIT;
                            }
                        }
                        var4_8 = v2;
                        break block9;
                    }
                    if ("parquet".equals(var2_2)) {
                        ParquetSchemaConverter$.MODULE$.checkFieldNames((Seq<String>)this.colNames$1);
                        var4_9 = BoxedUnit.UNIT;
                    } else if ("orc".equals(var2_2)) {
                        OrcFileFormat$.MODULE$.checkFieldNames((Seq<String>)this.colNames$1);
                        var4_10 = BoxedUnit.UNIT;
                    } else {
                        var4_11 = BoxedUnit.UNIT;
                    }
                }
            }
            {
                this.table$7 = table$7;
                this.colNames$1 = colNames$1;
            }
        });
    }

    public void verifyNotReadPath(LogicalPlan query, Path outputPath) {
        Seq inputPaths = (Seq)EliminateBarriers$.MODULE$.apply(query).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Seq<Path> seq;
                LogicalRelation logicalRelation;
                BaseRelation r2;
                A1 A1 = x2;
                if (A1 instanceof LogicalRelation && (r2 = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)r2;
                    seq = hadoopFsRelation.location().rootPaths();
                } else {
                    seq = function1.apply(x2);
                }
                return (B1)seq;
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalRelation logicalRelation;
                BaseRelation r2;
                LogicalPlan logicalPlan2 = x2;
                boolean bl = logicalPlan2 instanceof LogicalRelation && (r2 = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) instanceof HadoopFsRelation;
                return bl;
            }
        }).flatten((Function1)Predef$.MODULE$.$conforms());
        if (inputPaths.contains((Object)outputPath)) {
            throw new AnalysisException("Cannot overwrite a path that is also being read from.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private DDLUtils$() {
        MODULE$ = this;
        this.HIVE_PROVIDER = "hive";
    }
}

