/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.WrappedString;
import scala.runtime.BoxesRunTime;

public final class CSVUtils$ {
    public static final CSVUtils$ MODULE$;

    static {
        new CSVUtils$();
    }

    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        Dataset<String> nonEmptyLines = lines.filter(functions$.MODULE$.length(functions$.MODULE$.trim(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$))).$greater(BoxesRunTime.boxToInteger((int)0)));
        return options.isCommentSet() ? nonEmptyLines.filter(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$).startsWith(((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString()).unary_$bang()) : nonEmptyLines;
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return iter.filter((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final CSVOptions options$1;

            public final boolean apply(String line) {
                return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(((Object)BoxesRunTime.boxToCharacter((char)this.options$1.comment())).toString());
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        return options.headerFlag() ? iter.filterNot((Function1)new Serializable(firstLine){
            public static final long serialVersionUID = 0L;
            private final String firstLine$1;

            public final boolean apply(String x$1) {
                String string = x$1;
                String string2 = this.firstLine$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.firstLine$1 = firstLine$1;
            }
        }) : iter;
    }

    public Iterator<String> skipComments(Iterator<String> iter, CSVOptions options) {
        Iterator iterator2;
        if (options.isCommentSet()) {
            String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            iterator2 = iter.dropWhile((Function1)new Serializable(commentPrefix){
                public static final long serialVersionUID = 0L;
                private final String commentPrefix$1;

                public final boolean apply(String line) {
                    return line.trim().isEmpty() || line.trim().startsWith(this.commentPrefix$1);
                }
                {
                    this.commentPrefix$1 = commentPrefix$1;
                }
            });
        } else {
            iterator2 = iter.dropWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$2) {
                    return x$2.trim().isEmpty();
                }
            });
        }
        return iterator2;
    }

    public Option<String> extractHeader(Iterator<String> iter, CSVOptions options) {
        Iterator<String> nonEmptyLines = this.skipComments(iter, options);
        return nonEmptyLines.hasNext() ? new Some(nonEmptyLines.next()) : None$.MODULE$;
    }

    public char toChar(String str2) throws IllegalArgumentException {
        char c;
        WrappedString wrappedString;
        block15: {
            int n;
            block7: {
                block14: {
                    Some some;
                    block13: {
                        Some some2;
                        block12: {
                            Some some3;
                            block11: {
                                Some some4;
                                block10: {
                                    Some some5;
                                    block9: {
                                        Some some6;
                                        block8: {
                                            block6: {
                                                int c2;
                                                char c3;
                                                wrappedString = Predef$.MODULE$.wrapString(str2);
                                                Some some7 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (!some7.isEmpty() && some7.get() != null && ((SeqLike)some7.get()).lengthCompare(0) == 0) {
                                                    throw new IllegalArgumentException("Delimiter cannot be empty string");
                                                }
                                                Some some8 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (!some8.isEmpty() && some8.get() != null && ((SeqLike)some8.get()).lengthCompare(1) == 0 && '\\' == (c3 = BoxesRunTime.unboxToChar((Object)((SeqLike)some8.get()).apply(0)))) {
                                                    throw new IllegalArgumentException("Single backslash is prohibited. It has special meaning as beginning of an escape sequence. To get the backslash character, pass a string with two backslashes as the delimiter.");
                                                }
                                                Some some9 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (some9.isEmpty() || some9.get() == null || ((SeqLike)some9.get()).lengthCompare(1) != 0) break block6;
                                                n = c2 = BoxesRunTime.unboxToChar((Object)((SeqLike)some9.get()).apply(0));
                                                break block7;
                                            }
                                            Some some10 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                            if (some10.isEmpty() || some10.get() == null || ((SeqLike)some10.get()).lengthCompare(2) != 0) break block8;
                                            char c4 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(0));
                                            char c5 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(1));
                                            if ('\\' != c4 || 't' != c5) break block8;
                                            n = 9;
                                            break block7;
                                        }
                                        if ((some6 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some6.get() == null || ((SeqLike)some6.get()).lengthCompare(2) != 0) break block9;
                                        char c6 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(0));
                                        char c7 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(1));
                                        if ('\\' != c6 || 'r' != c7) break block9;
                                        n = 13;
                                        break block7;
                                    }
                                    if ((some5 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some5.get() == null || ((SeqLike)some5.get()).lengthCompare(2) != 0) break block10;
                                    char c8 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(0));
                                    char c9 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(1));
                                    if ('\\' != c8 || 'b' != c9) break block10;
                                    n = 8;
                                    break block7;
                                }
                                if ((some4 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some4.get() == null || ((SeqLike)some4.get()).lengthCompare(2) != 0) break block11;
                                char c10 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(0));
                                char c11 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(1));
                                if ('\\' != c10 || 'f' != c11) break block11;
                                n = 12;
                                break block7;
                            }
                            if ((some3 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some3.get() == null || ((SeqLike)some3.get()).lengthCompare(2) != 0) break block12;
                            char c12 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(0));
                            char c13 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(1));
                            if ('\\' != c12 || '\"' != c13) break block12;
                            n = 34;
                            break block7;
                        }
                        if ((some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(2) != 0) break block13;
                        char c14 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(0));
                        char c15 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(1));
                        if ('\\' != c14 || '\'' != c15) break block13;
                        n = 39;
                        break block7;
                    }
                    if ((some = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block14;
                    char c16 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0));
                    char c17 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(1));
                    if ('\\' != c16 || '\\' != c17) break block14;
                    n = 92;
                    break block7;
                }
                String string = str2;
                String string2 = "\u0000";
                if (string != null ? !string.equals(string2) : string2 != null) break block15;
                n = 0;
            }
            return (char)n;
        }
        Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0)))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported special character for delimiter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delimiter cannot be more than one character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})));
    }

    public Dataset<String> sample(Dataset<String> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final CSVOptions options$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.options$3.samplingRatio())}));
            }
            {
                this.options$3 = options$3;
            }
        });
        return options.samplingRatio() > 0.99 ? csv : csv.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<String[]> sample(RDD<String[]> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final CSVOptions options$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.options$2.samplingRatio())}));
            }
            {
                this.options$2 = options$2;
            }
        });
        return options.samplingRatio() > 0.99 ? csv : csv.sample(false, options.samplingRatio(), 1L);
    }

    private CSVUtils$() {
        MODULE$ = this;
    }
}

