/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.io.File;
import java.net.URI;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.metric.SQLMetricsTestUtils;
import org.apache.spark.sql.execution.metric.SQLMetricsTestUtils$;
import org.apache.spark.sql.execution.metric.SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$;
import org.apache.spark.sql.execution.metric.SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$anonfun$apply$mcV$sp$1$;
import org.apache.spark.sql.execution.metric.SQLMetricsTestUtils$$anonfun$testSparkPlanMetrics$1$;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.apache.spark.sql.execution.ui.SparkPlanGraph$;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class SQLMetricsTestUtils$class {
    public static Set currentExecutionIds(SQLMetricsTestUtils $this) {
        $this.spark().sparkContext().listenerBus().waitUntilEmpty(10000L);
        return ((TraversableOnce)$this.statusStore().executionsList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(SQLExecutionUIData x$1) {
                return x$1.executionId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public static SQLAppStatusStore statusStore(SQLMetricsTestUtils $this) {
        return $this.spark().sharedState().statusStore();
    }

    public static void org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$verifyWriteDataMetrics(SQLMetricsTestUtils $this, Seq metricsValues, Function0 func) {
        int totalNumBytes;
        Set executionIds;
        Set<Object> previousExecutionIds = $this.currentExecutionIds();
        func.apply$mcV$sp();
        $this.spark().sparkContext().listenerBus().waitUntilEmpty(10000L);
        Set $org_scalatest_assert_macro_left = executionIds = (Set)$this.currentExecutionIds().diff(previousExecutionIds);
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        long executionId = BoxesRunTime.unboxToLong((Object)executionIds.head());
        SparkPlanGraphNode executedNode = (SparkPlanGraphNode)$this.statusStore().planGraph(executionId).nodes().head();
        Seq metricsNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of written files", "number of dynamic part", "number of output rows"}));
        Map metrics = $this.statusStore().executionMetrics(executionId);
        ((IterableLike)metricsNames.zip((GenIterable)metricsValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this, executedNode, metrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLMetricsTestUtils $outer;
            private final SparkPlanGraphNode executedNode$1;
            private final Map metrics$1;

            public final Assertion apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int metricValue;
                    String metricsName = (String)tuple2._1();
                    int expected2 = tuple2._2$mcI$sp();
                    Option sqlMetric = this.executedNode$1.metrics().find((Function1)new Serializable(this, metricsName){
                        public static final long serialVersionUID = 0L;
                        private final String metricsName$1;

                        public final boolean apply(SQLPlanMetric x$2) {
                            String string = x$2.name();
                            String string2 = this.metricsName$1;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.metricsName$1 = metricsName$1;
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sqlMetric.isDefined(), "sqlMetric.isDefined", Prettifier$.MODULE$.default());
                    ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                    long accumulatorId = ((SQLPlanMetric)sqlMetric.get()).accumulatorId();
                    int $org_scalatest_assert_macro_left = metricValue = new StringOps(Predef$.MODULE$.augmentString(((String)this.metrics$1.apply((Object)BoxesRunTime.boxToLong((long)accumulatorId))).replaceAll(",", ""))).toInt();
                    int $org_scalatest_assert_macro_right = expected2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertion assertion = ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                    return assertion;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executedNode$1 = executedNode$1;
                this.metrics$1 = metrics$1;
            }
        });
        SQLPlanMetric totalNumBytesMetric = (SQLPlanMetric)executedNode.metrics().find((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SQLPlanMetric x$3) {
                String string = x$3.name();
                String string2 = "bytes of written output";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).get();
        int $org_scalatest_assert_macro_left2 = totalNumBytes = new StringOps(Predef$.MODULE$.augmentString(((String)metrics.apply((Object)BoxesRunTime.boxToLong((long)totalNumBytesMetric.accumulatorId()))).replaceAll(",", ""))).toInt();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
    }

    public static void testMetricsNonDynamicPartition(SQLMetricsTestUtils $this, String dataFormat, String tableName) {
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)new Serializable($this, dataFormat, tableName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLMetricsTestUtils $outer;
            public final String dataFormat$1;
            public final String tableName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SQLMetricsTestUtils.class.getClassLoader());
                public final class Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
                    }

                    public Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$typecreator5$1(SQLMetricsTestUtils$.anonfun.testMetricsNonDynamicPartition.1 $outer) {
                    }
                }
                this.$outer.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 2)})), this.$outer.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$typecreator5$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format(this.dataFormat$1).mode("overwrite").saveAsTable(this.tableName$1);
                File tableLocation = new File(this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(this.tableName$1)).location());
                SQLMetricsTestUtils$class.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$verifyWriteDataMetrics(this.$outer, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 100})), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SQLMetricsTestUtils$.anonfun.testMetricsNonDynamicPartition.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SQLMetricsTestUtils.class.getClassLoader());
                        public final class Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$anonfun$apply$mcV$sp$1$$typecreator13$1
                        extends TypeCreator {
                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
                            }

                            public Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$anonfun$apply$mcV$sp$1$$typecreator13$1(SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$.anonfun.apply.mcV.sp.1 $outer) {
                            }
                        }
                        this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer().testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int i) {
                                return new Tuple2.mcII.sp(i, i + 1);
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom()), this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer().testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$anonfun$testMetricsNonDynamicPartition$1$$anonfun$apply$mcV$sp$1$$typecreator13$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).repartition(2).write().format(this.$outer.dataFormat$1).mode("overwrite").insertInto(this.$outer.tableName$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                int $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(tableLocation)).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$4) {
                        return x$4.getName().startsWith("part-");
                    }
                });
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            }

            public /* synthetic */ SQLMetricsTestUtils org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataFormat$1 = dataFormat$1;
                this.tableName$1 = tableName$1;
            }
        });
    }

    public static void testMetricsDynamicPartition(SQLMetricsTestUtils $this, String provider, String dataFormat, String tableName) {
        $this.withTempPath((Function1<File, BoxedUnit>)new Serializable($this, provider, dataFormat, tableName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLMetricsTestUtils $outer;
            private final String provider$1;
            public final String dataFormat$2;
            public final String tableName$2;

            public final void apply(File dir) {
                this.$outer.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |CREATE TABLE ", "(a int, b int)\n           |USING ", "\n           |PARTITIONED BY(a)\n           |LOCATION '", "'\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$2, this.provider$1, dir.toURI()})))).stripMargin());
                CatalogTable table = this.$outer.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(this.tableName$2));
                URI $org_scalatest_assert_macro_left = table.location();
                URI $org_scalatest_assert_macro_right = this.$outer.makeQualifiedPath(dir.getAbsolutePath());
                URI uRI = $org_scalatest_assert_macro_left;
                URI uRI2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
                ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                Dataset df3 = this.$outer.spark().range(0L, 40L, 1L, 1).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id a", "id b"}));
                SQLMetricsTestUtils$class.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$verifyWriteDataMetrics(this.$outer, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{40, 40, 80})), (Function0)new Serializable(this, df3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SQLMetricsTestUtils$.anonfun.testMetricsDynamicPartition.1 $outer;
                    private final Dataset df$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.df$1.union(this.df$1).repartition(2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer().testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})).write().format(this.$outer.dataFormat$2).mode("overwrite").insertInto(this.$outer.tableName$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.df$1 = df$1;
                    }
                });
                int $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(dir)).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$5) {
                        return x$5.getName().startsWith("part-");
                    }
                });
                int $org_scalatest_assert_macro_right2 = 40;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            }

            public /* synthetic */ SQLMetricsTestUtils org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.provider$1 = provider$1;
                this.dataFormat$2 = dataFormat$2;
                this.tableName$2 = tableName$2;
            }
        });
    }

    public static Option getSparkPlanMetrics(SQLMetricsTestUtils $this, Dataset df3, int expectedNumOfJobs, Set expectedNodeIds, boolean enableWholeStage) {
        None$ none$;
        Set<Object> previousExecutionIds = $this.currentExecutionIds();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.codegen.wholeStage"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableWholeStage)).toString())}), (Function0<BoxedUnit>)new Serializable($this, df3){
            public static final long serialVersionUID = 0L;
            private final Dataset df$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.df$2.collect();
            }
            {
                this.df$2 = df$2;
            }
        });
        $this.sparkContext().listenerBus().waitUntilEmpty(10000L);
        Set executionIds = (Set)$this.currentExecutionIds().diff(previousExecutionIds);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)BoxesRunTime.boxToInteger((int)executionIds.size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        long executionId = BoxesRunTime.unboxToLong((Object)executionIds.head());
        Map jobs = ((SQLExecutionUIData)$this.statusStore().execution(executionId).get()).jobs();
        int $org_scalatest_assert_macro_left2 = jobs.size();
        int $org_scalatest_assert_macro_right2 = expectedNumOfJobs;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        if (jobs.size() == expectedNumOfJobs) {
            Map metricValues = $this.statusStore().executionMetrics(executionId);
            Map metrics = ((TraversableOnce)((TraversableLike)SparkPlanGraph$.MODULE$.apply(SparkPlanInfo$.MODULE$.fromSparkPlan(df3.queryExecution().executedPlan())).allNodes().filter((Function1)new Serializable($this, expectedNodeIds){
                public static final long serialVersionUID = 0L;
                private final Set expectedNodeIds$1;

                public final boolean apply(SparkPlanGraphNode node) {
                    return this.expectedNodeIds$1.contains((Object)BoxesRunTime.boxToLong((long)node.id()));
                }
                {
                    this.expectedNodeIds$1 = expectedNodeIds$1;
                }
            })).map((Function1)new Serializable($this, metricValues){
                public static final long serialVersionUID = 0L;
                public final Map metricValues$1;

                public final Tuple2<Object, Tuple2<String, Map<String, String>>> apply(SparkPlanGraphNode node) {
                    Map nodeMetrics = ((TraversableOnce)node.metrics().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SQLMetricsTestUtils$.anonfun.6 $outer;

                        public final Tuple2<String, String> apply(SQLPlanMetric metric) {
                            String metricValue = (String)this.$outer.metricValues$1.apply((Object)BoxesRunTime.boxToLong((long)metric.accumulatorId()));
                            return new Tuple2((Object)metric.name(), (Object)metricValue);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)node.id()), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node.name()), (Object)nodeMetrics));
                }
                {
                    this.metricValues$1 = metricValues$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            none$ = new Some((Object)metrics);
        } else {
            ((Logging)$this).logWarning((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Due to a race condition, we miss some jobs and cannot verify the metric values";
                }
            });
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static boolean getSparkPlanMetrics$default$4(SQLMetricsTestUtils $this) {
        return false;
    }

    public static void testSparkPlanMetrics(SQLMetricsTestUtils $this, Dataset df3, int expectedNumOfJobs, Map expectedMetrics) {
        Option<Map<Object, Tuple2<String, Map<String, Object>>>> optActualMetrics = $this.getSparkPlanMetrics((Dataset<Row>)df3, expectedNumOfJobs, (Set<Object>)expectedMetrics.keySet(), $this.getSparkPlanMetrics$default$4());
        optActualMetrics.foreach((Function1)new Serializable($this, expectedMetrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLMetricsTestUtils $outer;
            public final Map expectedMetrics$1;

            public final void apply(Map<Object, Tuple2<String, Map<String, Object>>> actualMetrics) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this.$outer).convertToEqualizer((Object)this.expectedMetrics$1.keySet());
                Set $org_scalatest_assert_macro_right = actualMetrics.keySet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                ((Assertions)this.$outer).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                this.expectedMetrics$1.keySet().foreach((Function1)new Serializable(this, actualMetrics){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SQLMetricsTestUtils$.anonfun.testSparkPlanMetrics.1 $outer;
                    private final Map actualMetrics$1;

                    public final void apply(long nodeId) {
                        this.apply$mcVJ$sp(nodeId);
                    }

                    public void apply$mcVJ$sp(long nodeId) {
                        Tuple2 tuple2 = (Tuple2)this.$outer.expectedMetrics$1.apply((Object)BoxesRunTime.boxToLong((long)nodeId));
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            String expectedNodeName = (String)tuple2._1();
                            Map expectedMetricsMap = (Map)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)expectedNodeName, (Object)expectedMetricsMap);
                            String expectedNodeName2 = (String)tuple23._1();
                            Map expectedMetricsMap2 = (Map)tuple23._2();
                            Tuple2 tuple24 = (Tuple2)this.actualMetrics$1.apply((Object)BoxesRunTime.boxToLong((long)nodeId));
                            if (tuple24 != null) {
                                Tuple2 tuple25;
                                String actualNodeName = (String)tuple24._1();
                                Map actualMetricsMap = (Map)tuple24._2();
                                Tuple2 tuple26 = tuple25 = new Tuple2((Object)actualNodeName, (Object)actualMetricsMap);
                                String actualNodeName2 = (String)tuple26._1();
                                Map actualMetricsMap2 = (Map)tuple26._2();
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer()).convertToEqualizer((Object)expectedNodeName2);
                                String $org_scalatest_assert_macro_right = actualNodeName2;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                ((Assertions)this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer()).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
                                expectedMetricsMap2.keySet().foreach((Function1)new Serializable(this, expectedMetricsMap2, actualMetricsMap2){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ SQLMetricsTestUtils$$anonfun$testSparkPlanMetrics$1$.anonfun.apply.2 $outer;
                                    private final Map expectedMetricsMap$1;
                                    private final Map actualMetricsMap$1;

                                    public final Assertion apply(String metricName) {
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer()).convertToEqualizer((Object)this.expectedMetricsMap$1.apply((Object)metricName).toString());
                                        Object $org_scalatest_assert_macro_right = this.actualMetricsMap$1.apply((Object)metricName);
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        return ((Assertions)this.$outer.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer()).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.expectedMetricsMap$1 = expectedMetricsMap$1;
                                        this.actualMetricsMap$1 = actualMetricsMap$1;
                                    }
                                });
                                return;
                            }
                            throw new MatchError((Object)tuple24);
                        }
                        throw new MatchError((Object)tuple2);
                    }

                    public /* synthetic */ SQLMetricsTestUtils$.anonfun.testSparkPlanMetrics.1 org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.actualMetrics$1 = actualMetrics$1;
                    }
                });
            }

            public /* synthetic */ SQLMetricsTestUtils org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedMetrics$1 = expectedMetrics$1;
            }
        });
    }

    public static void $init$(SQLMetricsTestUtils $this) {
    }
}

