/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.CSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.SessionConfigSupport;
import org.apache.spark.sql.sources.v2.SimpleCSVInputPartitionReader;
import org.apache.spark.sql.sources.v2.SimpleCounter$;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001=\u0011\u0001dU5na2,wK]5uC\ndW\rR1uCN{WO]2f\u0015\t\u0019A!\u0001\u0002we)\u0011QAB\u0001\bg>,(oY3t\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003\u0007\u000f EA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\taA)\u0019;b'>,(oY3WeA\u0011\u0011$H\u0005\u0003=\t\u00111BU3bIN+\b\u000f]8siB\u0011\u0011\u0004I\u0005\u0003C\t\u0011Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"!G\u0012\n\u0005\u0011\u0012!\u0001F*fgNLwN\\\"p]\u001aLwmU;qa>\u0014H\u000fC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0004\u0001\u0005\u0006U\u0001!\tbK\u0001\u000bMVdGnU2iK6\fG#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=2\u0011!\u0002;za\u0016\u001c\u0018BA\u0019/\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006g\u0001!\t\u0005N\u0001\nW\u0016L\bK]3gSb$\u0012!\u000e\t\u0003mqr!a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111\b\u000f\u0004\u0005\u0001\u0002\u0001\u0011I\u0001\u0004SK\u0006$WM]\n\u0004\u007fA\u0011\u0005CA\"G\u001b\u0005!%BA#\u0003\u0003\u0019\u0011X-\u00193fe&\u0011q\t\u0012\u0002\u0011\t\u0006$\u0018mU8ve\u000e,'+Z1eKJD\u0001\"S \u0003\u0002\u0003\u0006I!N\u0001\u0005a\u0006$\b\u000e\u0003\u0005L\u007f\t\u0005\t\u0015!\u0003M\u0003\u0011\u0019wN\u001c4\u0011\u00055\u000bV\"\u0001(\u000b\u0005-{%B\u0001)\u000b\u0003\u0019A\u0017\rZ8pa&\u0011!K\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b\u0019zD\u0011\u0001+\u0015\u0007U;\u0006\f\u0005\u0002W\u007f5\t\u0001\u0001C\u0003J'\u0002\u0007Q\u0007C\u0003L'\u0002\u0007A\nC\u0003[\u007f\u0011\u00053&\u0001\u0006sK\u0006$7k\u00195f[\u0006DQ\u0001X \u0005Bu\u000b1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$\u0012A\u0018\t\u0004?\n$W\"\u00011\u000b\u0005\u0005$\u0012\u0001B;uS2L!a\u00191\u0003\t1K7\u000f\u001e\t\u0004\u0007\u0016<\u0017B\u00014E\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u0004\u0002\u0011\r\fG/\u00197zgRL!\u0001\\5\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0004\u0005]\u0002\u0001qN\u0001\u0004Xe&$XM]\n\u0004[B\u0001\bCA9u\u001b\u0005\u0011(BA:\u0003\u0003\u00199(/\u001b;fe&\u0011QO\u001d\u0002\u0011\t\u0006$\u0018mU8ve\u000e,wK]5uKJD\u0001b^7\u0003\u0002\u0003\u0006I!N\u0001\u0006U>\u0014\u0017\n\u001a\u0005\t\u00136\u0014\t\u0011)A\u0005k!A1*\u001cB\u0001B\u0003%A\nC\u0003'[\u0012\u00051\u0010\u0006\u0003}{z|\bC\u0001,n\u0011\u00159(\u00101\u00016\u0011\u0015I%\u00101\u00016\u0011\u0015Y%\u00101\u0001M\u0011\u001d\t\u0019!\u001cC!\u0003\u000b\t1c\u0019:fCR,wK]5uKJ4\u0015m\u0019;pef$\"!a\u0002\u0011\tE\fIaZ\u0005\u0004\u0003\u0017\u0011(!\u0005#bi\u0006<&/\u001b;fe\u001a\u000b7\r^8ss\"9\u0011qB7\u0005B\u0005E\u0011AE8o\t\u0006$\u0018m\u0016:ji\u0016\u00148i\\7nSR$B!a\u0005\u0002\u001aA\u0019q'!\u0006\n\u0007\u0005]\u0001H\u0001\u0003V]&$\b\u0002CA\u000e\u0003\u001b\u0001\r!!\b\u0002\u000f5,7o]1hKB\u0019\u0011/a\b\n\u0007\u0005\u0005\"OA\nXe&$XM]\"p[6LG/T3tg\u0006<W\rC\u0004\u0002&5$\t%a\n\u0002\r\r|W.\\5u)\u0011\t\u0019\"!\u000b\t\u0011\u0005-\u00121\u0005a\u0001\u0003[\t\u0001\"\\3tg\u0006<Wm\u001d\t\u0006o\u0005=\u0012QD\u0005\u0004\u0003cA$!B!se\u0006L\bbBA\u001b[\u0012\u0005\u0013qG\u0001\u0006C\n|'\u000f\u001e\u000b\u0005\u0003'\tI\u0004\u0003\u0005\u0002,\u0005M\u0002\u0019AA\u0017\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\tAb\u0019:fCR,'+Z1eKJ$2AQA!\u0011!\t\u0019%a\u000fA\u0002\u0005\u0015\u0013aB8qi&|gn\u001d\t\u00043\u0005\u001d\u0013bAA%\u0005\t\tB)\u0019;b'>,(oY3PaRLwN\\:\t\u000f\u00055\u0003\u0001\"\u0011\u0002P\u0005a1M]3bi\u0016<&/\u001b;feRQ\u0011\u0011KA,\u00033\ni&!\u001b\u0011\t}\u000b\u0019\u0006]\u0005\u0004\u0003+\u0002'\u0001C(qi&|g.\u00197\t\r]\fY\u00051\u00016\u0011\u001d\tY&a\u0013A\u00021\naa]2iK6\f\u0007\u0002CA0\u0003\u0017\u0002\r!!\u0019\u0002\t5|G-\u001a\t\u0005\u0003G\n)'D\u0001\u0007\u0013\r\t9G\u0002\u0002\t'\u00064X-T8eK\"A\u00111IA&\u0001\u0004\t)\u0005")
public class SimpleWritableDataSource
implements ReadSupport,
WriteSupport,
SessionConfigSupport {
    public StructType fullSchema() {
        return new StructType().add("i", "long").add("j", "long");
    }

    public String keyPrefix() {
        return "simpleWritableDataSource";
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        return new Reader(this, path.toUri().toString(), conf);
    }

    public Optional<DataSourceWriter> createWriter(String jobId, StructType schema2, SaveMode mode, DataSourceOptions options) {
        Predef$.MODULE$.assert(!((SparkContext)SparkContext$.MODULE$.getActive().get()).conf().getBoolean("spark.speculation", false));
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        FileSystem fs = path.getFileSystem(conf);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.ErrorIfExists;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && fs.exists(path)) {
            throw new RuntimeException("data already exists.");
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && fs.exists(path)) {
            return Optional.empty();
        }
        SaveMode saveMode5 = mode;
        SaveMode saveMode6 = SaveMode.Overwrite;
        Object object = !(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true)) : BoxedUnit.UNIT;
        String pathStr = path.toUri().toString();
        return Optional.of(new Writer(this, jobId, pathStr, conf));
    }

    public class Reader
    implements DataSourceReader {
        private final String path;
        public final Configuration org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public StructType readSchema() {
            return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer().fullSchema();
        }

        public List<InputPartition<InternalRow>> planInputPartitions() {
            Path dataPath = new Path(this.path);
            FileSystem fs = dataPath.getFileSystem(this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf);
            return fs.exists(dataPath) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(dataPath)).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus status) {
                    String name = status.getPath().getName();
                    return name.startsWith("_") || name.startsWith(".");
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Reader $outer;

                public final InputPartition<InternalRow> apply(FileStatus f) {
                    SerializableConfiguration serializableConf = new SerializableConfiguration(this.$outer.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf);
                    return new SimpleCSVInputPartitionReader(f.getPath().toUri().toString(), serializableConf);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputPartition.class)))).toList()).asJava() : Collections.emptyList();
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer() {
            return this.$outer;
        }

        public Reader(SimpleWritableDataSource $outer, String path, Configuration conf) {
            this.path = path;
            this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class Writer
    implements DataSourceWriter {
        private final String jobId;
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public DataWriterFactory<InternalRow> createWriterFactory() {
            SimpleCounter$.MODULE$.resetCounter();
            return new CSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        public void onDataWriterCommit(WriterCommitMessage message) {
            SimpleCounter$.MODULE$.increaseCounter();
        }

        /*
         * WARNING - void declaration
         */
        public void commit(WriterCommitMessage[] messages) {
            Path finalPath = new Path(this.path);
            Path jobPath = new Path(new Path(finalPath, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            try {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(jobPath)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).foreach((Function1)new Serializable(this, finalPath, fs){
                    public static final long serialVersionUID = 0L;
                    private final Path finalPath$1;
                    private final FileSystem fs$1;

                    public final void apply(Path file) {
                        Path dest = new Path(this.finalPath$1, file.getName());
                        if (this.fs$1.rename(file, dest)) {
                            return;
                        }
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to rename(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, dest})));
                    }
                    {
                        this.finalPath$1 = finalPath$1;
                        this.fs$1 = fs$1;
                    }
                });
            }
            catch (Throwable throwable) {
                void var3_3;
                void var4_4;
                var4_4.delete((Path)var3_3, true);
                throw throwable;
            }
            fs.delete(jobPath, true);
        }

        public void abort(WriterCommitMessage[] messages) {
            Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            fs.delete(jobPath, true);
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Writer$$$outer() {
            return this.$outer;
        }

        public Writer(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

