/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.test.TestSparkSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaBeanWithArraySuite {
    private static final List<Record> RECORDS = new ArrayList<Record>();
    private TestSparkSession spark;

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void testBeanWithArrayFieldDeserialization() {
        Encoder encoder = Encoders.bean(Record.class);
        Dataset dataset = this.spark.read().format("json").schema("id int, intervals array<struct<startTime: bigint, endTime: bigint>>").load("src/test/resources/test-data/with-array-fields.json").as(encoder);
        List records = dataset.collectAsList();
        Assert.assertEquals((Object)records, RECORDS);
    }

    static {
        RECORDS.add(new Record(1, Arrays.asList(new Interval(111L, 211L), new Interval(121L, 221L))));
        RECORDS.add(new Record(2, Arrays.asList(new Interval(112L, 212L), new Interval(122L, 222L))));
        RECORDS.add(new Record(3, Arrays.asList(new Interval(113L, 213L), new Interval(123L, 223L))));
    }

    public static class Interval {
        private long startTime;
        private long endTime;

        public Interval() {
        }

        Interval(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Interval)) {
                return false;
            }
            Interval other = (Interval)obj;
            return other.startTime == this.startTime && other.endTime == this.endTime;
        }

        public String toString() {
            return String.format("[%d,%d]", this.startTime, this.endTime);
        }
    }

    public static class Record {
        private int id;
        private List<Interval> intervals;

        public Record() {
        }

        Record(int id, List<Interval> intervals) {
            this.id = id;
            this.intervals = intervals;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public List<Interval> getIntervals() {
            return this.intervals;
        }

        public void setIntervals(List<Interval> intervals) {
            this.intervals = intervals;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Record)) {
                return false;
            }
            Record other = (Record)obj;
            return other.id == this.id && other.intervals.equals(this.intervals);
        }

        public String toString() {
            return String.format("{ id: %d, intervals: %s }", this.id, this.intervals);
        }
    }
}

