/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ViewHelper$ {
    public static final ViewHelper$ MODULE$;

    static {
        new ViewHelper$();
    }

    private Map<String, String> generateViewDefaultDatabase(String databaseName) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CatalogTable$.MODULE$.VIEW_DEFAULT_DATABASE()), (Object)databaseName)}));
    }

    private Map<String, String> generateQueryColumnNames(Seq<String> columns2) {
        HashMap props = new HashMap();
        if (columns2.nonEmpty()) {
            props.put((Object)CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_NUM_COLUMNS(), (Object)((Object)BoxesRunTime.boxToInteger((int)columns2.length())).toString());
            ((IterableLike)columns2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final HashMap props$1;

                public final Option<String> apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String colName = (String)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Option option = this.props$1.put((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX(), BoxesRunTime.boxToInteger((int)index)})), (Object)colName);
                        return option;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.props$1 = props$1;
                }
            });
        }
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeQueryColumnNames(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_PREFIX());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public Map<String, String> generateViewProperties(Map<String, String> properties, SparkSession session, LogicalPlan analyzedPlan, String[] fieldNames) {
        String[] queryOutput = analyzedPlan.schema().fieldNames();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), "in the view definition", session.sessionState().conf().resolver());
        String viewDefaultDatabase = session.sessionState().catalog().getCurrentDatabase();
        return this.removeQueryColumnNames(properties).$plus$plus(this.generateViewDefaultDatabase(viewDefaultDatabase)).$plus$plus(this.generateQueryColumnNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])queryOutput)));
    }

    public void checkCyclicViewReference(LogicalPlan plan, Seq<TableIdentifier> path, TableIdentifier viewIdent) {
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            TableIdentifier ident = view.desc().identifier();
            Seq newPath = (Seq)path.$colon$plus((Object)ident, Seq$.MODULE$.canBuildFrom());
            TableIdentifier tableIdentifier = ident;
            TableIdentifier tableIdentifier2 = viewIdent;
            if (!(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null)) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recursive view ", " detected "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{viewIdent}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(cycle: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newPath.mkString(" -> ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            view.children().foreach((Function1)new Serializable(viewIdent, newPath){
                public static final long serialVersionUID = 0L;
                private final TableIdentifier viewIdent$2;
                private final Seq newPath$1;

                public final void apply(LogicalPlan child) {
                    ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)this.newPath$1, this.viewIdent$2);
                }
                {
                    this.viewIdent$2 = viewIdent$2;
                    this.newPath$1 = newPath$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            plan.children().foreach((Function1)new Serializable(path, viewIdent){
                public static final long serialVersionUID = 0L;
                private final Seq path$1;
                private final TableIdentifier viewIdent$2;

                public final void apply(LogicalPlan child) {
                    ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)this.path$1, this.viewIdent$2);
                }
                {
                    this.path$1 = path$1;
                    this.viewIdent$2 = viewIdent$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        plan.expressions().foreach((Function1)new Serializable(path, viewIdent){
            public static final long serialVersionUID = 0L;
            private final Seq path$1;
            private final TableIdentifier viewIdent$2;

            public final void apply(Expression expr) {
                Expression expression = expr;
                if (expression instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                    ViewHelper$.MODULE$.checkCyclicViewReference((LogicalPlan)subqueryExpression.plan(), (Seq<TableIdentifier>)this.path$1, this.viewIdent$2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.path$1 = path$1;
                this.viewIdent$2 = viewIdent$2;
            }
        });
    }

    private ViewHelper$() {
        MODULE$ = this;
    }
}

