/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryTestingUtils$;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.collection.unsafe.sort.UnsafeExternalSorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class ExternalAppendOnlyUnsafeRowArrayBenchmark$ {
    public static ExternalAppendOnlyUnsafeRowArrayBenchmark$ MODULE$;

    static {
        new ExternalAppendOnlyUnsafeRowArrayBenchmark$();
    }

    public void testAgainstRawArrayBuffer(int numSpillThreshold, int numRows, int iterations) {
        Random random = new Random();
        IndexedSeq rows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows).map((Function1 & Serializable & scala.Serializable)x$1 -> ExternalAppendOnlyUnsafeRowArrayBenchmark$.$anonfun$testAgainstRawArrayBuffer$1(random, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        Benchmark benchmark = new Benchmark(new StringBuilder(16).append("Array with ").append(numRows).append(" rows").toString(), (long)(iterations * numRows), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        int initialSize = Math.min(ExternalAppendOnlyUnsafeRowArray$.MODULE$.DefaultInitialSizeOfInMemoryBuffer(), numSpillThreshold);
        benchmark.addCase("ArrayBuffer", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                ArrayBuffer array = new ArrayBuffer(initialSize);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> array.$plus$eq((Object)x.copy()));
                int n = array.length();
                for (int i = 0; i < n; ++i) {
                    sum$1.elem += ((UnsafeRow)array.apply(i)).getLong(0);
                }
                array.clear();
            });
        });
        benchmark.addCase("ExternalAppendOnlyUnsafeRowArray", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(ExternalAppendOnlyUnsafeRowArray$.MODULE$.DefaultInitialSizeOfInMemoryBuffer(), numSpillThreshold);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    array.add(x);
                    return BoxedUnit.UNIT;
                });
                Iterator iterator = array.generateIterator();
                while (iterator.hasNext()) {
                    sum$2.elem += ((UnsafeRow)iterator.next()).getLong(0);
                }
                array.clear();
            });
        });
        SparkConf conf = new SparkConf(false);
        conf.set("spark.serializer.objectStreamReset", "1");
        conf.set("spark.serializer", "org.apache.spark.serializer.JavaSerializer");
        SparkContext sc = new SparkContext("local", "test", conf);
        TaskContext taskContext = MemoryTestingUtils$.MODULE$.fakeTaskContext(SparkEnv$.MODULE$.get());
        TaskContext$.MODULE$.setTaskContext(taskContext);
        benchmark.run();
        sc.stop();
    }

    public void testAgainstRawUnsafeExternalSorter(int numSpillThreshold, int numRows, int iterations) {
        Random random = new Random();
        IndexedSeq rows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows).map((Function1 & Serializable & scala.Serializable)x$4 -> ExternalAppendOnlyUnsafeRowArrayBenchmark$.$anonfun$testAgainstRawUnsafeExternalSorter$1(random, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        Benchmark benchmark = new Benchmark(new StringBuilder(19).append("Spilling with ").append(numRows).append(" rows").toString(), (long)(iterations * numRows), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("UnsafeExternalSorter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                UnsafeExternalSorter array = UnsafeExternalSorter.create((TaskMemoryManager)TaskContext$.MODULE$.get().taskMemoryManager(), (BlockManager)SparkEnv$.MODULE$.get().blockManager(), (SerializerManager)SparkEnv$.MODULE$.get().serializerManager(), (TaskContext)TaskContext$.MODULE$.get(), null, null, (int)1024, (long)SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes(), (int)numSpillThreshold, (boolean)false);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    array.insertRecord(x.getBaseObject(), x.getBaseOffset(), x.getSizeInBytes(), 0L, false);
                    return BoxedUnit.UNIT;
                });
                UnsafeRow unsafeRow = new UnsafeRow(1);
                UnsafeSorterIterator iter = array.getIterator(0);
                while (iter.hasNext()) {
                    iter.loadNext();
                    unsafeRow.pointTo(iter.getBaseObject(), iter.getBaseOffset(), iter.getRecordLength());
                    sum$3.elem += unsafeRow.getLong(0);
                }
                array.cleanupResources();
            });
        });
        benchmark.addCase("ExternalAppendOnlyUnsafeRowArray", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(numSpillThreshold, numSpillThreshold);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    array.add(x);
                    return BoxedUnit.UNIT;
                });
                Iterator iterator = array.generateIterator();
                while (iterator.hasNext()) {
                    sum$4.elem += ((UnsafeRow)iterator.next()).getLong(0);
                }
                array.clear();
            });
        });
        SparkConf conf = new SparkConf(false);
        conf.set("spark.serializer.objectStreamReset", "1");
        conf.set("spark.serializer", "org.apache.spark.serializer.JavaSerializer");
        SparkContext sc = new SparkContext("local", "test", conf);
        TaskContext taskContext = MemoryTestingUtils$.MODULE$.fakeTaskContext(SparkEnv$.MODULE$.get());
        TaskContext$.MODULE$.setTaskContext(taskContext);
        benchmark.run();
        sc.stop();
    }

    public void main(String[] args) {
        int spillThreshold = 100000;
        this.testAgainstRawArrayBuffer(spillThreshold, 1000, 262144);
        this.testAgainstRawArrayBuffer(spillThreshold, 30000, 16384);
        this.testAgainstRawArrayBuffer(spillThreshold, 100000, 1024);
        this.testAgainstRawUnsafeExternalSorter(100000, 1000, 262144);
        this.testAgainstRawUnsafeExternalSorter(BoxesRunTime.unboxToInt((Object)package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD().defaultValue().get()), 10000, 16);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ UnsafeRow $anonfun$testAgainstRawArrayBuffer$1(Random random$1, int x$1) {
        void var2_2;
        UnsafeRow row = new UnsafeRow(1);
        row.pointTo(new byte[64], 16);
        row.setLong(0, random$1.nextLong());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ UnsafeRow $anonfun$testAgainstRawUnsafeExternalSorter$1(Random random$2, int x$4) {
        void var2_2;
        UnsafeRow row = new UnsafeRow(1);
        row.pointTo(new byte[64], 16);
        row.setLong(0, random$2.nextLong());
        return var2_2;
    }

    private ExternalAppendOnlyUnsafeRowArrayBenchmark$() {
        MODULE$ = this;
    }
}

