/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.collection.SortDataFormat;
import org.apache.spark.util.collection.Sorter;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RadixSort;
import org.apache.spark.util.collection.unsafe.sort.RecordPointerAndKeyPrefix;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSortDataFormat;
import org.apache.spark.util.random.XORShiftRandom;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M3A\u0001B\u0003\u0001%!)1\u0004\u0001C\u00019!)a\u0004\u0001C\u0005?!)A\t\u0001C\u0005\u000b\ni1k\u001c:u\u0005\u0016t7\r[7be.T!AB\u0004\u0002\u0013\t,gn\u00195nCJ\\'B\u0001\u0005\n\u0003%)\u00070Z2vi&|gN\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001']\u0001\"\u0001F\u000b\u000e\u0003-I!AF\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tA\u0012$D\u0001\u0006\u0013\tQRAA\u0007CK:\u001c\u0007.\\1sW\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"\u0001\u0007\u0001\u0002-I,g-\u001a:f]\u000e,7*Z=Qe\u00164\u0017\u000e_*peR$R\u0001\t\u00141k]\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\")qE\u0001a\u0001Q\u0005\u0019!-\u001e4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B1se\u0006L(BA\u0017\f\u0003\u0019)hn]1gK&\u0011qF\u000b\u0002\n\u0019>tw-\u0011:sCfDQ!\r\u0002A\u0002I\n!\u0001\\8\u0011\u0005\u0005\u001a\u0014B\u0001\u001b#\u0005\rIe\u000e\u001e\u0005\u0006m\t\u0001\rAM\u0001\u0003Q&DQ\u0001\u000f\u0002A\u0002e\naA]3g\u00076\u0004\bC\u0001\u001eC\u001b\u0005Y$B\u0001\u001f>\u0003\u0011\u0019xN\u001d;\u000b\u00055r$BA A\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u0003.\tA!\u001e;jY&\u00111i\u000f\u0002\u0011!J,g-\u001b=D_6\u0004\u0018M]1u_J\f\u0011dZ3oKJ\fG/Z&fsB\u0013XMZ5y)\u0016\u001cH\u000fR1uCR\u0019a)S&\u0011\t\u0005:\u0005\u0006K\u0005\u0003\u0011\n\u0012a\u0001V;qY\u0016\u0014\u0004\"\u0002&\u0004\u0001\u0004\u0011\u0014\u0001B:ju\u0016Da\u0001T\u0002\u0005\u0002\u0004i\u0015\u0001\u0002:b]\u0012\u00042!\t(Q\u0013\ty%E\u0001\u0005=Eft\u0017-\\3?!\t\t\u0013+\u0003\u0002SE\t!Aj\u001c8h\u0001")
public class SortBenchmark
extends SparkFunSuite
implements BenchmarkBase {
    private SparkSession sparkSession;
    private volatile boolean bitmap$0;

    @Override
    public void runBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        BenchmarkBase.runBenchmark$(this, name, cardinality, f);
    }

    private SparkSession sparkSession$lzycompute() {
        SortBenchmark sortBenchmark = this;
        synchronized (sortBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = BenchmarkBase.sparkSession$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    @Override
    public SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    private void referenceKeyPrefixSort(LongArray buf, int lo, int hi, PrefixComparator refCmp) {
        LongArray sortBuffer = new LongArray(MemoryBlock.fromLongArray((long[])new long[(int)buf.size()]));
        new Sorter((SortDataFormat)new UnsafeSortDataFormat(sortBuffer)).sort((Object)buf, lo, hi, (Comparator)new Comparator<RecordPointerAndKeyPrefix>(null, refCmp){
            private final PrefixComparator refCmp$1;

            public Comparator<RecordPointerAndKeyPrefix> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<RecordPointerAndKeyPrefix> thenComparing(Comparator<? super RecordPointerAndKeyPrefix> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<RecordPointerAndKeyPrefix> thenComparing(Function<? super RecordPointerAndKeyPrefix, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<RecordPointerAndKeyPrefix> thenComparing(Function<? super RecordPointerAndKeyPrefix, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<RecordPointerAndKeyPrefix> thenComparingInt(ToIntFunction<? super RecordPointerAndKeyPrefix> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<RecordPointerAndKeyPrefix> thenComparingLong(ToLongFunction<? super RecordPointerAndKeyPrefix> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<RecordPointerAndKeyPrefix> thenComparingDouble(ToDoubleFunction<? super RecordPointerAndKeyPrefix> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(RecordPointerAndKeyPrefix r1, RecordPointerAndKeyPrefix r2) {
                return this.refCmp$1.compare(r1.keyPrefix, r2.keyPrefix);
            }
            {
                this.refCmp$1 = refCmp$1;
            }
        });
    }

    private Tuple2<LongArray, LongArray> generateKeyPrefixTestData(int size, Function0<Object> rand) {
        long[] ref = (long[])Array$.MODULE$.tabulate(size * 2, (Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> rand.apply$mcJ$sp(), ClassTag$.MODULE$.Long());
        long[] extended = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ref)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])Array$.MODULE$.fill(size * 2, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        return new Tuple2((Object)new LongArray(MemoryBlock.fromLongArray((long[])ref)), (Object)new LongArray(MemoryBlock.fromLongArray((long[])extended)));
    }

    public static final /* synthetic */ void $anonfun$new$2(SortBenchmark $this, int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = (long[])Array$.MODULE$.tabulate(size$1 * 2, (Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> rand$2.nextLong(), ClassTag$.MODULE$.Long());
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        $this.referenceKeyPrefixSort(buf, 0, size$1, PrefixComparators.BINARY);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$new$4(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] ref = (long[])Array$.MODULE$.tabulate(size$1, (Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> rand$2.nextLong(), ClassTag$.MODULE$.Long());
        timer.startTiming();
        Arrays.sort(ref);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$new$6(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = new long[size$1 * 2];
        for (int i = 0; i < size$1; ++i) {
            array[i] = rand$2.nextLong() & 0xFFL;
        }
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        RadixSort.sort((LongArray)buf, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$new$7(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = new long[size$1 * 2];
        for (int i = 0; i < size$1; ++i) {
            array[i] = rand$2.nextLong() & 0xFFFFL;
        }
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        RadixSort.sort((LongArray)buf, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$new$8(int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        long[] array = new long[size$1 * 2];
        for (int i = 0; i < size$1; ++i) {
            array[i] = rand$2.nextLong();
        }
        LongArray buf = new LongArray(MemoryBlock.fromLongArray((long[])array));
        timer.startTiming();
        RadixSort.sort((LongArray)buf, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public static final /* synthetic */ void $anonfun$new$9(SortBenchmark $this, int size$1, XORShiftRandom rand$2, Benchmark.Timer timer) {
        LongArray buf2;
        Tuple2<LongArray, LongArray> tuple2 = $this.generateKeyPrefixTestData(size$1, (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> rand$2.nextLong());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LongArray longArray = buf2 = (LongArray)tuple2._2();
        LongArray buf22 = longArray;
        timer.startTiming();
        RadixSort.sortKeyPrefixArray((LongArray)buf22, (long)0L, (long)size$1, (int)0, (int)7, (boolean)false, (boolean)false);
        timer.stopTiming();
    }

    public SortBenchmark() {
        BenchmarkBase.$init$(this);
        this.ignore("sort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int size = 25000000;
            XORShiftRandom rand = new XORShiftRandom(123L);
            Benchmark benchmark = new Benchmark(new StringBuilder(11).append("radix sort ").append(size).toString(), (long)size, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
            benchmark.addTimerCase("reference TimSort key prefix array", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
                SortBenchmark.$anonfun$new$2(this, size, rand, timer);
                return BoxedUnit.UNIT;
            });
            benchmark.addTimerCase("reference Arrays.sort", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
                SortBenchmark.$anonfun$new$4(size, rand, timer);
                return BoxedUnit.UNIT;
            });
            benchmark.addTimerCase("radix sort one byte", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
                SortBenchmark.$anonfun$new$6(size, rand, timer);
                return BoxedUnit.UNIT;
            });
            benchmark.addTimerCase("radix sort two bytes", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
                SortBenchmark.$anonfun$new$7(size, rand, timer);
                return BoxedUnit.UNIT;
            });
            benchmark.addTimerCase("radix sort eight bytes", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
                SortBenchmark.$anonfun$new$8(size, rand, timer);
                return BoxedUnit.UNIT;
            });
            benchmark.addTimerCase("radix sort key prefix array", benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
                SortBenchmark.$anonfun$new$9(this, size, rand, timer);
                return BoxedUnit.UNIT;
            });
            benchmark.run();
        }, new Position("SortBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }
}

