/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.benchmark.TPCDSQueryBenchmarkArguments;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TPCDSQueryBenchmark$
implements Logging {
    public static TPCDSQueryBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;
    private final Seq<String> tables;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new TPCDSQueryBenchmark$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public Seq<String> tables() {
        return this.tables;
    }

    public Map<String, Object> setupTables(String dataLocation) {
        return ((TraversableOnce)this.tables().map((Function1 & Serializable & scala.Serializable)tableName -> {
            MODULE$.spark().read().parquet(new StringBuilder(1).append(dataLocation).append("/").append((String)tableName).toString()).createOrReplaceTempView(tableName);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tableName), (Object)BoxesRunTime.boxToLong((long)MODULE$.spark().table(tableName).count()));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void runTpcdsQueries(String queryLocation, Seq<String> queries, Map<String, Object> tableSizes, String nameSuffix) {
        queries.foreach((Function1 & Serializable & scala.Serializable)name -> {
            TPCDSQueryBenchmark$.$anonfun$runTpcdsQueries$1(queryLocation, tableSizes, nameSuffix, name);
            return BoxedUnit.UNIT;
        });
    }

    public String runTpcdsQueries$default$4() {
        return "";
    }

    public Seq<String> filterQueries(Seq<String> origQueries, TPCDSQueryBenchmarkArguments args) {
        Seq seq;
        if (args.queryFilter().nonEmpty()) {
            Set<String> set = args.queryFilter();
            seq = (Seq)origQueries.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)));
        } else {
            seq = origQueries;
        }
        return seq;
    }

    public void main(String[] args) {
        Seq<String> queriesV2_7ToRun;
        TPCDSQueryBenchmarkArguments benchmarkArgs = new TPCDSQueryBenchmarkArguments(args);
        Seq tpcdsQueries = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14a", "q14b", "q15", "q16", "q17", "q18", "q19", "q20", "q21", "q22", "q23a", "q23b", "q24a", "q24b", "q25", "q26", "q27", "q28", "q29", "q30", "q31", "q32", "q33", "q34", "q35", "q36", "q37", "q38", "q39a", "q39b", "q40", "q41", "q42", "q43", "q44", "q45", "q46", "q47", "q48", "q49", "q50", "q51", "q52", "q53", "q54", "q55", "q56", "q57", "q58", "q59", "q60", "q61", "q62", "q63", "q64", "q65", "q66", "q67", "q68", "q69", "q70", "q71", "q72", "q73", "q74", "q75", "q76", "q77", "q78", "q79", "q80", "q81", "q82", "q83", "q84", "q85", "q86", "q87", "q88", "q89", "q90", "q91", "q92", "q93", "q94", "q95", "q96", "q97", "q98", "q99"}));
        Seq tpcdsQueriesV2_7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q5a", "q6", "q10a", "q11", "q12", "q14", "q14a", "q18a", "q20", "q22", "q22a", "q24", "q27a", "q34", "q35", "q35a", "q36a", "q47", "q49", "q51a", "q57", "q64", "q67a", "q70a", "q72", "q74", "q75", "q77a", "q78", "q80a", "q86a", "q98"}));
        Seq<String> queriesV1_4ToRun = this.filterQueries((Seq<String>)tpcdsQueries, benchmarkArgs);
        if (((SeqLike)queriesV1_4ToRun.$plus$plus(queriesV2_7ToRun = this.filterQueries((Seq<String>)tpcdsQueriesV2_7, benchmarkArgs), Seq$.MODULE$.canBuildFrom())).isEmpty()) {
            throw new RuntimeException(new StringBuilder(45).append("Empty queries to run. Bad query name filter: ").append(benchmarkArgs.queryFilter()).toString());
        }
        Map<String, Object> tableSizes = this.setupTables(benchmarkArgs.dataLocation());
        this.runTpcdsQueries("tpcds", queriesV1_4ToRun, tableSizes, this.runTpcdsQueries$default$4());
        this.runTpcdsQueries("tpcds-v2.7.0", queriesV2_7ToRun, tableSizes, "-v2.7");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$runTpcdsQueries$2(HashSet queryRelations$1, LogicalPlan x0$1) {
        LogicalRelation logicalRelation;
        Option option;
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            AliasIdentifier alias = subqueryAlias.name();
            if (subqueryAlias.child() instanceof LogicalRelation) {
                queryRelations$1.add((Object)alias.identifier());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (logicalPlan instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan).catalogTable()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            queryRelations$1.add((Object)catalogTable.identifier().table());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (logicalPlan instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan;
            CatalogTable tableMeta = hiveTableRelation.tableMeta();
            queryRelations$1.add((Object)tableMeta.identifier().table());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$runTpcdsQueries$3(Map tableSizes$1, String x$1) {
        return BoxesRunTime.unboxToLong((Object)tableSizes$1.getOrElse((Object)x$1, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$runTpcdsQueries$1(String queryLocation$1, Map tableSizes$1, String nameSuffix$1, String name) {
        String x$12 = new StringBuilder(5).append(queryLocation$1).append("/").append(name).append(".sql").toString();
        ClassLoader x$22 = Thread.currentThread().getContextClassLoader();
        String x$3 = package$.MODULE$.resourceToString$default$2();
        String queryString = package$.MODULE$.resourceToString(x$12, x$3, x$22);
        HashSet queryRelations = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        MODULE$.spark().sql(queryString).queryExecution().analyzed().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TPCDSQueryBenchmark$.$anonfun$runTpcdsQueries$2(queryRelations, x0$1);
            return BoxedUnit.UNIT;
        });
        long numRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)queryRelations.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)TPCDSQueryBenchmark$.$anonfun$runTpcdsQueries$3(tableSizes$1, x$1)), HashSet$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Benchmark benchmark = new Benchmark("TPCDS Snappy", numRows, 5, Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase(new StringBuilder(0).append(name).append(nameSuffix$1).toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.spark().sql(queryString).collect());
        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("\n\n===== TPCDS QUERY BENCHMARK OUTPUT FOR ").append(name).append(" =====\n").toString());
        benchmark.run();
        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("\n\n===== FINISHED ").append(name).append(" =====\n").toString());
    }

    private TPCDSQueryBenchmark$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.conf = new SparkConf().setMaster("local[1]").setAppName("test-sql-context").set("spark.sql.parquet.compression.codec", "snappy").set("spark.sql.shuffle.partitions", "4").set("spark.driver.memory", "3g").set("spark.executor.memory", "3g").set("spark.sql.autoBroadcastJoinThreshold", ((Object)BoxesRunTime.boxToInteger((int)0x1400000)).toString()).set("spark.sql.crossJoin.enabled", "true");
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.tables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalog_page", "catalog_returns", "customer", "customer_address", "customer_demographics", "date_dim", "household_demographics", "inventory", "item", "promotion", "store", "store_returns", "catalog_sales", "web_sales", "store_sales", "web_returns", "web_site", "reason", "call_center", "warehouse", "ship_mode", "income_band", "time_dim", "web_page"}));
    }
}

