/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0002\u0004\u0001+!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002BB\u0012\u0001A\u0003%\u0001\u0005C\u0003%\u0001\u0011%QE\u0001\u000bV]&4xnY5usB\u000b'o]3s'VLG/\u001a\u0006\u0003\u000f!\t1aY:w\u0015\tI!\"A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0006\r\u0003%)\u00070Z2vi&|gN\u0003\u0002\u000e\u001d\u0005\u00191/\u001d7\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002\u001d%\u0011\u0011D\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u00051\u0011A\u00029beN,'/F\u0001!!\ti\u0012%\u0003\u0002#\r\tyQK\\5w_\u000eLG/\u001f)beN,'/A\u0004qCJ\u001cXM\u001d\u0011\u0002\u0015\u0005\u001c8/\u001a:u\u001dVdG\u000e\u0006\u0002'aA\u0011q%\f\b\u0003Q-j\u0011!\u000b\u0006\u0003UI\t\u0011b]2bY\u0006$Xm\u001d;\n\u00051J\u0013a\u00029bG.\fw-Z\u0005\u0003]=\u0012\u0011\"Q:tKJ$\u0018n\u001c8\u000b\u00051J\u0003\"B\u0019\u0005\u0001\u0004\u0011\u0014!\u0001<\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u0007\u0005s\u0017\u0010")
public class UnivocityParserSuite
extends SparkFunSuite {
    private final UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.empty()), new CSVOptions(Predef$.MODULE$.Map().empty(), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4()));

    private UnivocityParser parser() {
        return this.parser;
    }

    private Assertion assertNull(Object v) {
        Object $org_scalatest_assert_macro_left = v;
        Object $org_scalatest_assert_macro_right = null;
        Object object = $org_scalatest_assert_macro_left;
        Object var5_4 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var5_4) : var5_4 != null), Prettifier$.MODULE$.default());
        return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
    }

    public static final /* synthetic */ Assertion $anonfun$new$8(UnivocityParserSuite $this, boolean b) {
        CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"null")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
        Function1 converter = $this.parser().makeConverter("_1", (DataType)StringType$.MODULE$, b, options);
        Object $org_scalatest_assert_macro_left = converter.apply((Object)"");
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)"");
        Object object = $org_scalatest_assert_macro_left;
        UTF8String uTF8String = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(uTF8String) : uTF8String != null), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
    }

    public UnivocityParserSuite() {
        this.test("Can parse decimal type values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq stringValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10.05", "1,000.01", "158,058,049.001"}));
            Seq decimalValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.05, 1000.01, 1.58058049001E8}));
            DecimalType decimalType = new DecimalType();
            ((IterableLike)stringValues.zip((GenIterable)decimalValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String strVal = (String)tuple2._1();
                double decimalVal = tuple2._2$mcD$sp();
                BigDecimal decimalValue = new BigDecimal(((Object)BoxesRunTime.boxToDouble((double)decimalVal)).toString());
                CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
                String x$1 = "_1";
                DecimalType x$2 = decimalType;
                CSVOptions x$3 = options;
                boolean x$4 = this.parser().makeConverter$default$3();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parser().makeConverter(x$1, (DataType)x$2, x$4, x$3).apply((Object)strVal));
                Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(decimalValue, decimalType.precision(), decimalType.scale());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
                return assertion;
            });
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("Nullable types are handled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, BooleanType$.MODULE$, DecimalType$.MODULE$.DoubleDecimal(), TimestampType$.MODULE$, DateType$.MODULE$, StringType$.MODULE$}));
            types.foreach((Function1 & Serializable & scala.Serializable)t -> {
                CSVOptions nullValueOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"-")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
                Function1 converter = this.parser().makeConverter("_1", (DataType)t, true, nullValueOptions);
                this.assertNull(converter.apply((Object)"-"));
                this.assertNull(converter.apply(null));
                CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
                return this.assertNull(this.parser().makeConverter("_1", (DataType)t, true, options).apply((Object)""));
            });
            types.foreach((Function1 & Serializable & scala.Serializable)t -> {
                String message;
                CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"-")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
                Function1 converter = this.parser().makeConverter("_1", (DataType)t, false, options);
                String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> converter.apply((Object)"-"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72))).getMessage();
                String $org_scalatest_assert_macro_right = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                String $org_scalatest_assert_macro_left2 = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> converter.apply(null), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76))).getMessage();
                String $org_scalatest_assert_macro_right2 = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)b -> UnivocityParserSuite.$anonfun$new$8(this, BoxesRunTime.unboxToBoolean((Object)b)));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Throws exception for empty string with non null type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            RuntimeException exception = (RuntimeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.parser().makeConverter("_1", (DataType)IntegerType$.MODULE$, false, options).apply((Object)""), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "null value found but field _1 is not nullable.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Types are cast correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object castedDate;
            Object castedTimestamp;
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            String x$5 = "_1";
            ByteType$ x$6 = ByteType$.MODULE$;
            CSVOptions x$7 = options;
            boolean x$8 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left = this.parser().makeConverter(x$5, (DataType)x$6, x$8, x$7).apply((Object)"10");
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            String x$9 = "_1";
            ShortType$ x$10 = ShortType$.MODULE$;
            CSVOptions x$11 = options;
            boolean x$12 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left2 = this.parser().makeConverter(x$9, (DataType)x$10, x$12, x$11).apply((Object)"10");
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            String x$13 = "_1";
            IntegerType$ x$14 = IntegerType$.MODULE$;
            CSVOptions x$15 = options;
            boolean x$16 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left3 = this.parser().makeConverter(x$13, (DataType)x$14, x$16, x$15).apply((Object)"10");
            int $org_scalatest_assert_macro_right3 = 10;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            String x$17 = "_1";
            LongType$ x$18 = LongType$.MODULE$;
            CSVOptions x$19 = options;
            boolean x$20 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left4 = this.parser().makeConverter(x$17, (DataType)x$18, x$20, x$19).apply((Object)"10");
            int $org_scalatest_assert_macro_right4 = 10;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            String x$21 = "_1";
            FloatType$ x$22 = FloatType$.MODULE$;
            CSVOptions x$23 = options;
            boolean x$24 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left5 = this.parser().makeConverter(x$21, (DataType)x$22, x$24, x$23).apply((Object)"1.00");
            double $org_scalatest_assert_macro_right5 = 1.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            String x$25 = "_1";
            DoubleType$ x$26 = DoubleType$.MODULE$;
            CSVOptions x$27 = options;
            boolean x$28 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left6 = this.parser().makeConverter(x$25, (DataType)x$26, x$28, x$27).apply((Object)"1.00");
            double $org_scalatest_assert_macro_right6 = 1.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            String x$29 = "_1";
            BooleanType$ x$30 = BooleanType$.MODULE$;
            CSVOptions x$31 = options;
            boolean x$32 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left7 = this.parser().makeConverter(x$29, (DataType)x$30, x$32, x$31).apply((Object)"true");
            boolean $org_scalatest_assert_macro_right7 = true;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left7, (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            CSVOptions timestampsOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"dd/MM/yyyy hh:mm")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            String customTimestamp = "31/01/2015 00:00";
            long expectedTime = timestampsOptions.timestampFormat().parse(customTimestamp).getTime();
            Object $org_scalatest_assert_macro_left8 = castedTimestamp = this.parser().makeConverter("_1", (DataType)TimestampType$.MODULE$, true, timestampsOptions).apply((Object)customTimestamp);
            long $org_scalatest_assert_macro_right8 = expectedTime * 1000L;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            String customDate = "31/01/2015";
            CSVOptions dateOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"dd/MM/yyyy")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            long expectedDate = dateOptions.dateFormat().parse(customDate).getTime();
            Object $org_scalatest_assert_macro_left9 = castedDate = this.parser().makeConverter("_1", (DataType)DateType$.MODULE$, true, dateOptions).apply((Object)customTimestamp);
            int $org_scalatest_assert_macro_right9 = DateTimeUtils$.MODULE$.millisToDays(expectedDate);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left9, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            String timestamp = "2015-01-01 00:00:00";
            String x$33 = "_1";
            TimestampType$ x$34 = TimestampType$.MODULE$;
            CSVOptions x$35 = options;
            boolean x$36 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left10 = this.parser().makeConverter(x$33, (DataType)x$34, x$36, x$35).apply((Object)timestamp);
            long $org_scalatest_assert_macro_right10 = DateTimeUtils$.MODULE$.stringToTime(timestamp).getTime() * 1000L;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left10, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left10, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            String x$37 = "_1";
            DateType$ x$38 = DateType$.MODULE$;
            CSVOptions x$39 = options;
            boolean x$40 = this.parser().makeConverter$default$3();
            Object $org_scalatest_assert_macro_left11 = this.parser().makeConverter(x$37, (DataType)x$38, x$40, x$39).apply((Object)"2015-01-01");
            int $org_scalatest_assert_macro_right11 = DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime("2015-01-01").getTime());
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left11, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left11, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11)), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("Throws exception for casting an invalid string to Float and Double Types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{DoubleType$.MODULE$, FloatType$.MODULE$}));
            Seq input = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10u000", "abc", "1 2/3"}));
            types.foreach((Function1 & Serializable & scala.Serializable)dt -> {
                input.foreach((Function1 & Serializable & scala.Serializable)v -> {
                    String message;
                    String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                        String x$41 = "_1";
                        FractionalType x$42 = dt;
                        CSVOptions x$43 = options$2;
                        boolean x$44 = $this.parser().makeConverter$default$3();
                        return $this.parser().makeConverter(x$41, (DataType)x$42, x$44, x$43).apply(v);
                    }, ClassTag$.MODULE$.apply(NumberFormatException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140))).getMessage();
                    String $org_scalatest_assert_macro_right = v;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("Float NaN values are parsed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            float floatVal;
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nanValue"), (Object)"nn")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            float $org_scalatest_assert_macro_left = floatVal = BoxesRunTime.unboxToFloat((Object)this.parser().makeConverter("_1", (DataType)FloatType$.MODULE$, true, options).apply((Object)"nn"));
            float $org_scalatest_assert_macro_right = floatVal;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("Double NaN values are parsed correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nanValue"), (Object)"-")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            double doubleVal = BoxesRunTime.unboxToDouble((Object)this.parser().makeConverter("_1", (DataType)DoubleType$.MODULE$, true, options).apply((Object)"-"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(doubleVal).isNaN(), "scala.Predef.double2Double(doubleVal).isNaN()", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("Float infinite values can be parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            float floatVal2;
            float floatVal1;
            CSVOptions negativeInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"negativeInf"), (Object)"max")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            float $org_scalatest_assert_macro_left = floatVal1 = BoxesRunTime.unboxToFloat((Object)this.parser().makeConverter("_1", (DataType)FloatType$.MODULE$, true, negativeInfOptions).apply((Object)"max"));
            float $org_scalatest_assert_macro_right = Float.NEGATIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            CSVOptions positiveInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"positiveInf"), (Object)"max")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            float $org_scalatest_assert_macro_left2 = floatVal2 = BoxesRunTime.unboxToFloat((Object)this.parser().makeConverter("_1", (DataType)FloatType$.MODULE$, true, positiveInfOptions).apply((Object)"max"));
            float $org_scalatest_assert_macro_right2 = Float.POSITIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("Double infinite values can be parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double doubleVal2;
            double doubleVal1;
            CSVOptions negativeInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"negativeInf"), (Object)"max")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            double $org_scalatest_assert_macro_left = doubleVal1 = BoxesRunTime.unboxToDouble((Object)this.parser().makeConverter("_1", (DataType)DoubleType$.MODULE$, true, negativeInfOptions).apply((Object)"max"));
            double $org_scalatest_assert_macro_right = Double.NEGATIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            CSVOptions positiveInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"positiveInf"), (Object)"max")})), false, "GMT", CSVOptions$.MODULE$.$lessinit$greater$default$4());
            double $org_scalatest_assert_macro_left2 = doubleVal2 = BoxesRunTime.unboxToDouble((Object)this.parser().makeConverter("_1", (DataType)DoubleType$.MODULE$, true, positiveInfOptions).apply((Object)"max"));
            double $org_scalatest_assert_macro_right2 = Double.POSITIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
    }
}

