/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.DataSourceAnalysis;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y3AAC\u0006\u0001-!)\u0011\u0005\u0001C\u0001E!IQ\u0005\u0001a\u0001\u0002\u0004%IA\n\u0005\n{\u0001\u0001\r\u00111A\u0005\nyB\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0014\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00139\u0005\"\u0003(\u0001\u0001\u0004\u0005\r\u0011\"\u0003P\u0011%\t\u0006\u00011A\u0001B\u0003&\u0001\nC\u0003S\u0001\u0011\u00053\u000bC\u0003U\u0001\u0011%QKA\fECR\f7k\\;sG\u0016\fe.\u00197zg&\u001c8+^5uK*\u0011A\"D\u0001\bg>,(oY3t\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\u0007\t\u00031ei\u0011aD\u0005\u00035=\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0014\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002!;\t\t\")\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018\t\u001c7\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005Y\u0011\u0001\u0005;be\u001e,G/\u0011;ue&\u0014W\u000f^3t+\u00059\u0003c\u0001\u00153k9\u0011\u0011f\f\b\u0003U5j\u0011a\u000b\u0006\u0003YU\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005A\n\u0014a\u00029bG.\fw-\u001a\u0006\u0002]%\u00111\u0007\u000e\u0002\u0004'\u0016\f(B\u0001\u00192!\t14(D\u00018\u0015\tA\u0014(A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u001e\u000e\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001f8\u0005%\tE\u000f\u001e:jEV$X-\u0001\u000buCJ<W\r^!uiJL'-\u001e;fg~#S-\u001d\u000b\u0003\u007f\r\u0003\"\u0001Q!\u000e\u0003EJ!AQ\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\t\u000e\t\t\u00111\u0001(\u0003\rAH%M\u0001\u0012i\u0006\u0014x-\u001a;BiR\u0014\u0018NY;uKN\u0004\u0013!\u0006;be\u001e,G\u000fU1si&$\u0018n\u001c8TG\",W.Y\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111*D\u0001\u0006if\u0004Xm]\u0005\u0003\u001b*\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003e!\u0018M]4fiB\u000b'\u000f^5uS>t7k\u00195f[\u0006|F%Z9\u0015\u0005}\u0002\u0006b\u0002#\u0007\u0003\u0003\u0005\r\u0001S\u0001\u0017i\u0006\u0014x-\u001a;QCJ$\u0018\u000e^5p]N\u001b\u0007.Z7bA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u007f\u0005\u00012\r[3dWB\u0013xN[3di2K7\u000f\u001e\u000b\u0004\u007fYc\u0006\"B,\n\u0001\u0004A\u0016AB1diV\fG\u000eE\u0002)ee\u0003\"A\u000e.\n\u0005m;$AC#yaJ,7o]5p]\")Q,\u0003a\u00011\u0006AQ\r\u001f9fGR,G\r")
public class DataSourceAnalysisSuite
extends SparkFunSuite {
    private Seq<Attribute> targetAttributes;
    private StructType targetPartitionSchema;

    private Seq<Attribute> targetAttributes() {
        return this.targetAttributes;
    }

    private void targetAttributes_$eq(Seq<Attribute> x$1) {
        this.targetAttributes = x$1;
    }

    private StructType targetPartitionSchema() {
        return this.targetPartitionSchema;
    }

    private void targetPartitionSchema_$eq(StructType x$1) {
        this.targetPartitionSchema = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.targetAttributes_$eq((Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}))));
        this.targetPartitionSchema_$eq(new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)IntegerType$.MODULE$));
    }

    private void checkProjectList(Seq<Expression> actual, Seq<Expression> expected) {
        Seq withoutAliases = (Seq)actual.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression;
            Expression expression2 = x0$1;
            if (expression2 instanceof Alias) {
                Alias alias = (Alias)expression2;
                expression = alias.child();
            } else {
                expression = expression2;
            }
            return expression;
        }, Seq$.MODULE$.canBuildFrom());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(withoutAliases);
        Seq<Expression> $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    private static final Expression cast$1(Expression e, DataType dt, SQLConf conf$1) {
        return new Cast(e, dt, Option$.MODULE$.apply((Object)conf$1.sessionLocalTimeZone()));
    }

    public static final /* synthetic */ void $anonfun$new$1(DataSourceAnalysisSuite $this, boolean caseSensitive) {
        SQLConf conf = new SQLConf().copy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE()), (Object)BoxesRunTime.boxToBoolean((boolean)caseSensitive))}));
        DataSourceAnalysis rule = new DataSourceAnalysis(conf);
        $this.test(new StringBuilder(77).append("convertStaticPartitions only handle INSERT having at least static partitions ").append(new StringBuilder(17).append("(caseSensitive: ").append(caseSensitive).append(")").toString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AssertionError)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61)), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        $this.test(new StringBuilder(33).append("Missing columns (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72)))), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        $this.test(new StringBuilder(46).append("Missing partitioning columns (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            return (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101))));
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        $this.test(new StringBuilder(44).append("Wrong partitioning columns (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)new Some((Object)"2"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            return caseSensitive ? $this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131)) : BoxedUnit.UNIT;
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        $this.test(new StringBuilder(58).append("Static partitions need to appear before dynamic partitions").append(new StringBuilder(18).append(" (caseSensitive: ").append(caseSensitive).append(")").toString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> rule.convertStaticPartitions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145)))), new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        $this.test(new StringBuilder(39).append("All static partitions (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!caseSensitive) {
                Seq nonPartitionedAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
                Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf), DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom());
                Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
                $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            }
            Seq nonPartitionedAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq expected = (Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf), DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"3"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom());
            Seq actual = rule.convertStaticPartitions(nonPartitionedAttributes, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new Some((Object)"3"))})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
            Seq nonPartitionedAttributes2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq expected2 = (Seq)nonPartitionedAttributes2.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom());
            Seq actual2 = rule.convertStaticPartitions(nonPartitionedAttributes2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()})), new StructType().add("b", (DataType)IntegerType$.MODULE$));
            $this.checkProjectList((Seq<Expression>)actual2, (Seq<Expression>)expected2);
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        $this.test(new StringBuilder(56).append("Static partition and dynamic partition (caseSensitive: ").append(caseSensitive).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq nonPartitionedAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "e")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "f")).int()}));
            Seq dynamicPartitionAttributes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "g")).int()}));
            Seq expected = (Seq)((TraversableLike)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{DataSourceAnalysisSuite.cast$1((Expression)Literal$.MODULE$.apply((Object)"1"), (DataType)IntegerType$.MODULE$, conf)})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dynamicPartitionAttributes, Seq$.MODULE$.canBuildFrom());
            Seq actual = rule.convertStaticPartitions((Seq)nonPartitionedAttributes.$plus$plus((GenTraversableOnce)dynamicPartitionAttributes, Seq$.MODULE$.canBuildFrom()), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)})), $this.targetAttributes(), $this.targetPartitionSchema());
            $this.checkProjectList((Seq<Expression>)actual, (Seq<Expression>)expected);
        }, new Position("DataSourceAnalysisSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public DataSourceAnalysisSuite() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)caseSensitive -> {
            DataSourceAnalysisSuite.$anonfun$new$1(this, BoxesRunTime.unboxToBoolean((Object)caseSensitive));
            return BoxedUnit.UNIT;
        });
    }
}

